<?php 
if( !defined("WHMCS") ) 
{
    exit( "This file cannot be accessed directly" );
}

function mdpzero_licensing_MetaData()
{
    return array( "DisplayName" => "Mac License Software", "APIVersion" => "1.1", "RequiresServer" => false );
}

function mdpzero_licensing_ConfigOptions()
{   

    try {
        $query = "CREATE TABLE `mod_mac_licensing` (`id` INT( 10 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,`serviceid` INT( 10 ) NOT NULL ,`addon_id` INT(10) NOT NULL DEFAULT  0,`licensekey` TEXT NOT NULL ,`validdomain` TEXT NOT NULL ,`validip` TEXT NOT NULL ,`validdirectory` TEXT NOT NULL ,`device` TEXT NOT NULL ,`reissues` INT( 1 ) NOT NULL ,`status` ENUM( 'Active', 'Reissued', 'Suspended', 'Expired' ) NOT NULL ,`lastaccess` datetime NOT NULL default '0000-00-00 00:00:00')";
         WHMCS\Database\Capsule::select($query);
    }
    catch(Exception $e) {

    }

    $supportUpdateAddons[0] = "None";    
    
    $configarray = array( "Key Length" => array( "Type" => "text", "Size" => "10", "Description" => "String Length eg. 10" ), "Key Prefix" => array( "Type" => "text", "Size" => "20", "Description" => "eg. Leased-" ), "Secret Key" => array( "Type" => "text", "Size" => "20", "Description" => "Used in MD5 Verification" ) );
    return $configarray;
}

function mdpzero_licensing_genkey($length, $prefix)
{
    if( !$length ) 
    {
        $length = 10;
    }

    $seeds = "abcdef0123456789";
    $key = NULL;
    $seeds_count = strlen($seeds) - 1;
    for( $i = 0; $i < $length; $i++ ) 
    {
        $key .= $seeds[rand(0, $seeds_count)];
    }
    $licensekey = $prefix . $key;
    $result = select_query("mod_mac_licensing", "COUNT(*)", array( "licensekey" => $licensekey ));
    $data = mysql_fetch_array($result);
    if( $data[0] ) 
    {
        $licensekey = mdpzero_licensing_genkey($length, $prefix);
    }

    return $licensekey;
}

function mdpzero_licensing_CreateAccount($params)
{

    $length = $params["configoption1"];
    $prefix = $params["configoption2"];
    $licensekey = mdpzero_licensing_genkey($length, $prefix);
    WHMCS\Database\Capsule::table("mod_mac_licensing")->insert(array( "serviceid" => $params["serviceid"], "addon_id" => '', "licensekey" => $licensekey, "validdomain" => "", "validip" => "", "validdirectory" => "", "reissues" => "0", "status" => "Reissued" ));
    updateService(array( "domain" => $licensekey, "username" => "", "password" => "" ));   

    return "success";
}

function mdpzero_licensing_SuspendAccount($params)
{   

    WHMCS\Database\Capsule::table("mod_mac_licensing")->where("serviceid", "=", $params["serviceid"])->update(array( "status" => "Suspended" ));
    return "success";
}

function mdpzero_licensing_UnsuspendAccount($params)
{


    WHMCS\Database\Capsule::table("mod_mac_licensing")->where("serviceid", "=", $params["serviceid"])->update(array( "status" => "Active" ));
    return "success";
}

function mdpzero_licensing_TerminateAccount($params)
{    

    WHMCS\Database\Capsule::table("mod_mac_licensing")->where("serviceid", "=", $params["serviceid"])->update(array( "status" => "Expired" ));
    return "success";
}

function mdpzero_licensing_AdminCustomButtonArray()
{
    $buttonarray = array( "Reissue License" => "reissue");
    return $buttonarray;
}

function mdpzero_licensing_ClientAreaCustomButtonArray()
{
    $buttonarray = array( "Reissue License" => "reissue" );
    return $buttonarray;
}

function mdpzero_licensing_reissue($params)
{
    
    $license = mdpzero_licensing_get_license($params);
    if( !$license ) 
    {
        return "No license exists for this item";
    }   

    if( $license->status != "Active" ) 
    {
        return "License must be active to be reissued";
    }

   

    WHMCS\Database\Capsule::table("mod_mac_licensing")->where("id", "=", $license->id)->increment("reissues", 1, array( "status" => "Reissued" ));
    run_hook("LicensingAddonReissue", array( "licenseid" => $license->id, "serviceid" => $params["serviceid"], "addon_id" => '' ));
    return "success";
}





function mdpzero_licensing_manage($params)
{
    $license = mdpzero_licensing_get_license($params);
    if( !$license ) 
    {
        return "No license exists for this item";
    }

    return "redirect|addonmodules.php?module=licensing&action=manage&id=" . $license->id;
}

function mdpzero_licensing_valid_input_clean($vals)
{
    $vals = explode(",", $vals);
    foreach( $vals as $k => $v ) 
    {
        $vals[$k] = trim($v, " \t\n\r");
    }
    return implode(",", $vals);
}

function mdpzero_licensing_AdminServicesTabFields($params)
{
   

    $license = mdpzero_licensing_get_license($params);
    //echo '<pre>'; print_r($license);die();
    if( $license ) 
    {
        $licenseId = $license->id;
        $validdomain = $license->validdomain;
        $validip = $license->validip;
        $device = $license->device;
        $validdirectory = $license->validdirectory;
        $reissues = $license->reissues;
        $status = $license->status;
        $lastAccess = $license->lastaccess;
        if( $lastAccess == "0000-00-00 00:00:00" ) 
        {
            $lastAccess = "Never";
        }
        else
        {
            $lastAccess = fromMySQLDate($lastAccess, "time");
        }

        $statusoptions = "<option";
        if( $status == "Reissued" ) 
        {
            $statusoptions .= " selected";
        }

        $statusoptions .= ">Reissued</option><option";
        if( $status == "Active" ) 
        {
            $statusoptions .= " selected";
        }

        $statusoptions .= ">Active</option><option";
        if( $status == "Suspended" ) 
        {
            $statusoptions .= " selected";
        }

        $statusoptions .= ">Suspended</option><option";
        if( $status == "Expired" ) 
        {
            $statusoptions .= " selected";
        }

        $statusoptions .= ">Expired</option>";



        $deviceoptions = "<option";
        if( $device == "1-monitor" ) 
        {
            $deviceoptions .= " selected";
        }

        $deviceoptions .= " value = '1-monitor'>1-monitor</option><option";
        if( $device == "Multi-monitor" ) 
        {
            $deviceoptions .= " selected";
        }

        $deviceoptions .= " value = 'Multi-monitor'>Multi-monitor</option>";
        
        
        
        $tableData = array();       
        
        
        // $fieldsArray = array( "Mac Address" => "<textarea name=\"modulefields[0]\" rows=\"2\" class=\"form-control input-600\">" . $validdomain . "</textarea>", "Host IP" => "<textarea name=\"modulefields[1]\" rows=\"2\" class=\"form-control input-600\">" . $validip . "</textarea>", "Gateway" => "<textarea name=\"modulefields[2]\" rows=\"2\" class=\"form-control input-600\">" . $validdirectory . "</textarea>","Device" => "<textarea name=\"modulefields[3]\" rows=\"2\" class=\"form-control input-600\">" . $device . "</textarea>", "License Status" => "<select name=\"modulefields[4]\" id=\"licensestatus\" class=\"form-control select-inline\">" . $statusoptions . "</select>", "Recent Access Log" => $recentAccessLog, "Number of Reissues" => $reissues, "Last Access" => $lastAccess );
        $fieldsArray = array( "Mac Address" => "<textarea name=\"modulefields[0]\" rows=\"2\" class=\"form-control input-600\">" . $validdomain . "</textarea>", "Host IP" => "<textarea name=\"modulefields[1]\" rows=\"2\" class=\"form-control input-600\">" . $validip . "</textarea>", "Gateway" => "<textarea name=\"modulefields[2]\" rows=\"2\" class=\"form-control input-600\">" . $validdirectory . "</textarea>","Device" => "<select name=\"modulefields[3]\" id=\"licensestatus\" class=\"form-control select-inline\">".$deviceoptions."</select>", "License Status" => "<select name=\"modulefields[4]\" id=\"licensestatus\" class=\"form-control select-inline\">" . $statusoptions . "</select>", "Recent Access Log" => $recentAccessLog, "Number of Reissues" => $reissues, "Last Access" => $lastAccess );
        return $fieldsArray;
    }
    else
    {
        return array();
    }

}

function mdpzero_licensing_AdminServicesTabFieldsSave($params)
{
    update_query("mod_mac_licensing", array( "validdomain" => mdpzero_licensing_valid_input_clean($_POST["modulefields"][0]), "validip" => mdpzero_licensing_valid_input_clean($_POST["modulefields"][1]), "validdirectory" => mdpzero_licensing_valid_input_clean($_POST["modulefields"][2]), "device" => mdpzero_licensing_valid_input_clean($_POST["modulefields"][3]), "status" => $_POST["modulefields"][4] ), array( "serviceid" => $params["serviceid"] ));
}



function mdpzero_licensing_ClientArea($params)
{
    $addonId = (array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0);
    $model = $params["model"];
    $licenseData = WHMCS\Database\Capsule::table("mod_mac_licensing")->where("serviceid", "=", $params["serviceid"])->first();
    $productName = ($model instanceof WHMCS\Service\Addon ? $model->productAddon->name : $model->product->name);
    $licenseKey = $licenseData->licensekey;
    $validDomain = $licenseData->validdomain;
    $validIp = $licenseData->validip;
    $device = $licenseData->device;
    $validDirectory = $licenseData->validdirectory;
    $status = $licenseData->status;
    

    return array( "overrideDisplayTitle" => $productName, "overrideBreadcrumb" => array( array( "clientarea.php?action=products&module=licensing", Lang::trans("licensingaddon.mylicenses") ), array( "clientarea.php?action=productdetails#", Lang::trans("licensingaddon.manageLicense") ) ), "tabOverviewReplacementTemplate" => "managelicense.tpl", "tabOverviewModuleOutputTemplate" => "licenseinfo.tpl", "templateVariables" => array( "licensekey" => $licenseKey, "device" => $device, "validdomain" => $validDomain, "validip" => $validIp, "validdirectory" => $validDirectory, "status" => $status, "allowreissues" => $allowReissues, "allowDomainConflicts" => $allowDomainConflicts, "allowIpConflicts" => $allowIpConflicts, "allowDirectoryConflicts" => $allowDirectoryConflicts ) );
}

function mdpzero_licensing_does_license_exist(array $params)
{
    $addonId = (array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0);
    return WHMCS\Database\Capsule::table("mod_mac_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->count();
}

function mdpzero_licensing_get_license(array $params)
{
    $addonId = (array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0);
    return WHMCS\Database\Capsule::table("mod_mac_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->first();
}


