{if isset($RSThemes['pages'][$templatefile]) && file_exists($RSThemes['pages'][$templatefile]['fullPath'])}
    {include file=$RSThemes['pages'][$templatefile]['fullPath']}
{else}
    {if $errormessage}
        {include file="$template/includes/alert.tpl" type="error" errorshtml=$errormessage additionalClasses='alert-primary'}
    {/if}
    {* 
        -- Start of integration code --
        - Integration code for: Premium Support Tickets For WHMCS from ModulesGarden
        - Module URL: https://www.modulesgarden.com/products/whmcs/premium-support-tickets
    *}
    {if $PremiumSupportTickets && $PremiumSupportTickets.canCreate}
        <div class="alert alert-lagom alert-primary alert-info alert-premium-support-tickets">
            <div class="alert-body">
                {$PremiumSupportTickets.haveInCreatePointsMsg} <b class="ticket-points">{$PremiumSupportTickets.havePoints}</b>
            </div>
        </div>
        <script type="text/javascript">
        {literal}
        $(document).ready(function() {
            $('select[name=deptid]').change(function() {
                window.location.href = 'submitticket.php?step=2&deptid='+$(this).val();
            });
        });
        {/literal}
        </script>
    {/if}
    {* -- End of integration code -- *}
    <form method="post" action="{$smarty.server.PHP_SELF}?step=3" enctype="multipart/form-data" role="form">
        <div class="section section-sm">
            <div class="section-header">
                <h2 class="section-title">{$LANG.ticketinfo}</h2>
            </div>
            <div class="section-body">
                <div class="panel panel-default open-ticket-information">
                    <div class="panel-body d-flex flex-column row-gap-base flex-nowrap">
                        <div class="row row-sm row-gap-base">
                            {if $loggedin}
                                <div class="form-group col-md-6 mb-0 d-flex flex-column flex-nowrap">
                                    <label class="text-heading-color font-weight-medium mb-2">{$rslang->trans('support.open_ticket.ticket_creator')}</label>
                                    <div class="ticket-creator">
                                        {if $RSThemes.addonSettings.show_gravatar_image == 'displayed'}
                                            <div class="creator-avatar creator-avatar-md">
                                                <img class="lazyload" data-src="https://www.gravatar.com/avatar/{$loggedinuser->email|md5}{if $RSThemes.addonSettings.gravatar_placeholder && $RSThemes.addonSettings.gravatar_placeholder != "default"}?d={$RSThemes.addonSettings.gravatar_placeholder}{/if}" alt="Avatar">
                                            </div>
                                        {/if}
                                        <div class="creator-details">
                                            <div class="creator-details-container">
                                                <p class="creator-details-name mb-0">{if $loggedin}{$clientsdetails.fullname}{else}{$name}{/if}</p>
                                                <p class="creator-details-email mb-0 p-xs">{$email}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-md-6 mb-0 d-flex flex-column flex-nowrap">
                                    <label for="inputDepartment" class="text-heading-color font-weight-medium mb-2">{$rslang->trans('support.open_ticket.ticket_department')}</label>
                                    <select name="deptid" id="inputDepartment" class="form-control hidden" onchange="refreshCustomFields(this)">
                                        {foreach from=$departments item=department}
                                            <option value="{$department.id}"{if $department.id eq $deptid} selected="selected"{/if}>
                                                {$department.name}
                                            </option>
                                        {/foreach}
                                    </select>
                                    <div class="dropdown dropdown-select-list dropdown-select-list-icon department-dropdown" data-department-dropdown>
                                        <div tabindex="0" class="dropdown-toggle {if $departments|@count <= 1}dropdown-toggle-disabled{/if}" {if $departments|@count > 1}data-toggle="dropdown"{/if}>
                                            <div class="dropdown-icon">
                                                {if is_array($graphics['department']) && isset($graphics['department'][$deptid]) && $graphics['department'][$deptid]->enabled && $graphics['department'][$deptid]->getJson()->condensed->type}
                                                    {assign var=graphic value=$graphics['department'][$deptid]->getJson()->condensed->graphic}
                                                    {assign var=graphicType value=$graphics['department'][$deptid]->getJson()->condensed->type}
                                                    <span class="graphic-item graphic-item-sm">
                                                        {if $graphicType == "icon"}
                                                            {include file="$template/assets/svg-icon/{$graphic}"}
                                                        {else if $graphicType == "media"}
                                                            <img src="{$WEB_ROOT}/templates/{$template}/assets/img/page-manager/{$graphic}" alt="{$departments[$deptid].name}">
                                                        {else if $graphicType == "font-icon"}
                                                            <span class="graphic-item-bg">
                                                                <i class="{$graphic}"></i>
                                                            </span>
                                                        {/if}
                                                    </span>
                                                {else}
                                                    <i class="lm lm-envelope"></i>
                                                {/if}
                                            </div>
                                            <div dropdown-content-title class="dropdown-toggle-content">
                                                <div class="dropdown-toggle-content-title">
                                                    <span class="font-weight-medium">{$department}</span>
                                                    {if isset($supportDepartmentsWorkingList)}                                                        
                                                        {foreach item=supportDepartment from=$supportDepartmentsWorkingList}
                                                            {if $deptid == $supportDepartment->id && $supportDepartment->supportTools}
                                                                <span class="label label-{if $supportDepartment->supportTools.isWorking}success{elseif !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}warning{else}default{/if} label-xs label-rounded">
                                                                    <span class="status status-{if $supportDepartment->supportTools.isWorking}active{elseif !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}warning{else}default{/if}">
                                                                        {if $supportDepartment->supportTools.isWorking}
                                                                            {$rsSupportHoursLang->trans('general.online')}
                                                                        {elseif !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}
                                                                            {$rsSupportHoursLang->trans('general.closed')}
                                                                        {else}
                                                                            {$rsSupportHoursLang->trans('general.offline')}
                                                                        {/if}
                                                                    </span>
                                                                    <i data-html="true" data-toggle="tooltip" data-original-title="{if $supportDepartment->supportTools.isWorking && !$supportDepartment->supportTools.allDay}{sprintf($rsSupportHoursLang->trans('general.support_available_for'), $supportDepartment->supportTools.timeString)}{elseif !$supportDepartment->supportTools.allDay && !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}{$supportDepartment->supportTools.holidayObject.holiday.name} - {$supportDepartment->supportTools.holidayObject.timestamp}{elseif $supportDepartment->supportTools.allDay && $supportDepartment->supportTools.isWorking}{$rsSupportHoursLang->trans('general.all_day')}{else}{sprintf($rsSupportHoursLang->trans('general.support_will_available'), $supportDepartment->supportTools.timeString)}{/if}">
                                                                        {include file="$template/assets/img/help-icon-ticket.svg"}
                                                                    </i>
                                                                </span>
                                                            {/if}
                                                        {/foreach}
                                                    {/if}
                                                </div>
                                                {foreach from=$departments item=department}
                                                    {if $deptid == $department.id}
                                                        <p class="p-xs mb-0 text-lighter-color">{$department.description}</p>
                                                    {/if}
                                                {/foreach}    
                                            </div>
                                            <div class="dropdown-caret {if $departments|@count <= 1}hidden{/if}">
                                                <i class="ls ls-caret"></i>
                                            </div>
                                        </div>
                                        <ul class="dropdown-menu dropdown-list dropdown-lazy has-scroll py-0">
                                            {foreach from=$departments item=department}
                                            <a tabindex="0" tabindex="0" class="dropdown-list-item dropdown-list-item-border" value="{$department.id}" {if isset($sensitiveDataEnabled) && $sensitiveDataEnabled && $loggedin} data-display-sensitvie-department="{$sensitiveDataSupportDepartmentsEnabled[$department.id]} {/if}">
                                                    <div class="item-icon">
                                                        {if is_array($graphics['department']) && isset($graphics['department'][$department.id]) && $graphics['department'][$department.id]->enabled && $graphics['department'][$department.id]->getJson()->condensed->type}
                                                            {assign var=graphic value=$graphics['department'][$department.id]->getJson()->condensed->graphic}
                                                            {assign var=graphicType value=$graphics['department'][$department.id]->getJson()->condensed->type}
                                                            <span class="graphic-item graphic-item-sm">
                                                                {if $graphicType == "icon"}
                                                                    {include file="$template/assets/svg-icon/{$graphic}"}
                                                                {else if $graphicType == "media"}
                                                                    <img src="{$WEB_ROOT}/templates/{$template}/assets/img/page-manager/{$graphic}" alt="{$department.name}">
                                                                {else if $graphicType == "font-icon"}
                                                                    <span class="graphic-item-bg">
                                                                        <i class="{$graphic}"></i>
                                                                    </span>
                                                                {/if}
                                                            </span>
                                                        {else}
                                                            <i class="lm lm-envelope"></i>
                                                        {/if}
                                                    </div>
                                                    <div class="item-desc">
                                                        <div>
                                                            <span class="item-desc-title font-weight-medium">{$department.name}</span>
                                                            {if isset($supportDepartmentsWorkingList)}
                                                                {foreach item=supportDepartment from=$supportDepartmentsWorkingList}
                                                                    {if $department.id == $supportDepartment->id && $supportDepartment->supportTools}
                                                                        <span class="label label-{if $supportDepartment->supportTools.isWorking}success{elseif !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}warning{else}default{/if} label-xs label-rounded">
                                                                            <span class="status status-{if $supportDepartment->supportTools.isWorking}active{elseif !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}warning{else}default{/if}">
                                                                                {if $supportDepartment->supportTools.isWorking}
                                                                                    {$rsSupportHoursLang->trans('general.online')}
                                                                                {elseif !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}
                                                                                    {$rsSupportHoursLang->trans('general.closed')}
                                                                                {else}
                                                                                    {$rsSupportHoursLang->trans('general.offline')}
                                                                                {/if}
                                                                            </span>
                                                                            <i data-html="true" data-toggle="tooltip" data-original-title="{if $supportDepartment->supportTools.isWorking && !$supportDepartment->supportTools.allDay}{sprintf($rsSupportHoursLang->trans('general.support_available_for'), $supportDepartment->supportTools.timeString)}{elseif !$supportDepartment->supportTools.allDay && !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}{$supportDepartment->supportTools.holidayObject.holiday.name} - {$supportDepartment->supportTools.holidayObject.timestamp}{elseif $supportDepartment->supportTools.allDay && $supportDepartment->supportTools.isWorking}{$rsSupportHoursLang->trans('general.all_day')}{else}{sprintf($rsSupportHoursLang->trans('general.support_will_available'), $supportDepartment->supportTools.timeString)}{/if}">
                                                                                {include file="$template/assets/img/help-icon-ticket.svg"}
                                                                            </i>
                                                                        </span>
                                                                    {/if}
                                                                {/foreach}
                                                            {/if}
                                                        </div>
                                                        <p class="p-xs mb-0 text-lighter-color">{$department.description}</p>
                                                    </div>
                                                </a>
                                            {/foreach}    
                                        </ul>
                                    </div>
                                </div>
                            {else}
                                <div class="form-group col-md-6 mb-0">
                                    <label class="mb-2 font-weight-medium text-heading-color" for="inputName">{$LANG.supportticketsclientname}</label>
                                    <input type="text" name="name" id="inputName" value="" class="form-control" placeholder="{$LANG.supportticketsclientname}" />
                                </div>
                                <div class="form-group col-md-6 mb-0">
                                    <label class="mb-2 font-weight-medium text-heading-color" for="inputEmail">{$LANG.supportticketsclientemail}</label>
                                    <input type="email" name="email" id="inputEmail" value="" class="form-control" placeholder="{$LANG.enteremail}" />
                                </div>
                            {/if}
                        </div>
                        <div class="row row-sm row-gap-base">
                            {if $loggedin}
                                {if $relatedservices}
                                    <div class="form-group {if  $RSThemes['pages'][$templatefile] && $RSThemes['pages'][$templatefile]['config']['hideTicketPriority'] != "1"}col-md-6{else}col-12{/if} mb-0">
                                        <label for="inputRelatedService" class="text-heading-color font-weight-medium mb-2">{$rslang->trans('support.open_ticket.related_product')}</label>
                                        <select name="relatedservice" id="inputRelatedService" class="form-control hidden">
                                            <option value="">{$LANG.none}</option>
                                            {foreach from=$relatedservices item=relatedservice}
                                                {if isset($RSThemes['pages'][$templatefile]) && $RSThemes['pages'][$templatefile]['config']['hideInactiveServices'] == "1" && (!empty($RSThemes['pages'][$templatefile]['config']['hideInactiveServicesStatus']) || !empty($RSThemes['pages'][$templatefile]['config']['hideInactiveDomainStatus']))}
                                                    {include file="$template/includes/tickets/hide-inactive-services.tpl" type="related-services"}           
                                                {/if}
                                                {if !$hiddeStatus}
                                                    <option value="{$relatedservice.id}" {if $relatedservice.id eq $selectedservice} selected="selected"{/if}>
                                                        {if $relatedservice.groupName}{$relatedservice.groupName} - {/if}{$relatedservice.name} ({$relatedservice.status})
                                                    </option>
                                                {/if}
                                            {/foreach}
                                        </select>
                                        <div class="dropdown dropdown-select-list dropdown-select-list-sm related-product-dropdown" data-dropdown-menu-search-container>
                                            <a tabindex="0" class="dropdown-toggle" tabindex="0" href="#" data-toggle="dropdown" data-dropdown-menu-search-toggle>
                                                <div class="dropdown-toggle-content">
                                                <div dropdown-content-title class="dropdown-toggle-content-title">
                                                    {if $selectedservice}
                                                        {foreach from=$relatedservices item=relatedservice}
                                                            {if $relatedservice.id == $selectedservice}
                                                                <span class="related-item">
                                                                    <span class="related-item-group font-weight-medium">{if $relatedservice.groupName}{$relatedservice.groupName} - {/if}</span>
                                                                    <span class="related-item-name">{$relatedservice.name}</span>
                                                                </span> 
                                                                <span class="label label-xs label-rounded label-{if $relatedservice.rawStatus|lower == "active"}success{elseif $relatedservice.rawStatus|lower == "pending"}warning{else}default{/if}"><span class="status status-{$relatedservice.rawStatus|lower}">{$relatedservice.status}</span></span>
                                                            {/if}
                                                        {/foreach}  
                                                    {else}
                                                        <span class="p-md">{$LANG.none}</span>
                                                    {/if}
                                                    </div>
                                                </div>
                                                <div class="dropdown-caret">
                                                    <i class="ls ls-caret"></i>
                                                </div>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-search dropdown-list dropdown-lazy" data-dropdown-menu-search-menu>                                       
                                                <div class="dropdown-header dropdown-header-bordered input-group align-center">
                                                    <i class="input-group-icon lm lm-search"></i>
                                                    <input class="form-control" placeholder="Search..." type="text" data-dropdown-menu-search-input>
                                                </div>
                                                <div class="dropdown-menu-items has-scroll" data-dropdown-menu-search-items>
                                                    <a tabindex="0" class="dropdown-list-item" tabindex="0" data-dropdown-menu-search-item data-search="{$LANG.none}" value="">{$LANG.none}</a>
                                                    {foreach from=$relatedservices item=relatedservice}
                                                        {if isset($RSThemes['pages'][$templatefile]) && $RSThemes['pages'][$templatefile]['config']['hideInactiveServices'] == "1" && (!empty($RSThemes['pages'][$templatefile]['config']['hideInactiveServicesStatus']) || !empty($RSThemes['pages'][$templatefile]['config']['hideInactiveDomainStatus']))}
                                                            {include file="$template/includes/tickets/hide-inactive-services.tpl" type="related-services"}           
                                                        {/if}
                                                        {if !$hiddeStatus}
                                                            <a tabindex="0" class="dropdown-list-item" tabindex="0" data-dropdown-menu-search-item data-search="{if $relatedservice.groupName}{$relatedservice.groupName|strip_tags} - {/if}{$relatedservice.name|strip_tags} {$relatedservice.status|strip_tags}" value="{$relatedservice.id}" {if $relatedservice.id eq $selectedservice} selected="selected"{/if}>                                                           
                                                                <span class="related-item">
                                                                    <span class="related-item-group font-weight-medium">{if $relatedservice.groupName}{$relatedservice.groupName} - {/if}</span>
                                                                    <span class="related-item-name">{$relatedservice.name}</span>
                                                                </span> 
                                                                <span class="label label-xs label-rounded label-{if $relatedservice.rawStatus|lower == "active"}success{elseif $relatedservice.rawStatus|lower == "pending"}warning{else}default{/if}"><span class="status status-{$relatedservice.rawStatus|lower}">{$relatedservice.status}</span></span>
                                                            </a>
                                                        {/if}
                                                    {/foreach}  
                                                    <div class="dropdown-menu-item dropdown-menu-no-data" data-dropdown-menu-search-no-data>
                                                        <span class="text-info text-large">
                                                            {$LANG.norecordsfound}
                                                        </span>
                                                    </div>
                                                </div>     
                                            </div>
                                        </div>
                                    </div>
                                {/if}
                            {else}
                                <div class="form-group col-12 mb-0">
                                    <label class="text-heading-color font-weight-medium mb-2">{$rslang->trans('support.open_ticket.ticket_department')}</label>
                                    <select name="deptid" id="inputDepartment" class="form-control hidden" onchange="refreshCustomFields(this)">
                                        {foreach from=$departments item=department}
                                            <option value="{$department.id}"{if $department.id eq $deptid} selected="selected"{/if}>
                                                {$department.name}
                                            </option>
                                        {/foreach}
                                    </select>
                                    <div class="dropdown dropdown-select-list dropdown-select-list-icon department-dropdown">
                                        <div class="dropdown-toggle {if $departments|@count <= 1}dropdown-toggle-disabled{/if}" {if $departments|@count > 1}data-toggle="dropdown"{/if}>
                                            <div class="dropdown-icon">
                                                {if is_array($graphics['department']) && isset($graphics['department'][$deptid]) && $graphics['department'][$deptid]->enabled && $graphics['department'][$deptid]->getJson()->condensed->type}
                                                    {assign var=graphic value=$graphics['department'][$deptid]->getJson()->condensed->graphic}
                                                    {assign var=graphicType value=$graphics['department'][$deptid]->getJson()->condensed->type}
                                                    <span class="graphic-item graphic-item-sm">
                                                        {if $graphicType == "icon"}
                                                            {include file="$template/assets/svg-icon/{$graphic}"}
                                                        {else if $graphicType == "media"}
                                                            <img src="{$WEB_ROOT}/templates/{$template}/assets/img/page-manager/{$graphic}" alt="{$departments[$deptid].name}">
                                                        {else if $graphicType == "font-icon"}
                                                            <span class="graphic-item-bg">
                                                                <i class="{$graphic}"></i>
                                                            </span>
                                                        {/if}
                                                    </span>
                                                {else}
                                                    <i class="lm lm-envelope"></i>
                                                {/if}
                                            </div>
                                            <div dropdown-content-title class="dropdown-toggle-content">
                                                <div class="dropdown-toggle-content-title">
                                                    <span class="font-weight-medium">{$department}</span>
                                                    {if isset($supportDepartmentsWorkingList)}                                                        
                                                        {foreach item=supportDepartment from=$supportDepartmentsWorkingList}
                                                            {if $deptid == $supportDepartment->id && $supportDepartment->supportTools}
                                                                <span class="label label-{if $supportDepartment->supportTools.isWorking}success{elseif !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}warning{else}default{/if} label-xs label-rounded">
                                                                    <span class="status status-{if $supportDepartment->supportTools.isWorking}active{elseif !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}warning{else}default{/if}">
                                                                        {if $supportDepartment->supportTools.isWorking}
                                                                            {$rsSupportHoursLang->trans('general.online')}
                                                                        {elseif !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}
                                                                            {$rsSupportHoursLang->trans('general.closed')}
                                                                        {else}
                                                                            {$rsSupportHoursLang->trans('general.offline')}
                                                                        {/if}
                                                                    </span>
                                                                    <i data-html="true" data-toggle="tooltip" data-original-title="{if $supportDepartment->supportTools.isWorking && !$supportDepartment->supportTools.allDay}{sprintf($rsSupportHoursLang->trans('general.support_available_for'), $supportDepartment->supportTools.timeString)}{elseif !$supportDepartment->supportTools.allDay && !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}{$supportDepartment->supportTools.holidayObject.holiday.name} - {$supportDepartment->supportTools.holidayObject.timestamp}{elseif $supportDepartment->supportTools.allDay && $supportDepartment->supportTools.isWorking}{$rsSupportHoursLang->trans('general.all_day')}{else}{sprintf($rsSupportHoursLang->trans('general.support_will_available'), $supportDepartment->supportTools.timeString)}{/if}">
                                                                        {include file="$template/assets/img/help-icon-ticket.svg"}
                                                                    </i>
                                                                </span>
                                                            {/if}
                                                        {/foreach}
                                                    {/if}
                                                </div>
                                                {foreach from=$departments item=department}
                                                    {if $deptid == $department.id}
                                                        <p class="p-xs mb-0 text-lighter-color">{$department.description}</p>
                                                    {/if}
                                                {/foreach}    
                                            </div>
                                            <div class="dropdown-caret {if $departments|@count <= 1}hidden{/if}">
                                                <i class="ls ls-caret"></i>
                                            </div>
                                        </div>
                                        <ul class="dropdown-menu dropdown-list dropdown-lazy has-scroll py-0">
                                            {foreach from=$departments item=department}
                                            <a tabindex="0" class="dropdown-list-item dropdown-list-item-border" value="{$department.id}">
                                                    <div class="item-icon">
                                                        {if is_array($graphics['department']) && isset($graphics['department'][$department.id]) && $graphics['department'][$department.id]->enabled && $graphics['department'][$department.id]->getJson()->condensed->type}
                                                            {assign var=graphic value=$graphics['department'][$department.id]->getJson()->condensed->graphic}
                                                            {assign var=graphicType value=$graphics['department'][$department.id]->getJson()->condensed->type}
                                                            <span class="graphic-item graphic-item-sm">
                                                                {if $graphicType == "icon"}
                                                                    {include file="$template/assets/svg-icon/{$graphic}"}
                                                                {else if $graphicType == "media"}
                                                                    <img src="{$WEB_ROOT}/templates/{$template}/assets/img/page-manager/{$graphic}" alt="{$department.name}">
                                                                {else if $graphicType == "font-icon"}
                                                                    <span class="graphic-item-bg">
                                                                        <i class="{$graphic}"></i>
                                                                    </span>
                                                                {/if}
                                                            </span>
                                                        {else}
                                                            <i class="lm lm-envelope"></i>
                                                        {/if}
                                                    </div>
                                                    <div class="item-desc">
                                                        <div>
                                                            <span class="item-desc-title font-weight-medium">{$department.name}</span>
                                                            {if isset($supportDepartmentsWorkingList)}
                                                                {foreach item=supportDepartment from=$supportDepartmentsWorkingList}
                                                                    {if $department.id == $supportDepartment->id && $supportDepartment->supportTools}
                                                                        <span class="label label-{if $supportDepartment->supportTools.isWorking}success{elseif !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}warning{else}default{/if} label-xs label-rounded">
                                                                            <span class="status status-{if $supportDepartment->supportTools.isWorking}active{elseif !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}warning{else}default{/if}">
                                                                                {if $supportDepartment->supportTools.isWorking}
                                                                                    {$rsSupportHoursLang->trans('general.online')}
                                                                                {elseif !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}
                                                                                    {$rsSupportHoursLang->trans('general.closed')}
                                                                                {else}
                                                                                    {$rsSupportHoursLang->trans('general.offline')}
                                                                                {/if}
                                                                            </span>
                                                                            <i data-html="true" data-toggle="tooltip" data-original-title="{if $supportDepartment->supportTools.isWorking && !$supportDepartment->supportTools.allDay}{sprintf($rsSupportHoursLang->trans('general.support_available_for'), $supportDepartment->supportTools.timeString)}{elseif !$supportDepartment->supportTools.allDay && !$supportDepartment->supportTools.isWorking && ($supportDepartment->supportTools.holidayActive && $supportDepartment->supportTools.applyHolidays)}{$supportDepartment->supportTools.holidayObject.holiday.name} - {$supportDepartment->supportTools.holidayObject.timestamp}{elseif $supportDepartment->supportTools.allDay && $supportDepartment->supportTools.isWorking}{$rsSupportHoursLang->trans('general.all_day')}{else}{sprintf($rsSupportHoursLang->trans('general.support_will_available'), $supportDepartment->supportTools.timeString)}{/if}">
                                                                                {include file="$template/assets/img/help-icon-ticket.svg"}
                                                                            </i>
                                                                        </span>
                                                                    {/if}
                                                                {/foreach}
                                                            {/if}
                                                        </div>
                                                        <p class="p-xs mb-0 text-lighter-color">{$department.description}</p>
                                                    </div>
                                                </a>
                                            {/foreach}    
                                        </ul>
                                    </div>
                                </div>
                            {/if}
                            {if $RSThemes['pages'][$templatefile] && $RSThemes['pages'][$templatefile]['config']['hideTicketPriority'] != "1"}                            
                                <div class="form-group {if $relatedservices}col-md-6{else}col-12{/if} mb-0">
                                    <label for="inputPriority" class="text-heading-color font-weight-medium mb-2">{$LANG.supportticketspriority}</label>
                                    {* -- Start of integration code --
                                    - Integration code for: Premium Support Tickets For WHMCS from ModulesGarden
                                    - Module URL: https://www.modulesgarden.com/products/whmcs/premium-support-tickets *}
                                    {if $PremiumSupportTicketsAddonIsActive}
                                        <select name="urgency" id="inputPriority" class="form-control hidden">
                                            <option value="High"{if $urgency eq "High"} selected="selected"{/if}>
                                                {$LANG.supportticketsticketurgencyhigh} - {$PremiumSupportTickets.requiredPlusHigh} SCP
                                            </option>
                                            <option value="Medium"{if $urgency eq "Medium" || !$urgency} selected="selected"{/if}>
                                                {$LANG.supportticketsticketurgencymedium} - {$PremiumSupportTickets.requiredPlusNormal} SCP
                                            </option>
                                            <option value="Low"{if $urgency eq "Low"} selected="selected"{/if}>
                                                {$LANG.supportticketsticketurgencylow} - {$PremiumSupportTickets.requiredPlusLow} SCP
                                            </option>
                                        </select>                            
                                    {* -- End of integration code -- *}
                                    {else}
                                        <select name="urgency" id="inputPriority" class="form-control hidden">
                                            <option value="High"{if $urgency eq "High"} selected="selected"{/if}>
                                                {$LANG.supportticketsticketurgencyhigh}
                                            </option>
                                            <option value="Medium"{if $urgency eq "Medium" || !$urgency} selected="selected"{/if}>
                                                {$LANG.supportticketsticketurgencymedium}
                                            </option>
                                            <option value="Low"{if $urgency eq "Low"} selected="selected"{/if}>
                                                {$LANG.supportticketsticketurgencylow}
                                            </option>
                                        </select>
                                    {/if}
                                    <div class="dropdown dropdown-select-list dropdown-select-list-sm ticket-priority-dropdown">
                                        <div tabindex="0" class="dropdown-toggle" data-toggle="dropdown">
                                            <div class="dropdown-toggle-content">
                                                <div dropdown-content-title class="dropdown-toggle-content-title">
                                                    <span class="p-md">
                                                        {if $urgency eq "High"}
                                                            {$LANG.supportticketsticketurgencyhigh}
                                                        {elseif $urgency eq "Medium" || !$urgency}
                                                            {$LANG.supportticketsticketurgencymedium}
                                                        {elseif $urgency eq "High"}
                                                            {$LANG.supportticketsticketurgencylow}
                                                        {/if}
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="dropdown-caret">
                                                <i class="ls ls-caret"></i>
                                            </div>
                                        </div>
                                        <ul class="dropdown-menu dropdown-lazy has-scroll">
                                            <a tabindex="0" class="dropdown-list-item" tabindex="0" value="High">{$LANG.supportticketsticketurgencyhigh}</a> 
                                            <a tabindex="0" class="dropdown-list-item" tabindex="0" value="Medium">{$LANG.supportticketsticketurgencymedium}</a>
                                            <a tabindex="0" class="dropdown-list-item" tabindex="0" value="Low">{$LANG.supportticketsticketurgencylow}</a>
                                        </ul>
                                    </div>
                                </div>
                            {/if}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="section section-sm">
            <div class="section-header">
                <h2 class="section-title">{$rslang->trans('support.ticket_details')}</h2>
            </div>
            <div class="section-body">
                <div class="panel panel-default open-ticket-form">
                    <div class="panel-body">
                        <div class="row row-gap-base">
                            <div class="form-group col-12 mb-0">
                                <label class="font-weight-medium mb-2 text-heading-color" for="inputSubject">{$LANG.supportticketsticketsubject}</label>
                                <input type="text" name="subject" id="inputSubject" value="{$subject}" class="form-control" />
                            </div>
                            <div class="ticket-content col-12">
                                {if isset($sensitiveDataEnabled) && $sensitiveDataEnabled && $loggedin}
                                    <div class="tabs w-100 {if (is_array($sensitiveDataSupportDepartmentsEnabled) && $sensitiveDataSupportDepartmentsEnabled[$deptid] == 0)}hidden{/if}" id="ticket-message" data-nav-tabs>
                                        <ul class="panel-tabs nav nav-tabs nav-tabs-xs">
                                            <li>
                                                <a tabindex="0" class="active" href="#open-ticket-message" data-nav-tab-message data-toggle="tab" aria-expanded="false">{$LANG.contactmessage}</a>
                                            </li>
                                            <li>
                                                <a tabindex="0" class="" href="#sensitive-data" data-nav-tab-sensitive data-toggle="tab" aria-expanded="false"><span>{$sensitiveDataTranslations->getClientTranslation("open_ticket.tab_name")|unescape:'html'}</span></a>
                                            </li>
                                        </ul>
                                    </div>
                                    <label class="font-weight-medium mb-0 mt-0 text-heading-color {if (is_array($sensitiveDataSupportDepartmentsEnabled) && $sensitiveDataSupportDepartmentsEnabled[$deptid] == 1)}hidden{/if}" data-message-title-label>{$LANG.contactmessage}</label>
                                {else}
                                    <label class="font-weight-medium mb-0 mt-0 text-heading-color">{$LANG.contactmessage}</label>
                                {/if}
                                <div class="tab-content w-100">
                                    <div class="tab-pane active tab-message" data-tab-message-content id="open-ticket-message">
                                        {include file="$template/includes/open-ticket/open-ticket-tab.tpl"}
                                    </div>
                                    {if isset($sensitiveDataEnabled) && $sensitiveDataEnabled && $loggedin}
                                        <div class="tab-pane tab-sensitive" data-tab-sensitive-content id="sensitive-data">
                                            {include file="$template/core/extensions/SensitiveDataManager/views/open-ticket.tpl" translations=$sensitiveDataTranslations}
                                        </div>
                                    {/if}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="section section-sm section-custom-fields">
            <div class="section-header">
                <h2 class="section-title">{$LANG.additionalInfo}</h2>
            </div>
            <div class="section-body">
                <div id="customFieldsContainer">
                    {include file="$template/supportticketsubmit-customfields.tpl"}
                </div>
            </div>
        </div>
         {if $captcha->isEnabled()}    
            <div class="login-captcha">
                {include file="$template/includes/captcha.tpl"}
            </div>
        {/if}
        <div class="panel panel-default mb-0 panel-form-action">
            <div class="panel-body">            
                <div class="form-actions mt-0">
                    <input type="submit" id="openTicketSubmit" value="{$rslang->trans('support.support_ticket_send')}" class="btn btn-primary disable-on-click{$captcha->getButtonClass($captchaForm)}" />
                    <a tabindex="0" href="supporttickets.php" class="btn btn-default">{$LANG.cancel}</a>
                </div>
            </div>
        </div>
    </form>
    {if $kbsuggestions}
        <script>
            jQuery(document).ready(function () {
                getTicketSuggestions();
            });
        </script>
    {/if}
{/if}