{if file_exists("templates/$template/store/socialbee/overwrites/index.tpl")}
    {include file="{$template}/store/socialbee/overwrites/index.tpl"}  
{else} 
<div class="site site-socialbee">
        <div class="site-banner banner banner-sides banner-{$siteBannerStyle}">
            <div class="container">
                <div class="banner-content">
                    <h1 class="banner-title">{lang key='store.socialbee.header'}</h1>
                    <div class="banner-desc">
                        <p>{lang key='store.socialbee.hero'}</p>
                    </div>
                    <div class="banner-actions">
                        <a tabindex="0" href="#" class="btn btn-lg btn-primary{if $siteBannerStyle == 'primary'}-faded{/if}" onclick="smoothScroll('#pricing');return false">{lang key="store.websiteBuilder.tab.pricing"}</a>
                        <a tabindex="0" href="#" class="btn btn-lg {if $siteBannerStyle == 'default'}btn-primary-outline{else}btn-light-outline{/if}" onclick="smoothScroll('#overview');return false">{lang key="learnmore"}</a>
                    </div>
                </div>
                <div class="banner-background">
                    <div class="banner-graphic">
                        {if $RSThemes.styles.iconType == "modern"}
                                {include file="$template/includes/common/svg-illustration.tpl" illustration="products/modern/socialbee"}
                            {else}
                                {include file="$template/includes/common/svg-illustration.tpl" illustration="products/socialbee"}
                            {/if}              
                    </div>
                    <div class="banner-shape">
                        {include file="$template/includes/common/svg-illustration.tpl" illustration="site/banner-shape"}
                    </div>
                </div>
            </div>  
        </div> 

        <div class="site-section" id="overview">
            <div class="container">
                <div class="section-sides">
                    <div class="section-graphic">
                        <div class="browser browser-sm">
                            <img role="presentation" src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/SocialBeeFeatures.png" alt="Features">
                        </div> 
                    </div>
                    <div class="section-content">
                        <h2 class="section-title">{lang key='store.socialbee.content.header'}</h2>
                        <div class="section-desc">
                            <p class="p-xlg">{lang key='store.socialbee.content.p1'}</p>
                            <p class="p-xlg">{lang key='store.socialbee.content.p2'}</p>
                            <p class="p-xlg">{lang key='store.socialbee.content.p3'}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div> 

        <div class="site-section" >
            <div class="container">
                <div class="section-content">
                    <h2 class="section-title">Social Bee Features</h2>        
                    <ul class="nav nav-tabs nav-tabs-features" role="tablist">
                        <li role="presentation"><a tabindex="0" role="tab"  class="active" href="#create" aria-controls="create" role="tab" data-toggle="tab">{lang key='create'}</a></li>
                        <li role="presentation"><a tabindex="0" role="tab"  href="#schedule" aria-controls="schedule" role="tab" data-toggle="tab">{lang key='store.schedule'}</a></li>
                        <li role="presentation"><a tabindex="0" role="tab"  href="#engage" aria-controls="engage" role="tab" data-toggle="tab">{lang key='store.engage'}</a></li>
                        <li role="presentation"><a tabindex="0" role="tab"  href="#collaborate" aria-controls="collaborate" role="tab" data-toggle="tab">{lang key='store.collaborate'}</a></li>
                        <li role="presentation"><a tabindex="0" role="tab"  href="#analyze" aria-controls="analyze" role="tab" data-toggle="tab">{lang key='store.analyze'}</a></li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade active show" role="tabpanel" id="create">
                            <div class="section-content">
                                <div class="row row-eg-height row-eq-height-xs features">
                                    <div class="col-md col-md-4 col-sm-6">
                                        <div class="feature">
                                            <div class="feature-icon">
                                                {include file="$template/assets/svg-icon/photos.tpl"}
                                            </div>
                                            <div class="feature-content">
                                                <p class="feature-desc">{lang key='store.socialbee.features.create.i1'}</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md col-md-4 col-sm-6">
                                        <div class="feature">
                                            <div class="feature-icon">
                                                {include file="$template/assets/svg-icon/64-rocket-dashed-box.tpl"}
                                            </div>
                                                <div class="feature-content">
                                                <p class="feature-desc">{lang key='store.socialbee.features.create.i2'}</p>
                                                </div>
                                        </div>
                                    </div>

                                    <div class="col-md col-md-4 col-sm-6">
                                        <div class="feature">
                                            <div class="feature-icon">
                                                {include file="$template/assets/svg-icon/blogging.tpl"}
                                            </div>
                                            <div class="feature-content">
                                                <p class="feature-desc">{lang key='store.socialbee.features.create.i3'}</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md col-md-4 col-sm-6">
                                        <div class="feature">
                                            <div class="feature-icon">
                                                {include file="$template/assets/svg-icon/64-badge-website-3.tpl"}
                                            </div>
                                            <div class="feature-content">
                                                <p class="feature-desc">{lang key='store.socialbee.features.create.i4'}</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md col-md-4 col-sm-6">
                                        <div class="feature">
                                            <div class="feature-icon"> 
                                                {include file="$template/assets/svg-icon/icon-unlimited-files-and-databases.tpl"}
                                            </div>
                                            <div class="feature-content">
                                                <p class="feature-desc">{lang key='store.socialbee.features.create.i5'}</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md col-md-4 col-sm-6">
                                        <div class="feature">
                                            <div class="feature-icon">
                                                {include file="$template/assets/svg-icon/video.tpl"}
                                            </div>
                                            <div class="feature-content">
                                                <p class="feature-desc">{lang key='store.socialbee.features.create.i6'}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" role="tabpanel" id="schedule">
                            <div class="section-content">
                                <div class="row row-eg-height row-eq-height-xs features">
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/instagram-twitter-connect.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.schedule.i1'}</p>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-calendar-1.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.schedule.i2'}</p>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/blogging.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.schedule.i3'}</p>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-arrows-up-clock-time-3.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.schedule.i4'}</p>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-badge-2.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.schedule.i5'}</p>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/clock-time-box.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.schedule.i6'}</p>
                                                </div>
                                            </div>
                                        </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" role="tabpanel" id="engage">
                            <div class="section-content">
                                <div class="row row-eg-height row-eq-height-xs features">
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/email-archiving.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.engage.i1'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/comments.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.engage.i2'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/icon-full-automation.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.engage.i3'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/our-team.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.engage.i4'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-website-success-cup-3.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.engage.i5'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-briefcase-3.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.engage.i6'}</p>
                                                </div>
                                            </div>
                                        </div>
                                </div>
                            </div>
                        </div>
                       
                        <div class="tab-pane fade" role="tabpanel" id="collaborate">
                            <div class="section-content">
                                <div class="row row-eg-height row-eq-height-xs features">
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-one-click-installation-6.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.collaborate.i1'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-check-circle.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.collaborate.i2'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-dashboard-time-clock.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.collaborate.i3'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-dashboard-success.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.collaborate.i4'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/our-team.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.collaborate.i5'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-litespeed.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.collaborate.i6'}</p>
                                                </div>
                                            </div>
                                        </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane fade" role="tabpanel" id="analyze">
                            <div class="section-content">
                                <div class="row row-eg-height row-eq-height-xs features">
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-laptop-chart.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.analyze.i1'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-chart-briefcase.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.analyze.i2'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-browser-bar-chart.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.analyze.i3'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-website-success-cup-1.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.analyze.i4'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/64-calendar-2.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.analyze.i5'}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md col-md-4 col-sm-6">
                                            <div class="feature">
                                                <div class="feature-icon">
                                                    {include file="$template/assets/svg-icon/icon-file-change-alert-monitoring.tpl"}
                                                </div>
                                                <div class="feature-content">
                                                    <p class="feature-desc">{lang key='store.socialbee.features.analyze.i6'}</p>
                                                </div>
                                            </div>
                                        </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="section-actions">
                        <a tabindex="0" href="#" class="btn btn-primary btn-lg" onclick="smoothScroll('#pricing');return false">
                            {lang key='store.socialbee.packages'}
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="site-section social-bee" id="pricing">
            <div class="container">
                <div class="section-content">
                    <h2 class="section-title">{lang key='store.socialbee.pricing.header.title'}</h2>
                    <p class="section-subtitle">{lang key='store.socialbee.pricing.header.body'}</p>
                    <div class="pricing-table-container">
                        <div class="pricing-table">
                            <div class="pricing-table__row pricing-table__header-row">
                                <div class="pricing-table__cell pricing-table__header-cell pricing-table__feature-header">{lang key='features'}</div>
                                {foreach $planComparisonData as $plan}
                                <div class="pricing-table__cell pricing-table__header-cell pricing-table__plan-header">
                                    {lang key='store.socialbee.plan.'|cat:($plan->name|lower)}
                                </div>
                                {/foreach}
                            </div>

                            {foreach $planFeatures as $featureKey => $featureValues}
                                <div class="pricing-table__row">
                                    <div class="pricing-table__cell pricing-table__feature-name">
                                        {lang key="store.socialbee.comparison."|cat:$featureKey}
                                    </div>
                                    {foreach $featureValues as $featureValue}
                                    <div class="pricing-table__cell">
                                        {if $featureValue}
                                            {if $featureValue === true}
                                                <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M9.5 18C14.4706 18 18.5 13.9706 18.5 9C18.5 4.02944 14.4706 0 9.5 0C4.52944 0 0.5 4.02944 0.5 9C0.5 13.9706 4.52944 18 9.5 18ZM13.6479 5.1479L14.3479 5.8479C14.3948 5.89438 14.432 5.94968 14.4573 6.01061C14.4827 6.07154 14.4958 6.13689 14.4958 6.2029C14.4958 6.2689 14.4827 6.33426 14.4573 6.39519C14.432 6.45612 14.3948 6.51142 14.3479 6.5579L8.0579 12.8479C8.01325 12.8959 7.95905 12.9341 7.89877 12.9599C7.83849 12.9858 7.77347 12.9987 7.7079 12.9979H7.2879C7.22232 12.9987 7.15731 12.9858 7.09703 12.9599C7.03675 12.9341 6.98254 12.8959 6.9379 12.8479L4.6479 10.5579C4.60104 10.5114 4.56384 10.4561 4.53845 10.3952C4.51307 10.3343 4.5 10.2689 4.5 10.2029C4.5 10.1369 4.51307 10.0715 4.53845 10.0106C4.56384 9.94968 4.60104 9.89438 4.6479 9.8479L5.3479 9.1479C5.39438 9.10104 5.44968 9.06384 5.51061 9.03845C5.57154 9.01307 5.63689 9 5.7029 9C5.76891 9 5.83426 9.01307 5.89519 9.03845C5.95612 9.06384 6.01142 9.10104 6.0579 9.1479L7.4979 10.5879L12.9379 5.1479C12.9844 5.10104 13.0397 5.06384 13.1006 5.03845C13.1615 5.01307 13.2269 5 13.2929 5C13.3589 5 13.4243 5.01307 13.4852 5.03845C13.5461 5.06384 13.6014 5.10104 13.6479 5.1479Z" fill="#299341"/>
                                                </svg>
                                            {elseif is_string($featureValue)}
                                                <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M9.5 0C14.4706 0 18.5 4.02944 18.5 9C18.5 13.9706 14.4706 18 9.5 18C4.52944 18 0.5 13.9706 0.5 9C0.5 4.02944 4.52944 0 9.5 0ZM9.44922 7.53516L5.91406 4L4.5 5.41406L8.03516 8.94922L4.5 12.4854L5.91406 13.8994L9.44922 10.3633L12.9854 13.8994L14.3994 12.4854L10.8633 8.94922L14.3994 5.41406L12.9854 4L9.44922 7.53516Z" fill="#D92632"/>
                                                </svg>
                                            {else}
                                                {$featureValue}
                                            {/if}
                                        {else}
                                            <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M9.5 0C14.4706 0 18.5 4.02944 18.5 9C18.5 13.9706 14.4706 18 9.5 18C4.52944 18 0.5 13.9706 0.5 9C0.5 4.02944 4.52944 0 9.5 0ZM9.44922 7.53516L5.91406 4L4.5 5.41406L8.03516 8.94922L4.5 12.4854L5.91406 13.8994L9.44922 10.3633L12.9854 13.8994L14.3994 12.4854L10.8633 8.94922L14.3994 5.41406L12.9854 4L9.44922 7.53516Z" fill="#D92632"/>
                                            </svg>
                                        {/if}
                                    </div>
                                    {/foreach}
                                </div>
                            {/foreach}

                            <div class="pricing-table__row">
                                <div class="pricing-table__cell pricing-table__feature-name">
                                    {lang key='store.price'}
                                </div>
                                {foreach $planComparisonData as $plan}
                                    <div class="pricing-table__cell">
                                        {if  $plan->isFree()}
                                            {lang key="orderpaymenttermfree"}
                                        {else}
                                            {$plan->pricing()->first()->toPrefixedString()}
                                        {/if}
                                    </div>
                                {/foreach}
                            </div>

                            <div class="pricing-table__row pricing-table__row-actions">
                                <div class="pricing-table__cell pricing-table__feature-name pricing-table__cell"></div>
                                {foreach $planComparisonData as $plan}
                                    <div class="pricing-table__cell">
                                        <form method="post" action="{routePath('cart-order')}">
                                            <input type="hidden" name="checkout" value="1">
                                            <input type="hidden" name="pid" value="{$plan->id}">
                                            <button tabindex="0" class="btn btn-primary btn-sm">{lang key='store.getstarted'}</button>
                                        </form>
                                    </div>
                                {/foreach}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="site-section">
            <div class="container">
                <h2 class="section-title">{lang key='store.faq'}</h2>
                <p class="section-subtitle">{lang key='store.socialbee.faq.unanswered'}</p>
                <div class="section-content m-w-lg m-a">    
                    <div class="panel-group panel-group-condensed panel-faq accordion" id="accordion">
                        <div class="panel panel-accordion is-open">
                            <div class="panel-heading" data-toggle="collapse" aria-expanded="false" role="button" tabindex="0" data-target="#which-social-medial" aria-expanded="true" role="button">
                                <h4 class="panel-title"><i class="lm lm-plus"></i>{lang key='store.socialbee.faq.q1'}</h4>
                            </div>
                            <div id="which-social-medial" class="panel-collapse collapse show" aria-expanded="true" role="button" style="" data-parent="#accordion">
                                <div class="panel-body">
                                    <p>{lang key='store.socialbee.faq.a1'}</p>
                                </div>
                            </div>        
                        </div>
                        <div class="panel panel-accordion">
                            <div class="panel-heading" data-toggle="collapse" aria-expanded="false" role="button" tabindex="0" data-target="#why_should_i_choose_socialbee" aria-expanded="true" role="button">
                                <h4 class="panel-title"><i class="lm lm-plus"></i>{lang key='store.socialbee.faq.q2'}</h4>
                            </div>
                            <div id="why_should_i_choose_socialbee" class="panel-collapse collapse" aria-expanded="true" role="button" style="" data-parent="#accordion">
                                <div class="panel-body">
                                    <p>{lang key='store.socialbee.faq.a2.text'}</p>
                                    <ul>
                                        <li>
                                            {lang key='store.socialbee.faq.a2.i1'}
                                        </li>
                                        <li>
                                            {lang key='store.socialbee.faq.a2.i2'}
                                        </li>
                                        <li>
                                            {lang key='store.socialbee.faq.a2.i3'}
                                        </li>
                                        <li>
                                            {lang key='store.socialbee.faq.a2.i4'}
                                        </li>
                                        <li>
                                            {lang key='store.socialbee.faq.a2.i5'}
                                        </li>
                                    </ul>
                                </div>
                            </div>        
                        </div>
                        <div class="panel panel-accordion">
                            <div class="panel-heading" data-toggle="collapse" aria-expanded="false" role="button" tabindex="0" data-target="#what_support_options_are_available_for_socialbee" aria-expanded="true" role="button">
                                <h4 class="panel-title"><i class="lm lm-plus"></i>{lang key='store.socialbee.faq.q3'}</h4>
                            </div>
                            <div id="what_support_options_are_available_for_socialbee" class="panel-collapse collapse" aria-expanded="true" role="button" style="" data-parent="#accordion">
                                <div class="panel-body">
                                    <p>{lang key='store.socialbee.faq.a3'}</p>
                                </div>
                            </div>        
                        </div>
                        <div class="panel panel-accordion">
                            <div class="panel-heading" data-toggle="collapse" aria-expanded="false" role="button" tabindex="0" data-target="#are_socialbee_agency_plans_different_from_the_regular_pro_plan" aria-expanded="true" role="button">
                                <h4 class="panel-title"><i class="lm lm-plus"></i>{lang key='store.socialbee.faq.q4'}</h4>
                            </div>
                            <div id="are_socialbee_agency_plans_different_from_the_regular_pro_plan" class="panel-collapse collapse" aria-expanded="true" role="button" style="" data-parent="#accordion">
                                <div class="panel-body">
                                    <p>
                                        {lang key='store.socialbee.faq.a4.text'}
                                    </p>

                                    <ul>
                                        <li><b>{lang key='store.socialbee.plan.pro'}:</b>
                                            <ul class="faq__nested-list">
                                                <li>{lang key='store.socialbee.profiles' num=25}</li>
                                                <li>{lang key='store.socialbee.workspaceusers' num=3} | {lang key='store.socialbee.workspaceusers' num=5}</li>
                                            </ul>
                                        </li>

                                        <li><b>{lang key='store.socialbee.plan.pro50'}:</b>
                                            <ul class="faq__nested-list">
                                                <li>{lang key='store.socialbee.profiles' num=50}</li>
                                                <li>{lang key='store.socialbee.workspaceusers' num=5} | {lang key='store.socialbee.workspaceusers' num=10}</li>
                                            </ul>
                                        </li>

                                        <li><b>{lang key='store.socialbee.plan.pro100'}:</b>
                                            <ul class="faq__nested-list">
                                                <li>{lang key='store.socialbee.profiles' num=100}</li>
                                                <li>{lang key='store.socialbee.workspaceusers' num=5} | {lang key='store.socialbee.workspaceusers' num=20}</li>
                                            </ul>
                                        </li>

                                        <li><b>{lang key='store.socialbee.plan.pro150'}:</b>
                                            <ul class="faq__nested-list">
                                                <li>{lang key='store.socialbee.profiles' num=150}</li>
                                                <li>{lang key='store.socialbee.workspaceusers' num=5} | {lang key='store.socialbee.workspaceusers' num=30}</li>
                                            </ul>
                                        </li>
                                    </ul>
                                </div>
                            </div>        
                        </div>
                        <div class="panel panel-accordion">
                            <div class="panel-heading" data-toggle="collapse" aria-expanded="false" role="button" tabindex="0" data-target="#where_are_socialbee_servers_located" aria-expanded="true" role="button">
                                <h4 class="panel-title"><i class="lm lm-plus"></i>{lang key='store.socialbee.faq.q5'}</h4>
                            </div>
                            <div id="where_are_socialbee_servers_located" class="panel-collapse collapse" aria-expanded="true" role="button" style="" data-parent="#accordion">
                                <div class="panel-body">
                                    <p>{lang key='store.socialbee.faq.a5'}</p>
                                </div>
                            </div>        
                        </div>
                    </div>
                </div>
            </div>
        </div>
</div>
{/if}