<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Error – Something Went Wrong</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <style>
        body {
            margin: 0;
            padding: 0;
            background: #f2f2f5;
            font-family: "Poppins", Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .error-container {
            background: #fff;
            padding: 40px 50px;
            max-width: 500px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        }

        .error-icon {
            font-size: 60px;
            color: #F24361;
        }

        h1 {
            margin-top: 20px;
            font-size: 28px;
            color: #1A234A;
            font-weight: 600;
        }

        p {
            margin: 10px 0 20px;
            font-size: 15px;
            color: #555;
            line-height: 1.6;
        }

        .btn {
            display: inline-block;
            margin-top: 15px;
            background: #F24361;
            color: #fff!important;
            padding: 12px 25px;
            border-radius: 6px;
            font-size: 15px;
            text-decoration: none;
            transition: 0.2s;
        }

        .btn:hover {
            background: #d83453;
        }

        .footer {
            margin-top: 20px;
            font-size: 13px;
            color: #999;
        }
    </style>
</head>

<body>

<div class="error-container">

    <div class="error-icon">⚠️</div>

    <h1>Something Went Wrong</h1>

    <p>
        We were unable to process your request at this moment.<br>
        This may be temporary — please try again shortly.
    </p>

    <a href="/" class="btn">Return to Homepage</a>

    <div class="footer">
        If the problem continues, please contact support.
    </div>

</div>

</body>
</html>
