<?php

return [
    'display_name' => 'Boxed',
    'preview'      => 'thumb.png',
    'settings'     => [
        'showContinueButton' => [
            'type' => 'checkbox',
            'name' => 'showContinueButton',
            'label' => 'Replace "Add To Cart" Button With "Continue"',
            'tooltip' => 'Replace "Add To Cart" button with "Continue" button, for primary domain lookup in the main box below domain search.'
        ],
        'automaticallyAddViaExternalLink' => [
            'type' => 'checkbox',
            'name' => 'automaticallyAddViaExternalLink',
            'label' => 'Automatic Domain Order',
            'tooltip' => "When external product link includes sld & tld - eg. `cart.php?a=add&pid=1&sld=whmcs&tld=.com` - domain will be automatically added to the cart"    
        ],
        'SearchPrefix' => [
            'type' => 'checkbox',
            'name' => 'SearchPrefix',
            'label' => 'Show WWW Prefix for Domain Search',
            'tooltip' => "Shows a 'www.' prefix hint in front of the domain entry field for clarity. It does not affect validation or search results."
        ],
        'tldCategorySelect' => [
            'type' => 'checkbox',
            'name' => 'tldCategorySelect',
            'label' => 'Display Spotlight TLDs in a Separate Category',
            'tooltip' => 'Show TLDs from the WHMCS "Spotlight" list in a special "Most Popular" section above other extensions in the TLD dropdown.',
            'tooltip_url' => 'https://lagom.rsstudio.net/docs/page-templates/#display-spotlight-tlds-in-a-separate-category',
        ],
        'tldSorting' => [
            'type' => 'select',
            'name' => 'tldSorting',
            'label' => 'Sorting TLDs in Dropdown Selection',
            'options' => 'Default,Alphabetically',
            'default' => 'Default',
            'tooltip' => 'Choose how TLDs are ordered in the TLD dropdown. Keep the WHMCS order or sort alphabetically.',
            'tooltip_url' => 'https://lagom.rsstudio.net/docs/page-templates/#sorting-tlds-in-dropdown-selection',
        ],
    ]
];
