<h3 class="page-header"><i class="fa fa-briefcase"></i> {$_lang.projectdetails} <a class="btn btn-link pull-right flip" href="index.php?m=project_management"><i class="fa fa-folder-open-o"></i> {$_lang.projectsoverview}</a></h3>



<h3>{$project.title} <small> <span class="label label-success"><span class="glyphicon glyphicon-briefcase"> </span> {$project.status}</span>{if in_array('staff',$features)} <span class="label label-default"><span class="glyphicon glyphicon-user"></span> {$project.adminname}</span>{/if}</small></h3>

<div class="row">
    <div class="col-md-4">
    <div class="form-group">
        <div class="input-group">
          <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span></span>
          <input type="text" class="form-control" placeholder="{$_lang.created}:{$project.created}">
      </div>
  </div>
  </div>
  <div class="col-md-4">
  <div class="form-group">
    <div class="input-group">
      <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span></span>
      <input type="text" class="form-control" placeholder=" {$_lang.duedate}:{$project.duedate}">
  </div>
</div>
</div>
{if in_array('time',$features)}
<div class="col-md-4">
<div class="form-group">
    <div class="input-group">
      <span class="input-group-addon"><span class="glyphicon glyphicon-time"></span></span>
      <input type="text" class="form-control" placeholder="{$_lang.totaltime}:{$project.totaltime}">
  </div>
</div>
</div>
</div>
{/if}
{if in_array('tasks',$features)}
<div class="panel panel-default">
  <div class="panel-heading gray-header"><h3 class="panel-title"><span aria-hidden="true" class="icon icon-drawer"></span> {$_lang.tasks} <a class="btn btn-xs btn-link pull-right flip" href="#" onclick="showTimeLogs();return false"><i class="fa fa-clock-o"></i> {$_lang.showhidetimelogs}</a></h3>
  </div>
  <div class="clearfix"></div>
  <div class="panel-body">
    <p>{$_lang.projectguidance}</p>
</div>
<table class="table table-striped">
    {foreach from=$tasks key=tasknum item=task}
    <tr>
        <td class="width20px"><span class="badge badge-circle">{$tasknum}</span></td>
        <td><p>{if $task.completed}<span class="label active">{$_lang.completed}</span>{/if} {$task.task}{if $task.duein} <span class="taskdue">{$task.duein}</span> <span class="label label-default">{$task.duedate}</span>{/if}{if $task.times}</p>
            <table class="table timedetail">
                <thead>
                    <tr>
                        <th><i class="fa fa-clock-o"></i> {$_lang.starttime}</th>
                        <th><i class="fa fa-clock-o"></i> {$_lang.stoptime}</th>
                        <th>{$_lang.duration}</th>
                    </tr>
                </thead>
                <tbody>
                    {foreach from=$task.times item=time}
                    <tr>
                        <td>{$time.start}</td>
                        {if $time.end}<td>{$time.end}</td>
                        <td class="textcenter">{$time.duration}</td>
                        {else}<td colspan="2">{$_lang.inprogress}</td>
                        {/if}
                    </tr>
                    {/foreach}
                    <tr>
                        <td colspan="2">{$_lang.total}</td>
                        <td>{$task.totaltime}</td>
                    </tr>
                </tbody>
            </table>
            {/if}</td>
        </tr>
        {foreachelse}
        <tr>
            <td colspan="6">{$LANG.norecordsfound}</td>
        </tr>
        {/foreach}
    </table>
    <div class="panel-footer">
                {if in_array('addtasks',$features)}
                    <form method="post" action="index.php?m=project_management&a=view">
                        <input type="hidden" name="id" value="{$project.id}" />
                        <div class="input-group">
                            <input type="text" name="newtask" class="form-control">
                            <span class="input-group-btn">
                                <button type="submit" class="btn btn-default">
                                   <i class="fa fa-plus"></i> {$_lang.addtask}
                                </button>
                            </span>
                        </div>
                    </form>
                {/if}

</div>
</div>
{/if}
<ul class="nav nav-tabs marginbottom15" data-tabs="tabs">
    <li class="active"><a href="#tab1" data-toggle="tab">{$_lang.associatedtickets}</a></li>
    <li><a href="#tab2" data-toggle="tab">{$_lang.associatedinvoices}</a></li>
    <li><a href="#tab3" data-toggle="tab">{$_lang.timetracking}</a></li>
</ul>
<div class="tab-content">
    <div id="tab1" class="tab-pane active">
        <div class="panel panel-default">
          <div class="panel-heading gray-header">
            <h3 class="panel-title"><i class="fa fa-clone"></i> {$_lang.associatedtickets}</h3>
        </div>
        <div class="panel-body">
            {if $tickets}
            {foreach from=$tickets item=ticket}
            <p><span class="label label-default">{$ticket.tid}</span> <a href="viewticket.php?tid={$ticket.tid}&c={$ticket.c}">{$ticket.title}</a></p>
            {/foreach}
            {else}
            {$_lang.none}
            {/if}
        </div>
    </div>
</div>
<div id="tab2" class="tab-pane">
    <div class="panel panel-default">
      <div class="panel-heading  gray-header">
        <h3 class="panel-title"><i class="fa fa-file-o"></i> {$_lang.associatedinvoices}</h3>
    </div>
    <div class="panel-body">
        {if $invoices}
        {foreach from=$invoices item=invoice}
        <p><a href="viewinvoice.php?id={$invoice.id}">{$LANG.invoicenumber}{$invoice.id}</a> - {$invoice.total} <span class="label {$invoice.rawstatus}">{$invoice.status}</span></p>
        {/foreach}
        {else}
        <p>{$_lang.none}</p>
        {/if}
    </div>
</div>
</div>
{if in_array('time',$features)}
<div id="tab3" class="tab-pane">
    <div class="panel panel-default">
      <div class="panel-heading  gray-header">
        <h3 class="panel-title"><i class="fa fa-clock-o"></i> {$_lang.timetracking}</h3>
    </div>
    <div class="panel-body">
        <h3>{$project.totaltime} <small>{$_lang.hours}</small></h3>
    </div>
</div>
</div>
{/if}
</div>
{if in_array('files',$features)}
<div class="panel panel-default">
  <div class="panel-heading  gray-header">
    <h3 class="panel-title"><i class="fa fa-upload"></i> {$_lang.fileuploads}</h3>
</div>
<div class="panel-body">
    {if $attachments}
    {foreach from=$attachments key=attachnum item=attachment}
    <div class="col-md-3"><div class="well well-sm"><i class="fa fa-file-o"></i> <a href="modules/addons/project_management/project_management.php?action=dl&projectid={$project.id}&i={$attachnum}">{$attachment.filename}</a></div></div>
    {/foreach}
    {else}
    <p>{$_lang.none}</p>
    {/if}
</div>
</div>
<p>
    <button type="button" class="btn btn-default" onclick="showFileUpload()" id="btnFileUpload">
        <i class="fa fa-plus"></i>
        {$_lang.addfile}
    </button>
</p>
<div id="containerUploadFile" class="hidden">
    <form method="post" action="{$smarty.server.PHP_SELF}?m=project_management&a=view" enctype="multipart/form-data">
        <input type="hidden" name="id" value="{$project.id}" />
        <input type="hidden" name="upload" value="true" />
        <p><input type="file" name="attachments[]" class="form-control" /></p>
        <p><input type="submit" value="{$_lang.upload}" class="btn btn-success" /></p>
    </form>
    <small class="text-muted">
        {$_lang.allowedExtensions}<br />
        {$allowedExtensions}
    </small>
</div>
{/if}
<script>
    function showFileUpload() {
        if (!jQuery("#containerUploadFile").is(":visible")) {
            jQuery("#containerUploadFile").hide().removeClass('hidden');
        }
        jQuery('#containerUploadFile').slideToggle();
    }
    function showTimeLogs() {
        jQuery('.timedetail').fadeToggle();
    }
</script>
