{if $minimal == 1}
	<section class="login-box">
		<div class="minimal-logo">
			{*<span class="icon icon-logo"></span>*}
			<img src="{$MB_logo}">
		</div>

		<h2>{$LANG.login}</h2>

		<p class="text-danger bg-danger text-alert {if !$incorrect} displaynone{/if}" id="login-error">
			<strong><i class="fa fa-exclamation-triangle"></i> {$LANG.warning}</strong><br/>{$LANG.loginincorrect}
		</p>

		{if $ssoredirect}
			<p class="text-info bg-info"><i class="fa fa-external-link-square"></i> {$LANG.sso.redirectafterlogin}</p>
		{/if}

		<form method="post" action="{$systemsslurl}dologin.php">
			<div class="form-group">
				<div class="input-group input-group-lg">
					<span class="input-group-addon"><i class="icon icon-email"></i></span>
					<input class="form-control" name="username" type="text" placeholder="{$LANG.loginemail}">
				</div>
			</div>
			<div class="form-group">
				<div class="input-group input-group-lg">
					<span class="input-group-addon"><i class="icon icon-password"></i></span>
					<input class="form-control" name="password" type="password" placeholder="{$LANG.loginpassword}">
				</div>
			</div>

			<button>{$LANG.login}</button>

			<section>
				<div>
					<input type="checkbox" name="rememberme" id="rememberme">
					<label class="checkbox rememberme" for="rememberme">{$LANG.loginrememberme}</label>
				</div>
				<div>
					<a href="register.php">{$LANG.signup}</a> |
					<a href="pwreset.php" class="forgot">{$LANG.loginforgotteninstructions}</a>
				</div>
			</section>
		</form>
	</section>
{else}
<div class="container-fluid">
    {include file="$template/pageheader.tpl" title=$LANG.login}
    {if $incorrect}
		<div class="alert alert-danger">
			<p><i class="fa fa-exclamation-triangle"></i> {$LANG.loginincorrect}</p>
		</div>
	{elseif $ssoredirect}
		{include file="$template/includes/alert.tpl" type="info" msg=$LANG.sso.redirectafterlogin}
	{/if}
	<form method="post" action="{$systemsslurl}dologin.php">
		<div class="row">
			<div class="col-md-6">
				<div class="form-group">
					<label class="control-label" for="username">{$LANG.loginemail}:</label>
					<input class="form-control" name="username" id="username" tabindex="1" type="text" />
				</div>
				<div class="checkbox">
					<label><input type="checkbox" tabindex="3" name="rememberme"{if $rememberme} checked="checked"{/if} />{$LANG.loginrememberme}</label>
				</div>
			</div>
			<div class="col-md-6">
				<div class="form-group">
					<label class="control-label" for="password">{$LANG.loginpassword}:</label>
					<input class="form-control" name="password" id="password" tabindex="2" type="password" />
				</div>
				<a href="pwreset.php" tabindex="5">{$LANG.loginforgotteninstructions}</a>
			</div>
		</div>
		<input type="submit" tabindex="4" class="btn btn-primary" value="{$LANG.loginbutton}" />
	</form>
</div>
{/if}