{include file="$template/pageheader.tpl" title=$LANG.clientareaproducts desc=$LANG.clientareaproductsintro}
{include file="$template/includes/tablelist.tpl" tableName="ServicesList" filterColumn="3" noSortColumns="4"}
<script type="text/javascript">
    jQuery(document).ready( function ()
    {
        var table = jQuery('#tableServicesList').removeClass('hidden').DataTable();
        {if $orderby == 'product'}
            table.order([0, '{$sort}'], [3, 'asc']);
        {elseif $orderby == 'amount' || $orderby == 'billingcycle'}
            table.order(1, '{$sort}');
        {elseif $orderby == 'nextduedate'}
            table.order(2, '{$sort}');
        {elseif $orderby == 'domainstatus'}
            table.order(3, '{$sort}');
        {/if}
        table.draw();
        jQuery('#tableLoading').addClass('hidden');
    });
</script>






<div class="panel panel-default">

  <div class="panel-heading clearfix"> {include file="$template/includes/sidebar.tpl" sidebar=$primarySidebar}</div>

    <table id="tableServicesList" class="table table-list hidden">
        <thead>
            <tr>
                <th>{$LANG.orderproduct}</th>
                <th>{$LANG.clientareaaddonpricing}</th>
                <th>{$LANG.clientareahostingnextduedate}</th>
                <th>{$LANG.clientareastatus}</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            {foreach key=num item=service from=$services}
                <tr>
                    <td>
                        <a class="btn-link-custom" href="clientarea.php?action=productdetails&amp;id={$service.id}"><strong>{$service.product}</strong></span></a>
						{*if $service.domain}<br><a href="http://{$service.domain}" target="_blank">{$service.domain}</a>{/if*}
						{if $service.domain}<br>{$service.domain}{/if}
					</td>
                    <td>{$service.amount}<br>{$service.billingcycle}</td>
                    <td><span class="hidden">{$service.normalisedNextDueDate}</span>{$service.nextduedate}</td>
                    <td><span class="label label-{$service.status|strtolower}">{$service.statustext}</span></td>
                    <td class="text-right"><a class="btn btn-link" href="clientarea.php?action=productdetails&amp;id={$service.id}"><span class="ion-chevron-right action-icon"></span></a>
                    </td>
                </tr>
            {/foreach}
        </tbody>
    </table>
    <div class="text-center" id="tableLoading">
        <p><i class="fa fa-spinner fa-spin"></i> {$LANG.loading}</p>
    </div>
    <div class="clearfix"></div>
</div>
