{include file="$template/pageheader.tpl" title=$LANG.invoices desc=$LANG.invoicesintro}
{include file="$template/includes/tablelist.tpl" tableName="InvoicesList" filterColumn="4" noSortColumns="5"}

<div class="form-group clearfix">
<div class="pull-right flip">
    <span class="invoicetotal">{$LANG.invoicesoutstandingbalance}: <span class="text{if $nobalance} label label-success{else} label label-warning{/if}">{$totalbalance}</span></span>{if $masspay}&nbsp; <a href="clientarea.php?action=masspay&all=true" class="btn btn-link"><span class="glyphicon glyphicon-ok-circle"></span> {$LANG.masspayall}</a>{/if}
</div>
</div>

<script type="text/javascript">
    jQuery(document).ready( function ()
    {
        var table = jQuery('#tableInvoicesList').removeClass('hidden').DataTable();
        {if $orderby == 'default'}
            table.order([4, 'desc'], [2, 'asc']);
        {elseif $orderby == 'invoicenum'}
            table.order(0, '{$sort}');
        {elseif $orderby == 'date'}
            table.order(1, '{$sort}');
        {elseif $orderby == 'duedate'}
            table.order(2, '{$sort}');
        {elseif $orderby == 'total'}
            table.order(3, '{$sort}');
        {elseif $orderby == 'status'}
            table.order(4, '{$sort}');
        {/if}
        table.draw();
        jQuery('#tableLoading').addClass('hidden');
    });
</script>

<div class="table-container clearfix">
    <div class="panel panel-default">
    <div class="panel-heading clearfix"> {include file="$template/includes/sidebar.tpl" sidebar=$primarySidebar}</div>
    <table id="tableInvoicesList" class="table table-list hidden">
        <thead>
            <tr>
                <th>{$LANG.invoicestitle}</th>
                <th>{$LANG.invoicesdatecreated}</th>
                <th>{$LANG.invoicesdatedue}</th>
                <th>{$LANG.invoicestotal}</th>
                <th>{$LANG.invoicesstatus}</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            {foreach key=num item=invoice from=$invoices}
                <tr>
                    <td>{$invoice.invoicenum}</td>
                    <td><span class="hidden">{$invoice.normalisedDateCreated}</span>{$invoice.datecreated}</td>
                    <td><span class="hidden">{$invoice.normalisedDateDue}</span>{$invoice.datedue}</td>
                    <td>{$invoice.total}</td>
                    <td><span class="label label-{$invoice.statusClass}">{$invoice.status}</span></td>
                    <td class="text-right"><a href="viewinvoice.php?id={$invoice.id}">
                            {*$LANG.clientareaviewdetails*}
							<i class="ion-chevron-right action-icon"></i>
                        </a>
                    </td>
                </tr>
            {/foreach}
        </tbody>
    </table>
    <div class="text-center" id="tableLoading">
        <p><i class="fa fa-spinner fa-spin"></i> {$LANG.loading}</p>
    </div>	
    </div>

</div>

