{literal}
<script type="text/javascript">
jQuery(function () {
  jQuery('[data-toggle="tooltip"]').tooltip()
})
</script>
{/literal}
<div class="clientarea-normal">
	<div class="row">
		<div class="col-sm-3 col-xs-6 clientarea-button">
			<a title="Products/Services" href="clientarea.php?action=products">
				<span class="pe-7s-server"></span>
				<h4>{$LANG.statsnumproducts}</h4>
			</a>
			<span class="label label-green">{$clientsstats.productsnumactive}</span>
		</div>
		<div class="col-sm-3 col-xs-6 clientarea-button">
			<a title="Domains" href="clientarea.php?action=domains">
				<span class="pe-7s-global"> </span>
				<h4>{$LANG.statsnumdomains}</h4>
			</a>
			<span class="label label-pink">{$clientsstats.numactivedomains}</span>
		</div>
		<div class="col-sm-3 col-xs-6 clientarea-button">
			<a title="Invoices" href="clientarea.php?action=invoices">
				<span class="pe-7s-file"> </span>
				<h4>{$LANG.invoicesdue}</h4>
			</a>
			<span class="label label-yellow">{$clientsstats.numdueinvoices}</span>
		</div>
		<div class="col-sm-3 col-xs-6 clientarea-button">
			<a title="Support Tickets" href="supporttickets.php">
				<span class="pe-7s-help1"> </span>
				<h4>{$LANG.statsnumtickets}</h4>
			</a>
			<span class="label label-blue">{$clientsstats.numtickets}</span>
		</div>
	</div>
</div>	
<div class="row">
	<div class="col-sm-6">
		<h4 class="subtitle">
			<i class="pe-7s-cash mr10"></i>
			<span>{$LANG.navbilling}</span>
		</h4>
			<table class="table">
				<tr>
					<td><i class="pe-7s-file font-20 pull-left mr10"></i> {$LANG.statsdueinvoicesbalance}:</td>
					<td><a href="clientarea.php?action=invoices">{$clientsstats.dueinvoicesbalance}</a>
					</td>
					<td><a href="clientarea.php?action=invoices" title="{$LANG.invoices}"><span class="ion-chevron-right action-icon"></span></a>
					</td>
				</tr>
				<tr>
					<td><i class="pe-7s-credit font-20 pull-left mr10"></i> {$LANG.statscreditbalance}:</td>
					<td><a href="clientarea.php?action=addfunds">{$clientsstats.creditbalance}</a>
					</td>
					<td><a href="clientarea.php?action=addfunds" title="{$LANG.addfunds}"><span class="ion-chevron-right action-icon"></span></a> 
					</td>
				</tr>
			</table>
		
	</div>
	<div class="col-sm-6">
		<h4 class="subtitle">
			<i class="pe-7s-info mr10"></i>
			<span>{$LANG.accountinfo}</span>
		</h4>
			<table class="table">
				<tr>
					<td><i class="pe-7s-user font-20 pull-left mr10"></i> {$clientsdetails.firstname} {$clientsdetails.lastname}</td>
					<td><a href="clientarea.php?action=details" title="{$LANG.editaccountdetails}"><span class="ion-chevron-right action-icon"></span></a></td>
				</tr>
				<tr>
					<td><i class="pe-7s-mail font-20 pull-left mr10"></i> {$clientsdetails.email}</td>
					<td><a href="clientarea.php?action=emails" title="{$LANG.navemailssent}"><span class="ion-chevron-right action-icon"></span></a></td>
				</tr>
			</table>
		
	</div> 
</div>
{if $announcements}
<div class="alert clearfix alert-white">
	<p><span class="glyphicon glyphicon-circle-arrow-right"></span> <strong>{$LANG.ourlatestnews}:</strong> {$announcements.0.text|strip_tags|truncate:100:'...'}
		<a href="announcements.php?id={$announcements.0.id}" class="btn btn-default btn-xs pull-right flip">{$LANG.more}</a>
	</p>
</div>{/if} {if $ccexpiringsoon}
<div class="alert alert-danger">
	<p><strong>{$LANG.ccexpiringsoon}:</strong> {$LANG.ccexpiringsoondesc|sprintf2:'
		<a href="clientarea.php?action=creditcard" class="btn btn-danger btn-xs pull-right flip">':'</a>'}</p>
	</div>{/if} {if $clientsstats.incredit}
	<div class="alert alert-success">
		<p><span class="glyphicon glyphicon-plus-sign"></span> <strong>{$LANG.availcreditbal}:</strong> {$LANG.availcreditbaldesc|sprintf2:$clientsstats.creditbalance}</p>
	</div>{/if} {if $clientsstats.numoverdueinvoices>0}
	<div class="alert alert-block alert-danger">
		<p><span class="pe-7s-info"></span> {$LANG.youhaveoverdueinvoices|sprintf2:$clientsstats.numoverdueinvoices}<a href="clientarea.php?action=masspay&amp;all=true" class="btn btn-xs btn-danger pull-right flip">{$LANG.invoicespaynow}</a></p>
	</div>{/if} {foreach from=$addons_html item=addon_html}
	<div class="margin15px0">{$addon_html}</div>{/foreach}

{if $show_inclientarea == 1 && $showqsl }
  {include file="$qsl_clientarea_flattern_template"}
{/if}
	
	<div class="row">
		<div class="col-md-12">
			<a class="btn btn-border pull-right flip mt10 mr10" href="submitticket.php">{$LANG.opennewticket}</a>
			<a class="btn btn-link pull-right flip mt10 mr10" href="supporttickets.php">{$LANG.all}</a>
			<h4  class="subtitle"><i class="badge mr10 badge-circle {if $clientsstats.numactivetickets>0}badge-success{/if}">{$clientsstats.numactivetickets}</i><span>{$LANG.supportticketsopentickets}</span></h4>
			{if in_array('tickets',$contactpermissions)}
				<table class="table table-data table-hover">
					<thead>
						<tr>
							<th>{$LANG.supportticketssubject}</th>
							<th class="hidden-sm hidden-xs">{$LANG.supportticketsdepartment}</th>
							<th class="hidden-sm hidden-xs">{$LANG.supportticketsticketurgency}</th>
							<th></th>
						</tr>
					</thead>
					<tbody>
						{foreach from=$tickets item=ticket}
                        {assign var="label" value="default"}
                        {if $ticket.status|strstr:"779500"}{assign var="label" value="success"}
                        {elseif $ticket.status|strstr:"000000"}{assign var="label" value="primary"}
                        {elseif $ticket.status|strstr:"ff6600"}{assign var="label" value="warning"}
                        {elseif $ticket.status|strstr:"224488"}{assign var="label" value="info"}
                        {elseif $ticket.status|strstr:"cc0000"}{assign var="label" value="danger"}
                        {/if}
						<tr>
							<td>
								<span class="hidden-sm hidden-xs"><button class="btn btn-link" data-toggle="tooltip" data-placement="top" title="{$LANG.supportticketsticketlastupdated}: {$ticket.lastreply}"><span class="glyphicon glyphicon-time"></span></button></span> <span class="label label-{$label}">{$ticket.status|regex_replace:"/(<span>|<span [^>]*>|<\\/span>)/":""}</span> <a href="viewticket.php?tid={$ticket.tid}&amp;c={$ticket.c}">{$ticket.subject}</a>
								<ul	class="cell-inner-list">
									<li class="visible-sm visible-xs"><span class="item-title">{$LANG.supportticketsticketlastupdated} : </span>{$ticket.lastreply}</li>
									<li class="visible-sm visible-xs"><span class="item-title">{$LANG.supportticketsdepartment}: </span>{$ticket.department}</li>
									<li class="visible-sm visible-xs"><span class="item-title">{$LANG.supportticketsticketurgency}: </span>{$ticket.urgency}</li>
								</ul>
							</td>						
							<td class="hidden-sm hidden-xs">{$ticket.department}</td>
							<td class="hidden-sm hidden-xs">{$ticket.urgency}</td>	
							<td><span class="pull-right flip"><a href="viewticket.php?tid={$ticket.tid}&amp;c={$ticket.c}"><span class="glyphicon glyphicon-chevron-right"></span></a></span>
							</td>
						</tr>
						{foreachelse}
						<tr>
							<td colspan="5" class="norecords">{$LANG.norecordsfound}</td>
						</tr>{/foreach}
					</tbody>
				</table>
				{/if}
			
		</div>
	</div>
	<div class="row">
		<div class="col-md-12">		
			{if in_array('invoices',$contactpermissions)}
			<a href="clientarea.php?action=masspay&amp;all=true" class="btn btn-border mt10 mr10 pull-right flip">{$LANG.masspayall}</a>
			<h4 class="subtitle" ><i class="badge mr10 badge-circle {if $clientsstats.numoverdueinvoices>0}badge-important{/if}">{$clientsstats.numdueinvoices}</i><span>{$LANG.invoicesdue}</span></h4>
			
				<form method="post" action="clientarea.php?action=masspay">
					<table class="table table-data table-hover">
						<thead>
							<tr>{if $masspay}
								<th class="cell-checkbox addons-list-custom">
									<input id="custom-01" type="checkbox" onclick="toggleCheckboxes('invids')" />
									<label for="custom-01"></label>
								</th>{/if}
								<th>{$LANG.invoicestitle}</th>
								<th class="text-center hidden-sm hidden-xs" class="invoicecreatedate">{$LANG.invoicesdatecreated}</th>
								<th class="text-center hidden-sm hidden-xs">{$LANG.invoicesdatedue}</th>
								<th class="text-center hidden-sm hidden-xs">{$LANG.invoicesstatus}</th>
								<th class="text-right hidden-sm hidden-xs">{$LANG.invoicestotal}</th>
								<th class="cell-view"></th>
							</tr>
						</thead>
						<tbody>{foreach from=$invoices item=invoice}
							<tr>{if $masspay}
								<td class="cell-checkbox addons-list-custom">
									<input id="custom-{$invoice.id}" type="checkbox" name="invoiceids[]" value="{$invoice.id}" class="invids" />
									<label for="custom-{$invoice.id}"></label>
								</td>{/if}
								<td><a href="viewinvoice.php?id={$invoice.id}" target="_blank" class="item-title">{$invoice.invoicenum}</a>
									<ul
									class="cell-inner-list visible-sm visible-xs">
									<li><span class="label label-{$invoice.rawstatus} label-danger">{$invoice.statustext}</span>
									</li>
									<li><span class="item-title">{$LANG.invoicestotal} : </span>{$invoice.total}</li>
									<li><span class="item-title">{$LANG.invoicesdatecreated} : </span>{$invoice.datecreated}</li>
									<li><span class="item-title">{$LANG.invoicesdatedue} : </span>{$invoice.datedue}</li>
								</ul>
							</td>
							<td class="text-center hidden-sm hidden-xs">{$invoice.datecreated}</td>
							<td class="text-center hidden-sm hidden-xs">{$invoice.datedue}</td>
							<td class="text-center hidden-sm hidden-xs"><span class="label label-{$invoice.rawstatus} label-danger">{$invoice.statustext}</span>
							</td>
							<td class="text-right hidden-sm hidden-xs">{$invoice.total}</td>
							<td class="cell-view"><a href="viewinvoice.php?id={$invoice.id}" target="_blank"><span class="ion-chevron-right action-icon"></span></a>
							</td>
						</tr>{foreachelse}
						<tr>
							<td colspan="{if $masspay}7{else}6{/if}" class="norecords">{$LANG.norecordsfound}</td>
						</tr>{/foreach}</tbody>{if $masspay}
						<tfoot>
							<tr>
								<td class="cell-checkbox addons-list-custom">
									<input id="custom-02" type="checkbox" onclick="toggleCheckboxes('invids')" class="invids" />
									<label for="custom-02"></label>
								</td>
								<td colspan="5" class="">
									<input type="submit" name="masspayselected" value="{$LANG.masspayselected}" class="btn btn-border" /></td><td class="hidden-sm"></td>
							</tr>
						</tfoot>{/if}
					</table>
				</form>
			{/if}
		</div>
	</div>
	{if $files}
	<h3>{$LANG.clientareafiles}</h3>
	<div class="row">
		<div class="form-group">{foreach from=$files item=file}
			<div class="col-md-6"><div class="well well-sm">
				<a href="dl.php?type=f&amp;id={$file.id}"><h4><span class="glyphicon glyphicon-floppy-disk"></span> {$file.title}</h4></a>
				<p>{$LANG.clientareafilesdate}: {$file.date}</p></div></div>{/foreach}</div>
			</div>{/if}
			<div class="modal fade" id="qsl" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel" aria-hidden="true">
			<div class="modal-dialog modal-sm">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
						<h4 class="modal-title">{$LANG.quickserverlogins}</h4>
					</div>
						 {if $show_inclientarea != 1 && $showqsl} 
							{include file="$qsl_modalarea_template"}
						{/if}
					</div>
				</div>
			</div>
				