{if isset($RSThemes['pages']['products'])}
    {include file=$RSThemes['pages']['products']['fullPath']}
{else} 
    {include file="orderforms/$carttpl/common.tpl"}

    <div class="col-md-3 pull-md-left sidebar hidden-xs hidden-sm">
        {include file="orderforms/$carttpl/sidebar-categories.tpl"}
    </div>
    <div class="main-content col-md-9 pull-md-right">
        {include file="orderforms/$carttpl/sidebar-categories-collapsed.tpl"}
        {if $errormessage}
            <div class="alert alert-danger">
                {$errormessage}
            </div>
        {/if}
        {foreach $hookAboveProductsOutput as $output}
            <div>
                {$output}
            </div>
        {/foreach}
        <div class="products" id="products">
            <div class="row row-eq-height row-eq-height-sm">
                {foreach $products as $key => $product}
                    <div class="col-lg-4 col-sm-6">
                        <div class="package {if $product.isFeatured}package-featured{/if}" id="product{$product@iteration}">
                            {if $product.isFeatured}
                                <span class="label-corner label-primary">{$rslang->trans('order.featured')}</span>
                            {/if}
                            <h3 class="package-name">{$product.name}</h3>
                            <div class="package-price">
                                {assign var="productCurrency" value="<span class='price-prefix'>{$currency.prefix}</span>"}
                                {if $product.bid}
                                    <div class="package-starting-from">{$LANG.bundledeal}</div>
                                    {if $product.displayprice}
                                        <span class="price"><span class="price-prefix">{$currency.prefix}</span>{$product.displayprice->toSuffixed()}</span>
                                    {/if}
                                {else}
                                    {if $product.pricing.hasconfigoptions}
                                        <div class="package-starting-from ">{$LANG.startingfrom}</div>
                                    {/if}
                                    <div class="price">{$product.pricing.minprice.price|replace:$currency.prefix:$productCurrency}{if $product.pricing.type !=="free" && $product.pricing.type !=="onetime"}<span class="price-cycle">/{if $product.pricing.minprice.cycle eq "monthly"}{$rslang->trans('order.period.short.monthly')}{elseif $product.pricing.minprice.cycle eq "quarterly"}{$rslang->trans('order.period.short.quarterly')}{elseif $product.pricing.minprice.cycle eq "semiannually"}{$rslang->trans('order.period.short.semiannually')}{elseif $product.pricing.minprice.cycle eq "annually"}{$rslang->trans('order.period.short.annually')}{elseif $product.pricing.minprice.cycle eq "biennially"}{$rslang->trans('order.period.short.biennially')}{elseif $product.pricing.minprice.cycle eq "triennially"}{$rslang->trans('order.period.short.triennially')}{/if}</span>{/if}</div>
                                    {if $product.pricing.minprice.setupFee}
                                        <div class="package-setup-fee">{$product.pricing.minprice.setupFee->toPrefixed()} {$LANG.ordersetupfee}</div>
                                    {/if}
                                {/if}
                            </div>
                            {if $product.features}
                            <ul class="package-features">
                                {foreach $product.features as $feature => $value}
                                    <li id="product{$product@iteration}-feature{$value@iteration}">
                                        {$feature} {$value}
                                    </li>
                                {/foreach}
                            </ul>
                            {/if}
                            {if $product.featuresdesc}
                                <div class="package-content">
                                    <p>{$product.featuresdesc}</p>
                                </div>    
                            {/if}
                            <div class="package-footer">
                                <a href="cart.php?a=add&{if $product.bid}bid={$product.bid}{else}pid={$product.pid}{/if}" class="btn btn-lg btn-primary" id="product{$product@iteration}-order-button">
                                    {$LANG.ordernowbutton}
                                </a>
                                {if $product.qty || $product.qty == "0"}
                                    <div class="package-qty">
                                        {$product.qty} {$LANG.orderavailable}
                                    </div>
                                {/if}
                            </div>
                        </div>
                    </div>
                {/foreach}
            </div>
        </div>   
    {foreach $hookBelowProductsOutput as $output}
            <div>
                {$output}
            </div>
        {/foreach}
    </div>
{/if}