<?php

if (!defined("WHMCS"))
    die("This file cannot be accessed directly");

function widget_nuvelink_subscriptions($vars) {
    global $_ADMINLANG,$chart;

    $title = 'Nuvelink Subscriptions';

    $args = array();
    $args['colors'] = '#80D044,#C11212,#CCCCCC';
    $args['legendpos'] = 'top';
    $args['xlabel'] = 'Day of the Month';
    $args['ylabel'] = 'Number of Subscriptions';
    $args['chartarea'] = '80,40,85%,70%';

    $content = $chart->drawChart('Area',chartdata_subscriptions(),$args,'300px');

    return array('title'=>$title,'content'=>$content);

}

function chartdata_subscriptions() {
    $chartdata = array();
    $chartdata['cols'][] = array('label'=>'Year','type'=>'string');
    $chartdata['cols'][] = array('label'=>'Provisioned','type'=>'number');
    $chartdata['cols'][] = array('label'=>'Not provisioned','type'=>'number');
    $chartdata['cols'][] = array('label'=>'All','type'=>'number');
    for ($i = 14; $i >= 0; $i--) {
        $date = mktime(0,0,0,date("m"),date("d")-$i,date("Y"));
        $provisioned = get_query_val("nl_subscription_details","COUNT(*)","date LIKE '".date("Y-m-d",$date)."%' AND status!='NOT_PROVISIONED'");
        $notProvisioned = get_query_val("nl_subscription_details","COUNT(*)","date LIKE '".date("Y-m-d",$date)."%' AND status='NOT_PROVISIONED'");
        $all = get_query_val("nl_subscription_details","COUNT(*)","date LIKE '".date("Y-m-d",$date)."%'");
        $chartdata['rows'][] = array('c'=>array(array('v'=>date("dS",$date)),array('v'=>(int)$provisioned),array('v'=>(int)$notProvisioned),array('v'=>(int)$all)));
    }
    return $chartdata;
}

add_hook("AdminHomeWidgets",1,"widget_nuvelink_subscriptions");
