<?php

if (!defined("WHMCS"))
    die("This file cannot be accessed directly");

function widget_nuvelink_customers($vars) {
    global $_ADMINLANG,$chart;

    $title = 'Nuvelink Customers';

    $args = array();
    $args['colors'] = '#80D044,#CCCCCC,#C11212';
    $args['legendpos'] = 'top';
    $args['xlabel'] = 'Day of the Month';
    $args['ylabel'] = 'Number of Customers';
    $args['chartarea'] = '80,40,85%,70%';

    $content = $chart->drawChart('Area',chartdata_customers(),$args,'300px');

    return array('title'=>$title,'content'=>$content);

}

function chartdata_customers() {
    $chartdata = array();
    $chartdata['cols'][] = array('label'=>'Year','type'=>'string');
    $chartdata['cols'][] = array('label'=>'Active','type'=>'number');
    $chartdata['cols'][] = array('label'=>'Inactive','type'=>'number');
    $chartdata['cols'][] = array('label'=>'Deleted','type'=>'number');
    for ($i = 14; $i >= 0; $i--) {
        $date = mktime(0,0,0,date("m"),date("d")-$i,date("Y"));
        $active = get_query_val("nl_customers","COUNT(*)","date LIKE '".date("Y-m-d",$date)."%' AND status='Active'");
        $inactive = get_query_val("nl_customers","COUNT(*)","date LIKE '".date("Y-m-d",$date)."%' AND status='Inactive'");
        $deleted = get_query_val("nl_customers","COUNT(*)","date LIKE '".date("Y-m-d",$date)."%' AND status='Deleted'");
        $chartdata['rows'][] = array('c'=>array(array('v'=>date("dS",$date)),array('v'=>(int)$active),array('v'=>(int)$inactive),array('v'=>(int)$deleted)));
    }
    return $chartdata;
}

add_hook("AdminHomeWidgets",1,"widget_nuvelink_customers");
