<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  WGS CF Partner API WHMCS Module By whmcsglobalservices.com
 *  Copyright whmcsglobalservices, All Rights Reserved
 *  
 *  Release: 15 July, 2015
 *  Version: 4.1.4
 *  WHMCS Version: v6,v7
 *  Update Date: 19 June, 2018
 * 
 *  By WHMCSGLOBALSERVICES    https://whmcsglobalservices.com
 *  Contact                   info@whmcsglobalservices.com
 *  
 *  This module is made under license issued by whmcsglobalservices.com
 *  and used under all terms and conditions of license.    Ownership of 
 *  module can not be changed.     Title and copy of    module  is  not
 *  available to any other person.
 *  
 *  @owner <whmcsglobalservices.com>
 *  @author <WHMCSGLOBALSERVICES>
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
if (!defined('DS'))
    define('DS', DIRECTORY_SEPARATOR);

use Illuminate\Database\Capsule\Manager as Capsule;

if (!defined("WHMCS"))
    die("This file cannot be accessed directly");


if (file_exists(__DIR__ . DS . 'classes' . DS . 'class.php'))
    require_once __DIR__ . DS . 'classes' . DS . 'class.php';

if (file_exists(__DIR__ . DS . 'classes' . DS . 'class.lang.php'))
    require_once __DIR__ . DS . 'classes' . DS . 'class.lang.php';

function wgs_cf_partnerapi_MetaData() {
    return array(
        'DisplayName' => 'WGS CF Partner API',
    );
}

function wgs_cf_partnerapi_ConfigOptions() {

# Should return an array of the module options for each product - maximum of 24
    global $whmcs;
    $productid = (int) $whmcs->get_req_var("id");

    $configValue = Capsule::table("tblproducts")->where("id", $productid)->first();
    if (empty($configValue->configoption1)) {
        $configarray = array("License Key" => array("Type" => "text", "Size" => "35", "Description" => "Enter your valid license key"));
    } else {
        $licenseinfo = wgs_cf_partnerapi_doCheckLicense($configValue->configoption1);
        $optionsresult = __customfieldsCFConfigurableOptions($productid);

        if ($optionsresult['result'] == 'success') {
            if ($optionsresult['availoptions'] == 0)
                $options = '-- No options --';
            else
                $options = $optionsresult['options'];
        }

        __createDbTable();

        if ($licenseinfo['status'] == 'Active') {
            $tabs = array(
                "overview" => "Overview",
                "analytics" => "Analytics",
                "dns" => "DNS",
                "crypto" => "Crypto",
                "firewall" => "Firewall",
                "speed" => "Speed",
                "caching" => "Caching",
                "scrapeshield" => "Scrape Shield",
                "plan" => "Plan"
            );
            if (isset($_POST["tabaccess"])) {
                Capsule::table("mod_cfsettings")->delete();
                foreach ($_POST["tabaccess"] as $key => $value) {
                    Capsule::table("mod_cfsettings")->insert(["setting" => $key, "value" => $value]);
                }
            }
            $tabpermission = array();
            $tabpermissionResult = Capsule::table("mod_cfsettings")->get();

            foreach ($tabpermissionResult as $tabpermissionData) {
                $tabpermissionData = (array) $tabpermissionData;
                $tabpermission[$tabpermissionData['setting']] = $tabpermissionData['value'];
            }

            $tabhtml = '';
            $tabhtml .= '<table style="width:100%">';
            $tabhtml .= '<tr><th colspan="100%" bgcolor="#FFFFD5" style="text-align:center;">Tab Access Management</th></tr>';
            $tabhtml .= '<tr>';
            foreach ($tabs as $key => $tab) {
                $tabhtml .= '<td><input type="checkbox" name="tabaccess[' . $key . ']" value="1" ';
                if (isset($tabpermission[$key])) {
                    $tabhtml .= 'checked';
                }
                $tabhtml .= '></td><td>' . $tab . '</td>';
            }
            $tabhtml .= '</tr>';
            $tabhtml .= '</table>';

            # include classes
            if (!class_exists('CF_HOST_API')) {
                require("class.cloudflareAPI.php");
            }

            $planArr = array('Free' => 'Free (Price: 0.00)');
            $resllerPlans = array();
            if (!empty($configValue->configoption2)) {
                # Cloudflare API
                $hostAPIKey = $configValue->configoption2;
                $hostAPI = new CF_HOST_API($hostAPIKey);
                $resllerPlans = $hostAPI->reseller_plan_list();
//                if ($resllerPlans->result == 'error') {
                logModuleCall("CF Partner", "reseller_plan_list", array('act' => 'reseller_plan_list'), (array) $resllerPlans);
//                }
                $planlist = 'Free--(Price: 0.00),';
                foreach ($resllerPlans->response->objs as $plan) {
                    $planlist .= $plan->sbase_name . '--(Price: ' . $plan->product_price . '/m),';
                    $planArr = array_merge($planArr, array($plan->sub_label => $plan->sbase_name . ' (Price: ' . $plan->product_price . '/m)'));
                }
                $planlist = rtrim($planlist, ',');
            }
            $script = '<script>jQuery(document).ready(function(){'
                    . 'jQuery("#tblModuleSettings select").css("max-width", "90%");'
                    . 'jQuery("input[name=\'packageconfigoption[11]\']").each(function(){							
                            if(jQuery(this).attr("type") == "checkbox"){
                                jQuery(this).attr("id","enablepaddon");
                                jQuery(this).attr("onclick","hideshowpgrpfield()");
                                hideshowpgrpfield();
                            }
                            });'
                    . '});'
                    . 'function hideshowpgrpfield(){'
                    . 'if(jQuery("#enablepaddon").prop("checked")){jQuery("#enablepaddon").parent().parent().next(".fieldlabel").show();}else{jQuery("#enablepaddon").parent().parent().next(".fieldlabel").hide();}'
                    . 'if(jQuery("#enablepaddon").prop("checked")){jQuery("#enablepaddon").parent().parent().next(".fieldlabel").next(".fieldarea").show();}else{jQuery("#enablepaddon").parent().parent().next(".fieldlabel").next(".fieldarea").hide();}'
                    . 'if(jQuery("#enablepaddon").prop("checked")){jQuery("#enablepaddon").parent().parent().parent().next("tr").show();}else{jQuery("#enablepaddon").parent().parent().parent().next("tr").hide();}'
                    . '};'
                    . '</script>';
            $alreadyConfigured = Capsule::table('tblproducts')->where('configoption13', '!=', '')->where('servertype', 'wgs_cf_partnerapi')->count();
            $configarray = array(
                "License Key" => array("Type" => "text", "Size" => "35", "Description" => "{$script}<a style='text-decoration:none;' href='javacsript:void(0)' title='Your license key is Active'><img src='/modules/servers/wgs_cf_partnerapi/images/icon-cloud-on.png' style='height:16px;width:16px;'></a>"),
                "CloudFlare Host API Key" => array("Type" => "text", "Size" => "50", "Description" => "<a style='text-decoration:none;' href='javacsript:void(0)' title='Enter your cloudflare Host API Key here'><img src='/modules/servers/wgs_cf_partnerapi/images/info.gif'></a><tr><td colspan=4>" . $tabhtml . "</td></tr><tr bgcolor='#FFFFD5'><td colspan=4 style='font-weight:bold;text-align:center;font-size:13px;'> Cloudflare Clientarea Fields (To Create Cloudflare Account) </td></tr>"),
                "cf_email" => array(
                    "FriendlyName" => "Email Address",
                    "Type" => "dropdown",
                    "Size" => "35",
                    "Options" => $options,
                    "Description" => "<a style='text-decoration:none;' href='javacsript:void(0)' title='Email address for Cloudflare Account'><img src='/modules/servers/wgs_cf_partnerapi/images/info.gif'></a>",
                    "Default" => "",
                ),
                "cf_password" => array(
                    "FriendlyName" => "Password",
                    "Type" => "dropdown",
                    "Size" => "35",
                    "Options" => $options,
                    "Description" => "<a style='text-decoration:none;' href='javacsript:void(0)' title='Password for Cloudflare Account'><img src='/modules/servers/wgs_cf_partnerapi/images/info.gif'></a>",
                    "Default" => "",
                ),
                "cf_username" => array(
                    "FriendlyName" => "Username",
                    "Type" => "dropdown",
                    "Size" => "35",
                    "Options" => $options,
                    "Description" => "<a style='text-decoration:none;' href='javacsript:void(0)' title='Username for Cloudflare Account'><img src='/modules/servers/wgs_cf_partnerapi/images/info.gif'></a>",
                    "Default" => "",
                ),
                "cf_userkey" => array(
                    "FriendlyName" => "User Key",
                    "Type" => "dropdown",
                    "Size" => "35",
                    "Options" => $options,
                    "Description" => "<a style='text-decoration:none;' href='javacsript:void(0)' title='For developer use only (User Key of Cloudflare Account)'><img src='/modules/servers/wgs_cf_partnerapi/images/info.gif'></a>",
                    "Default" => "",
                ),
                "cf_userapikey" => array(
                    "FriendlyName" => "User API Key",
                    "Type" => "dropdown",
                    "Size" => "35",
                    "Options" => $options,
                    "Default" => "",
                    "Description" => "<a style='text-decoration:none;' href='javacsript:void(0)' title='For developer use only (User API Key of Cloudflare Account)'><img src='/modules/servers/wgs_cf_partnerapi/images/info.gif'></a>"
                ),
                "cf_zone_setup" => array(
                    "FriendlyName" => "Zone Setup",
                    "Type" => "dropdown",
                    "Size" => "35",
                    "Options" => array('zone_set' => 'Partial Zone Set Up (CNAME)', 'full_zone_set' => 'Full Zone Set (DNS)'),
                    "Default" => "full_zone_set",
                    "Description" => "<a style='text-decoration:none;' href='javacsript:void(0)' title='Select which type of zone you want to set with domain, when module create command run. '><img src='/modules/servers/wgs_cf_partnerapi/images/info.gif'></a>"
                ),
                "cf_plan" => array(
                    "FriendlyName" => "Cloudflare Plan",
                    "Type" => "dropdown",
                    "Size" => "35",
                    "Options" => $planArr, // $planlist,
                    "Default" => "Free",
                ),
                "dns_create" => array(
                    "FriendlyName" => "Create A DNS record",
                    "Type" => "yesno",
                    "Default" => "no",
                    "Description" => "If you want to create A DNS record with newly added domain in CF"
                ),
                "forcefully_paddon" => array(
                    "FriendlyName" => "Enable Product Addon",
                    "Type" => "yesno",
                    "Default" => "no",
                    "Description" => "Enable to add forcefully product addon with hosting product (if you don't want to show CF product addons on orderpage)."
                ),
                "product_grp" => array(
                    "FriendlyName" => "Products Group Name",
                    "Type" => "textarea",
                    "Description" => "Put the products group name with new line."
                ),
            );
            $anotherConfigOptionArr = array(
                "product_name" => array(
                    "FriendlyName" => "Product Name",
                    "Type" => "text",
                    "Default" => $configarray->name,
                    "Description" => "If you want to add forcefully product addon with hosting product then you've to create a new free product with WHMCS and then put this created product name in this field.."
                ),
            );

            if ($alreadyConfigured == 0) {
                $configarray = array_merge($configarray, $anotherConfigOptionArr);
            }

# Auto Create Custom Fields
            __createCFPartnerCustomfields($productid);
            __createProductAddons($resllerPlans, $productid);
        } else {
            $configarray = array(
                "License Key" => array("Type" => "text", "Size" => "35", "Description" => "<font color='#ff0000'><a style='text-decoration:none;' href='javacsript:void(0)' title='Your license key is " . $licenseinfo['status'] . "'><img src='/modules/servers/wgs_cf_partnerapi/images/trash.png' style='height:16px;width:16px;'></a></font>"),
            );
        }
    }

    return $configarray;
}

function wgs_cf_partnerapi_CreateAccount($params) {

    $license_check = wgs_cf_partnerapi_checkLicense($params['configoption1']);

    if ($license_check['status'] != 'Active') {
        return "Your license is " . $license_check['status'];
    }

# include classes
    if (!class_exists('CF_HOST_API')) {
        require("class.cloudflareAPI.php");
    }
    if (file_exists(__DIR__ . '/class.wgs_cf_partnerapi.php')) {
        require_once __DIR__ . '/class.wgs_cf_partnerapi.php';
    }
    require_once 'class.cloudflareclientapi.php';
    $apiurl = "https://api.cloudflare.com/client/v4/";

# Email Address
    $emailAddressField = substr($params['configoption3'], strpos($params['configoption3'], ':') + 1);
    $emailAddressField = cloudflare_Encoding::fixUTF8($emailAddressField);
# Password
    $passwordField = substr($params['configoption4'], strpos($params['configoption4'], ':') + 1);
    $passwordField = cloudflare_Encoding::fixUTF8($passwordField);
# Uesername
    $usernameField = substr($params['configoption5'], strpos($params['configoption5'], ':') + 1);
    $usernameField = cloudflare_Encoding::fixUTF8($usernameField);
# User Key
    $userKeyField = substr($params['configoption6'], strpos($params['configoption6'], ':') + 1);
    $userKeyField = cloudflare_Encoding::fixUTF8($userKeyField);
# User API Key
    $userAPIKeyField = substr($params['configoption7'], strpos($params['configoption7'], ':') + 1);
    $userAPIKeyField = cloudflare_Encoding::fixUTF8($userAPIKeyField);
# Client Area custom Fields

    $cfUserdetail = Capsule::table('mod_cf_zone')->where('uid', $params['userid'])->where('email', $params['clientsdetails']['email'])->first();
    if ($cfUserdetail) {
        $cfusername = $emailAddress = $cfUserdetail->email;
        $cfpassword = $password = $cfUserdetail->password;
        $username = $cfUserdetail->username;
    } else {
        if (!empty($params['customfields'][$emailAddressField])) {
            $cfusername = $emailAddress = $params['customfields'][$emailAddressField];
            $username = str_replace('@', '', $params['customfields'][$emailAddressField]);
        } else {
            $cfusername = $emailAddress = $params['clientsdetails']['email'];
            $username = str_replace('@', '', $params['clientsdetails']['email']);
        }

        if (!empty($params['customfields'][$passwordField]))
            $cfpassword = $password = $params['customfields'][$passwordField];
        else
            $cfpassword = $password = wgs_cf_generateRandomString(10);
        if (!empty($params['customfields'][$usernameField]))
            $username = $params['customfields'][$usernameField];
    }

# Admin only custom field
    $emailAddressFieldId = getCustomfieldId($emailAddressField, $params['pid']);
    $passwordFieldId = getCustomfieldId($passwordField, $params['pid']);
    $usernameFieldId = getCustomfieldId($usernameField, $params['pid']);
    $userkeyfieldId = getCustomfieldId($userKeyField, $params['pid']);
    $userAPIkeyfieldId = getCustomfieldId($userAPIKeyField, $params['pid']);

    $showdomainoptions = Capsule::table('tblproducts')->select('showdomainoptions')->where('id', $params['pid'])->first();
    $domain = $params['customfields']['cloudflare_domain'];
    if (!empty($domain)) {
        if ($showdomainoptions->showdomainoptions != 0)
            $domain = $params['domain'];
    }
    $params['customfields']['cloudflare_domain'] = $domain;

# Cloudflare API
    $hostAPIKey = $params['configoption2'];
    $hostAPI = new CF_HOST_API($hostAPIKey);

    $request_body = array("cloudflare_email" => $emailAddress, "cloudflare_pass" => $password, "cloudflare_username" => $username);
    $result = $hostAPI->user_create($emailAddress, $password, $username);

    logModuleCall("CF Partner", "user_create", $request_body, (array) $result);
    if ($result->result == "success") {

        $command = "updateclientproduct";
        $adminuser = wgs_cf_partnerapi_getAdminId();
        $values["serviceid"] = $params["serviceid"];
        if (empty($params['domain']))
            $values['domain'] = $params['customfields']['cloudflare_domain'];
        $values["customfields"] = base64_encode(serialize(array($emailAddressFieldId => $result->response->cloudflare_email, $passwordFieldId => $password, $usernameFieldId => $result->response->cloudflare_username, $userkeyfieldId => $result->response->user_key, $userAPIkeyfieldId => $result->response->user_api_key)));
        $results = localAPI($command, $values, $adminuser);

        try {
            if (empty($cfUserdetail)) {
                Capsule::table('mod_cf_zone')->insert(['uid' => $params['userid'], 'email' => $emailAddress, 'password' => $password, 'username' => $username]);
            } else {
                Capsule::table('mod_cf_zone')->where('uid', $params['userid'])->where('email', $emailAddress)->update(['uid' => $params['userid'], 'email' => $emailAddress, 'password' => $password, 'username' => $username]);
            }
        } catch (Exception $ex) {
            logActivity("Unable to insert/update table: mod_cf_zone error: {$ex->getMessage()}");
        }

        logModuleCall("CF Partner", "WHMCS API updateclientproduct, Clodflare User Created", $values, $results);
        $cfapikey = $result->response->user_api_key;
        $wgs_cf_partnerapi = new wgs_cf_partnerapi($apiurl, $cfusername, $cfpassword, $cfapikey);
        $website = $params['customfields']['cloudflare_domain'];

        $zoneResult = $wgs_cf_partnerapi->getAllZones($website);

        logModuleCall("CF Partner", "Get Zone detail (create account)", $website, $zoneResult);

        if (empty($zoneResult['result']) && $zoneResult['success'] == 1) {
            $hostAPI1 = new CF_HOST_API($hostAPIKey);
            $resolve_to = 'cloudflare-resolve-to.' . $website;
            $subdomains = 'www';
            $getAddonId = Capsule::table('mod_cf_manage_service')->where('sid', $params['serviceid'])->first();
            $hostingServerIp = NULL;
            if ($getAddonId->addonid) {
                $getPlan = Capsule::table('mod_cf_p_addons')->where('addonid', $getAddonId->addonid)->first();
                $hostingService = Capsule::table('tblhosting')->where('packageid', '!=', $params['pid'])->where('domain', $params['customfields']['cloudflare_domain'])->first();
                $command = "GetClientsProducts";
                $adminuser = wgs_cf_partnerapi_getAdminId();
                $values["serviceid"] = $hostingService->id;
                $results = localAPI($command, $values, $adminuser);
                if ($results['result'] == 'success')
                    $hostingServerIp = $results['products']['product'][0]['serverip'];
            }

            $zoneType = $params['configoption8'];
            if ($getPlan->cf_plan_name == 'Free Plan With Cloudflare DNS Setup')
                $zoneType = 'full_zone_set';
            elseif ($getPlan->cf_plan_name == 'Free Plan With CNAME Setup') {
                $zoneType = 'zone_set';
            }

            $zone_add = $hostAPI1->zone_set($result->response->user_key, $website, $resolve_to, $subdomains, $zoneType);

            logModuleCall("CF Partner", "Add zone (create account)", $website, (array) $zone_add);
            if ($zone_add->result == 'success') {
                $planTag = $params['configoption9'];
                if ($getPlan->cf_plan) {
                    $planTag = $getPlan->cf_plan;
                }
                if ($planTag != 'Free') {
                    $plan_sub = $hostAPI1->reseller_sub_new($result->response->user_key, $website, $planTag);
                    logModuleCall("CF Partner", "Add sub plan to Cloudflare Partner", array('zone' => $website, 'plan_tag' => $planTag), (array) $plan_sub);
                    if ($plan_sub->result == "success") {

                        $subCustomfiledId = Capsule::table("tblcustomfields")->where("type", "product")->where("relid", $params['pid'])->where("fieldname", 'Subscription ID')->first();

                        $command = 'UpdateClientProduct';
                        $postData = array(
                            'serviceid' => $params['serviceid'],
                            'customfields' => base64_encode(serialize(array($subCustomfiledId->id => $plan_sub->response->sub_id)))
                        );
                        $adminId = Capsule::table("tbladmins")->orderBy('id', 'ASC')->first();
                        $adminUsername = $adminId->id;

                        $results = localAPI($command, $postData, $adminUsername);
                    } else {
                        $results['message'] = $plan_sub->msg;
                    }
                }
                $zoneResult = $wgs_cf_partnerapi->getAllZones($website);
                $nameservers = $zoneResult['result'][0]['name_servers'];
                if ($nameservers) {
                    $domainId = '';
                    $doaminDetail = Capsule::table('tbldomains')->where('domain', $params['customfields']['cloudflare_domain'])->first();
                    $domainId = $doaminDetail->id;
                    if ($domainId) {
                        $updateNs = wgs_cf_whmcs_local_api('DomainUpdateNameservers', array('domainid' => $domainId, 'ns1' => $nameservers[0], 'ns2' => $nameservers[1]));
                        if ($updateNs['result'] == 'success') {
                            logActivity("NS successfully updated with registrar domain: {$website}");
                        } elseif ($updateNs['result'] == 'error') {
                            logActivity("Unable to update nameservers with registrar domain: {$website} error: {$updateNs['message']}");
                        }
                    } else {
                        logActivity("Unable to update nameservers with registrar domain: {$website} error: domain is not found in whmcs db");
                    }
                    if ($params['configoption10'] == 'on' || $params['configoption10'] == '1') {
                        $server_ip = (!empty($hostingServerIp)) ? $hostingServerIp : $params['serverip'];
                        if ($server_ip) {
                            $dnsData = array(
                                'zone_id' => $zoneResult['result'][0]['id'],
                                'cfdnstype' => 'A',
                                'cfdnsname' => $website,
                                'cfdnsvalue' => $server_ip,
                                'cfdnsttl' => '120'
                            );
                            $createDns = $wgs_cf_partnerapi->createDNSRecord($dnsData);
                            if ($createDns['result'] == 'error') {
                                logModuleCall("CF Partner", "Set DNS record (add website on clientarea)", $dnsData, 'Error: ' . $createDns['data']['apierror']);
                                logActivity("Set DNS record failed $website: " . $createDns['data']['apierror']);
                            } else {
                                logModuleCall("CF Partner", "Set DNS record (add website on clientarea)", $dnsData, 'Dns record has been successfully added');
                                logActivity("DNS record has been steup zone :$website");
                            }
                        } else {
                            logActivity("Unable to add the DNS record domain: {$website} error: server iP not found");
                        }
                    }
                }
            }
        }

        $result = ($results['result'] == "success") ? "success" : $results['message'];
        return $result;
    } else {
        $command = "updateclientproduct";
        $adminuser = wgs_cf_partnerapi_getAdminId();
        $values["serviceid"] = $params["serviceid"];
        if (empty($params['domain']))
            $values['domain'] = $params['customfields']['cloudflare_domain'];
        $values["customfields"] = base64_encode(serialize(array($emailAddressFieldId => $cfusername, $passwordFieldId => $cfpassword, $usernameFieldId => $username)));
        $results = localAPI($command, $values, $adminuser);
//        return $result->msg;
        return 'success';
    }
}

function wgs_cf_partnerapi_SuspendAccount($params) {
    return 'success';
}

function wgs_cf_partnerapi_UnsuspendAccount($params) {
    return 'success';
}

function wgs_cf_partnerapi_TerminateAccount($params) {
    $showdomainoptions = Capsule::table('tblproducts')->select('showdomainoptions')->where('id', $params['pid'])->first();
    $domain = $params['customfields']['cloudflare_domain'];
    if (empty($domain)) {
        if ($showdomainoptions->showdomainoptions != 0)
            $domain = $params['domain'];
    }
    $params['customfields']['cloudflare_domain'] = $domain;
    if (empty($params['customfields']['cloudflare_domain'])) {
        logModuleCall("CF Partner", "Terminate domain", $params["serviceid"], 'Domain name is missing');
        return 'Domain name is missing';
    }
    if (!class_exists('CF_HOST_API')) {
        require("class.cloudflareAPI.php");
    }
    $userKeyField = substr($params['configoption6'], strpos($params['configoption6'], ':') + 1);
    $userKeyField = cloudflare_Encoding::fixUTF8($userKeyField);

    $userAPIKeyField = substr($params['configoption7'], strpos($params['configoption7'], ':') + 1);
    $userAPIKeyField = cloudflare_Encoding::fixUTF8($userAPIKeyField);

    $userkeyfieldId = getCustomfieldId($userKeyField, $params['pid']);
    $userAPIkeyfieldId = getCustomfieldId($userAPIKeyField, $params['pid']);

    $userkey = $params['customfields'][$userKeyField];
    $hostAPIKey = $params['configoption2'];
    $hostAPI2 = new CF_HOST_API($hostAPIKey);
    $zone_delete = $hostAPI2->zone_delete($params['customfields']['cloudflare_domain'], $userkey);

    logModuleCall("CF Partner", "Terminate domain", $params["domain"], (array) $zone_delete);
    if ($zone_delete->result == 'error') {
        return "Error: " . $zone_delete->msg;
    } elseif ($zone_delete->result = 'success') {
        $command = "updateclientproduct";
        $adminuser = wgs_cf_partnerapi_getAdminId();
        $values["serviceid"] = $params["serviceid"];
        $values["customfields"] = base64_encode(serialize(array($userkeyfieldId => '', $userAPIkeyfieldId => '')));
        $results = localAPI($command, $values, $adminuser);
    }
    return 'success';
}

function wgs_cf_partnerapi_ChangePackage($params) {
    try {
        $license_check = wgs_cf_partnerapi_checkLicense($params['configoption1']);

        if ($license_check['status'] != 'Active') {
            return "Your license is " . $license_check['status'];
        }

        if (!class_exists('CF_HOST_API')) {
            require("class.cloudflareAPI.php");
        }

        # Email Address
        $emailAddressField = substr($params['configoption3'], strpos($params['configoption3'], ':') + 1);
        $emailAddressField = cloudflare_Encoding::fixUTF8($emailAddressField);
        # Password
        $passwordField = substr($params['configoption4'], strpos($params['configoption4'], ':') + 1);
        $passwordField = cloudflare_Encoding::fixUTF8($passwordField);
        # Uesername
        $usernameField = substr($params['configoption5'], strpos($params['configoption5'], ':') + 1);
        $usernameField = cloudflare_Encoding::fixUTF8($usernameField);

        $userKeyField = substr($params['configoption6'], strpos($params['configoption6'], ':') + 1);
        $userKeyField = cloudflare_Encoding::fixUTF8($userKeyField);

        $userAPIKeyField = substr($params['configoption7'], strpos($params['configoption7'], ':') + 1);
        $userAPIKeyField = cloudflare_Encoding::fixUTF8($userAPIKeyField);

        $userkeyfieldId = getCustomfieldId($userKeyField, $params['pid']);
        $userAPIkeyfieldId = getCustomfieldId($userAPIKeyField, $params['pid']);


        $cfusername = $params['customfields'][$emailAddressField];
        $cfpassword = $params['customfields'][$passwordField];
        $cfUserApiKey = $params['customfields'][$userAPIKeyField];

        $userkey = $params['customfields'][$userKeyField];
        $hostAPIKey = $params['configoption2'];
        $hostAPI = new CF_HOST_API($hostAPIKey);

        $planTag = $params['configoption9'];

        $showdomainoptions = Capsule::table('tblproducts')->select('showdomainoptions')->where('id', $params['pid'])->first();
        $domain = $params['customfields']['cloudflare_domain'];
        if (empty($domain)) {
            if ($showdomainoptions->showdomainoptions != 0)
                $domain = $params['domain'];
        }
        $params['customfields']['cloudflare_domain'] = $domain;

        $getOldSubscriptionId = $hostAPI->zone_list($params['customfields']['cloudflare_domain']);

        foreach ($getOldSubscriptionId->response as $value) {
            if ($value->zone_name == $params['customfields']['cloudflare_domain'] && $value->user_email == $cfusername && $value->sub_status == 'V') {
                $oldSubscriptionId = $value->sub_id;
                $oldSubscriptionLabel = $value->sub_label;
            }
        }

        if ($planTag != 'Free') {

            if (!empty($oldSubscriptionLabel)) {
                $cancelSub = $hostAPI->reseller_sub_cancel($userkey, $params['customfields']['cloudflare_domain'], $oldSubscriptionLabel, $oldSubscriptionId);
                logModuleCall("CF Partner", "Upgrade plan (cancel existing subscription)", array('zone' => $params['customfields']['cloudflare_domain'], 'plan_tag' => $planTag), (array) $cancelSub);
            } else {
                $cancelSub->result = 'success';
            }
            if ($cancelSub->result == 'success') {
                $plan_sub = $hostAPI->reseller_sub_new($userkey, $params['customfields']['cloudflare_domain'], $planTag);
                logModuleCall("CF Partner", "Upgrade plan", array('zone' => $params['customfields']['cloudflare_domain'], 'plan_tag' => $planTag), (array) $plan_sub);
                if ($plan_sub->result == "success") {

                    $subCustomfiledId = Capsule::table("tblcustomfields")->where("type", "product")->where("relid", $params['pid'])->where("fieldname", 'Subscription ID')->first();

                    $command = 'UpdateClientProduct';
                    $postData = array(
                        'serviceid' => $params['serviceid'],
                        'customfields' => base64_encode(serialize(array($subCustomfiledId->id => $plan_sub->response->sub_id)))
                    );
                    $adminId = Capsule::table("tbladmins")->orderBy('id', 'ASC')->first();
                    $adminUsername = $adminId->id;

                    $results = localAPI($command, $postData, $adminUsername);
                    $result = 'success';
                } else {
                    $result = $plan_sub->msg;
                }
            } else {
                return 'Error: ' . $cancelSub->msg;
            }
        } else {
            $cancelSub = $hostAPI->reseller_sub_cancel($userkey, $params['customfields']['cloudflare_domain'], $oldSubscriptionLabel, $oldSubscriptionId);
            logModuleCall("CF Partner", "Upgrade plan (cancel subscription)", array('zone' => $params['customfields']['cloudflare_domain'], 'plan_tag' => $planTag), (array) $cancelSub);
            if ($cancelSub->result == 'success') {
                $subCustomfiledId = Capsule::table("tblcustomfields")->where("type", "product")->where("relid", $params['pid'])->where("fieldname", 'Subscription ID')->first();

                $command = 'UpdateClientProduct';
                $postData = array(
                    'serviceid' => $params['serviceid'],
                    'customfields' => base64_encode(serialize(array($subCustomfiledId->id => '')))
                );
                $adminId = Capsule::table("tbladmins")->orderBy('id', 'ASC')->first();
                $adminUsername = $adminId->id;

                $results = localAPI($command, $postData, $adminUsername);
                return 'success';
            } else {
                return 'Error: ' . $cancelSub->msg;
            }
        }
    } catch (Exception $ex) {
        $result = $ex->getMessage();
        logModuleCall("CF Partner", "Upgrade plan", array('zone' => $params['customfields']['cloudflare_domain'], 'plan_tag' => $planTag), $result);
    }
    return $result;
}

function wgs_cf_partnerapi_ClientArea($params) {
    $license_check = wgs_cf_partnerapi_checkLicense($params['configoption1']);

    if ($license_check['status'] != 'Active') {
        return "<font color='red'>" . $license_check['status'] . ' License, Please contact with support!' . "</font>";
    }
    $wgsLang = new wgsLang();
    $clientLanguage = $wgsLang->wgs_cf_get_client_language($params);
    $language = $wgsLang->wgs_cf_partnerapi_getLang($clientLanguage);

    require_once __DIR__ . '/action/cflogin.php';
    $showdomainoptions = Capsule::table('tblproducts')->select('showdomainoptions')->where('id', $params['pid'])->first();
    $domain = $params['customfields']['cloudflare_domain'];
    if (empty($domain)) {
        if ($showdomainoptions->showdomainoptions != 0)
            $domain = $params['domain'];
    }

    $params['customfields']['cloudflare_domain'] = $domain;
    if (empty($params['customfields']['cloudflare_domain']))
        return 'Domain field is empty.';
    if (!empty($errors) || !empty($zone_error)) {

        $code = array(
            'templatefile' => $templateFile,
            'breadcrumb' => '<a href="clientarea.php?action=productdetails&id=' . $params['serviceid'] . '</a>',
            'vars' => $vars,
        );
    } else {
        $code = "<form method='post' id='cloudflareform' action='clientarea.php?action=productdetails&id=" . $params['serviceid'] . "'>";
        $code .= "<input type='hidden' name='modop' value='custom'>";
        $code .= "<input type='hidden' name='a' value='manage_page'>";
        $code .= "<input type='hidden' name='cf_action' id='cf_action' value='manageWebsite'>";
        $code .= "<input type='hidden' name='website' id='website' value='" . $params['customfields']['cloudflare_domain'] . "'>";
        $code .= "<input type='submit' id='manage_cf' value='" . $language['cf_manage_cf'] . "' class='btn'>";
        $code .= "</form>";

//        $code .= "<script>$(document).ready(function(){";
//        $code .= "$('#manage_cf').click();";
//        $code .= "$('#cloudflareform').parent().css('border','none');";
//        $code .= "});</script>";
    }

    return $code;
}

function wgs_cf_partnerapi_ClientAreaCustomButtonArray($params) {
    $wgsLang = new wgsLang();
    $clientLanguage = $wgsLang->wgs_cf_get_client_language($params);
    $language = $wgsLang->wgs_cf_partnerapi_getLang($clientLanguage);

    $buttonarray = array(
        $language['cf_manage_cf'] => "manage_page",
    );
    return $buttonarray;
}

function wgs_cf_partnerapi_manage_page($params) {

    global $CONFIG;
    $wgsLang = new wgsLang();
    $clientLanguage = $wgsLang->wgs_cf_get_client_language($params);
    $language = $wgsLang->wgs_cf_partnerapi_getLang($clientLanguage);

    $systemURL = $systemurl = (empty($CONFIG['SystemSSLURL'])) ? $CONFIG['SystemURL'] : $CONFIG['SystemSSLURL'];

    $www = (strpos($_SERVER['HTTP_HOST'], 'www')) ? 1 : 0;

    if ($www) {
        if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on')
            $origin = 'https://www.';
        else
            $origin = 'http://www.';

        $moduleURL = $url = str_replace('https://', $origin, $systemurl) . '/modules/servers/wgs_cf_partnerapi/';
    }else {
        $moduleURL = $url = $systemurl . '/modules/servers/wgs_cf_partnerapi/';
    }

# include classes
    if (!class_exists('CF_HOST_API')) {
        require("class.cloudflareAPI.php");
    }
    if (file_exists(__DIR__ . '/class.wgs_cf_partnerapi.php')) {
        require_once __DIR__ . '/class.wgs_cf_partnerapi.php';
    }
    require_once 'class.cloudflareclientapi.php';
    $apiurl = "https://api.cloudflare.com/client/v4/";


    $hostAPIKey = $params['configoption2'];

# Email Address
    $emailAddressField = substr($params['configoption3'], strpos($params['configoption3'], ':') + 1);
    $emailAddressField = cloudflare_Encoding::fixUTF8($emailAddressField);
# Password
    $passwordField = substr($params['configoption4'], strpos($params['configoption4'], ':') + 1);
    $passwordField = cloudflare_Encoding::fixUTF8($passwordField);
# Uesername
    $usernameField = substr($params['configoption5'], strpos($params['configoption5'], ':') + 1);
    $usernameField = cloudflare_Encoding::fixUTF8($usernameField);
# User Key
    $userKeyField = substr($params['configoption6'], strpos($params['configoption6'], ':') + 1);
    $userKeyField = cloudflare_Encoding::fixUTF8($userKeyField);
# User API Key
    $userAPIKeyField = substr($params['configoption7'], strpos($params['configoption7'], ':') + 1);
    $userAPIKeyField = cloudflare_Encoding::fixUTF8($userAPIKeyField);
# Client Area custom Fields
    $cfusername = $emailAddress = $params['customfields'][$emailAddressField];
    $cfpassword = $password = $params['customfields'][$passwordField];
    $username = $params['customfields'][$usernameField];
    $userkey = $params['customfields'][$userKeyField];
    $cfapikey = $userapikey = $params['customfields'][$userAPIKeyField];

    $details = array("cf_email" => $emailAddress,
        "cf_password" => $password,
        "cf_username" => $username,
        "cf_key" => $userkey,
        "cf_apikey" => $userapikey);

    $vars = array(
        'url' => $url,
        'account' => $details,
        'wgs_lang' => $language,
        'user_lang' => $clientLanguage
    );

    $wgs_cf_partnerapi = new wgs_cf_partnerapi($apiurl, $cfusername, $cfpassword, $cfapikey);
    if (isset($_POST["website"])) {

        $website = $_POST["website"];
        $action = $_POST["cf_action"];

        switch ($action) {
            case 'manageWebsite':

                $domain = $website;

                $cloudflareclientapi = new Cloudflareclientapi($cfusername, $cfapikey, $domain);

                $result = $wgs_cf_partnerapi->getAllZones($domain);

# Cloudflare Nameservers
                if (isset($result["result"][0]["name_servers"][0])) {
                    $cf_nameserver1 = $result["result"][0]["name_servers"][0];
                } else {
                    $cf_nameserver1 = "";
                }
                if (isset($result["result"][0]["name_servers"][1])) {
                    $cf_nameserver2 = $result["result"][0]["name_servers"][1];
                } else {
                    $cf_nameserver2 = "";
                }

# Original Nameservers
                if (isset($result["result"][0]["original_name_servers"][0])) {
                    $original_nameserver1 = $result["result"][0]["original_name_servers"][0];
                } else {
                    $original_nameserver1 = "";
                }
                if (isset($result["result"][0]["original_name_servers"][1])) {
                    $original_nameserver2 = $result["result"][0]["original_name_servers"][1];
                } else {
                    $original_nameserver2 = "";
                }
                if (isset($result["result"][0]["original_name_servers"][2])) {
                    $original_nameserver3 = $result["result"][0]["original_name_servers"][2];
                } else {
                    $original_nameserver3 = "";
                }
                if (isset($result["result"][0]["original_name_servers"][3])) {
                    $original_nameserver4 = $result["result"][0]["original_name_servers"][3];
                } else {
                    $original_nameserver4 = "";
                }
                if (isset($result["result"][0]["original_name_servers"][4])) {
                    $original_nameserver5 = $result["result"][0]["original_name_servers"][4];
                } else {
                    $original_nameserver5 = "";
                }

                $cfid = $result["result"][0]["id"];

                $wgs_cf_partnerapi->setZoneIdentifier($cfid);

                $domainDetails = $wgs_cf_partnerapi->getZoneDetails();

                $cloudflareNameservers = $domainDetails['result']['name_servers'];

                $originalNameservers = $domainDetails['result']['original_name_servers'];
                $originalregistrar = $domainDetails['result']['original_registrar'];

                if ($domainDetails["result"]["paused"]) {
                    $status = "Paused";
                } else {
                    $status = ucfirst($domainDetails["result"]["status"]);
                }

                $cfplan = $domainDetails["result"]["plan"]["legacy_id"];

                require_once __DIR__ . '/template/header.php';
                require_once __DIR__ . '/template/menu.php';

                $cloudflareNameservers = empty($cloudflareNameservers) ? $language['cf_dns_zone'] : $cloudflareNameservers;
                $originalregistrar = empty($originalregistrar) ? $language['cf_not_avail'] : $originalregistrar;
                $originalNameservers = empty($originalNameservers) ? $language['cf_not_avail'] : $originalNameservers;

                $vars["systemURL"] = $systemURL;
                $vars["moduleURL"] = $moduleURL;
                $vars["domain"] = $domain;
                $vars["status"] = $status;
                $vars["cloudflarenameservers"] = $cloudflareNameservers;
                $vars["originalregistrar"] = $originalregistrar;
                $vars["originalnameservers"] = $originalNameservers;
                $vars["headerhtml"] = $headerhtml;
                $vars["menu"] = $menu;
                $vars["plan"] = $cfplan;

                if ($status == "Pending") {
                    $templateFile = "template/home";
                } else {
                    require_once __DIR__ . '/action/overview.php';
                }

                if (isset($_POST["cfaction"])) {
                    if (file_exists(__DIR__ . '/action/' . $_POST["cfaction"] . '.php')) {
                        require_once __DIR__ . '/action/' . $_POST["cfaction"] . '.php';
                    }
                }

                $pagearray = array(
                    'templatefile' => $templateFile,
                    'breadcrumb' => '<a href="clientarea.php?action=productdetails&id=' . $params['serviceid'] . '&modop=custom&a=manage_page">' . $language['cf_manage_cf'] . '</a>',
                    'vars' => $vars,
                );
                break;
            case 'addWebsite':
                $hostAPI1 = new CF_HOST_API($hostAPIKey);
                $resolve_to = 'cloudflare-resolve-to.' . $website;
                $subdomains = 'www';
                $zoneType = $params['configoption8'];
                $planTag = $params['configoption9'];

                $zone_add = $hostAPI1->zone_set($userkey, $website, $resolve_to, $subdomains, $zoneType);

                if ($zone_add->result == "success")
                    $sts = 'Zone added successfully';
                elseif ($zone_add->result == 'error')
                    $sts = 'Error: ' . $zone_add->msg;
                logModuleCall("CF Partner", "Add Website to Cloudflare Partner", $website, $sts);

                if (!empty($zone_add)) {
                    $vars['zoneadd_result'] = $zone_add->result;

                    if ($zone_add->result == "success") {
                        $planTag = $params['configoption9'];

                        if ($planTag != 'Free') {
                            $plan_sub = $hostAPI1->reseller_sub_new($userkey, $website, $planTag);
                            logModuleCall("CF Partner", "Add sub plan to Cloudflare Partner", array('zone' => $website, 'plan_tag' => $planTag), (array) $plan_sub);
                            if ($plan_sub->result == "success") {

                                $subCustomfiledId = Capsule::table("tblcustomfields")->where("type", "product")->where("relid", $params['pid'])->where("fieldname", 'Subscription ID')->first();

                                $command = 'UpdateClientProduct';
                                $postData = array(
                                    'serviceid' => $params['serviceid'],
                                    'customfields' => base64_encode(serialize(array($subCustomfiledId->id => $plan_sub->response->sub_id)))
                                );
                                $adminId = Capsule::table("tbladmins")->orderBy('id', 'ASC')->first();
                                $adminUsername = $adminId->id;

                                $results = localAPI($command, $postData, $adminUsername);
                                $plan_sub->msg = $language['cf_website_added_success'];
                            } else {
                                $vars['zoneadd_message'] = $plan_sub->msg;
                                if (gettype($plan_sub) == "array" && !empty($plan_sub['error'])) {
                                    $vars['zoneadd_message'] = $plan_sub['error'];
                                    $vars['zoneadd_result'] = "error";
                                }
                            }
                        } else {
                            $zone_add->msg = $language['cf_website_added_success'];
                        }

                        $zoneResult = $wgs_cf_partnerapi->getAllZones($website);
                        if (empty($zoneResult['result']) && $zoneResult['success'] == 1) {
                            logActivity("get zone detail (add website on clientarea) zone: {$website} error: zone record not found");
                        } elseif ($zoneResult['result'] == 'error') {
                            logActivity("get zone detail (add website on clientarea) zone: {$website} error: {$zoneResult['data']['apierror']}");
                        } elseif (!empty($zoneResult['result']) && $zoneResult['success'] == 1) {
                            $nameservers = $zoneResult['result'][0]['name_servers'];
                            if ($nameservers) {
                                $domainId = '';
                                $doaminDetail = Capsule::table('tbldomains')->where('domain', $params['customfields']['cloudflare_domain'])->where('status', 'Active')->first();
                                $domainId = $doaminDetail->id;
                                if ($domainId) {
                                    $updateNs = wgs_cf_whmcs_local_api('DomainUpdateNameservers', array('domainid' => $domainId, 'ns1' => $nameservers[0], 'ns2' => $nameservers[1]));
                                    if ($updateNs['result'] == 'success') {
                                        logActivity("NS successfully updated with registrar domain: {$website}");
                                    } elseif ($updateNs['result'] == 'error') {
                                        logActivity("Unable to update nameservers with registrar domain: {$website} error: {$updateNs['message']}");
                                    }
                                } else {
                                    logActivity("Unable to update nameservers with registrar domain: {$website} error: domain is not found in whmcs db");
                                }
                                if ($params['configoption10'] == 'on' || $params['configoption10'] == '1') {
                                    $server_ip = $params['serverip'];
                                    if ($server_ip) {
                                        $dnsData = array(
                                            'zone_id' => $zoneResult['result'][0]['id'],
                                            'cfdnstype' => 'A',
                                            'cfdnsname' => $website,
                                            'cfdnsvalue' => $server_ip,
                                            'cfdnsttl' => '120'
                                        );
                                        $createDns = $wgs_cf_partnerapi->createDNSRecord($dnsData);
                                        if ($createDns['result'] == 'error') {
                                            logModuleCall("CF Partner", "Set DNS record (add website on clientarea)", $dnsData, 'Error: ' . $createDns['data']['apierror']);
                                            logActivity("Set DNS record failed $website: " . $createDns['data']['apierror']);
                                        } else {
                                            logModuleCall("CF Partner", "Set DNS record (add website on clientarea)", $dnsData, 'Dns record has been successfully added');
                                            logActivity("DNS record has been steup zone :$website");
                                        }
                                    } else {
                                        logActivity("Unable to add the DNS record domain: {$website} error: server iP not found");
                                    }
                                }
                            } else {
                                logActivity("Unable to find the cf nameservers domain: {$website}");
                            }
                        }
                        $zone_add->msg = $language['cf_website_added_success'];
                    } else {
                        $vars['zoneadd_message'] = $zone_add->msg;
                        if ($zone_add->result == 'error') {
                            $vars['zoneadd_message'] = $zone_add->msg;
                            $vars['zoneadd_result'] = "error";
                        }
                    }
                }
                $hostAPI2 = new CF_HOST_API($emailAddress, $userapikey);
                $zone_load_multi = $hostAPI2->zone_load_multi($emailAddress);
                $vars['zone_load_multi'] = $zone_load_multi->response->zones->objs;

                $pagearray = array(
                    'templatefile' => 'cloudflare',
                    'breadcrumb' => '<a href="clientarea.php?action=productdetails&id=' . $params['serviceid'] . '&modop=custom&a=manage_page">' . $language['cf_manage_cf'] . '</a>',
                    'vars' => $vars,
                );

                break;
            case 'deleteWebsite':
                $hostAPI2 = new CF_HOST_API($hostAPIKey);
                $zone_delete = $hostAPI2->zone_delete($website, $userkey);

                $vars['delete_result'] = $zone_delete->result;
                if ($vars['delete_result'] == "success") {
                    $zone_delete->msg = $language['cf_website_deleted_success'];
                }
                $vars['delete_message'] = $zone_delete->msg;

                $hostAPI1 = new CF_HOST_API($emailAddress, $userapikey);
                $zone_load_multi = $hostAPI1->zone_load_multi($emailAddress);
                $vars['zone_load_multi'] = $zone_load_multi->response->zones->objs;

                $pagearray = array(
                    'templatefile' => 'cloudflare',
                    'breadcrumb' => '<a href="clientarea.php?action=productdetails&id=' . $params['serviceid'] . '&modop=custom&a=manage_page">' . $language['cf_manage_cf'] . '</a>',
                    'vars' => $vars,
                );
                break;
        }
    } else {
        require_once __DIR__ . '/action/cflogin.php';

        if (!empty($errors) || !empty($zone_error)) {

            $pagearray = array(
                'templatefile' => $templateFile,
                'breadcrumb' => '<a href="clientarea.php?action=productdetails&id=' . $params['serviceid'] . '</a>',
                'vars' => $vars,
            );
        } else {
# Cloudflare Client API
            $hostAPI = new CF_HOST_API($emailAddress, $userapikey);
            $zone_load_multi = $hostAPI->zone_load_multi($emailAddress);
            $vars['zone_load_multi'] = $zone_load_multi->response->zones->objs;

            $pagearray = array(
                'templatefile' => 'cloudflare',
                'breadcrumb' => '<a href="clientarea.php?action=productdetails&id=' . $params['serviceid'] . '&modop=custom&a=manage_page">' . $language['cf_manage_cf'] . '</a>',
                'vars' => $vars,
            );
        }
    }

    return $pagearray;
}

function wgs_cf_partnerapi_doCheckLicense($license) {

    if ($license) {
        $localkey = '';
        $result = wgs_cf_partnerapi_checkLicense($license, $localkey);

        $result['licensekey'] = $license;
    } else {
        $result['status'] = 'licensekeynotfound';
    }

    return $result;
}

?>
