<p>{$breadcrumbnav} <span style="float: right;margin-right: 5px;"><a href="javascript:submitCloudflareForm();">Back to Zone List</a></span></p>
<script type="text/javascript" src="{$url}js/stats/d3.v3.min.js"></script>
<link rel="stylesheet" type="text/css" href="{$url}css/stats/cfstyle.css" />
<script type="text/javascript" src="{$url}js/cf.js"></script>
{literal}

    <script>
        

        function statsinpiecharts(regularTrafficPer, regularTrafficValue, crawlerPer, crawlerValue, threatsPer, threatsValue, requestbycloudflarePer, requestbycloudflareValue, requestbyuserPer, requestbyuserValue, bandwidthbycloudflarePer, bandwidthbycloudflareValue, bandwidthbyuserPer, bandwidthbyuserValue) {

            // **************** Pie Chart 1 For Stats **************** //

            var mode = regularTrafficValue + crawlerValue + threatsValue;
            var requestmode = requestbycloudflareValue + requestbyuserValue;
            var bandwidthmode = bandwidthbycloudflareValue + bandwidthbyuserValue;

            var w = 450, //width
                    h = 450, //height
                    r = 200 //radius

            color = d3.scale.ordinal()
                    .range(["#02B3E7", "#FFEC62", "#EB0D42"]);

            data = [{"label": "Regular Traffic", "value": regularTrafficPer, "title": regularTrafficValue},
                {"label": "Crawlers/bots", "value": crawlerPer, "title": crawlerValue},
                {"label": "Threats", "value": threatsPer, "title": threatsValue}];

            if (mode == 0) {

                color = d3.scale.ordinal()
                        .range(["#eae1e2"]);

                data = [{"label": "", "value": 100, "title": ""}];

            }

            var vis = d3.select("#section-underline-1-piechart")
                    .append("svg:svg")
                    .data([data])
                    .attr("width", w)
                    .attr("height", h)
                    .append("svg:g")
                    .attr("transform", "translate(" + 220 + "," + 220 + ")")

            var arc = d3.svg.arc()
                    .outerRadius(r);


            var pie = d3.layout.pie()
                    .value(function(d) {
                        return d.value;
                    });



            if (mode == 0) {
                var arcs = vis.selectAll("g.slice")
                        .data(pie)
                        .enter()
                        .append("svg:g")
                        .attr("class", "slice");
            } else {
                var arcs = vis.selectAll("g.slice")
                        .data(pie)
                        .enter()
                        .append("svg:g")
                        .attr("class", "slice")
                        .on("mouseover", function(d, i) {
                            d3.select("#tooltip")
                                    .style("left", d3.event.pageX / 2 + "px")
                                    .style("top", d3.event.pageY / 2 + "px")
                                    .style("opacity", 1)
                                    .select("#lvalue").text(data[i].label);
                            d3.select("#tooltip").select("#value").text(d.value);
                            d3.select("#tooltip").select("#tvalue").text(data[i].title);
                        })
                        .on("mouseout", function() {
                            // Hide the tooltip
                            d3.select("#tooltip")
                                    .style("opacity", 0);
                        });
            }

            var asdf = arcs.append("svg:path")
                    .attr("fill", function(d, i) {
                        return color(i);
                    })
                    .attr("d", arc);

            arcs.append("svg:text")
                    .attr("transform", function(d) {

                        d.innerRadius = 0;
                        d.outerRadius = r;
                        return "translate(" + arc.centroid(d) + ")";
                    });
            //.attr("text-anchor", "middle")                         
            //.text(function(d, i) {
            //   return data[i].label;
            //});        //get the label from our original data array

            var arc1 = d3.svg.arc()
                    .outerRadius(r - 10)
                    .innerRadius(0);

            var arc2 = d3.svg.arc()
                    .outerRadius(r + 10)
                    .innerRadius(0);

            asdf.on("mouseover", function(d) {
                d3.select(this).transition().duration(200).attr("d", arc2);
            });

            asdf.on("mouseout", function(d, i) {
                d3.select(this).transition().duration(200).attr("d", arc);
            });

            var circle = vis.append("circle")
                    .attr({
                        "cx": 0,
                        "cy": 0,
                        "r": 190,
                        "fill": "none",
                        "stroke": "#fff",
                        "stroke-width": 2
                    });
            // **************** Pie Chart 1 For Stats **************** //


            // **************** Pie Chart 2 For Stats **************** //

            var w_1 = 250, //width
                    h_1 = 250, //height
                    r_1 = 100 //radius

            color_1 = d3.scale.ordinal()
                    .range(["#736D79", "#ff77aa"]);

            data_1 = [{"label": "Request saved by Cloudflare", "value": requestbycloudflarePer, "title": requestbycloudflareValue},
                {"label": "Request saved by User", "value": requestbyuserPer, "title": requestbyuserValue}];

            if (requestmode == 0) {

                color_1 = d3.scale.ordinal()
                        .range(["#eae1e2"]);

                data_1 = [{"label": "", "value": 100, "title": ""}];

            }

            var vis_1 = d3.select("#section-underline-1-piechart-requestserved")
                    .append("svg:svg")              //create the SVG element inside the <body>
                    .data([data_1])                   //associate our data with the document
                    .attr("width", w_1)           //set the width and height of our visualization (these will be attributes of the <svg> tag
                    .attr("height", h_1)
                    .append("svg:g")                //make a group to hold our pie chart
                    .attr("transform", "translate(" + 120 + "," + 120 + ")")    //move the center of the pie chart from 0, 0 to radius, radius

            var arc_1 = d3.svg.arc()              //this will create <path> elements for us using arc data
                    .outerRadius(r_1);


            var pie_1 = d3.layout.pie()           //this will create arc data for us given a list of values
                    .value(function(d) {
                        return d.value;
                    });    //we must tell it out to access the value of each element in our data array



            if (requestmode == 0) {
                var arcs_1 = vis_1.selectAll("g.slice")
                        .data(pie_1)
                        .enter()
                        .append("svg:g")
                        .attr("class", "slice");
            } else {
                var arcs_1 = vis_1.selectAll("g.slice")     //this selects all <g> elements with class slice (there aren't any yet)
                        .data(pie_1)                          //associate the generated pie data (an array of arcs, each having startAngle, endAngle and value properties) 
                        .enter()                            //this will create <g> elements for every "extra" data element that should be associated with a selection. The result is creating a <g> for every object in the data array
                        .append("svg:g")                //create a group to hold each slice (we will have a <path> and a <text> element associated with each slice)
                        .attr("class", "slice")
                        .on("mouseover", function(d, i) {
                            d3.select("#tooltip")
                                    .style("left", d3.event.pageX / 2 + "px")
                                    .style("top", d3.event.pageY / 2 + "px")
                                    .style("opacity", 1)
                                    .select("#lvalue").text(data_1[i].label);
                            d3.select("#tooltip").select("#value").text(d.value);
                            d3.select("#tooltip").select("#tvalue").text(data_1[i].title);
                        })
                        .on("mouseout", function() {
                            // Hide the tooltip
                            d3.select("#tooltip")
                                    .style("opacity", 0);
                        });
            }

            //allow us to style things in the slices (like text)
            var asdf_1 = arcs_1.append("svg:path")
                    .attr("fill", function(d, i) {
                        return color_1(i);
                    }) //set the color for each slice to be chosen from the color function defined above
                    .attr("d", arc_1);                                    //this creates the actual SVG path using the associated data (pie) with the arc drawing function

            arcs_1.append("svg:text")                                     //add a label to each slice
                    .attr("transform", function(d) {                    //set the label's origin to the center of the arc
                        //we have to make sure to set these before calling arc.centroid
                        d.innerRadius = 0;
                        d.outerRadius = r;
                        return "translate(" + arc_1.centroid(d) + ")";        //this gives us a pair of coordinates like [50, 50]
                    });


            var arc1_1 = d3.svg.arc()
                    .outerRadius(r_1 - 10)
                    .innerRadius(0);

            var arc2_1 = d3.svg.arc()
                    .outerRadius(r_1 + 10)
                    .innerRadius(0);

            asdf_1.on("mouseover", function(d) {
                d3.select(this).transition().duration(200).attr("d", arc2_1);
            });

            asdf_1.on("mouseout", function(d, i) {
                d3.select(this).transition().duration(200).attr("d", arc_1);
            });

            var circle_1 = vis_1.append("circle")
                    .attr({
                        "cx": 0,
                        "cy": 0,
                        "r": 90,
                        "fill": "none",
                        "stroke": "#fff",
                        "stroke-width": 2
                    });

            // **************** Pie Chart 2 For Stats **************** //


            // **************** Pie Chart 3 For Stats **************** //

            var w_2 = 250, //width
                    h_2 = 250, //height
                    r_2 = 100 //radius

            color_2 = d3.scale.ordinal()
                    .range(["#736D79", "#2CC185"]);

            data_2 = [{"label": "Bandwidth saved by Cloudflare", "value": bandwidthbycloudflarePer, "title": bandwidthbycloudflareValue},
                {"label": "Bandwidth saved by User", "value": bandwidthbyuserPer, "title": bandwidthbyuserValue}];

            if (bandwidthmode == 0) {
                color_2 = d3.scale.ordinal()
                        .range(["#eae1e2"]);

                data_2 = [{"label": "", "value": 100, "title": ""}];
            }

            var vis_2 = d3.select("#section-underline-1-piechart-bandwidthserved")
                    .append("svg:svg")              //create the SVG element inside the <body>
                    .data([data_2])                   //associate our data with the document
                    .attr("width", w_2)           //set the width and height of our visualization (these will be attributes of the <svg> tag
                    .attr("height", h_2)
                    .append("svg:g")                //make a group to hold our pie chart
                    .attr("transform", "translate(" + 120 + "," + 120 + ")")    //move the center of the pie chart from 0, 0 to radius, radius

            var arc_2 = d3.svg.arc()              //this will create <path> elements for us using arc data
                    .outerRadius(r_2);


            var pie_2 = d3.layout.pie()           //this will create arc data for us given a list of values
                    .value(function(d) {
                        return d.value;
                    });    //we must tell it out to access the value of each element in our data array



            if (bandwidthmode == 0) {
                var arcs_2 = vis_2.selectAll("g.slice")
                        .data(pie_2)
                        .enter()
                        .append("svg:g")
                        .attr("class", "slice");
            } else {
                var arcs_2 = vis_2.selectAll("g.slice")     //this selects all <g> elements with class slice (there aren't any yet)
                        .data(pie_2)                          //associate the generated pie data (an array of arcs, each having startAngle, endAngle and value properties) 
                        .enter()                            //this will create <g> elements for every "extra" data element that should be associated with a selection. The result is creating a <g> for every object in the data array
                        .append("svg:g")                //create a group to hold each slice (we will have a <path> and a <text> element associated with each slice)
                        .attr("class", "slice")
                        .on("mouseover", function(d, i) {
                            d3.select("#tooltip")
                                    .style("left", d3.event.pageX / 2 + "px")
                                    .style("top", d3.event.pageY / 2 + "px")
                                    .style("opacity", 1)
                                    .select("#lvalue").text(data_2[i].label);
                            d3.select("#tooltip").select("#value").text(d.value);
                            d3.select("#tooltip").select("#tvalue").text(data_2[i].title);
                        })
                        .on("mouseout", function() {
                            // Hide the tooltip
                            d3.select("#tooltip")
                                    .style("opacity", 0);
                        });
            }


            //allow us to style things in the slices (like text)
            var asdf_2 = arcs_2.append("svg:path")
                    .attr("fill", function(d, i) {
                        return color_2(i);
                    }) //set the color for each slice to be chosen from the color function defined above
                    .attr("d", arc_2);                                    //this creates the actual SVG path using the associated data (pie) with the arc drawing function

            arcs_1.append("svg:text")                                     //add a label to each slice
                    .attr("transform", function(d) {                    //set the label's origin to the center of the arc
                        //we have to make sure to set these before calling arc.centroid
                        d.innerRadius = 0;
                        d.outerRadius = r;
                        return "translate(" + arc_2.centroid(d) + ")";        //this gives us a pair of coordinates like [50, 50]
                    });

            var arc1_2 = d3.svg.arc()
                    .outerRadius(r_2 - 10)
                    .innerRadius(0);

            var arc2_2 = d3.svg.arc()
                    .outerRadius(r_2 + 10)
                    .innerRadius(0);

            asdf_2.on("mouseover", function(d) {
                d3.select(this).transition().duration(200).attr("d", arc2_1);
            });

            asdf_2.on("mouseout", function(d, i) {
                d3.select(this).transition().duration(200).attr("d", arc_1);
            });

            var circle_2 = vis_2.append("circle")
                    .attr({
                        "cx": 0,
                        "cy": 0,
                        "r": 90,
                        "fill": "none",
                        "stroke": "#fff",
                        "stroke-width": 2
                    });

            // **************** Pie Chart 3 For Stats **************** //
        }

        ///////////////////////////////////////////////////////////////////////
        var responseurl = 'modules/servers/wgs_cf_partnerapi/response.php';

        var defaults = {
            'serviceid': '{/literal}{$id}{literal}',
            'username': '{/literal}{$user}{literal}',
            'userpass': '{/literal}{$password}{literal}',
            'domain': '{/literal}{$domain}{literal}',
            'cf_api_key': '{/literal}{$cf_api_key}{literal}'
        };

        function get_stats(interval) {

            opts = jQuery.extend(defaults, {'action': 'get_stats', 'interval': interval});

            jQuery.post(responseurl, opts, function(data) {
                var data2 = jQuery.parseJSON(data);

                // Pageview
                var pageview_regularTrafficValue = data2.result.objs[0].trafficBreakdown.pageviews.regular;

                var pageview_crawlerValue = data2.result.objs[0].trafficBreakdown.pageviews.crawler;

                var pageview_threatsValue = data2.result.objs[0].trafficBreakdown.pageviews.threat;

                var pageview_total = pageview_regularTrafficValue + pageview_crawlerValue + pageview_threatsValue;

                var pageview_regularTrafficPer = Math.round((pageview_regularTrafficValue / pageview_total) * 100);
                var pageview_crawlerPer = Math.round((pageview_crawlerValue / pageview_total) * 100);
                var pageview_threatsPer = Math.round((pageview_threatsValue / pageview_total) * 100);
                // Unique Visitor
                var unique_visitor_total = data2.result.objs[0].trafficBreakdown.uniques.regular + data2.result.objs[0].trafficBreakdown.uniques.threat + data2.result.objs[0].trafficBreakdown.uniques.crawler;
                // Requests
                var requestbycloudflareValue = data2.result.objs[0].requestsServed.cloudflare;

                var requestbyuserValue = data2.result.objs[0].requestsServed.user;

                var requesttotal = requestbycloudflareValue + requestbyuserValue;
                var requestbycloudflarePer = Math.round((requestbycloudflareValue / requesttotal) * 100);
                var requestbyuserPer = Math.round((requestbyuserValue / requesttotal) * 100);
                // Bandwidth
                var bandwidthbycloudflareValue = Math.round(data2.result.objs[0].bandwidthServed.cloudflare / 1024);
                var bandwidthbyuserValue = Math.round(data2.result.objs[0].bandwidthServed.user / 1024);

                var bandwidthtotal = bandwidthbycloudflareValue + bandwidthbyuserValue;
                var bandwidthbycloudflarePer = Math.round((bandwidthbycloudflareValue / bandwidthtotal) * 100);
                var bandwidthbyuserPer = Math.round((bandwidthbyuserValue / bandwidthtotal) * 100);




                jQuery('#pageviewtotal span').html(pageview_total);
                jQuery('#pageviewregular span').html(pageview_regularTrafficValue);
                jQuery('#pageviewthreat span').html(pageview_threatsValue);
                jQuery('#pageviewcrawler span').html(pageview_crawlerValue);


                jQuery('#uniquetotal span').html(unique_visitor_total);
                jQuery('#uniqueregular span').html(data2.result.objs[0].trafficBreakdown.uniques.regular);
                jQuery('#uniquethreat span').html(data2.result.objs[0].trafficBreakdown.uniques.threat);
                jQuery('#uniquecrawler span').html(data2.result.objs[0].trafficBreakdown.uniques.crawler);


                jQuery('#bandwidthuser span').html(bandwidthbyuserValue);
                jQuery('#bandwidthCF span').html(bandwidthbycloudflareValue);
                jQuery('#bandwidthtotal span').html(bandwidthtotal);


                jQuery('#requestuser span').html(requestbyuserValue);
                jQuery('#requestCF span').html(requestbycloudflareValue);
                jQuery('#requesttotal span').html(requesttotal);

                $("#section-underline-1-piechart").html('');
                $("#section-underline-1-piechart-bandwidthserved").html('');
                $("#section-underline-1-piechart-requestserved").html('');

                statsinpiecharts(pageview_regularTrafficPer, pageview_regularTrafficValue, pageview_crawlerPer, pageview_crawlerValue, pageview_threatsPer, pageview_threatsValue, requestbycloudflarePer, requestbycloudflareValue, requestbyuserPer, requestbyuserValue, bandwidthbycloudflarePer, bandwidthbycloudflareValue, bandwidthbyuserPer, bandwidthbyuserValue);

            });

        }//function

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////
        // ********************************* TAB 2 - Actions *************************************** //
        function show_saved(id) {
            jQuery('.errorbox').slideUp('slow');
            jQuery('#settings_saved' + id).slideDown('slow', function() {
                jQuery(this).delay(2000).slideUp('slow');
            });
        }//function
        function scrolltotop() {
            $("html, body").animate({
                scrollTop: 80
            }, 600);
            return false;
        }

        // 1. Cache Level Settings
        function cachelevel(type) {
            if (type === 'basic') {
                set_cache_lvl_basic();
            } else if (type === 'agg') {
                set_cache_lvl_agg();
            }
        }

        function set_cache_lvl_basic() {
            $(".cachelevelloader").show();
            opts = jQuery.extend(defaults, {'action': 'cache_lvl'}, {'cache_level': 'basic'});
            jQuery.post(responseurl, opts, function(data) {
                var data2 = jQuery.parseJSON(data);
                jQuery('#cachelvlval option').removeAttr('selected');
                jQuery('#cachelvlval').val('basic');
                jQuery('#cachelvlval option[value="basic"]').attr('selected', 'selected');
                $(".cachelevelloader").hide();
                scrolltotop();
                show_saved('2');
            });
        }//function	
        function set_cache_lvl_agg() {
            $(".cachelevelloader").show();
            opts = jQuery.extend(defaults, {'action': 'cache_lvl'}, {'cache_level': 'agg'});
            jQuery.post(responseurl, opts, function(data) {
                var data2 = jQuery.parseJSON(data);
                jQuery('#cachelvlval option').removeAttr('selected');
                jQuery('#cachelvlval').val('agg');
                jQuery('#cachelvlval option[value="agg"]').attr('selected', 'selected');
                $(".cachelevelloader").hide();
                scrolltotop();
                show_saved('2');
            });
        }//function	

        // 2. Clear/Purge Cache
        function clear_cache() {
            $(".clearcacheloader").show();
            opts = jQuery.extend(defaults, {'action': 'fpurge_ts'});
            jQuery.post(responseurl, opts, function(data) {
                var data2 = jQuery.parseJSON(data);
                jQuery('#clearcache a').delay(100).fadeOut('slow');
                $(".clearcacheloader").hide();
                jQuery('#clearcache').html('<p style="color: #008744;">Cache Cleared this session</p>');
            });
        }//function

        // 3. Purge Single File
        function zone_file_purge() {
            $(".purgesinglefileloader").show();
            var url = jQuery('#purge_file_path').val();
            opts = jQuery.extend(defaults, {'action': 'zone_file_purge', 'url': url});
            jQuery.post(responseurl, opts, function(data) {
                var data2 = jQuery.parseJSON(data);
                $(".purgesinglefileloader").hide();
                scrolltotop();
                if (data2.result == 'error') {
                    jQuery('.errorbox2').html(data2.msg).slideDown('slow');
                } else {
                    show_saved('2');
                }
            });
        }
        // 4. Automatic IPV46 settings
        function ipv46() {
            $(".ipv46loader").show();
            var v = $('#ipv46_select').val();
            opts = jQuery.extend(defaults, {'action': 'ipv46', 'v': v});
            jQuery.post(responseurl, opts, function(data) {
                var data2 = jQuery.parseJSON(data);
                $(".ipv46loader").hide();
                scrolltotop();
                if (data2.result == 'error') {
                    jQuery('.errorbox2').html(data2.msg).slideDown('slow');
                } else {
                    show_saved('2');
                }
            });
        }
        // 5. Set Rocket Loader
        function async() {
            $(".rocketloader").show();
            var v = $('#async_id').val();
            opts = jQuery.extend(defaults, {'action': 'async', 'v': v});
            jQuery.post(responseurl, opts, function(data) {
                var data2 = jQuery.parseJSON(data);
                $(".rocketloader").hide();
                scrolltotop();
                if (data2.result == 'error') {
                    jQuery('.errorbox2').html(data2.msg).slideDown('slow');
                } else {
                    show_saved('2');
                }
            });
        }
        // 6. Auto minify Web Optimization
        function minify() {
            $(".autominifyloader").show();
            var v = $('#minify_id').val();
            opts = jQuery.extend(defaults, {'action': 'minify', 'v': v});
            jQuery.post(responseurl, opts, function(data) {
                var data2 = jQuery.parseJSON(data);
                $(".autominifyloader").hide();
                scrolltotop();
                if (data2.result == 'error') {
                    jQuery('.errorbox2').html(data2.msg).slideDown('slow');
                } else {
                    show_saved('2');
                }
            });
        }
        // 7.Toggle Developer Mode 
        function dev_mode_off() {
            $(".toggledeveloperloader").show();
            opts = jQuery.extend(defaults, {'action': 'dev_mode', 'dev_mode': '0'});
            jQuery.post(responseurl, opts, function(data) {
                var data2 = jQuery.parseJSON(data);
                jQuery('#devmode input').removeAttr('checked');
                jQuery('#devmode input[value="off"]').attr('checked', 'checked');
                $(".toggledeveloperloader").hide();
                scrolltotop();
                show_saved('2');
            });
        }//function
        function dev_mode_on() {
            $(".toggledeveloperloader").show();
            opts = jQuery.extend(defaults, {'action': 'dev_mode', 'dev_mode': '1'});
            jQuery.post(responseurl, opts, function(data) {
                var data2 = jQuery.parseJSON(data);
                jQuery('#devmode input').removeAttr('checked');
                jQuery('#devmode input[value="on"]').attr('checked', 'checked');
                $(".toggledeveloperloader").hide();
                scrolltotop();
                show_saved('2');
            });
        }//function

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////



        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////
        // ********************************* TAB 3 - Security *************************************** //
        // 1. Security Level Settings
        function send_security() {
            $(".seclvlloader").show();
            var val = jQuery('#seclvlval').val();
            opts = jQuery.extend(defaults, {'action': 'sec_lvl', 'sec_lvl': val});
            jQuery.post(responseurl, opts, function(data) {
                alert(data);
                var data2 = jQuery.parseJSON(data);
                $(".seclvlloader").hide();
                scrolltotop();
                if (data2.result == 'error') {
                    jQuery('.errorbox3').html(data2.msg).slideDown('slow');
                } else {
                    jQuery('#seclvlval').val(val);
                    show_saved('3');
                }
            });
        }//function


        // 2. Blacklist or Whitelist IP Address
        function send_ip() {
            var val = jQuery('#ipval').val();
            var action = jQuery('#ipvaltype').val();
            opts = jQuery.extend(defaults, {'action': action, 'ipval': val});
            jQuery.post(responseurl, opts, function(data) {
                var data2 = jQuery.parseJSON(data);
                if (data2.result == 'error') {
                    jQuery('.errorbox3').html(data2.msg).slideDown('slow');
                } else {
                    show_saved('3');
                }
            });
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////
        //************************************* TAB 5 - DNS ******************************************//
        function add_new() {
            $(".addnewdnsloader").show();
            var data = jQuery('#newrec').serialize();
            opts = jQuery.extend(defaults, {'action': 'add_new', 'data': data});
            jQuery.post(responseurl, opts, function(data) {
                var data2 = jQuery.parseJSON(data);
                $(".addnewdnsloader").hide();
                if (data2.result == 'error') {
                    $('html, body').animate({scrollTop: 200}, 'slow');
                    jQuery('.errorbox5').html(data2.msg).slideDown('slow');

                    //} else if (data2.result.ok) {
                } else if (data2.rec.obj.rec_id) {
                    var str = "<tr class='view'><td>" + data2.rec.obj.display_name + "</td><td>" + data2.rec.obj.type + "</td><td>" + data2.rec.obj.display_content + "</td>";
                    var ttltext = '10 mins';
                    var ttlopt = "";
                    var cloudstatus = '';
                    var cloudopt = '';
                    if (data2.rec.obj.service_mode == '1') {
                        cloudstatus = "<div class='active-cloud'></div>";
                        cloudopt = "<option  value='0'>Disable</option><option selected='selected'  value='1'>Enable</option>";
                    } else {
                        cloudstatus = "<div class='inactive-cloud'></div>";
                        cloudopt = "<option  selected='selected' value='0'>Disable</option><option  value='1'>Enable</option>";
                    }
                    str += "<td> " + ttltext + " </td><td>" + cloudstatus + "</td><td><div class='btn editbtn'>Edit</div></td></tr>";
                    str += "<tr class='edit' id='" + data2.rec.obj.rec_id + "'><td><input type='hidden'  name='name' id='" + data2.rec.obj.rec_id + "_name' value='" + data2.rec.obj.display_name + "'/>" + data2.rec.obj.display_name + "</td>\n\
                      <td><input type='hidden'  name='type' id='" + data2.rec.obj.rec_id + "_type'  value='" + data2.rec.obj.type + "'/>" + data2.rec.obj.type + "</td>\n\
    <td><input type='text' name='content' id='" + data2.rec.obj.rec_id + "_content'   value='" + data2.rec.obj.content + "'/></td><td class='input ttl' id='" + data2.rec.obj.rec_id + "_ttl' rel='600'>10 mins</td><td><select name='cdn' id='" + data2.rec.obj.rec_id + "_cdn' >" + cloudopt + "</select></td><td><div class='canceledit btn'>Cancel</div><input type='submit' value='Save'  rc='" + data2.rec.obj.rec_id + "' class='btn updatedns'/><input type='button' rc='" + data2.rec.obj.rec_id + "' class='btn deleterec' dname='" + data2.rec.obj.display_name + "." + jQuery('.deleterec').attr('zone') + "' zone='" + jQuery('.deleterec').attr('zone') + "' value='Delete'/></td>";
                    jQuery(str).appendTo('.dnstable');

                }


            });
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        jQuery(document).ready(function() { // Document Ready

            $('#menu').fancySelect().on('change', function() {
                get_stats($(this).val());
            });

            var regularTrafficPer = {/literal}{$pageview.regular.per}{literal};
            var regularTrafficValue = {/literal}{$pageview.regular.value}{literal};

            var crawlerPer = {/literal}{$pageview.crawler.per}{literal};
            var crawlerValue = {/literal}{$pageview.crawler.value}{literal};

            var threatsPer = {/literal}{$pageview.threat.per}{literal};
            var threatsValue = {/literal}{$pageview.threat.value}{literal};

            var requestbycloudflarePer = {/literal}{$request_saved.cloudflare.per}{literal};
            var requestbycloudflareValue = {/literal}{$request_saved.cloudflare.value}{literal};

            var requestbyuserPer = {/literal}{$request_saved.user.per}{literal};
            var requestbyuserValue = {/literal}{$request_saved.user.value}{literal};

            var bandwidthbycloudflarePer = {/literal}{$bandwidth_saved.cloudflare.per}{literal};
            var bandwidthbycloudflareValue = {/literal}{$bandwidth_saved.cloudflare.value}{literal};

            var bandwidthbyuserPer = {/literal}{$bandwidth_saved.user.per}{literal};
            var bandwidthbyuserValue = {/literal}{$bandwidth_saved.user.value}{literal};


            statsinpiecharts(regularTrafficPer, regularTrafficValue, crawlerPer, crawlerValue, threatsPer, threatsValue, requestbycloudflarePer, requestbycloudflareValue, requestbyuserPer, requestbyuserValue, bandwidthbycloudflarePer, bandwidthbycloudflareValue, bandwidthbyuserPer, bandwidthbyuserValue);

            //////////////////////////////////
            /// 5. ******** DNS ********* ///
            ////////////////////////////////

            jQuery(".editbtn").on('click', function() {

                jQuery(this).parent().parent().hide();

                jQuery(this).parent().parent().next('tr').fadeIn('slow');
            });

            jQuery().on('', function() {

            });
            jQuery('.updatedns').on('click', function() {
                var selector = jQuery(this).parent().parent().html();
                var rc = jQuery(this).attr('rc');
                var content = jQuery('#' + rc + '_content').val();
                var ttl = jQuery('#' + rc + '_ttl').attr('rel');
                var ttltext = jQuery('#' + rc + '_ttl').text();
                var name = jQuery('#' + rc + '_name').val();
                var display_name = jQuery('#' + rc + '_name').parent().text();
                var type = jQuery('#' + rc + '_type').val();
                var cdn = jQuery('#' + rc + '_cdn').val();
                var zone = jQuery(this).next().attr('zone');
                var stredit = '';

                opts = jQuery.extend(defaults, {'action': 'rec_edit', 'content': content, 'ttl': ttl, 'rc': rc, 'name': name, 'type': type, 'cdn': cdn, 'zone': zone});
                jQuery.post(responseurl, opts, function(data) {

                    var data2 = jQuery.parseJSON(data);
                    if (data2.result == 'error') {
                        $('html, body').animate({scrollTop: 200}, 'slow');
                        jQuery('.errorbox').html(data2.msg).slideDown('slow').scrollTop();

                    } else {
                        //window.location.reload(true);
                        var strview = "<td>" + display_name + "</td><td>" + data2.rec.obj.type + "</td><td>" + data2.rec.obj.content + "</td>";

                        var ttlopt = "";

                        var cloudstatus = '';
                        var cloudopt = '';
                        if (data2.rec.obj.service_mode == '1') {
                            cloudstatus = "<div class='active-cloud'></div>";
                            cloudopt = "<option  value='0'>Disable</option><option selected='selected'  value='1'>Enable</option>";
                        } else {
                            cloudstatus = "<div class='inactive-cloud'></div>";
                            cloudopt = "<option  selected='selected' value='0'>Disable</option><option  value='1'>Enable</option>";
                        }

                        strview += "<td> " + ttltext + " </td><td>" + cloudstatus + "</td><td><div class='btn editbtn btn-info'>Edit</div></td>";
                        stredit = "<td><input type='hidden'  name='name' id='" + data2.rec.obj.rec_id + "_name' value='" + data2.rec.obj.display_name + "'/>" + display_name + "</td>\n\
                      <td><input type='hidden'  name='type' id='" + data2.rec.obj.rec_id + "_type'  value='" + data2.rec.obj.type + "'/>" + data2.rec.obj.type + "</td>\n\
    <td><input type='text' class='textboxh' name='content' id='" + data2.rec.obj.rec_id + "_content'   value='" + data2.rec.obj.content + "'/></td><td class='input ttl' id='" + data2.rec.obj.rec_id + "_ttl' rel='600'>10 mins</td><td><select name='cdn' id='" + data2.rec.obj.rec_id + "_cdn' >" + cloudopt + "</select></td><td><div class='canceledit btn'>Cancel</div> <input type='submit' value='Save'  rc='" + data2.rec.obj.rec_id + "' class='btn updatedns btn-success'/> <input type='button' class='btn deleterec btn-danger' dname='" + data2.rec.obj.name + "' zone='" + jQuery('.deleterec').attr('zone') + "' value='Delete'/></td>";
                        jQuery('#' + rc).prev('tr').html(strview).show();
                        jQuery('#' + rc).hide().html(stredit);
                        jQuery('#' + rc).attr('id', data2.rec.obj.rec_id);


                    }
                    jQuery('#seclvlval option').removeAttr('selected');
                    jQuery('#seclvlval').val('med');
                    jQuery('#seclvlval option[value="med"]').attr('selected', 'selected');

                });
            });
            jQuery('.canceledit').on('click', function() {
                jQuery(this).parent().parent().hide();
                jQuery(this).parent().parent().prev('tr').fadeIn('slow');
            });
            jQuery('.deleterec').on('click', function() {
                var curselector = this;
                var id = jQuery(this).attr('rc');
                opts = jQuery.extend(defaults, {'action': 'rec_del', 'id': id});
                jQuery.post(responseurl, opts, function(data) {
                    var data2 = jQuery.parseJSON(data);
                    if (data2.result.length != '0') {
                        jQuery(curselector).parent().parent().fadeOut('slow');
                    } else {
                        $('html, body').animate({scrollTop: 200}, 'slow');
                        jQuery('.errorbox').html('Unable to delete').slideDown('slow').scrollTop();
                    }
                    jQuery('#seclvlval option').removeAttr('selected');
                    jQuery('#seclvlval').val('med');
                    jQuery('#seclvlval option[value="med"]').attr('selected', 'selected');

                });
            });
            var selectedtype = jQuery('#type').val();
            var previouselected = selectedtype;
            jQuery('.type-' + selectedtype).show();
            jQuery('#addnew').show();
            jQuery('#type').change(function() {
                selectedtype = jQuery('#type').val();
                jQuery('.type-' + previouselected).hide();
                previouselected = selectedtype;
                jQuery('.type-' + selectedtype).show();

            });


        }); // Document Ready
    </script>
{/literal}


<link rel="stylesheet" media="screen, projection" href="{$url}css/stats/fancySelect.css">
<script src="{$url}js/stats/fancySelect.js"></script>
<link rel="stylesheet" type="text/css" href="{$url}css/stats/demo.css" />
<link rel="stylesheet" type="text/css" href="{$url}css/stats/tabs.css" />
<link rel="stylesheet" type="text/css" href="{$url}css/stats/tabstyles.css" />
<script src="{$url}js/stats/modernizr.custom.js"></script>

<form name="cloudflare-form" method="post" id="cloudflare-form" action="clientarea.php?action=productdetails&id={$smarty.get.id}">
    <input type='hidden' name='modop' value='custom'>
    <input type='hidden' name='a' value='manage_page'>
</form>

<header class="codrops-header">
    <h1><img src="{$url}images/cloud.png" alt="CloudFlare "> {$domain}</h1>
</header>

<section>
    <div class="tabs tabs-style-underline">
        <nav>
            <ul>
                <li><a href="#section-underline-1" class="cloudflare cloudflare-upload"><span>Stats</span></a></li>
                <li><a href="#section-underline-2" class="cloudflare cloudflare-tools"><span>Actions</span></a></li>
                <li><a href="#section-underline-3" class="cloudflare cloudflare-box"><span>Security</span></a></li>
                <li><a href="#section-underline-4" class="cloudflare cloudflare-display"><span>Reports</span></a></li>
                <li><a href="#section-underline-5" class="cloudflare cloudflare-config"><span>DNS</span></a></li>
            </ul>
        </nav>
        <div class="content-wrap">
            <section id="section-underline-1">


                <div style="float:right;">
                    <select id="menu">
                        <option value=""> View Stats </option>
                        <option value="40"> Past Day </option>
                        <option value="20" selected="selected"> 30 Days </option>
                        <option value="30"> 7 Days </option>
                        <option value="100"> 24 Hours </option>
                        <option value="110"> 12 Hours </option>
                        <option value="120"> 6 Hours </option>
                    </select>
                </div>
                <div class="color-scale">
                    <svg width="15" height="15"><rect width="15" height="15" class="color-scale1" /></svg> Regular Traffic
                    <svg width="15" height="15"><rect width="15" height="15" class="color-scale2" /></svg> Crawlers/bots
                    <svg width="15" height="15"><rect width="15" height="15" class="color-scale3" /></svg> Threats
                </div>
                <p id="section-underline-1-piechart" class="pie-chart">
                <div id="tooltip" class="hidden">
                    <p><span id="lvalue"></span></p>
                    <p><span id="tvalue"></span> Page Views</p>
                    <p><span id="value">100</span>% of total</p>
                </div>
                </p>
                <div class="divright_cf">
                    <div id="securitysetting" class="darkgrey_text bottomline_cf">Your security setting: <span>{$securitysetting}</span></div>
                    <div id="pageviewtotal" class="lightgrey_text">Page Views <span>{$pageview.total}</span></div> 
                    <div id="pageviewregular" class="blue_text">Regular Traffic <span>{$pageview.regular.value}</span></div>
                    <div id="pageviewcrawler" class="pink_text">Crawlers/bots <span>{$pageview.crawler.value}</span></div>
                    <div id="pageviewthreat" class="red_text bottomline_cf">Threats <span>{$pageview.threat.value}</span></div>
                    <div id="uniquetotal" class="lightgrey_text">Unique Visitors <span>{$unique_visitor.total}</span></div> 
                    <div id="uniqueregular" class="blue_text">Regular Traffic <span>{$unique_visitor.regular.value}</span></div>
                    <div id="uniquecrawler" class="pink_text">Crawlers/bots <span>{$unique_visitor.crawler.value}</span></div>
                    <div id="uniquethreat" class="redr_text bottomline_cf">Threats <span>{$unique_visitor.threat.value}</span></div>
                </div>
                <div style="clear: both;"></div>
                <div id="section-underline-1-piechart-requestserved" class="pie-chart" style="margin-left: 95px;"></div>
                <div class="divright_cf">
                    <div class="darkgrey_text bottomline_cf">Request Saved</div>
                    <div id="requestCF" class="lightgrey_text"><span>{$request_saved.cloudflare.value}</span> requests saved by CloudFlare</div>
                    <div id="requestuser" class="pink_text"><span>{$request_saved.user.value}</span> requests saved by User</div>
                    <div id="requesttotal" class="lightgrey_text"><span>{$request_saved.total}</span> Total Requests</div>
                </div>
                <div style="clear: both;"></div>
                <div id="section-underline-1-piechart-bandwidthserved" class="pie-chart" style="margin-left: 95px;"></div>
                <div class="divright_cf">
                    <div class="darkgrey_text bottomline_cf">Bandwidth Saved</div>
                    <div id="bandwidthCF" class="lightfrey_text"><span>{$bandwidth_saved.cloudflare.value}</span> bandwidth saved by CloudFlare</div>
                    <div id="bandwidthuser" class="green_text"><span>{$bandwidth_saved.user.value}</span> bandwidth saved by User</div>
                    <div id="bandwidthtotal" class="lightgrey_text"><span>{$bandwidth_saved.total}</span> Total Bandwidth</div>
                </div>
                <div style="clear: both;"></div>
            </section>


            <!-- *************************************************************************** -->
            <!-- *************************************************************************** -->
            <!-- *********************** Section 2 *********************** Starts ********** -->
            <section id="section-underline-2"><p>

                <div id="settings_saved2" class="alert alert-success" style="display:none;text-align:center;"><strong>Settings Saved</strong></div>
                <div class="errorbox errorbox2"></div>


                <!-- ****** 1. Cache Level Settings ****** -->
                <div class="div-main-cf">
                    <div class="div-sub-cf">
                        <h3 id="cachelvltitle" class="orange_text">Cache Level Settings</h3>
                        <div id="cachelvl">
                            <p style="line-height: 22px;">
                                <span style="color:#04374E;">
                                    Adjust your caching level to modify CDN's caching behavior.</span><br/><br/>
                                <strong>Aggressive: </strong>{$domain}/pic.jpg?with=query<br/><strong>Basic: </strong>{$domain}/pic.jpg</p>
                            <p>Choose a Cache Level: 
                                <select id="cachelvlval" name="cachelvlval" onchange="cachelevel(this.value)">
                                    <option value="basic"{if $cf_stats.response.result.objs.0.cache_lvl eq 'basic'} selected="selected"{/if} >Basic</option>
                                    <option value="agg"{if $cf_stats.response.result.objs.0.cache_lvl eq 'agg'} selected="selected"{/if} >Aggressive</option>
                                </select> <span class="loader cachelevelloader"><img src="modules/servers/wgs_cf_partnerapi/images/admin/loader.gif"></span></p>
                        </div>
                    </div>
                    <!-- ****** 2. Clear/Purge Cache ****** -->
                    <div class="div-sub-cf">
                        <h3 id="clearcachetitle" class="orange_text">Clear/Purge Cache</h3>
                        <div id="clearcache">
                            <p>Immediately purge cached resources for your website.</p>
                            <p><a href="javascript:void(0);" onclick="jQuery:clear_cache();
                                    jQuery(this).text('Clearing Cache');
                                    return false;" class="btn btn-info">Clear / Purge</a> <span class="loader clearcacheloader"><img src="modules/servers/wgs_cf_partnerapi/images/admin/loader.gif"></span></p>
                        </div>
                    </div>

                </div>

                <div style="clear: both"></div>                

                <!-- ****** 3. Purge Single File ****** -->
                <div class="div-main-cf">
                    <div class="div-sub-cf">
                        <h3 id="file_purge_title" class="orange_text">Purge Single File</h3>
                        <div id="file_purge"><input type="text" id="purge_file_path" name="file_path" style="height: 28px;"/> <p><a href="javascript:void(0);" onclick="jQuery:zone_file_purge();
                                jQuery(this).text('Clearing Cache');
                                return false;" class="btn btn-info">Clear / Purge</a> <span class="loader purgesinglefileloader"><img src="modules/servers/wgs_cf_partnerapi/images/admin/loader.gif"></span></p></div>
                    </div>
                    <!-- ****** 4. Automatic IPv6 ****** -->
                    <div class="div-sub-cf">
                        <h3 id="automatic_ipv46_title" class="orange_text">Automatic IPv6</h3>
                        <div id="file_purge"><select name="IPV46Setting" id="ipv46_select" style="width:140px" class="ui-helper-hidden-accessible"><option value="3">Enable</option><option value="0">Disable</option></select><p><a href="javascript:void(0);" onclick="jQuery:ipv46();
                                return false;" class="btn btn-info">Submit</a> <span class="loader ipv46loader"><img src="modules/servers/wgs_cf_partnerapi/images/admin/loader.gif"></span> </p></div>
                    </div>
                </div>
                <!-- ****** 5. Set Rocket Loader ****** -->
                <div class="div-main-cf">
                    <div class="div-sub-cf">
                        <h3 id="file_purge_title" class="orange_text">Set Rocket Loader</h3>
                        <div id="file_purge"><select name="async_select" id="async_id" style="width:140px" class="ui-helper-hidden-accessible"><option value="0">Off</option><option value="a">Automatic</option><option value="m">Manual</option></select><p><a href="javascript:void(0);" onclick="jQuery:async();
                                return false;" class="btn btn-info">Submit</a> <span class="loader rocketloader"><img src="modules/servers/wgs_cf_partnerapi/images/admin/loader.gif"></span> </p></div>
                    </div>
                    <!-- ****** 6. Auto Minify Web Optimization ****** -->
                    <div class="div-sub-cf">
                        <h3 id="file_purge_title" class="orange_text"> Auto Minify (Web optimization)</h3>
                        <div id="file_purge"><select name="minify_select" id="minify_id" style="width:140px" class="ui-helper-hidden-accessible"><option value="0">Off</option><option value="1">Javascript</option><option value="2">Css Only</option><option value="3">JavaScript and CSS</option><option value="4">HTML only</option><option value="5">JavaScript and HTML</option><option value="6">CSS and HTML</option><option value="7">CSS, JavaScript, and HTML</option></select><p><a href="javascript:void(0);" onclick="jQuery:minify();
                                return false;" class="btn btn-info">Submit</a> <span class="loader autominifyloader"><img src="modules/servers/wgs_cf_partnerapi/images/admin/loader.gif"></span> </p></div>
                    </div>
                </div>
                <!-- ****** 7. Toggle Developer Mode ****** -->
                <div class="div-main-cf">
                    <div class="div-sub-cf">
                        <h3 id="devmodetitle" class="orange_text">Toggle DEV Mode</h3>
                        <div id="devmode">
                            <p>Temporarily enter development mode on your websites.</p>
                            <p><input type="radio" onclick="jQuery:dev_mode_off();
                                    return false;" name="dev_mode" value="off" {if $cf_stats.response.result.objs.0.dev_mode eq '0'}checked="checked" {/if}/> Off  <input type="radio" onclick="jQuery:dev_mode_on();
                                            return false;" name="dev_mode" value="on" {if $cf_stats.response.result.objs.0.dev_mode != '0'}checked="checked" {/if}/> On <span class="loader toggledeveloperloader"><img src="modules/servers/wgs_cf_partnerapi/images/admin/loader.gif"></span></p>
                        </div>
                        <div class="div-sub-cf"></div>
                    </div>

                </p></section>
            <!-- *********************** Section 2 *********************** Ends ********** -->
            <!-- *************************************************************************** -->
            <!-- *************************************************************************** -->


            <!-- *************************************************************************** -->
            <!-- *************************************************************************** -->
            <!-- *********************** Section 3 *********************** Starts ********** -->

            <section id="section-underline-3"><p>
                <div id="settings_saved3" class="alert alert-success" style="display:none;text-align:center;"><strong>Settings Saved</strong></div>
                <div class="errorbox errorbox3"></div>

                <h3 id="seclvltitle" class="orange_text">Security Level Settings</h3>

                <div id="seclvl">
                    <p>Choose a Security Level:
                        <select id="seclvlval" name="seclvlval" style="margin-top: 10px;margin-right: 10px">
                            <option value="eoff"{if $cf_stats.response.result.objs.0.userSecuritySetting eq 'Essentially Off'} selected="selected"{/if}>Essencially Off</option>
                            <option value="low"{if $cf_stats.response.result.objs.0.userSecuritySetting eq 'Low'} selected="selected"{/if}>Low</option>
                            <option value="med"{if $cf_stats.response.result.objs.0.userSecuritySetting eq 'Medium'} selected="selected"{/if}>Medium</option>
                            <option value="high"{if $cf_stats.response.result.objs.0.userSecuritySetting eq 'High'} selected="selected"{/if}>High</option>
                            <option value="help"{if $cf_stats.response.result.objs.0.userSecuritySetting eq "I\'m under attack!"} selected="selected"{/if}> I'm under attack!</option>
                        </select>
                        <input type="button" name="submit_ip" id="submit_ip" class="btn btn-info" value="Send Request" onclick="send_security();"/>
                        <span class="loader seclvlloader"><img src="modules/servers/wgs_cf_partnerapi/images/admin/loader.gif"></span>
                    </p>
                </div>    
                <hr/>
                <h3 id="blockiptitle" class="orange_text">Blacklist or Whitelist IP Address</h3>
                <div id="blockip">
                    <p>IP Address: 
                        <input type="text" id="ipval" class="nomargins" name="ipval" value="" style="margin-top: 10px;height: 28px;" />
                        <select id="ipvaltype" name="ipvaltype" class="nomargins" style="margin-right: 10px !important;margin-top:10px">
                            <option value="black_list">Whithe List</option>
                            <option value="white_list">Black List</option>
                            <option value="remove_ip">Remove IP</option>
                        </select>
                        <input type="button" name="submit_ip" id="submit_ip" class="btn btn-info" value="Send Request" onclick="send_ip();"/>
                    </p>
                </div>
                </p>

            </section>

            <!-- *********************** Section 3 *********************** Ends ********** -->
            <!-- *************************************************************************** -->
            <!-- *************************************************************************** -->

            <!-- *************************************************************************** -->
            <!-- *************************************************************************** -->
            <!-- *********************** Section 4 *********************** Starts ********** -->
            <section id="section-underline-4"><p>
                <table class="cloudflare-table">
                    <thead style="color: #02B3E7;background: #e7ecea;">
                        <tr>
                            <th>IP</th>
                            <th>Classification</th>
                            <th>Hits</th>
                        </tr>
                    </thead>
                    {foreach from=$cf_ips.response.ips item=ip}
                        <tr>
                            <td{if $ip.classification eq 'threat'} style="background-color: #F2DEDE;border-color: #EED3D7;color: #B94A48;"{/if}>{$ip.ip}</td>
                            <td{if $ip.classification eq 'threat'} style="background-color: #F2DEDE;border-color: #EED3D7;color: #B94A48;"{/if}>{$ip.classification}</td>
                            <td{if $ip.classification eq 'threat'} style="background-color: #F2DEDE;border-color: #EED3D7;color: #B94A48;"{/if}>{$ip.hits}</td>
                        </tr>
                    {foreachelse}
                        <tr>
                            <td colspan="3" class="red_text">No Data</td>
                        </tr>
                    {/foreach}
                </table>
                </p></section>
            <!-- *********************** Section 4 *********************** Ends ********** -->
            <!-- *************************************************************************** -->
            <!-- *************************************************************************** -->

            <!-- *************************************************************************** -->
            <!-- *************************************************************************** -->
            <!-- *********************** Section 5 *********************** Starts ********** -->
            <section id="section-underline-5"><p>
                <div class="errorbox errorbox5"></div>
                <table class="cloudflare-table">
                    <thead style="color: #02B3E7;background: #e7ecea;">
                        <tr>
                            <th>Record name</th>
                            <th>Record type</th>
                            <th>IP/Name</th>
                            <th>TTL</th>
                            <th>CDN Enabled</th>
                            <th></th>
                        </tr>
                    </thead>
                    {foreach from=$cf_dns.response.recs.objs item=dns}
                        <tr class="view">
                            <td>{$dns.display_name}</td>
                            <td>{$dns.type}</td>
                            <td>{$dns.content}</td>
                            <td>{if $dns.ttl eq '1'} Automatic{elseif $dns.ttl eq '300'} 5 mins {elseif $dns.ttl eq '600'} 10 mins {elseif $dns.ttl eq '900'} 15 mins {elseif $dns.ttl eq '1800'} 30 mins {elseif $dns.ttl eq '3600'} 1 hour {elseif $dns.ttl eq '7200'} 2 hours {elseif $dns.ttl eq '18000'} 5 hours {elseif $dns.ttl eq '43200'} 12 hours {elseif $dns.ttl eq '86400'} 1 day{/if} </td>
                            <td>{if $dns.props.cloud_on eq '1'}<div class="active-cloud"></div>{else}<div class="inactive-cloud"></div>{/if}</td>
                            <td><div class="btn editbtn btn-info">Edit</div></td>
                        </tr>

                        <tr class="edit" id="{$dns.rec_id}">
                            <td><input type="hidden"  name="name" id="{$dns.rec_id}_name" value="{$dns.name}"/>{$dns.display_name}</td>
                            <td><input type="hidden"  name="type" id="{$dns.rec_id}_type"  value="{$dns.type}"/>{$dns.type}</td>
                            <td><input type="text" name="content" id="{$dns.rec_id}_content"   value="{$dns.content}" class="textboxh" /></td>
                            <td class="input ttl" id="{$dns.rec_id}_ttl" rel="{$dns.ttl}">
                                {if $dns.ttl eq '1'} Automatic{/if} 
                                {if $dns.ttl eq '300'} 5 mins {/if} 
                                {if $dns.ttl eq '600'} 10 mins {/if} 
                                {if $dns.ttl eq '900'} 15 mins {/if} 
                                {if $dns.ttl eq '1800'} 30 mins {/if} 
                                {if $dns.ttl eq '3600'} 1 hour {/if}
                                {if $dns.ttl eq '7200'} 2 hours {/if} 
                                {if $dns.ttl eq '18000'}5 hours {/if}
                                {if $dns.ttl eq '43200'} 12 hours {/if}
                                {if $dns.ttl eq '86400'} 1 day {/if} 
                            </td>
                            <td><select name="cdn" id="{$dns.rec_id}_cdn" >
                                    <option {if $dns.props.cloud_on eq '0'} selected='selected'{/if} value='0'>Disable</option>
                                    <option {if $dns.props.cloud_on eq '1'} selected='selected'{/if} value='1'>Enable</option>
                                </select>
                            </td>
                            <td>

                                <div class="canceledit button-inline" title="Cancel"><img src="modules/servers/wgs_cf_partnerapi/images/admin/disabled.png"></div>
                                <div class="updatedns button-inline" title="Save" rc="{$dns.rec_id}"><img src="modules/servers/wgs_cf_partnerapi/images/admin/tick.png"></div>
                                <div class="deleterec button-inline" title="Delete" rc="{$dns.rec_id}" dname="{$dns.name}" zone="{$dns.zone_name}"><img src="modules/servers/wgs_cf_partnerapi/images/admin/delete.png"></div>
                            </td>
                        </tr>

                    {foreachelse}
                        <tr>
                            <td colspan="6">No Data</td>
                        </tr>
                    {/foreach}

                </table>

                <form method="post" id="newrec" action="" onsubmit="add_new();
                        return false;">
                    <table class="table"><tr id="addnew">
                            <td class="cell type">
                                <select tabindex="1" name="type" id="type" class="type-picker input type">
                                    <option value="a">A</option>
                                    <option value="cname">CNAME</option>  
                                    <option value="mx">MX</option>
                                    <option value="txt">TXT</option>
                                    <option value="spf">SPF</option>
                                    <option value="aaaa">AAAA</option>
                                    <option value="ns">NS</option>
                                    <option value="srv">SRV</option>
                                    <option value="loc">LOC</option>
                                </select>
                            </td>

                            <td class="cell name truncatable">
                                <span class="edit-pane"><input type="text" name="name" error="" placeholder="e.g. www" tabindex="1" value="" class="input name textboxh"></span>
                            </td>
                            <td class="cell value">

                                <span class="edit-pane type-a" style="display: none">points to <input type="text" name="a-content" error="" placeholder="e.g. 127.0.0.1" tabindex="1" value="" class="input hlpr type-a-content textboxh"></span>
                                <span class="edit-pane type-cname" style="display: none">is an alias of 
                                    <input type="text" name="cname-content" error="" placeholder="e.g. mydomain.com" tabindex="1" value="" class="input hlpr type-cname-content textboxh">
                                </span>
                                <span class="edit-pane type-mx" style="display: none">mail handled by 
                                    <input type="text" name="mx-content" error="" placeholder="e.g. mydomain.com" tabindex="1" value="" class="input hlpr type-mx-content textboxh">
                                    <br/> with priority<input type="text" name="mx-prio" error="" placeholder="" tabindex="1" style="width: 50px" value="" class="input hlpr type-mx-prio textboxh">
                                </span>
                                <span class="edit-pane type-txt" style="display: none">
                                    <input type="text" name="txt-content" error="" placeholder="Text record value" tabindex="1" value="" class="input hlpr type-txt-content textboxh">
                                </span>
                                <span class="edit-pane type-spf" style="display: none">
                                    <input type="text" name="spf-content" error="" placeholder="SPF record value" tabindex="1" value="" class="input hlpr type-spf-content textboxh">
                                </span>
                                <span class="edit-pane type-aaaa" style="display: none">points to
                                    <input type="text" name="aaaa-content" error="" placeholder="e.g. mydomain.com" tabindex="1" value="" class="input hlpr type-aaaa-content textboxh">
                                </span>
                                <span class="edit-pane type-ns" style="display: none">managed by
                                    <input type="text" name="ns-content" error="" placeholder="e.g. nameserver.com" tabindex="1" value="" class="input hlpr type-ns-content textboxh">
                                </span>
                                <span class="edit-pane type-loc" style="display: none">
                                    <input type="text" name="loc-content" error="" placeholder="LOC record value" tabindex="1" value="" class="input hlpr type-loc-content textboxh">
                                </span>  <span class="edit-pane type-srv" style="display: none">
                                    <table><tr><td> <span class="edit-pane type-srv"><span class="label srv-label">Service:</span></td><td><input type="text" error="" name="srv-service" value="" tabindex="1" class="input type-srv-service tooltip-right-margin-top invalid textboxh"></td></tr>
                                        <tr><td> <span class="edit-pane type-srv"><span class="label srv-label">Protocol:</span></td><td><select error="" tabindex="1" name="srv-protocol" class="input type-srv-protocol tooltip-right-margin-top textboxh"><option value="_tcp">tcp</option><option value="_udp">udp</option><option value="_tls">tls</option></select></td></tr>
                                        <tr><td> <span class="edit-pane type-srv"><span class="label srv-label">Name:</span></td><td><input type="text" error="" placeholder="@" name="srv-srvname" value="" tabindex="1" class="input type-srv-srvname tooltip-right-margin-top textboxh"></td></tr>
                                        <tr><td> <span class="edit-pane type-srv"><span class="label srv-label">Priority:</span></td><td> <input type="text" error="" name="srv-prio" value="" tabindex="1" class="input type-srv-prio tooltip-right-margin-top invalid textboxh"></td></tr>
                                        <tr><td> <span class="edit-pane type-srv"><span class="label srv-label">Weight:</span></td><td> <input type="text" error="" value="" tabindex="1" name="srv-weight" class="input type-srv-weight tooltip-right-margin-top invalid textboxh"></td></tr>
                                        <tr><td> <span class="edit-pane type-srv"><span class="label srv-label">Port:</span></td><td><input type="text" error="" value="" name="srv-port" tabindex="1" class="input type-srv-port tooltip-right-margin-top invalid textboxh"></td></tr>
                                        <tr><td><span class="edit-pane type-srv"><span class="label srv-label">Target:</span></td><td> <input type="text" error="" name="srv-target" value="" tabindex="1" class="input type-srv-target invalid textboxh"></td></tr>
                                    </table>   </span> 

                            </td>
                            <td class="cell ttl">
                                &nbsp;
                                <!--                        <span class="edit-pane">
                                                            <select tabindex="1" name="ttl" selected="" class="input ttl newttl">
                                                                <option value="1">Automatic</option>
                                                                <option value="300">5 mins</option>
                                                                <option value="600">10 mins</option>
                                                                <option value="900">15 mins</option>
                                                                <option value="1800">30 mins</option>
                                                                <option value="3600">1 hour</option>
                                                                <option value="7200">2 hours</option>
                                                                <option value="18000">5 hours</option>
                                                                <option value="43200">12 hours</option>
                                                                <option value="86400">1 day</option>
                                                            </select>
                                                        </span>-->
                            </td>
                            <td class="cell active"><div class="cloud"></div></td>
                            <td class="cell controls">
                                <div class="editing-controls">
                                    <input class="btn btn-primary" type="submit"   name="addnew" value="Add" />
                                </div>

                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%" style="text-align: center;">
                                <span class="loader addnewdnsloader"><img src="modules/servers/wgs_cf_partnerapi/images/admin/loader.gif"></span>
                            </td>
                        </tr>
                    </table>
                </form>
                </p></section>
            <!-- *********************** Section 5 *********************** Ends ********** -->
            <!-- *************************************************************************** -->
            <!-- *************************************************************************** -->




        </div><!-- /content -->
    </div>
</section>
<br/>
<script src="{$url}js/stats/cbpFWTabs.js"></script>
{literal}
    <script>
                    (function() {

                        [].slice.call(document.querySelectorAll('.tabs')).forEach(function(el) {
                            new CBPFWTabs(el);
                        });

                    })();
    </script>
{/literal}
