<?php

use Illuminate\Database\Capsule\Manager as Capsule;
use WHMCS\View\Menu\Item as MenuItem;

if (file_exists(__DIR__ . '/classes/class.php'))
    require_once __DIR__ . '/classes/class.php';

if (file_exists(__DIR__ . '/classes/class.lang.php'))
    require_once __DIR__ . '/classes/class.lang.php';

add_hook('ClientAreaPageProductsServices', '1', function($vars) {
    if (isset($_GET['action']) && ($_GET['action'] == 'products' || $_GET['action'] == 'services')) {
        global $smarty;
        $array = array();
        $domainArr = array();
        $i = 0;
        foreach ($smarty->getVariable('services')->value as $pKey => $value) {
            if ($value['product'] != 'Cloudflare') {
                $domainArr[] = $value['domain'];
            }
        }
        foreach ($smarty->getVariable('services')->value as $pKey => $value) {
            if ($value['product'] == 'Cloudflare') {
                $cfDomain = $value['domain'];
                if (!in_array($cfDomain, $domainArr)) {
                    $array[] = $value;
                    if ($value['status'] == 'Active')
                        $i++;
                }
            }

            if ($value['product'] != 'Cloudflare') {
                $array[] = $value;
                if ($value['status'] == 'Active')
                    $i++;
            }
        }
        $smarty->assign('services', $array);
        $smarty->assign('productsnumactivehosting', $i);
    }
});
add_hook('ClientAreaPageProductDetails', '1', function($vars) {

    if (isset($_GET['action']) && $_GET['action'] == 'productdetails' && !empty($_GET['id'])) {
        global $smarty;
        $getProductIDetail = Capsule::table('tblproducts')->where('configoption13', '!=', '')->where('servertype', 'wgs_cf_partnerapi')->first();
        $pid = $getProductIDetail->id;
        $getHostingId = Capsule::table('tblhosting')->where('packageid', $pid)->where('domain', $vars['domain'])->first();

        if ($getHostingId->id) {
            $cfUrl = 'clientarea.php?action=productdetails&id=' . $getHostingId->id;

//            $cfUrl = '<form style="display: inline-table;" method="post" target="_blank" id="cloudflareform" action="clientarea.php?action=productdetails&id=' . $getHostingId->id . '"><input type="hidden" name="modop" value="custom"><input type="hidden" name="a" value="manage_page"><input type="hidden" name="cf_action" id="cf_action" value="manageWebsite"><input type="hidden" name="website" id="website" value="brainstorm.photography"><input type="submit" value="Manage Cloudflare" class="btn"></form>';

            $smarty->assign('cfUrl', $cfUrl);
        }
    }
});

add_hook('ClientAreaSecondarySidebar', 1, function (MenuItem $secondarySidebar) {
    if (isset($_GET['action']) && $_GET['action'] == 'productdetails' && !empty($_GET['id'])) {
        global $smarty;
        $params['clientsdetails'] = (array) Capsule::table('tblclients')->where('id', $_SESSION['uid'])->first();
        $wgsLang = new wgsLang();
        $clientLanguage = $wgsLang->wgs_cf_get_client_language($params);
        $language = $wgsLang->wgs_cf_partnerapi_getLang($clientLanguage);
        $getProductIDetail = Capsule::table('tblproducts')->where('configoption13', '!=', '')->where('servertype', 'wgs_cf_partnerapi')->first();
        $pid = $getProductIDetail->id;
        $hostingService = Capsule::table('tblhosting')->where('id', $_GET['id'])->first();
        $getHostingId = Capsule::table('tblhosting')->where('packageid', $pid)->where('domain', $hostingService->domain)->first();

        if ($getHostingId->id) {
            $cfUrl = 'clientarea.php?action=productdetails&id=' . $getHostingId->id;
        }

        if (is_null($secondarySidebar->getChild($language['cf_cloudflare'])) && ($hostingService->id != $getHostingId->id)) {
            $secondarySidebar->addChild($language['cf_cloudflare'])
                    ->addChild($language['cf_manage_cf'])
                    ->setLabel($language['cf_manage_cf'])
                    ->setUri($cfUrl)
                    ->setOrder(100);
        }
    }
});

add_hook('ClientAreaPage', '2', function($vars) {

    $getProductIDetail = Capsule::table('tblproducts')->where('configoption13', '!=', '')->where('servertype', 'wgs_cf_partnerapi')->first();
    $params = (array) $getProductIDetail;
    $params['pid'] = $params['id'];
    if (!empty($_SESSION['cart']['products'])) {
        if (!class_exists('CF_HOST_API')) {
            require("class.cloudflareAPI.php");
        }
        foreach ($_SESSION['cart']['products'] as $key => $pData) {
            $pid = $pData['pid'];
            $getGid = Capsule::table('tblproducts')->where('id', $pid)->first();
            $gid = $getGid->gid;
            $pGrpArr = wgs_cf_create_productGroupsIdArr($params);
            if (!empty($params['configoption2'])) {
                # Cloudflare API
                $hostAPIKey = $params['configoption2'];
                $hostAPI = new CF_HOST_API($hostAPIKey);
                $resllerPlans = $hostAPI->reseller_plan_list();

                $pAddonName = '';
                $plan = $params['configoption9'];
                logModuleCall("CF Partner", "reseller_plan_list", array('act' => 'reseller_plan_list'), (array) $resllerPlans);
                if ($resllerPlans->response->objs) {
                    foreach ($resllerPlans->response->objs as $cfPlan) {
                        if ($plan == $cfPlan->sub_label) {
                            $pAddonName = ($params['configoption8'] == 'full_zone_set') ? $cfPlan->sbase_name . ' With Cloudflare DNS Setup' : $plan->sbase_name . ' With CNAME Setup';
                        }
                    }
                }
            }
            if ($plan == 'Free') {
                $pAddonName = ($params['configoption8'] == 'full_zone_set') ? 'Free Plan With Cloudflare DNS Setup' : 'Free Plan With CNAME Setup';
            }
            $getProductAddonId = wgs_getProductAddonId($pAddonName);

            if (in_array($gid, $pGrpArr) && $params['configoption11'] == 'on') {
                if (empty($_SESSION['cart']['products'][$key]['addons'])) {
                    $_SESSION['cart']['products'][$key]['addons'] = array($getProductAddonId);
                } elseif (!empty($_SESSION['cart']['products'][$key]['addons'])) {
                    if (!in_array($getProductAddonId, $_SESSION['cart']['products'][$key]['addons']))
                        $_SESSION['cart']['products'][$key]['addons'] = array_merge($_SESSION['cart']['products'][$key]['addons'], array($getProductAddonId));
                }
            }
        }
    }
});

function hook_cloudflare_create_zone($vars) {
    $getProductIDetail = Capsule::table('tblproducts')->where('configoption13', '!=', '')->where('servertype', 'wgs_cf_partnerapi')->first();
    $params = (array) $getProductIDetail;
    $addon_id = $vars["addonid"];
    $service_id = $vars["serviceid"];
    $user_id = $vars["userid"];
    $serviceDetail = wgs_get_serviceDomain($service_id);
    $pid = $params['pid'] = $params['id'];

    $domain = $serviceDetail['domain'];
    if (!class_exists('CF_HOST_API')) {
        require("class.cloudflareAPI.php");
    }
    if (!empty($params['configoption2'])) {
        # Cloudflare API
        $hostAPIKey = $params['configoption2'];
        $hostAPI = new CF_HOST_API($hostAPIKey);
        $resllerPlans = $hostAPI->reseller_plan_list();

        $pAddonName = '';
        $plan = $params['configoption9'];
        logModuleCall("CF Partner", "reseller_plan_list", array('act' => 'reseller_plan_list'), (array) $resllerPlans);
        if ($resllerPlans->response->objs) {
            foreach ($resllerPlans->response->objs as $cfPlan) {
                if ($plan == $cfPlan->sub_label) {
                    $pAddonName = ($params['configoption8'] == 'full_zone_set') ? $cfPlan->sbase_name . ' With Cloudflare DNS Setup' : $plan->sbase_name . ' With CNAME Setup';
                }
            }
        }
    }
    if ($plan == 'Free') {
        $pAddonName = ($params['configoption8'] == 'full_zone_set') ? 'Free Plan With Cloudflare DNS Setup' : 'Free Plan With CNAME Setup';
    }
    $getProductAddonId = wgs_getProductAddonId($pAddonName);
    $alreadyExist = Capsule::table('tblhosting')->where('packageid', $pid)->where('domain', $domain)->count();
    $customFieldId = Capsule::table('tblcustomfields')->where('type', 'product')->where('relid', $pid)->where('fieldname', 'like', '%cloudflare_domain%')->first();

    if ($addon_id == $getProductAddonId && $alreadyExist == 0) {
        $command = 'AddOrder';
        $postData = array(
            'clientid' => $user_id,
            'pid' => array($pid),
            'domain' => array($domain),
            'billingcycle' => array('free'),
            'noemail' => true,
            'noinvoice' => true,
            'noinvoiceemail' => true,
            'paymentmethod' => $serviceDetail['paymentmethod']
        );
        if (!empty($customFieldId))
            $postData = array_merge($postData, ['customfields' => array(base64_encode(serialize(array($customFieldId->id => $domain))))]);
        $serviceResults = wgs_cf_whmcs_local_api($command, $postData);
        if ($serviceResults['result'] == 'success') {
            try {
                if (Capsule::table('mod_cf_manage_service')->where('sid', $serviceResults['productids'])->count() == 0) {
                    Capsule::table('mod_cf_manage_service')->insert(['sid' => $serviceResults['productids'], 'addonid' => $addon_id]);
                } else {
                    Capsule::table('mod_cf_manage_service')->where('sid', $serviceResults['productids'])->update(['addonid' => $addon_id]);
                }
                $command = 'AcceptOrder';
                $postData = array(
                    'orderid' => $serviceResults['orderid'],
                    'autosetup' => true,
                    'sendemail' => false,
                );
                $acceptServiceResults = wgs_cf_whmcs_local_api($command, $postData);
                if ($acceptServiceResults['result'] == 'error') {
                    logActivity("Accept Cloudflare client service {$serviceResults['productids']} after addon ativate failed {$acceptServiceResults['message']}");
                }
            } catch (Exception $ex) {
                logActivity("Update/Insert data in mod_cf_manage_service: {$ex->getMessage()}");
            }
        } else {
            logActivity("Create Cloudflare client service after addon ativate failed {$serviceResults['message']}");
        }
    }
}

add_hook('AddonActivation', 1, 'hook_cloudflare_create_zone');
add_hook('AddonActivated', 1, 'hook_cloudflare_create_zone');

add_hook('AfterRegistrarRegistration', 1, function($vars) {

    # include classes
    if (!class_exists('CF_HOST_API')) {
        if (file_exists(__DIR__ . '/class.cloudflareAPI.php'))
            require("class.cloudflareAPI.php");
    }

    if (file_exists(__DIR__ . '/class.wgs_cf_partnerapi.php'))
        require_once __DIR__ . '/class.wgs_cf_partnerapi.php';

    if (file_exists(__DIR__ . '/class.cloudflareclientapi.php'))
        require_once 'class.cloudflareclientapi.php';

    if (file_exists(__DIR__ . '/wgs_cf_partnerapi.php'))
        require_once 'wgs_cf_partnerapi.php';

    if (file_exists(__DIR__ . '/classes/class.php'))
        require_once __DIR__ . '/classes/class.php';
    $apiurl = "https://api.cloudflare.com/client/v4/";

    $domainId = $vars['domainid'];
    $domain = $vars['sld'] . $vars['tld'];
    $getHostingData = Capsule::table('tblhosting')->where('domain', $domain)->first();
    $pid = $getHostingData->packageid;
    $sid = $getHostingData->id;
    $uid = $getHostingData->userid;

    $command = 'GetClientsProducts';
    $postData = array(
        'clientid' => $uid,
        'serviceid' => $sid,
    );

    $serviceResults = wgs_cf_whmcs_local_api($command, $postData);

    $productResults = Capsule::table('tblproducts')->where('id', $pid)->first();
    if ($productResults->servertype == 'wgs_cf_partnerapi') {
        $params = (array) $productResults;
        $params['pid'] = $params['id'];
        # Email Address
        $emailAddressField = substr($params['configoption3'], strpos($params['configoption3'], ':') + 1);
        $emailAddressField = cloudflare_Encoding::fixUTF8($emailAddressField);
        # Password
        $passwordField = substr($params['configoption4'], strpos($params['configoption4'], ':') + 1);
        $passwordField = cloudflare_Encoding::fixUTF8($passwordField);
        # Uesername
        $usernameField = substr($params['configoption5'], strpos($params['configoption5'], ':') + 1);
        $usernameField = cloudflare_Encoding::fixUTF8($usernameField);
        # User Key
        $userKeyField = substr($params['configoption6'], strpos($params['configoption6'], ':') + 1);
        $userKeyField = cloudflare_Encoding::fixUTF8($userKeyField);
        # User API Key
        $userAPIKeyField = substr($params['configoption7'], strpos($params['configoption7'], ':') + 1);
        $userAPIKeyField = cloudflare_Encoding::fixUTF8($userAPIKeyField);

        foreach ($serviceResults['products']['product'][0]['customfields']['customfield'] as $customfields) {
            if ($customfields['name'] == $emailAddressField)
                $cfusername = $emailAddress = $customfields['value'];
            if ($customfields['name'] == $passwordField)
                $cfpassword = $password = $customfields['value'];
            if ($customfields['name'] == $usernameField)
                $username = $customfields['value'];
            if ($customfields['name'] == $userKeyField)
                $cfUserkey = $customfields['value'];
            if ($customfields['name'] == $userAPIKeyField)
                $cfUserApiKey = $customfields['value'];
        }
        # Admin only custom field
        $userkeyfieldId = getCustomfieldId($userKeyField, $params['pid']);
        $userAPIkeyfieldId = getCustomfieldId($userAPIKeyField, $params['pid']);

        # Cloudflare API
        $hostAPIKey = $params['configoption2'];
        $hostAPI = new CF_HOST_API($hostAPIKey);

        $wgs_cf_partnerapi = new wgs_cf_partnerapi($apiurl, $cfusername, $cfpassword, $cfUserApiKey);
        $website = $domain;

        $hostAPI1 = new CF_HOST_API($hostAPIKey);
        $resolve_to = 'cloudflare-resolve-to.' . $website;
        $subdomains = 'www';
        $getAddonId = Capsule::table('mod_cf_manage_service')->where('sid', $params['serviceid'])->first();
        if ($getAddonId->addonid) {
            $getPlan = Capsule::table('mod_cf_p_addons')->where('addonid', $getAddonId->addonid)->first();
            $hostingService = Capsule::table('tblhosting')->where('packageid', '!=', $params['pid'])->where('domain', $params['domain'])->first();
            $command = "GetClientsProducts";
            $adminuser = wgs_cf_partnerapi_getAdminId();
            $values["serviceid"] = $hostingService->id;
            $results = localAPI($command, $values, $adminuser);
            if ($results['result'] == 'success')
                $hostingServerIp = $results['products']['product'][0]['serverip'];
        }
        $zoneType = $params['configoption8'];
        if ($getPlan->cf_plan_name == 'Free Plan With Cloudflare DNS Setup')
            $zoneType = 'full_zone_set';
        elseif ($getPlan->cf_plan_name == 'Free Plan With CNAME Setup') {
            $zoneType = 'zone_set';
        }
        $zoneResult = $wgs_cf_partnerapi->getAllZones($website);
        if (empty($zoneResult['result']) && $zoneResult['success'] == 1) {
            $zone_add = $hostAPI1->zone_set($cfUserkey, $website, $resolve_to, $subdomains, $zoneType);

            if ($zone_add->result == 'success') {

                $planTag = $params['configoption9'];
                if ($getPlan->cf_plan) {
                    $planTag = $getPlan->cf_plan;
                }
                if ($planTag != 'Free') {
                    $plan_sub = $hostAPI1->reseller_sub_new($cfUserApiKey, $website, $planTag);
                    logModuleCall("CF Partner", "Add sub plan to Cloudflare Partner (after domain registrar hook)", array('zone' => $website, 'plan_tag' => $planTag), (array) $plan_sub);
                    if ($plan_sub->result == "success") {

                        $subCustomfiledId = Capsule::table("tblcustomfields")->where("type", "product")->where("relid", $params['pid'])->where("fieldname", 'Subscription ID')->first();

                        $command = 'UpdateClientProduct';
                        $postData = array(
                            'serviceid' => $sid,
                            'customfields' => base64_encode(serialize(array($subCustomfiledId->id => $plan_sub->response->sub_id)))
                        );
                        $adminId = Capsule::table("tbladmins")->orderBy('id', 'ASC')->first();
                        $adminUsername = $adminId->id;

                        $results = localAPI($command, $postData, $adminUsername);
                    }
                }

                logModuleCall("CF Partner", "Add zone (after domain registrar hook)", $website, (array) $zone_add);
                logActivity("zone added successfully (after domain registrar hook) zone: {$website}");
                $zoneResult = $wgs_cf_partnerapi->getAllZones($website);

                logModuleCall("CF Partner", "Get Zone detail (after domain registrar hook)", $website, $zoneResult);
                $nameservers = '';
                if (empty($zoneResult['result']) && $zoneResult['success'] == 1) {
                    logActivity("get zone detail (after domain registrar hook) zone: {$website} error: zone record not found");
                } elseif ($zoneResult['result'] == 'error') {
                    logActivity("get zone detail (after domain registrar hook) zone: {$website} error: {$zoneResult['data']['apierror']}");
                } elseif (!empty($zoneResult['result']) && $zoneResult['success'] == 1) {
                    $nameservers = $zoneResult['result'][0]['name_servers'];
                    if ($nameservers) {
                        if ($domainId) {
                            $updateNs = wgs_cf_whmcs_local_api('DomainUpdateNameservers', array('domainid' => $domainId, 'ns1' => $nameservers[0], 'ns2' => $nameservers[1]));
                            if ($updateNs['result'] == 'success') {
                                logActivity("NS successfully updated with registrar domain: {$website}");
                            } elseif ($updateNs['result'] == 'error') {
                                logActivity("Unable to update nameservers with registrar domain: {$website} error: {$updateNs['message']}");
                            }
                        } else {
                            logActivity("Unable to update nameservers with registrar domain: {$website} error: domain is not found in whmcs db");
                        }
                        if ($params['configoption10'] == 'on' || $params['configoption10'] == '1') {
                            $server_ip = (!empty($hostingServerIp)) ? $hostingServerIp : $serviceResults['products']['product'][0]['serverip'];
                            if ($server_ip) {
                                $dnsData = array(
                                    'zone_id' => $zoneResult['result'][0]['id'],
                                    'cfdnstype' => 'A',
                                    'cfdnsname' => $website,
                                    'cfdnsvalue' => $server_ip,
                                    'cfdnsttl' => '120'
                                );
                                $createDns = $wgs_cf_partnerapi->createDNSRecord($dnsData);
                                if ($createDns['result'] == 'error') {
                                    logModuleCall("CF Partner", "Set DNS record (after domain registrar hook)", $dnsData, 'Error: ' . $createDns['data']['apierror']);
                                    logActivity("Set DNS record failed $website: " . $createDns['data']['apierror']);
                                } else {
                                    logModuleCall("CF Partner", "Set DNS record (after domain registrar hook)", $dnsData, 'Dns record has been successfully added');
                                    logActivity("DNS record has been steup zone: $website");
                                }
                            } else {
                                logActivity("Unable to add the DNS record domain: {$website} error: server iP not found");
                            }
                        }
                    } else {
                        logActivity("Unable to find the cf nameservers domain: {$website}");
                    }
                }
            } elseif ($zone_add->result == 'error') {
                logModuleCall("CF Partner", "Add zone (after domain registrar hook)", $website, 'Error: ' . $zone_add->msg);
                logActivity("zone doesn't added (after domain registrar hook) zone: {$website} error: {$zone_add->msg}");
            }
        } elseif (!empty($zoneResult['result']) && $zoneResult['success'] == 1) {
            $nameservers = $zoneResult['result'][0]['name_servers'];
            if ($nameservers) {
                if ($domainId) {
                    $updateNs = wgs_cf_whmcs_local_api('DomainUpdateNameservers', array('domainid' => $domainId, 'ns1' => $nameservers[0], 'ns2' => $nameservers[1]));
                    if ($updateNs['result'] == 'success') {
                        logActivity("NS successfully updated with registrar domain: {$website}");
                    } elseif ($updateNs['result'] == 'error') {
                        logActivity("Unable to update nameservers with registrar domain: {$website} error: {$updateNs['message']}");
                    }
                } else {
                    logActivity("Unable to update nameservers with registrar domain: {$website} error: domain is not found in whmcs db");
                }
                if ($params['configoption10'] == 'on' || $params['configoption10'] == '1') {
                    $server_ip = (!empty($hostingServerIp)) ? $hostingServerIp : $serviceResults['products']['product'][0]['serverip'];
                    if ($server_ip) {
                        $dnsData = array(
                            'zone_id' => $zoneResult['result'][0]['id'],
                            'cfdnstype' => 'A',
                            'cfdnsname' => $website,
                            'cfdnsvalue' => $server_ip,
                            'cfdnsttl' => '120'
                        );
                        $createDns = $wgs_cf_partnerapi->createDNSRecord($dnsData);
                        if ($createDns['result'] == 'error') {
                            logModuleCall("CF Partner", "Set DNS record (after domain registrar hook)", $dnsData, 'Error: ' . $createDns['data']['apierror']);
                            logActivity("Set DNS record failed $website: " . $createDns['data']['apierror']);
                        } else {
                            logModuleCall("CF Partner", "Set DNS record (after domain registrar hook)", $dnsData, 'Dns record has been successfully added');
                            logActivity("DNS record has been steup zone: $website");
                        }
                    } else {
                        logActivity("Unable to add the DNS record domain: {$website} error: server iP not found");
                    }
                }
            } else {
                logActivity("Unable to find the cf nameservers domain: {$website}");
            }
        }
    }
});

function wgs_cf_whmcs_local_api($command, $data) {
    $admin = Capsule::table('tbladmins')->orderBy('id')->first();

    $adminUsername = $admin->id;
    $command = $command;
    $postData = $data;

    $results = localAPI($command, $postData, $adminUsername);
    return $results;
}

function wgs_get_serviceDomain($serviceId) {
    $getDomain = Capsule::table('tblhosting')->where('id', $serviceId)->first();
    return (array) $getDomain;
}
