<?php

use Illuminate\Database\Capsule\Manager as Capsule;

if (!defined("PHP_EOL"))
    define("PHP_EOL", "\n");
####################################################################################################################
############################################### Custom Functions ###################################################
####################################################################################################################

function __createCFPartnerCustomfields($productid) {

    $customfields = array(
        "cloudflare_domain|Cloudflare Domain" => array("type" => "text", "description" => "", "fieldoptions" => "", "required" => "on", "showorder" => "on", "adminonly" => "", "sortorder" => '0'),
        "CloudFlare Email Address" => array("type" => "text", "description" => "Required, Enter a valid Email Address. You cannot change this email address later.", "fieldoptions" => "", "required" => "", "showorder" => "", "adminonly" => "on", "sortorder" => '1'),
        "CloudFlare Password" => array("type" => "password", "description" => "Required, Enter Password", "fieldoptions" => "", "required" => "", "showorder" => "", "adminonly" => "on", "sortorder" => '2'),
        "CloudFlare Username" => array("type" => "text", "description" => "Optional, If you do not enter username then Cloudflare will auto-generate username", "fieldoptions" => "", "required" => "", "showorder" => "", "adminonly" => "on", "sortorder" => '3'),
        "Cloudflare User Key" => array("type" => "text", "description" => "Cloudflare User Key, For developer use only", "fieldoptions" => "", "required" => "", "showorder" => "", "adminonly" => "on", "sortorder" => '4'),
        "Cloudflare User API Key" => array("type" => "text", "description" => "Cloudflare User API Key, For developer use only", "fieldoptions" => "", "required" => "", "showorder" => "", "adminonly" => "on", "sortorder" => '5'),
        "Subscription ID" => array("type" => "text", "description" => "Subcription plan id", "fieldoptions" => "", "required" => "", "showorder" => "", "adminonly" => "on", "sortorder" => '6'),
    );

    foreach ($customfields as $addfieldname => $addfield) {
        $addfieldnameArr = explode('|', $addfieldname);
        $customfieldresult = Capsule::table("tblcustomfields")->where("type", "product")->where("relid", $productid)->where("fieldname", 'like', '%' . $addfieldnameArr[0] . '%')->count();
        if ($customfieldresult == 0)
            $insert_query = Capsule::table("tblcustomfields")->insert(["type" => "product", "relid" => $productid, "fieldname" => $addfieldname, "fieldtype" => $addfield["type"], "description" => $addfield["description"], "fieldoptions" => $addfield["fieldoptions"], "regexpr" => "", "adminonly" => $addfield["adminonly"], "required" => $addfield["required"], "showorder" => $addfield["showorder"], "showinvoice" => "", "sortorder" => $addfield['sortorder']]);
    }
}

function __customfieldsCFConfigurableOptions($productid) {
    $query = "SELECT concat('CustomField:', fieldname) as custfld FROM tblcustomfields WHERE type='product' and relid=" . $productid . " UNION SELECT concat('ConfigOption:', optionname) as configfld FROM tblproductconfigoptions A, tblproductconfiglinks B WHERE A.gid = B.gid AND B.pid=" . $productid;
    $result = Capsule::select($query);
    $optionsAr = array();
    foreach ($result as $key => $optionValue) {
        $optionValue = (array) $optionValue;
        if ($optionValue['custfld'])
            $optionsAr[] = $optionValue['custfld'];
        if ($optionValue['configfld'])
            $optionsAr[] = $optionValue['configfld'];
    }
    $options = implode(",", $optionsAr);
    return array('result' => 'success', 'availoptions' => count($optionsAr), 'options' => $options);
}

function __createProductAddons($resllerPlans, $pid) {
    $planArr = array();
    $planArr['Free--0.00'] = array(
        array(
            "name" => 'Free Plan With CNAME Setup',
            "description" => "<br>Make your website faster and safer with CloudFlare<br><i>By selecting this addon</i>",
            "billingcycle" => "Free Account",
            "showorder" => "1",
            "welcomeemail" => 0,
            "weight" => 1,
            "autoactivate" => "1"),
        array(
            "name" => 'Free Plan With Cloudflare DNS Setup',
            "description" => "<br>Make your website faster and safer with CloudFlare<br><i>By selecting this addon</i>",
            "billingcycle" => "Free Account",
            "showorder" => "1",
            "welcomeemail" => 0,
            "weight" => 1,
            "autoactivate" => "1"));
    if (!empty($resllerPlans) && !empty($resllerPlans->response) && $resllerPlans->result == 'success') {
        foreach ($resllerPlans->response->objs as $plan) {
            $planArr[$plan->sub_label . '--' . $plan->product_price] = array(
                array(
                    "name" => $plan->sbase_name . ' With CNAME Setup',
                    "description" => "<br>Make your website faster and safer with CloudFlare<br><i>By selecting this addon</i>",
                    "billingcycle" => "Monthly",
                    "showorder" => "1",
                    "welcomeemail" => 0,
                    "weight" => 1,
                    "autoactivate" => "1"),
                array(
                    "name" => $plan->sbase_name . ' With Cloudflare DNS Setup',
                    "description" => "<br>Make your website faster and safer with CloudFlare<br><i>By selecting this addon</i>",
                    "billingcycle" => "Monthly",
                    "showorder" => "1",
                    "welcomeemail" => 0,
                    "weight" => 1,
                    "autoactivate" => "1")
            );
        }
    }
    foreach ($planArr as $planKey => $pAddon) {
        foreach ($pAddon as $pAddonArr) {
            if (Capsule::table('tbladdons')->where('name', $pAddonArr['name'])->count() == 0) {
                $priceArr = explode('--', $planKey);
                try {
                    $addonId = Capsule::table('tbladdons')->insertGetId($pAddonArr);
                } catch (Exception $ex) {
                    logActivity("couldn't insert data in 'tbladdons' error: {$ex->getMessage()}");
                }
                if ($addonId) {
                    if (Capsule::table('mod_cf_p_addons')->where('cf_plan_name', $pAddonArr['name'])->count() == 0) {
                        try {
                            Capsule::table('mod_cf_p_addons')->insert(['addonid' => $addonId, 'cf_plan' => $priceArr[0], 'cf_plan_name' => $pAddonArr['name']]);
                        } catch (Exception $ex) {
                            logActivity("couldn't insert data in 'mod_cf_p_addons' error: {$ex->getMessage()}");
                        }
                    }
                    try {
                        Capsule::table('tblpricing')->insert(['type' => 'addon', 'relid' => $addonId, 'currency' => '1', 'monthly' => $priceArr[1]]);
                    } catch (Exception $ex) {
                        logActivity("couldn't insert data in 'tblpricing' error: {$ex->getMessage()}");
                    }
                }
            }
        }
    }
}

function __createDbTable() {
    try {
        if (!Capsule::Schema()->hasTable('mod_cfsettings')) {
            Capsule::schema()->create(
                    'mod_cfsettings', function ($table) {
                $table->increments('id');
                $table->string('setting');
                $table->string('value');
            }
            );
        }
    } catch (\Exception $e) {
        logActivity("Unable to create mod_cfsettings: {$e->getMessage()}");
    }
    try {
        if (!Capsule::Schema()->hasTable('mod_cf_p_addons')) {
            Capsule::schema()->create(
                    'mod_cf_p_addons', function ($table) {
                $table->increments('id');
                $table->integer('addonid');
                $table->string('cf_plan');
                $table->string('cf_plan_name');
            }
            );
        }
    } catch (\Exception $e) {
        logActivity("Unable to create mod_cf_p_addons: {$e->getMessage()}");
    }
    try {
        if (!Capsule::Schema()->hasTable('mod_cf_manage_service')) {
            Capsule::schema()->create(
                    'mod_cf_manage_service', function ($table) {
                $table->increments('id');
                $table->integer('sid');
                $table->integer('addonid');
            }
            );
        }
    } catch (\Exception $e) {
        logActivity("Unable to create mod_cf_manage_service: {$e->getMessage()}");
    }
    try {
        if (!Capsule::Schema()->hasTable('mod_cf_zone')) {
            Capsule::schema()->create(
                    'mod_cf_zone', function ($table) {
                $table->increments('id');
                $table->integer('uid');
                $table->string('email');
                $table->string('password');
                $table->string('username');
            });
        }
    } catch (\Exception $e) {
        logActivity("Unable to create mod_cf_zone: {$e->getMessage()}");
    }

    try {
        if (Capsule::Schema()->hasColumn('mod_cfsettings', 'setting')) {
            $tables = Capsule::statement('ALTER TABLE mod_cfsettings MODIFY setting  VARCHAR(50)');
        }
    } catch (Exception $ex) {
        logActivity("Unable to create mod_cfsettings: {$ex->getMessage()}");
    }
}

function wgs_cf_partnerapi_getAdminId() {
    $Query = Capsule::table("tbladmins")->limit(1)->get();
    $Id = $Query[0]->id;
    return $Id;
}

function getCustomfieldId($fieldname, $productid) {
    $result = Capsule::table("tblcustomfields")->where("fieldname", $fieldname)->where("type", "product")->where("relid", $productid)->get();
    $data = $result[0]->id;
    return $data;
}

function wgs_cf_generateRandomString($length = 10) {
    $characters = 'abcdefghijklmnopqrstuvwxyz1234567890';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

function wgs_cf_getProductgroupName($gName) {
    $result = Capsule::table('tblproductgroups')->where('name', $gName)->first();
    return $result->id;
}

function wgs_cf_create_productGroupsIdArr($params) {
    $groupsArr = explode(PHP_EOL, $params['configoption12']);
    $gIdArr = array();
    foreach ($groupsArr as $group) {
        if ($group)
            $gIdArr[] = wgs_cf_getProductgroupName(trim($group));
    }
    return $gIdArr;
}

function wgs_getProductAddonId($name) {
    $result = Capsule::table('tbladdons')->where('name', $name)->first();
    return $result->id;
}

####################################################################################################################
############################################### Check Partner License ##############################################
####################################################################################################################

function wgs_cf_partnerapi_checkLicense($licensekey, $localkey = "") {
    $whmcsurl = "http://whmcsglobalservices.com/members/"; #enter your own whmcs url here
    $licensing_secret_key = "0987askjjlskdj"; #you can enter your own secret key here
    $check_token = time() . md5(mt_rand(1000000000, 1e+010) . $licensekey);
    $checkdate = date("Ymd");
    $usersip = isset($_SERVER['SERVER_ADDR']) ? $_SERVER['SERVER_ADDR'] : $_SERVER['LOCAL_ADDR'];
    $localkeydays = 5;
    $allowcheckfaildays = 3;
    $localkeyvalid = false;
    // for local key start
    $lkey = Capsule::table('tblconfiguration')->where('setting', 'wgs_cf_partnerapi_localkey')->get(); //add for local key
    if ($lkey) {
        $localkey = $lkey[0]->value;
    }
    // for local key end
    if ($localkey) {
        $localkey = str_replace("\n", "", $localkey);
        $localdata = substr($localkey, 0, strlen($localkey) - 32);
        $md5hash = substr($localkey, strlen($localkey) - 32);
        if ($md5hash == md5($localdata . $licensing_secret_key)) {
            $localdata = strrev($localdata);
            $md5hash = substr($localdata, 0, 32);
            $localdata = substr($localdata, 32);
            $localdata = base64_decode($localdata);
            $localkeyresults = unserialize($localdata);
            $originalcheckdate = $localkeyresults['checkdate'];
            if ($md5hash == md5($originalcheckdate . $licensing_secret_key)) {
                $localexpiry = date("Ymd", mktime(0, 0, 0, date("m"), date("d") - $localkeydays, date("Y")));
                if ($localexpiry < $originalcheckdate) {
                    $localkeyvalid = true;
                    $results = $localkeyresults;
                    $validdomains = explode(",", $results['validdomain']);
                    if (!in_array($_SERVER['SERVER_NAME'], $validdomains)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    $validips = explode(",", $results['validip']);
                    if (!in_array($usersip, $validips)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    if ($results['validdirectory'] != dirname(__FILE__)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                }
            }
        }
    }
    if (!$localkeyvalid) {
        $postfields['licensekey'] = $licensekey;
        $postfields['domain'] = $_SERVER['SERVER_NAME'];
        $postfields['ip'] = $usersip;
        $postfields['dir'] = dirname(__FILE__);
        if ($check_token) {
            $postfields['check_token'] = $check_token;
        }
        if (function_exists("curl_exec")) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $whmcsurl . "modules/servers/licensing/verify.php");
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $data = curl_exec($ch);
            curl_close($ch);
        } else {
            $fp = fsockopen($whmcsurl, 80, $errno, $errstr, 5);
            if ($fp) {
                $querystring = "";
                foreach ($postfields as $k => $v) {
                    $querystring .= "{$k}=" . urlencode($v) . "&";
                }
                $header = "POST " . $whmcsurl . "modules/servers/licensing/verify.php HTTP/1.0\r\n";
                $header .= "Host: " . $whmcsurl . "\r\n";
                $header .= "Content-type: application/x-www-form-urlencoded\r\n";
                $header .= "Content-length: " . @strlen(@$querystring) . "\r\n";
                $header .= "Connection: close\r\n\r\n";
                $header .= $querystring;
                $data = "";
                @stream_set_timeout(@$fp, 20);
                @fputs(@$fp, @$header);
                $status = @socket_get_status(@$fp);
                while (!feof(@$fp) && $status) {
                    $data .= @fgets(@$fp, 1024);
                    $status = @socket_get_status(@$fp);
                }
                @fclose(@$fp);
            }
        }
        if (!$data) {
            $localexpiry = date("Ymd", mktime(0, 0, 0, date("m"), date("d") - ( $localkeydays + $allowcheckfaildays ), date("Y")));
            if ($localexpiry < $originalcheckdate) {
                $results = $localkeyresults;
            } else {
                $results['status'] = "Invalid";
                $results['description'] = "Remote Check Failed";
                return $results;
            }
        }
        preg_match_all("/<(.*?)>([^<]+)<\\/\\1>/i", $data, $matches);
        $results = array();
        foreach ($matches[1] as $k => $v) {
            $results[$v] = $matches[2][$k];
        }
        if ($results['md5hash'] && $results['md5hash'] != md5($licensing_secret_key . $check_token)) {
            $results['status'] = "Invalid";
            $results['description'] = "MD5 Checksum Verification Failed";
            return $results;
        }
        if ($results['status'] == "Active") {
            $results['checkdate'] = $checkdate;
            $data_encoded = serialize($results);
            $data_encoded = base64_encode($data_encoded);
            $data_encoded = md5($checkdate . $licensing_secret_key) . $data_encoded;
            $data_encoded = strrev($data_encoded);
            $data_encoded = $data_encoded . md5($data_encoded . $licensing_secret_key);
            $data_encoded = wordwrap($data_encoded, 80, "\n", true);
            $results['localkey'] = $data_encoded;
            // for local key start
            if (!Capsule::table('tblconfiguration')->where('setting', 'wgs_cf_partnerapi_localkey')->get()) {
                Capsule::table('tblconfiguration')->insert(
                        [
                            'setting' => 'wgs_cf_partnerapi_localkey',
                            'value' => $results['localkey']
                        ]
                );
            } else {
                Capsule::table('tblconfiguration')
                        ->where('setting', 'wgs_cf_partnerapi_localkey')
                        ->update(
                                [
                                    'value' => $results['localkey']
                                ]
                );
            }
            // for local key end
        }
        $results['remotecheck'] = true;
    }

    unset($postfields);
    unset($data);
    unset($matches);
    unset($whmcsurl);
    unset($licensing_secret_key);
    unset($checkdate);
    unset($usersip);
    unset($localkeydays);
    unset($allowcheckfaildays);
    unset($md5hash);
    return $results;
}

?>
