<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  WGS CF Partner API WHMCS Module By whmcsglobalservices.com
 *  Copyright whmcsglobalservices, All Rights Reserved
 *  
 *  Release: 15 July, 2015
 *  Version: 4.1.2
 *  WHMCS Version: v6,v7
 *  Update Date: 09 February, 2016
 * 
 *  By WHMCSGLOBALSERVICES    https://whmcsglobalservices.com
 *  Contact                   info@whmcsglobalservices.com
 *  
 *  @owner <whmcsglobalservices.com>
 *  @author <WHMCSGLOBALSERVICES>
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

use Illuminate\Database\Capsule\Manager as Capsule;

class wgs_cf_partnerapi {

    private $apiurl;
    private $cfusername;
    private $cfpassword;
    private $cfapikey;
    private $zoneidentifier;
    public $salt;

    public function __construct() {
        $params = func_get_args();

        $this->apiurl = $params[0];
        $this->cfusername = $params[1];
        $this->cfpassword = $params[2];
        $this->cfapikey = $params[3];
        $this->salt = "cloudflare sensitve(data) encrypt/decrypt";
    }

    public function setZoneIdentifier($zid) {
        $this->zoneidentifier = $zid;
    }

    /*
     * * * * * * * * * * * * * * * * * * * *
     * Zone
     * * * * * * * * * * * * * * * * * * * *
     */

    public function getAllZones($zone = NULL) {
        $url = $this->apiurl . "zones?name=" . $zone;
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey, "per_page" => "50");
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function createZone($zone) {
        $url = $this->apiurl . "zones";
        $action = "post";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("name" => $zone);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function getZoneDetails() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier;
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function pauseZone() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier;
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("paused" => true);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function getUniversalSettinbgs() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . '/ssl/universal/settings';
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey, "per_page" => "50");
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function resumeZone($id) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier;
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("paused" => false);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function deleteZone() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier;
        $action = "delete";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function purgeAllFiles() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/purge_cache";
        $action = "delete";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $data = array("purge_everything" => true);
        $result = $this->doRequest($url, $action, $extra, json_encode($data));
        return $result;
    }

    public function wgsCfGetDashboard($time) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/analytics/dashboard?since=" . $time;
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function purgeIndividualFiles($files) { # $files: should be of array type
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/purge_cache";
        $action = "delete";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $data = array("files" => $files);
        $result = $this->doRequest($url, $action, $extra, json_encode($data));
        return $result;
    }

    public function wgsCf_formatSizeUnits($bytes) {
        if ($bytes >= 1000000000000) {
            $bytes = number_format($bytes / 1000000000000, 2) . ' TB';
        } else if ($bytes >= 1000000000) {
            $bytes = number_format($bytes / 1000000000, 2) . ' GB';
        } elseif ($bytes >= 1000000) {
            $bytes = number_format($bytes / 1000000, 2) . ' MB';
        } elseif ($bytes >= 1000) {
            $bytes = number_format($bytes / 1000, 2) . ' KB';
        } elseif ($bytes > 1) {
            $bytes = $bytes . ' bytes';
        } elseif ($bytes == 1) {
            $bytes = $bytes . ' byte';
        } else {
            $bytes = '0';
        }

        return $bytes;
    }

    /*
     * * * * * * * * * * * * * * * * * * *
     * * * * Zone Plans for a zone
     * * * * * * * * * * * * * * * * * * *
     */

    public function zonePlans() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/available_plans";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function zonePlanDetail($zoneplan) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/available_plans" . "/" . $zoneplan;
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    /*
     * * * * * * * * * * * * * * * * * * *
     * * * * Zone Settings for a zone
     * * * * * * * * * * * * * * * * * * *
     */

    # GET

    public function getAllZoneSettings() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getAdvancedDdosSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/advanced_ddos";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getAlwaysOnlineSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/always_online";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getBrowserCacheTTLSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/browser_cache_ttl";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getBrowserCheckSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/browser_check";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getCacheLevelSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/cache_level";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getChallengeTTLSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/challenge_ttl";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getDevelopmentModeSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/development_mode";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getEmailObfuscationSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/email_obfuscation";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getHotlinkProtectionSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/hotlink_protection";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getIPGeolocationSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/ip_geolocation";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getIPv6Setting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/ipv6";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getMinifySetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/minify";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getMobileRedirectSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/mobile_redirect";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getMirageSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/mirage";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getPolishSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/polish";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getRocketLoaderSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/rocket_loader";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getSecurityLevelSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/security_level";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getServerSideExcludeSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/server_side_exclude";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getSSLSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/ssl";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getWebApplicationFirewallSetting() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/waf";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function getIpFirewallList() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/firewall/access_rules/rules?per_page=100";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    # PATCH

    public function changeZonePlan($plan) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier;
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("plan" => $plan);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeAlwaysOnlineSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/always_online";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeBrowserCacheTTLSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/browser_cache_ttl";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => (int) $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeBrowserCheckSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/browser_check";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeCacheLevelSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/cache_level";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeChallengeTTLSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/challenge_ttl";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeDevelopmentModeSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/development_mode";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeEmailObfuscationSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/email_obfuscation";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeServerSideExclude($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/server_side_exclude";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeSSLSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/ssl";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeHotlinkProtectionSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/hotlink_protection";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeIPGeolocationSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/ip_geolocation";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeMaxUploadSize($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/max_upload";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeIPv6Setting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/ipv6";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changePseudoIPv4($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/pseudo_ipv4";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeMinifySetting($css, $html, $js) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/minify";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => array("css" => $css, "html" => $html, "js" => $js));
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeMobileRedirectSetting($mode, $subdomain, $stripuri) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/mobile_redirect";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => array("status" => $mode, "mobile_subdomain" => $subdomain, "strip_uri" => $stripuri));
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeMirageSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/mirage";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changePolishSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/polish";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeRocketLoaderSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/rocket_loader";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeSecurityHeaderSetting($enabled, $maxage, $includesubdomains, $preload) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/security_header";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => array("strict_transport_security" => array("enabled" => $enabled, "max_age" => $maxage, "include_subdomains" => $includesubdomains, "preload" => $preload)));
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function wgsCfEnableDnsSec($status) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/dnssec";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("status" => $status);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function wgsCfGetDnsSec() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/dnssec";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function wgsCfManageCnameFlattern($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/cname_flattening";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function wgsCfGetCnameFlattern() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/cname_flattening";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function changeSecurityLevelSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/security_level";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeServerSideExcludeSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/server_side_exclude";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeTLSclientAuthSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/server_side_exclude";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeWebApplicationFirewallSetting($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/waf";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeAdvancedDdosProtection($value) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/settings/advanced_ddos";
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("value" => $value);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeIpFirewallNotes($id, $notes) {
        $url = $this->apiurl . "user/firewall/access_rules/rules/" . $id;
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("notes" => $notes);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function changeIpFirewalMode($id, $mode) {
        $url = $this->apiurl . "user/firewall/access_rules/rules/" . $id;
        $action = "patch";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("mode" => $mode);
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function deleteFirewallIp($id) {
        $url = $this->apiurl . "user/firewall/access_rules/rules/" . $id;
        $action = "delete";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function addFirewallIp($ip, $mode, $notes) {
        $url = $this->apiurl . "user/firewall/access_rules/rules";
        $action = "post";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $post = array("allowed_modes" => array("block", "challenge", "whitelist"),
            "configuration" => array("value" => $ip, "target" => "ip"),
            "group" => array("id" => "owner"),
            "mode" => $mode, "notes" => $notes, "package_id" => "", "triggered_count" => 0
        );
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    /*
     * DNS Records for Zone
     */

    public function listDNSRecords() {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/dns_records?per_page=100";
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function dnsRecordDetails($zoneidentifier) {
        $url = $this->apiurl . "zones/" . $this->zoneidentifier . "/dns_records/" . $zoneidentifier;
        $action = "get";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    public function createDNSRecord($dnsdata) {
        $url = $this->apiurl . "zones/" . $dnsdata["zone_id"] . "/dns_records";
        $action = "post";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $type = $dnsdata["cfdnstype"];
        $dnsdata["cfdnsttl"] = intval($dnsdata["cfdnsttl"]);

        if ($type == "A" || $type == "AAAA" || $type == "CNAME" || $type == "SPF" || $type == "TXT" || $type == "NS") {
            $post = array("type" => $dnsdata["cfdnstype"], "name" => $dnsdata["cfdnsname"], "content" => $dnsdata["cfdnsvalue"], "ttl" => $dnsdata["cfdnsttl"]);
        }
        if ($type == "MX") {
            $dnsdata["cfmxpriority"] = intval($dnsdata["cfmxpriority"]);
            $post = array("type" => $dnsdata["cfdnstype"], "name" => $dnsdata["cfdnsname"], "content" => $dnsdata["cfdnsvalue"], "priority" => $dnsdata["cfmxpriority"], "ttl" => $dnsdata["cfdnsttl"]);
        }
        if ($type == "A" || $type == "AAAA" || $type == "CNAME") {
            switch ($dnsdata["proxied"]) {
                case "false":
                    $post = array_merge($post, array('proxied' => false));
                    break;
                case "true":
                    $post = array_merge($post, array('proxied' => true));
                    break;
            }
        }
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function editDNSRecord($dnsdata) {
        $url = $this->apiurl . "zones/" . $dnsdata["zone_id"] . "/dns_records/" . $dnsdata["dnsrecordid"];
        $action = "put";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $type = $dnsdata["cfdnstype"];

        switch ($dnsdata["proxiable"]) {
            case "false":
                $dnsdata["proxiable"] = false;
                break;
            case "true":
                $dnsdata["proxiable"] = true;
                break;
        }

        switch ($dnsdata["proxied"]) {
            case "false":
                $dnsdata["proxied"] = false;
                break;
            case "true":
                $dnsdata["proxied"] = true;
                break;
        }

        switch ($dnsdata["locked"]) {
            case "false":
                $dnsdata["locked"] = false;
                break;
            case "true":
                $dnsdata["locked"] = true;
                break;
        }

        if ($type == "A" || $type == "AAAA" || $type == "CNAME" || $type == "SPF" || $type == "TXT" || $type == "NS") {
            $post = array(
                "id" => $dnsdata["dnsrecordid"],
                "type" => $dnsdata["cfdnstype"],
                "name" => $dnsdata["cfdnsname"],
                "content" => $dnsdata["cfdnsvalue"],
                "ttl" => intval($dnsdata["cfdnsttl"]),
                "proxiable" => $dnsdata["proxiable"],
                "proxied" => $dnsdata["proxied"],
                "locked" => $dnsdata["locked"],
                "zone_id" => $dnsdata["zone_id"],
                "zone_name" => $dnsdata["zone_name"]
            );
        }
        if ($type == "MX") {
            $post = array(
                "id" => $dnsdata["dnsrecordid"],
                "type" => $dnsdata["cfdnstype"],
                "name" => $dnsdata["cfdnsname"],
                "content" => $dnsdata["cfdnsvalue"],
                "priority" => $dnsdata["cfmxpriority"],
                "ttl" => intval($dnsdata["cfdnsttl"]),
                "proxiable" => $dnsdata["proxiable"],
                "proxied" => $dnsdata["proxied"],
                "locked" => $dnsdata["locked"],
                "zone_id" => $dnsdata["zone_id"],
                "zone_name" => $dnsdata["zone_name"]
            );
        }
        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function enableDisableDnsRecord($dnsdata) {
        $url = $this->apiurl . "zones/" . $dnsdata["zone_id"] . "/dns_records/" . $dnsdata["dnsrecordid"];
        $action = "put";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $type = $dnsdata["cfdnstype"];

        switch ($dnsdata["proxiable"]) {
            case "false":
                $dnsdata["proxiable"] = false;
                break;
            case "true":
                $dnsdata["proxiable"] = true;
                break;
        }

        switch ($dnsdata["proxied"]) {
            case "false":
                $dnsdata["proxied"] = false;
                break;
            case "true":
                $dnsdata["proxied"] = true;
                break;
        }

        switch ($dnsdata["locked"]) {
            case "false":
                $dnsdata["locked"] = false;
                break;
            case "true":
                $dnsdata["locked"] = true;
                break;
        }

        if ($type == "A" || $type == "AAAA" || $type == "CNAME" || $type == "SPF" || $type == "TXT" || $type == "NS") {
            $post = array(
                "id" => $dnsdata["dnsrecordid"],
                "type" => $dnsdata["cfdnstype"],
                "name" => $dnsdata["cfdnsname"],
                "content" => $dnsdata["cfdnsvalue"],
                "ttl" => intval($dnsdata["cfdnsttl"]),
                "proxiable" => $dnsdata["proxiable"],
                "proxied" => $dnsdata["proxied"],
                "locked" => $dnsdata["locked"],
                "zone_id" => $dnsdata["zone_id"],
                "zone_name" => $dnsdata["zone_name"]
            );
        }
        if ($type == "MX") {
            $post = array(
                "id" => $dnsdata["dnsrecordid"],
                "type" => $dnsdata["cfdnstype"],
                "name" => $dnsdata["cfdnsname"],
                "content" => $dnsdata["cfdnsvalue"],
                "priority" => $dnsdata["cfmxpriority"],
                "ttl" => intval($dnsdata["cfdnsttl"]),
                "proxiable" => $dnsdata["proxiable"],
                "proxied" => $dnsdata["proxied"],
                "locked" => $dnsdata["locked"],
                "zone_id" => $dnsdata["zone_id"],
                "zone_name" => $dnsdata["zone_name"]
            );
        }

        $result = $this->doRequest($url, $action, $extra, json_encode($post));
        return $result;
    }

    public function deleteDNSRecord($dnsdata) {
        $url = $this->apiurl . "zones/" . $dnsdata["zone_id"] . "/dns_records/" . $dnsdata["dnsrecordid"];
        $action = "delete";
        $extra = array("cfusername" => $this->cfusername, "cfapikey" => $this->cfapikey);
        $result = $this->doRequest($url, $action, $extra);
        return $result;
    }

    /*
     *  Default custom Functions
     */

    public function browserCacheTTLSettingValues() {
        $ttl = array();
        $plan = $this->getZoneDetails();
        $legacyid = $plan["result"]["plan"]["legacy_id"];

        if ($legacyid == "enterprise") {
            $ttl["30"] = "30 seconds";
            $ttl["60"] = "1 minute";
            $ttl["300"] = "5 minutes";
            $ttl["1200"] = "20 minutes";
        }

        if ($legacyid == "business" || $legacyid == "pro" || $legacyid == "enterprise") {
            $ttl["1800"] = "30 minutes";
        }

        $ttl["7200"] = "2 hours";
        $ttl["10800"] = "3 hours";
        $ttl["14400"] = "4 hours";
        $ttl["18000"] = "5 hours";
        $ttl["28800"] = "8 hours";
        $ttl["43200"] = "12 hours";
        $ttl["57600"] = "16 hours";
        $ttl["72000"] = "20 hours";
        $ttl["86400"] = "1 day";
        $ttl["172800"] = "2 days";
        $ttl["259200"] = "3 days";
        $ttl["345600"] = "4 days";
        $ttl["432000"] = "5 days";
        $ttl["691200"] = "8 days";
        $ttl["1382400"] = "16 days";
        $ttl["2073600"] = "24 days";
        $ttl["2678400"] = "1 month";
        $ttl["5356800"] = "2 months";
        $ttl["16070400"] = "6 months";
        $ttl["31536000"] = "1 year";

        return $ttl;
    }

    public function uploadFileSizes() {
        $sizes = array();
        $plan = $this->getZoneDetails();
        $legacyid = $plan["result"]["plan"]["legacy_id"];

        if ($legacyid == "enterprise") {
            $sizes["500"] = "500 MB";
            $sizes["475"] = "475 MB";
            $sizes["450"] = "450 MB";
            $sizes["425"] = "425 MB";
            $sizes["400"] = "400 MB";
            $sizes["375"] = "375 MB";
            $sizes["350"] = "350 MB";
            $sizes["325"] = "325 MB";
            $sizes["300"] = "300 MB";
            $sizes["275"] = "275 MB";
            $sizes["250"] = "250 MB";
            $sizes["225"] = "225 MB";
        }
        if ($legacyid == "business" && $legacyid == "enterprise") {
            $sizes["200"] = "200 MB";
            $sizes["175"] = "175 MB";
            $sizes["150"] = "150 MB";
            $sizes["125"] = "125 MB";
        }
        $sizes["100"] = "100 MB";
        return $sizes;
    }

    function websiteSSLvalues($language) {
        $ssl = array();
        $ssl["full"] = $language['cf_crypto_ssl_full'];
        $ssl["off"] = $language['cf_crypto_ssl_off'];
        $ssl["flexible"] = $language['cf_crypto_ssl_flexible'];
        $ssl["strict"] = $language['cf_crypto_ssl_strict'];
        return $ssl;
    }

    public function hstsmaxageheader($language) {
        $maxage = array();
        $maxage["0"] = $language['cf_crypto_max_age_header_disable'];
        $maxage["2678400"] = $language['cf_crypto_max_age_header_1_mnth'];
        $maxage["5356800"] = $language['cf_crypto_max_age_header_2_mnths'];
        $maxage["8035200"] = $language['cf_crypto_max_age_header_3_mnths'];
        $maxage["10713600"] = $language['cf_crypto_max_age_header_4_mnths'];
        $maxage["13392000"] = $language['cf_crypto_max_age_header_5_mnths'];
        $maxage["16070400"] = $language['cf_crypto_max_age_header_6_mnths'];
        return $maxage;
    }

    public function IPv4SettingValues($language) {
        $ipv4 = array();
        $ipv4["off"] = $language['cf_dns_pseudo_ipv4_off'];
        $ipv4["add_header"] = $language['cf_dns_pseudo_ipv4_add_header'];
        $ipv4["overwrite_header"] = $language['cf_dns_pseudo_ipv4_ow_header'];
        return $ipv4;
    }

    public function dnsrecordtypes() {
        $dnsrecordtypes = array();
        $dnsrecordtypes["A"] = "A";
        $dnsrecordtypes["AAAA"] = "AAAA";
        $dnsrecordtypes["CNAME"] = "CNAME";
        $dnsrecordtypes["MX"] = "MX";
        # $dnsrecordtypes["LOC"] = "LOC"; Implement Later on; currently API is not available 
        # $dnsrecordtypes["SRV"] = "SRV"; Implement Later on; currently API is not available
        $dnsrecordtypes["SPF"] = "SPF";
        $dnsrecordtypes["TXT"] = "TXT";
        $dnsrecordtypes["NS"] = "NS";
        return $dnsrecordtypes;
    }

    public function dnsttlvalues($language) {
        $ttl = array();
        $ttl["1"] = $language['cf_dns_automatic'];
        $ttl["120"] = $language['cf_dns_2_mnts'];
        $ttl["300"] = $language['cf_dns_5_mnts'];
        $ttl["600"] = $language['cf_dns_10_mnts'];
        $ttl["900"] = $language['cf_dns_15_mnts'];
        $ttl["1800"] = $language['cf_dns_30_mnts'];
        $ttl["3600"] = $language['cf_dns_1_hr'];
        $ttl["7200"] = $language['cf_dns_2_hrs'];
        $ttl["18000"] = $language['cf_dns_5_hr'];
        $ttl["43200"] = $language['cf_dns_12_hr'];
        $ttl["86400"] = $language['cf_dns_1_day'];
        return $ttl;
    }

    public function securitylevelvalues($language) {
        $securityvalues = array();
        $securityvalues["essentially_off"] = $language['cf_firewall_security_level_essentially_off'];
        $securityvalues["low"] = $language['cf_firewall_security_level_low'];
        $securityvalues["medium"] = $language['cf_firewall_security_level_medium'];
        $securityvalues["high"] = $language['cf_firewall_security_level_high'];
        $securityvalues["under_attack"] = $language['cf_firewall_security_level_under_attack'];
        return $securityvalues;
    }

    public function challengettlvalues($language) {
        $ttl = array();
        $ttl["300"] = $language['cf_firewall_challenge_time_5_mnts'];
        $ttl["900"] = $language['cf_firewall_challenge_time_15_mnts'];
        $ttl["1800"] = $language['cf_firewall_challenge_time_30_mnts'];
        $ttl["2700"] = $language['cf_firewall_challenge_time_45_mnts'];
        $ttl["3600"] = $language['cf_firewall_challenge_time_1_hr'];
        $ttl["7200"] = $language['cf_firewall_challenge_time_2_hrs'];
        $ttl["10800"] = $language['cf_firewall_challenge_time_3_hrs'];
        $ttl["14400"] = $language['cf_firewall_challenge_time_4_hrs'];
        $ttl["28800"] = $language['cf_firewall_challenge_time_8_hrs'];
        $ttl["57600"] = $language['cf_firewall_challenge_time_16_hrs'];
        $ttl["86400"] = $language['cf_firewall_challenge_time_1_day'];
        $ttl["604800"] = $language['cf_firewall_challenge_time_1_week'];
        $ttl["2678400"] = $language['cf_firewall_challenge_time_1_mnth'];
        $ttl["31536000"] = $language['cf_firewall_challenge_time_1_year'];
        return $ttl;
    }

    /*
     * Encrypt Decrypt Data
     */

    public function cfencrypt($string) {
        $ivlen = openssl_cipher_iv_length($cipher = "AES-128-CBC");
        $iv = openssl_random_pseudo_bytes($ivlen);
        $ciphertext_raw = openssl_encrypt($string, $cipher, $key, $options = OPENSSL_RAW_DATA, $iv);
        $hmac = hash_hmac('sha256', $ciphertext_raw, $key, $as_binary = true);
        $encrypted = base64_encode($iv . $hmac . $ciphertext_raw);
        return $encrypted;
    }

    public function cfdecrypt($encrypted) {
        $data = base64_decode($encrypted);
        $ivlen = openssl_cipher_iv_length($cipher = "AES-128-CBC");
        $iv = substr($data, 0, $ivlen);
        $hmac = substr($data, $ivlen, $sha2len = 32);
        $ciphertext_raw = substr($data, $ivlen + $sha2len);
        $decrypted = openssl_decrypt($ciphertext_raw, $cipher, $key, $options = OPENSSL_RAW_DATA, $iv);
        $calcmac = hash_hmac('sha256', $ciphertext_raw, $key, $as_binary = true);
        if (hash_equals($hmac, $calcmac)) {//PHP 5.6+ timing attack safe comparison
            return $decrypted;
        }
    }

    /*
     * * * * * * * * * * * * * * * 
     * From Local DB
     * * * * * * * * * * * * * * *
     */

    public function getDomainDetails($serviceid, $columns) {
        $r = Capsule::select("SELECT " . implode(",", $columns) . " FROM `mod_cfdomain` WHERE `serviceid`=" . $serviceid);
        return $r;
    }

    public function serviceStatus($serviceid) {

        $query = Capsule::table('tblhosting')->select('domainstatus')->where('id', $serviceid)->get();
        return $query[0]->domainstatus;
    }

    public function adminId() {
        $data = Capsule::table('tbladmins')->select('id')->limit(1)->get();
        return $data[0]->id;
    }

    /*
     * Change Plan Functions
     */

    public function serviceDetails($serviceid) {

        $result = Capsule::table('tblhosting')->select('amount', 'billingcycle', 'nextduedate')->where('id', $serviceid)->get();
        $data = (array) $result[0];
        return $data;
    }

    public function doRequest($url, $action, $extra = NULL, $post = NULL) {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);

        if (count($extra) > 0) {

            $cfusername = $extra["cfusername"];
            $cfapikey = $extra["cfapikey"];

            $headers = array(
                "Content-Type: application/json",
                "X-Auth-Email: " . $cfusername,
                "X-Auth-Key: " . $cfapikey
            );
        }

        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        if (strtolower($action) == "get") {
            curl_setopt($ch, CURLOPT_HTTPGET, 1);
        }

        if (strtolower($action) == "post") {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        }

        if (strtolower($action) == "put") {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        }

        if (strtolower($action) == "patch") {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        }

        if (strtolower($action) == "delete") {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        }

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        $json = curl_exec($ch);

        $info = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        $error = curl_error($ch);

        $result = json_decode($json, true);

        if (curl_getinfo($ch, CURLINFO_HTTP_CODE) == 200 && empty($error) && !empty($result)) {
            return $result;
        } else {
            if (empty($result['success'])) {
                $apierror = $result['errors'][0]['message'];
                $cferrorcode = $result['errors'][0]['code'];
            }
            return array("result" => "error", "data" => array("info" => $info, "error" => $error, "cferrorcode" => $cferrorcode, "apierror" => $apierror));
        }
    }

}

?>
