<?php

class Cloudflareclientapi {

    private $apiurl;
    private $email;
    private $token;
    private $domain;

    public function __construct() {
        $params = func_get_args();

        $this->apiurl = "https://www.cloudflare.com/api_json.html";
        $this->email = $params[0];
        $this->token = $params[1];
        $this->domain = $params[2];
    }

    public function getStats($interval) {
        $action = "post";
        $post = array("a" => "stats", "interval" => $interval);
        $result = $this->doRequest($action, $post);
        return $result;
    }

    /*
     * 
     * Custom Functions
     * 
     */

    public function statIntervals($plan) {
        $statintervals = array(
            "20" => "Past 30 days",
            "30" => "Past 7 days",
            "40" => "Past day",
        );
        if ($plan != "free") { # For enterprise, business, pro
            $statintervals["100"] = "24 hours ago";
            $statintervals["110"] = "12 hours ago";
            $statintervals["120"] = "6 hours ago";
        }
        return $statintervals;
    }

    public function doRequest($action, $custompost = NULL) {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->apiurl);

        $commonpost = array("tkn" => $this->token, "email" => $this->email, "z" => $this->domain);
        $post = array_merge($commonpost, $custompost);

        if (strtolower($action) == "get") {
            curl_setopt($ch, CURLOPT_HTTPGET, 1);
        }

        if (strtolower($action) == "post") {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        }

        if (strtolower($action) == "put") {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        }

        if (strtolower($action) == "patch") {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        }

        if (strtolower($action) == "delete") {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        }
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        $json = curl_exec($ch);

        $info = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        $error = curl_error($ch);

        $result = json_decode($json, true);

        if (curl_getinfo($ch, CURLINFO_HTTP_CODE) == 200 && empty($error) && !empty($result) && $result['result'] != "error") {
            return $result;
        } else {
            $cferrorcode = $result["err_code"];
            $apierror = $result["msg"];
            return array("result" => "error", "data" => array("info" => $info, "error" => $error, "cferrorcode" => $cferrorcode, "apierror" => $apierror));
        }
    }

}

?>