<?php

if (isset($_POST["dnsaction"])) {
    switch ($_POST["dnsaction"]) {
        case "dnssec":
            $result = $wgs_cf_partnerapi->wgsCfEnableDnsSec($_POST['dnssec']);
            if ($result['result'] == "error") {
                $error = 'Error(' . $result["data"]["info"] . '): ';
                if (!empty($result["data"]["error"])) {
                    $error .= $result["data"]["error"] . ". ";
                }
                if (!empty($result["data"]["apierror"])) {
                    $error .= ' cfError(' . $result["data"]["cferrorcode"] . '):' . $result["data"]["apierror"];
                }
                $status = ['status' => 'error', 'msg' => $error];
            }
            if ($result["success"]) {
                $msg = $_POST['dnssec'] == 'active' ? $language['cf_dns_dnssec_enabled_status'] : $language['cf_dns_dnssec_disabled_status'];
                $status = ['status' => 'success', 'msg' => $msg, 'result' => $result["result"]];
            }
            print json_encode($status);
            exit();
            break;
        case "dnsseclist":
            $result = $wgs_cf_partnerapi->wgsCfGetDnsSec();
            if ($result['result'] == "error") {
                $error = 'Error(' . $result["data"]["info"] . '): ';
                if (!empty($result["data"]["error"])) {
                    $error .= $result["data"]["error"] . ". ";
                }
                if (!empty($result["data"]["apierror"])) {
                    $error .= ' cfError(' . $result["data"]["cferrorcode"] . '):' . $result["data"]["apierror"];
                }
                $status = ['status' => 'error', 'msg' => $error];
            }
            if ($result["success"]) {
                $status = ['status' => 'success', 'msg' => $msg, 'result' => $result["result"]];
            }
            print json_encode($status);
            exit();
            break;
        case "cnameflattern":
            $result = $wgs_cf_partnerapi->wgsCfManageCnameFlattern($_POST['cname_flattener']);
            if ($result['result'] == "error") {
                $error = 'Error(' . $result["data"]["info"] . '): ';
                if (!empty($result["data"]["error"])) {
                    $error .= $result["data"]["error"] . ". ";
                }
                if (!empty($result["data"]["apierror"])) {
                    $error .= ' cfError(' . $result["data"]["cferrorcode"] . '):' . $result["data"]["apierror"];
                }
//                $status = ['status' => 'error', 'msg' => $error];
                $vars["error"] = $error;
            }
            if ($result["success"]) {
//                $msg = $language['cf_dns_cname_flattener_success_msg'];
//                $status = ['status' => 'success', 'msg' => $msg, 'result' => $result["result"]];
                $vars["actionsucess"] = $language['cf_dns_cname_flattener_success_msg'];
            }
//            print json_encode($status);
//            exit();
            break;
        case "ipv6":
            $value = $_POST["ipv6"];
            $result = $wgs_cf_partnerapi->changeIPv6Setting($value);
            if ($result["success"]) {
                $vars["actionsucess"] = $language['cf_dns_ipv6_modify_success'];
            }
            if ($result['result'] == "error") {
                $error = 'Error(' . $result["data"]["info"] . '): ';
                if (!empty($result["data"]["error"])) {
                    $error .= $result["data"]["error"] . ". ";
                }
                if (!empty($result["data"]["apierror"])) {
                    $error .= ' cfError(' . $result["data"]["cferrorcode"] . '):' . $result["data"]["apierror"];
                }
                $vars["error"] = $error;
            }
            break;
        case "ipv4":
            $value = $_POST["ipv4"];
            $result = $wgs_cf_partnerapi->changePseudoIPv4($value);
            if ($result["success"]) {
                $vars["actionsucess"] = $language['cf_dns_pseudo_modify_success'];
            }
            if ($result['result'] == "error") {
                $error = 'Error(' . $result["data"]["info"] . '): ';
                if (!empty($result["data"]["error"])) {
                    $error .= $result["data"]["error"] . ". ";
                }
                if (!empty($result["data"]["apierror"])) {
                    $error .= ' cfError(' . $result["data"]["cferrorcode"] . '):' . $result["data"]["apierror"];
                }
                $vars["error"] = $error;
            }
            break;
        case "deleteadddnsrecords":
            $messagetype = $_POST["messagetype"];
            $message = $_POST["message"];
            if ($messagetype == "success") {
                $vars["actionsucess"] = $message;
            }
            break;
    }
}
/*
 * Fetch Data
 */
$actionResult = $wgs_cf_partnerapi->listDNSRecords();
if ($actionResult["result"] == "error") {
    $error = 'Error(' . $actionResult["data"]["info"] . '): ';
    if (!empty($actionResult["data"]["error"])) {
        $error .= $actionResult["data"]["error"] . ". ";
    }
    if (!empty($actionResult["data"]["apierror"])) {
        $error .= ' cfError(' . $actionResult["data"]["cferrorcode"] . '):' . $actionResult["data"]["apierror"];
    }
    $vars["error"] = $error;
}

if ($actionResult['success']) {
    $vars["success"] = 1;

    $vars["dnsrecords"] = $actionResult["result"];

    $actionResult2 = $wgs_cf_partnerapi->getAllZoneSettings();
    foreach ($actionResult2['result'] as $value) {
        $vars[$value['id']] = array("value" => $value['value'], "editable" => $value['editable']);
    }
    $ipv4settingvalues = $wgs_cf_partnerapi->IPv4SettingValues($language);
    $vars["ipv4settingvalues"] = $ipv4settingvalues;

    $dnsttlvalues = $wgs_cf_partnerapi->dnsttlvalues($language);
    $vars["dnsttlvalues"] = $dnsttlvalues;

    # encrypt password and cloudflare api key
//    function encodeSensitiveData(&$value, $key, $wgs_cf_partnerapi){
//        if($key == "configoption4" || $key == "configoption5"){
//            $value = $wgs_cf_partnerapi->cfencrypt($value);
//        }
//    }
//    array_walk($params, "encodeSensitiveData", $wgs_cf_partnerapi);

    $cloudflare_username_customfield = substr($params["configoption3"], strpos($params['configoption3'], ':') + 1); # Username Customfield
    $cloudflare_password_customfield = substr($params["configoption4"], strpos($params['configoption4'], ':') + 1); # Password Customfield

    $cloudflare_user_api_key_customfield = substr($params["configoption7"], strpos($params['configoption7'], ':') + 1); # User API Key Customfield

    $cloudflare_username = $params["customfields"][$cloudflare_username_customfield];
    $cloudflare_password = $params["customfields"][$cloudflare_password_customfield];
    $cloudflare_user_api_key = $params["customfields"][$cloudflare_user_api_key_customfield];

    $params["cloudflare_api_url"] = $apiurl;
    $params["cloudflare_username"] = $cloudflare_username;
    $params["cloudflare_password"] = $wgs_cf_partnerapi->cfencrypt($cloudflare_password);
    $params["cloudflare_user_api_key"] = $wgs_cf_partnerapi->cfencrypt($cloudflare_user_api_key);

    $result = $wgs_cf_partnerapi->wgsCfGetDnsSec();

    if ($result["result"] == "error") {
        $error = 'Error(' . $result["data"]["info"] . '): ';
        if (!empty($result["data"]["error"])) {
            $error .= $result["data"]["error"] . ". ";
        }
        if (!empty($result["data"]["apierror"])) {
            $error .= ' cfError(' . $result["data"]["cferrorcode"] . '):' . $result["data"]["apierror"];
        }
        $vars["error"] = $error;
    } else {
        $vars["dnssec"] = $result['result'];
    }

    $cnameFlattern = $wgs_cf_partnerapi->wgsCfGetCnameFlattern();
    if ($cnameFlattern["success"] == 1)
        $vars["cname_flattern"] = $cnameFlattern['result']['value'];
    $vars["params"] = $params;
    $vars["salt"] = base64_encode($wgs_cf_partnerapi->salt);
    $vars["zoneid"] = $cfid;

    # Fetch DNS record types
    $dnsrecordtypes = $wgs_cf_partnerapi->dnsrecordtypes();
    $vars["dnsrecordtypes"] = $dnsrecordtypes;
}

$templateFile = "template/dnstab/dns";
?>