<?php

use Illuminate\Database\Capsule\Manager as Capsule;

global $CONFIG;
$systemURL = $systemurl = (empty($CONFIG['SystemSSLURL'])) ? $CONFIG['SystemURL'] : $CONFIG['SystemSSLURL'];
$moduleURL = $url = $systemurl . '/modules/servers/wgs_cf_partnerapi/';

# include classes
if (!class_exists('CF_HOST_API')) {
    require(dirname(__DIR__) . "/class.cloudflareAPI.php");
}
if (file_exists(dirname(__DIR__) . '/class.wgs_cf_partnerapi.php')) {
    require_once dirname(__DIR__) . '/class.wgs_cf_partnerapi.php';
}
require_once dirname(__DIR__) . '/class.cloudflareclientapi.php';
$apiurl = "https://api.cloudflare.com/client/v4/";

# Email Address
$emailAddressField = substr($params['configoption3'], strpos($params['configoption3'], ':') + 1);
$emailAddressField = cloudflare_Encoding::fixUTF8($emailAddressField);
# Password
$passwordField = substr($params['configoption4'], strpos($params['configoption4'], ':') + 1);
$passwordField = cloudflare_Encoding::fixUTF8($passwordField);
# Uesername
$usernameField = substr($params['configoption5'], strpos($params['configoption5'], ':') + 1);
$usernameField = cloudflare_Encoding::fixUTF8($usernameField);
# User Key
$userKeyField = substr($params['configoption6'], strpos($params['configoption6'], ':') + 1);
$userKeyField = cloudflare_Encoding::fixUTF8($userKeyField);
# User API Key
$userAPIKeyField = substr($params['configoption7'], strpos($params['configoption7'], ':') + 1);
$userAPIKeyField = cloudflare_Encoding::fixUTF8($userAPIKeyField);
# Client Area custom Fields

$cfusername = $emailAddress = $params['customfields'][$emailAddressField];
$cfpassword = $password = $params['customfields'][$passwordField];
$username = $params['customfields'][$usernameField];

# Cloudflare API
$hostAPIKey = $params['configoption2'];
$hostAPI = new CF_HOST_API($hostAPIKey);

# Admin only custom field
$emailAddressFieldId = getCustomfieldId($emailAddressField, $params['pid']);
$passwordFieldId = getCustomfieldId($passwordField, $params['pid']);
$usernameFieldId = getCustomfieldId($usernameField, $params['pid']);
$userkeyfieldId = getCustomfieldId($userKeyField, $params['pid']);
$userAPIkeyfieldId = getCustomfieldId($userAPIKeyField, $params['pid']);

$showdomainoptions = Capsule::table('tblproducts')->select('showdomainoptions')->where('id', $params['pid'])->first();
$domain = $params['customfields']['cloudflare_domain'];
if (empty($domain)) {
    if ($showdomainoptions->showdomainoptions != 0)
        $domain = $params['domain'];
}
$params['customfields']['cloudflare_domain'] = $domain;

$request_body = array("cloudflare_email" => $emailAddress, "cloudflare_pass" => $password, "cloudflare_username" => $username);
$result = $hostAPI->user_create($emailAddress, $password, $username);

logModuleCall("CF Partner", "user create", $emailAddress, (array) $result);
$errors = '';
$zone_error = '';
if (strchr($result->msg, 'Password failed for CloudFlare account')) {
    if ($cfusername) {
        $errors .= "This Email Address (" . $cfusername . ") is already registered. Please try another!";
    }

    $errors .= "If you want to proceed with your existing account, then you must enter correct Email Address and Password.";
}
if ($result->msg)
    $errors .= $result->msg;
if ($result->result == 'success' && !empty($result->response)) {
    $cfapikey = $result->response->user_api_key;
    $wgs_cf_partnerapi = new wgs_cf_partnerapi($apiurl, $cfusername, $cfpassword, $cfapikey);
    $zoneResult = $wgs_cf_partnerapi->getAllZones($params['customfields']['cloudflare_domain']);

    if (empty($zoneResult['result']) && $zoneResult['success'] == 1) {
        $zone_error = "Domain {$params['customfields']['cloudflare_domain']} is not added yet!";
    }
    logModuleCall("CF Partner", "Get Zone detail (create account)", $params['customfields']['cloudflare_domain'], $zoneResult);
}
if (isset($_POST['cflogin']) && !empty($_POST['cflogin'])) {
    $emailAddress = $_POST['cfemail'];
    $password = $_POST['cfpw'];
    $usernameArr = explode('@', $emailAddress);
    $errors = '';
    $zone_error = '';
    if (empty($emailAddress)) {
        $error = 'Email address is required.';
    } elseif (empty($password)) {
        $error = 'password is required.';
    } else {
        $result = $hostAPI->user_create($emailAddress, $password, $usernameArr[0]);

        logModuleCall("CF Partner", "user create", $emailAddress, (array) $result);
        if ($result->result == 'error') {
            if (strchr($result->msg, 'Password failed for CloudFlare account')) {
                if ($emailAddress) {
                    $errors .= "This Email Address (" . $emailAddress . ") is already registered. Please try another!";
                }

                $errors .= "If you want to proceed with your existing account, then you must enter correct Email Address and Password.";
            }
            $errors .= $result->msg;
        } elseif ($result->result == 'success' && !empty($result->response)) {
            $command = "updateclientproduct";
            $adminuser = wgs_cf_partnerapi_getAdminId();
            $values["serviceid"] = $params["serviceid"];
            $values["customfields"] = base64_encode(serialize(array($emailAddressFieldId => $result->response->cloudflare_email, $passwordFieldId => $password, $usernameFieldId => $result->response->cloudflare_username, $userkeyfieldId => $result->response->user_key, $userAPIkeyfieldId => $result->response->user_api_key)));
            $results = localAPI($command, $values, $adminuser);
            logModuleCall("CF Partner", "WHMCS API updateclientproduct, Clodflare User Created", $values, $results);
            $cfUserdetail = Capsule::table('mod_cf_zone')->where('uid', $params['userid'])->where('email', $emailAddress)->first();
            try {
                if (empty($cfUserdetail)) {
                    Capsule::table('mod_cf_zone')->insert(['uid' => $params['userid'], 'email' => $emailAddress, 'password' => $password, 'username' => $usernameArr[0]]);
                } else {
                    Capsule::table('mod_cf_zone')->where('uid', $params['userid'])->where('email', $emailAddress)->update(['uid' => $params['userid'], 'email' => $emailAddress, 'password' => $password, 'username' => $usernameArr[0]]);
                }
            } catch (Exception $ex) {
                logActivity("Unable to insert/update table: mod_cf_zone error: {$ex->getMessage()}");
            }

            $cfapikey = $result->response->user_api_key;
            $wgs_cf_partnerapi = new wgs_cf_partnerapi($apiurl, $result->response->cloudflare_email, $password, $cfapikey);
            $website = $params['customfields']['cloudflare_domain'];
            if ($website) {
                $zoneResult = $wgs_cf_partnerapi->getAllZones($website);

                logModuleCall("CF Partner", "Get Zone detail (create account)", $website, $zoneResult);

                if (empty($zoneResult['result']) && $zoneResult['success'] == 1) {
                    $hostAPI1 = new CF_HOST_API($hostAPIKey);
                    $resolve_to = $website;
                    $subdomains = 'www';
                    $getAddonId = Capsule::table('mod_cf_manage_service')->where('sid', $params['serviceid'])->first();
                    if ($getAddonId->addonid) {
                        $getPlan = Capsule::table('mod_cf_p_addons')->where('addonid', $getAddonId->addonid)->first();
                        $hostingService = Capsule::table('tblhosting')->where('packageid', '!=', $params['pid'])->where('domain', $params['customfields']['cloudflare_domain'])->first();
                        $command = "GetClientsProducts";
                        $adminuser = wgs_cf_partnerapi_getAdminId();
                        $values["serviceid"] = $hostingService->id;
                        $results = localAPI($command, $values, $adminuser);
                        if ($results['result'] == 'success')
                            $hostingServerIp = $results['products']['product'][0]['serverip'];
                    }

                    $zoneType = $params['configoption8'];
                    if ($getPlan->cf_plan_name == 'Free Plan With Cloudflare DNS Setup')
                        $zoneType = 'full_zone_set';
                    elseif ($getPlan->cf_plan_name == 'Free Plan With CNAME Setup') {
                        $zoneType = 'zone_set';
                    }
                    $zone_add = $hostAPI1->zone_set($result->response->user_key, $website, $resolve_to, $subdomains, $zoneType);

                    logModuleCall("CF Partner", "Add zone (create account)", $website, array('act' => $zone_add->request->act, 'zone_name' => $zone_add->request->zone_name, 'result' => $zone_add->result, 'msg' => $zone_add->msg));

                    if ($zone_add->result == 'success') {
                        $planTag = $params['configoption9'];
                        if ($getPlan->cf_plan) {
                            $planTag = $getPlan->cf_plan;
                        }
                        if ($planTag != 'Free') {
                            $plan_sub = $hostAPI1->reseller_sub_new($result->response->user_key, $website, $planTag);
                            logModuleCall("CF Partner", "Add sub plan to Cloudflare Partner", array('zone' => $website, 'plan_tag' => $planTag), (array) $plan_sub);
                            if ($plan_sub->result == "success") {

                                $subCustomfiledId = Capsule::table("tblcustomfields")->where("type", "product")->where("relid", $params['pid'])->where("fieldname", 'Subscription ID')->first();

                                $command = 'UpdateClientProduct';
                                $postData = array(
                                    'serviceid' => $params['serviceid'],
                                    'customfields' => base64_encode(serialize(array($subCustomfiledId->id => $plan_sub->response->sub_id)))
                                );
                                $adminId = Capsule::table("tbladmins")->orderBy('id', 'ASC')->first();
                                $adminUsername = $adminId->id;

                                $results = localAPI($command, $postData, $adminUsername);
                                $plan_sub->msg = $language['cf_website_added_success'];
                            } else {
                                $zone_error = "Add reseller plan failed {$website} <br/> Error code:{$plan_sub->err_code}, Error Message: {$plan_sub->msg}";
                            }
                        }
                        $zoneResult = $wgs_cf_partnerapi->getAllZones($website);
                        $nameservers = $zoneResult['result'][0]['name_servers'];
                        if ($nameservers) {
                            $domainId = '';
                            $doaminDetail = Capsule::table('tbldomains')->where('domain', $params['customfields']['cloudflare_domain'])->first();
                            $domainId = $doaminDetail->id;
                            if ($domainId) {
                                $updateNs = wgs_cf_whmcs_local_api('DomainUpdateNameservers', array('domainid' => $domainId, 'ns1' => $nameservers[0], 'ns2' => $nameservers[1]));
                                if ($updateNs['result'] == 'success') {
                                    logActivity("NS successfully updated with registrar domain: {$website}");
                                } elseif ($updateNs['result'] == 'error') {
                                    logActivity("Unable to update nameservers with registrar domain: {$website} error: {$updateNs['message']}");
                                }
                            } else {
                                logActivity("Unable to update nameservers with registrar domain: {$website} error: domain is not found in whmcs db");
                            }
                            if ($params['configoption10'] == 'on' || $params['configoption10'] == '1') {
                                $server_ip = (!empty($hostingServerIp)) ? $hostingServerIp : $params['serverip'];
                                if ($server_ip) {
                                    $dnsData = array(
                                        'zone_id' => $zoneResult['result'][0]['id'],
                                        'cfdnstype' => 'A',
                                        'cfdnsname' => $website,
                                        'cfdnsvalue' => $server_ip,
                                        'cfdnsttl' => '120'
                                    );
                                    $createDns = $wgs_cf_partnerapi->createDNSRecord($dnsData);
                                    if ($createDns['result'] == 'error') {
                                        logModuleCall("CF Partner", "Set DNS record (add website on clientarea)", $dnsData, 'Error: ' . $createDns['data']['apierror']);
                                        logActivity("Set DNS record failed $website: " . $createDns['data']['apierror']);
                                    } else {
                                        logModuleCall("CF Partner", "Set DNS record (add website on clientarea)", $dnsData, 'Dns record has been successfully added');
                                        logActivity("DNS record has been steup zone :$website");
                                    }
                                } else {
                                    logActivity("Unable to add the DNS record domain: {$website} error: server iP not found");
                                }
                            }
                        }
                    } else {
                        $zone_error = "Add zone failed {$website} <br/>Error code: {$zone_add->err_code}, Error message: {$zone_add->msg}";
                    }
                } else {
                    $zone_error = "Add zone failed {$website} <br/>Error code: {$zoneResult->err_code}, Error message: {$zoneResult->msg}";
                }
            }
        }
    }
}

$vars = array(
    'url' => $url,
    'account' => $details,
    'wgs_lang' => $language,
    'user_lang' => $clientLanguage,
    'login_error' => $errors,
    'zone_error' => $zone_error,
    'emailaddress' => $emailAddress,
    'cfpassowrd' => $password
);
$templateFile = "template/cflogin/cflogin";
?>
