<?php
/**
 * My Licenses Menu Item
 *
 * Adds a 'My Licenses' link to the Services dropdown menu within the
 * client area linking to a product/service listing filtered for
 * licensing addon related products.
 *
 * @param WHMCS\Menu\Item $menu
 */

use WHMCS\Database\Capsule;

add_hook('ClientAreaPrimaryNavbar', -1, function ($menu)
{
    // check services menu exists
    if (!is_null($menu->getChild('Services'))) {
        // add my licenses link
        $menu->getChild('Services')
            ->addChild(
                Lang::trans('licensingaddon.mylicenses'),
                array(
                    'uri' => 'clientarea.php?action=products&module=licensing',
                    'order' => 11,
                )
            );
    }
});


add_hook('AdminAreaFooterOutput', 1, function($vars) {

if (isset($_POST['select_id'])) {
        $select_id = $_POST['select_id'];

        $getmacs = Capsule::table('mod_mac_licensing')->where('serviceid', $select_id)->first();
       
        $macdatas = $getmacs->validdomain;

        echo($macdatas);die();
    }    

if (isset($_POST['ids'])) {
    $ids = $_POST['ids'];
    $macdata = array();


    foreach ($ids as $value) {
        $getmac = Capsule::table('mod_mac_licensing')->where('serviceid', $value)->first();
        $macdata['id'][] = $getmac->serviceid;
        $macdata['validdomain'][] = $getmac->validdomain;
        // print_r($macdata);die();
    }

    // print_r($macdata);die();
    echo(json_encode($macdata));die();
}

$productselect = $_GET['productselect'];


    return <<<HTML
<script type="text/javascript">
    $(document).ready(function(){

        select_id = $("#frm2").find("[data-value=$productselect]").attr('data-value');

        $.ajax({
          url: '',
          type: 'post',
          data: { 
            "select_id": select_id
            },
            success: function(response) {
                $("#frm2").find("[data-value=$productselect]").children().append(' '+response);   
            }
        });    
        

        var ids = [];

        $('.selectize-auto-submit').one("click",function(){
              setTimeout(function() {
            $("#frm2").find("[data-selectable]").each(function() {
               var val = $(this).attr('data-value');

               ids.push(val);
            });

            
            // console.log((ids));

                $.ajax({
                  url: '',
                  type: 'post',
                  data: { 
                    "ids": ids
                  },
                  success: function(response) {
                    // console.log(response);
                    var obj = JSON.parse(response)
                    $.each(obj.id, function(k,v) {
                        // console.log(v);
                        var macids = obj.validdomain[k];
                        // console.log(macids);
                        if (v != null) {
                            $("#frm2").find("[data-selectable]").each(function() {
                               var val2 = $(this).attr('data-value');
                               if (val2 == v) {
                                $(this).children().append(' '+macids);

                                var abc = $("#frm2").find("[data-value=$productselect]");

                               }
                              
                            });

                        }


                    });


                  }
                });
            
            },300);  
        });

    });

    // $(document).ready(function(){
    // 	var div_input = $("#frm2").find(".selectize-input");

    //     var input_div = div_input.find('input')
    //     div_input.append('<input type="hidden" value="" name="" id="serchli">');
    //     // div_input.find('input').attr('value');
    //     $(input_div).keyup(function(){
    //    	  var texts = $(this).val();
    //       var txt = $('#serchli').val(texts);
    //       var txt2 = $('#serchli').attr('value');

    //       // console.log(txt2);
    //         // $("#frm2").find("[data-selectable]").hide();
    //         $("#frm2").find("[data-selectable]").each(function(){
            	
    //         		console.log($('#serchli').attr('value'));
      
                	
	   //          // if($(this).text().toUpperCase().indexOf(txt.toUpperCase()) != -1){
	   //          //   $(this).show();
	   //          // }
    //         });
            	
    //     });
    // });

</script>
HTML;


});
