<?php
set_time_limit(30*30*30);

if (!defined("WHMCS"))
{
    die("This file cannot be accessed directly");
}

function hc_MetaData()
{
    return array(
        'DisplayName' => 'Hosting Controller',        
        'DefaultNonSSLPort' => '8798', // Default Non-SSL Connection Port
        'DefaultSSLPort' => '8798', // Default SSL Connection Port
        'ServiceSingleSignOnLabel' => 'Login to Panel',
        'AdminSingleSignOnLabel' => 'Login to Panel',
    );
}
#####################################
#	Please Donot make any change in #
#	this file.						#
#									#
#									#
#####################################
function GetPanelApiAccessUrl($params)
{
	$url = "";
	$protocol = "https";
	$ipaddress = "hcapi.mydatapage.com";
	$port = "443";
	if(isset($params["serversecure"]) && $params["serversecure"] == "on")
		$protocol = "https";
	
	if(isset($params["serverip"]) && $params["serverip"] != "")
		$ipaddress = $params["serverip"];
	
	if(isset($params["serverport"]) && $params["serverport"] != "")
		$port = $params["serverport"];
	
	
	$url = $protocol."://".$ipaddress.":".$port;
	return $url;
}

function hc_TestConnection(array $params)
{
    try {
			$success = true;
			$errorMsg = 'API Connected Successfully';
			$url = "";
			$protocol = "https";
			$ipaddress = "hcapi.mydatapage.com";
			$port = "443";
			if(isset($_POST["secure"]) && $_POST["secure"] == "on")
				$protocol = "https";
			
			if(isset($_POST["ipaddress"]) && $_POST["ipaddress"] != "")
				$ipaddress = $_POST["ipaddress"];
			
			if(isset($_POST["port"]) && $_POST["port"] != "")
				$port = $_POST["port"];
			
			
			$url = $protocol."://".$ipaddress.":".$port;
			$apibaseurl = $url;
			$apiurl = $apibaseurl.'/panel-users/0';
			
			$serverusername = $_POST["username"];
			$serverpassword = $_POST["password"];
			$adduserdata = array();
			$httpresponse = hc_Connect($apiurl, $serverusername, $serverpassword, "GET", $adduserdata);


	 	//echo "apiurl==========$apiurl\n";
		//echo "serverusername========$serverusername\n";
	 	//echo "serverpassword==========$serverpassword\n\n";
	 	//echo "adduserdata=========$adduserdata\n";
	 //	echo 'httpresponse["code"]================'.$httpresponse["code"];
	//	echo 'httpresponse["body"]================'.$httpresponse["body"];

	 //die();	
		
			
			if($httpresponse["code"] != 200)
			{
				$success = false;
				$errorMsg = "Error occoured while connecting to the API";
			}
			
	} catch (Exception $e) {
			// Record the error in WHMCS's module log.
			logModuleCall('HC',__FUNCTION__,$params,$e->getMessage(),$e->getTraceAsString());
			$success = false;
			$errorMsg = $e->getMessage();
		}

		return array(
        'success' => $success,
        'error' => $errorMsg,
		);
}

function hc_Connect($endpointurl, $username, $password, $method = 'GET', $data=array())
{
    $endpointurl = rtrim($endpointurl,"/");
    $headers = array(
        'Accept: application/json',
        'Content-Type: application/json',
		'Cache-Control: no-cache'
    );
	
    $endpointurl = rtrim($endpointurl,"/");
    $headers = array(
        'Accept: application/json',
        'Content-Type: application/json',
    );
    $handle = curl_init();
	curl_setopt($handle, CURLOPT_FRESH_CONNECT, TRUE);
    curl_setopt($handle, CURLOPT_URL,$endpointurl);
    curl_setopt($handle, CURLOPT_RETURNTRANSFER,1);
    curl_setopt($handle, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($handle, CURLOPT_USERPWD,"$username:$password");
    curl_setopt($handle, CURLOPT_HTTPHEADER, $headers);

    switch($method) {
        case 'GET':
            break;
        case 'POST':
            curl_setopt($handle, CURLOPT_POST, true);
            curl_setopt($handle, CURLOPT_POSTFIELDS, $data);
            break;
        case 'PUT': 
            curl_setopt($handle, CURLOPT_CUSTOMREQUEST, 'PUT');
            curl_setopt($handle, CURLOPT_POSTFIELDS, $data);
            break;
        case 'DELETE':
            curl_setopt($handle, CURLOPT_CUSTOMREQUEST, 'DELETE');
            break;
    }

    $response = curl_exec($handle);	
    $httpErrorCode = curl_getinfo($handle, CURLINFO_HTTP_CODE);
    return array("code" => $httpErrorCode, "body" => $response);
}

function hc_ConfigOptions() {
    # Should return an array of the module options for each product - maximum of 24
    $configarray = array(
	"Plan Name" => array( "Type" => "text", "Size" => "25", ),
	"CResource Name" => array( "Type" => "text", "Size" => "25",  "Description" => "This Cresource will be used if no custom fields for resource are provided.",),
	"Product Type" => array(
            "FriendlyName" => "Product Type",
            "Type" => "dropdown", # Dropdown Choice of Options
            "Options" => array(
                'website' => 'Website',
                'vm' => 'Virtual Machine',
				'org' => 'Exchange Organization',
				'mailbox' => 'Exchange Mailbox',
				'csp' => 'CSP Customer',
				'skype' => 'Skype for Business',
				'sharepoint' => 'Microsoft SharePoint'
            ),
            "Description" => "Select the product type that will be created with new order.",
            "Default" => "website"),    
	);
	return $configarray;
}

function hc_CreateAccount($params) {
    $clientsdetails = $params["clientsdetails"]; # Array of clients details - firstname, lastname, email, country, etc...
    $customfields = $params["customfields"]; # Array of custom field values for the product

    # Additional variables if the product/service is linked to a server
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
	
	$newusername = $clientsdetails["customfields1"]!= Null ? $clientsdetails["customfields1"]: $customfields["Panel Login Name"];
    $newuserpassword = $clientsdetails["customfields2"]!= Null ? $clientsdetails["customfields2"]: $customfields["Panel Login Password"];
	
	$createwebsite = false;
	$createvm = false;
	$createorg = false;
	$createmailbox = false;
	$createcspcustomer = false;
	$createskype = false;
	$createsharepoint = false;
	
	$producttype = $params["configoption3"];
	
	if ((isset($newusername) && $newusername == ""))
	{
		return  "User Name is missing.";
	}
	if ((isset($newuserpassword) && $newuserpassword == ""))
	{
		return  "User Password is missing.";
	}
	if ((isset($params["configoption1"]) && $params["configoption1"] == ""))
	{
		return  "Plan Name is missing.";
	}
	
	$servername = "";//loadbalancing server
	if(isset($customfields["Server Name"]) && $customfields["Server Name"] != "")
	{
		$servername = $customfields["Server Name"];
	}
	
	if($producttype != null && $producttype == 'website')
	{				
		if (!(isset($params["domain"]) && $params["domain"] != ""))
		{
			return  "Website name is missing.";
		}
		$createwebsite = true;
	}
	if($producttype != null && $producttype == 'vm')
	{			
		if (!(isset($customfields["Virtual Machine Name"]) && $customfields["Virtual Machine Name"] != "") &&
			(isset($customfields["Admin Password"]) && $customfields["Admin Password"] != ""))
		{
			return  "Required custom fields are missing.";
		}
		$createvm = true;		
	}
    if($producttype != null && $producttype == 'org')
	{				
		if (!(isset($customfields["Organization Name"]) && $customfields["Organization Name"] != "") && 
		(isset($customfields["MailDomain Name"]) && $customfields["MailDomain Name"] != ""))
		{
			return  "Required custom fields are missing.";
		}
		$createorg = true;
	}
	if($producttype != null && $producttype == 'mailbox')
	{				
		if (!(isset($customfields["Mailbox Name"]) && $customfields["Mailbox Name"] != "") && 
		(isset($customfields["Mailbox Password"]) && $customfields["Mailbox Password"] != ""))
		{
			return  "Required custom fields are missing.";
		}
		$createmailbox = true;
	}
	if($producttype != null && $producttype == 'csp')
	{				
		if (!(isset($customfields["Domain Name"]) && $customfields["Domain Name"] != "") && 
		(isset($customfields["Company Name"]) && $customfields["Company Name"] != ""))
		{
			return  "Required custom fields are missing.";
		}
		$createcspcustomer = true;
	}
	if($producttype != null && $producttype == 'skype')
	{				
		if (!(isset($customfields["Organization Name"]) && $customfields["Organization Name"] != "") && 
		!(isset($customfields["SIP Domain Name"]) && $customfields["SIP Domain Name"] != ""))
		{
			return  "Required custom fields are missing.";
		}
		$createskype = true;
	}
	if($producttype != null && $producttype == 'sharepoint')
	{				
		if (!(isset($customfields["Organization Name"]) && $customfields["Organization Name"] != "") && 
			!(isset($customfields["Domain Name"]) && $customfields["Domain Name"] != "") &&
			!(isset($customfields["Site Host Header"]) && $customfields["Site Host Header"] != "") &&
			!(isset($customfields["Site Title"]) && $customfields["Site Title"] != "") &&
			!(isset($customfields["SharePoint Username"]) && $customfields["SharePoint Username"] != "") && 
			!(isset($customfields["SharePoint User Password"]) && $customfields["SharePoint User Password"] != ""))
		{
			return  "Required custom fields are missing.";
		}
		$createsharepoint = true;
	}
    
	//Get HC API access URL
	$apiurl = GetPanelApiAccessUrl($params);
	
	//get cresource id
	$cresourceid = 0;
	if(isset($params["configoption2"]) && $params["configoption2"] != "")
	{
		$cresourceid = GetCompositeResourceIdByName($serverusername, $serverpassword,$params["configoption2"],$apiurl);
	}
	
	$userId = 0;
	$mailDomainId = 0;
	$organizationId = 0;
	$serverRoleId = 0;
	
	if(!$createmailbox)
	{
		// add a new client. 
		$adduserdata = json_encode(array(
			'UserName'=> $newusername,
			'Password'=> $newuserpassword,
			'Description'=> "",
			'EmailAddress'=> $clientsdetails["email"],		
			'RoleId'=> 3,//always create client
		));
		
		$apiendpoint = $apiurl."/panel-users";
		$httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST", $adduserdata);
		
		
	 //	echo "apiendpoint==========$apiendpoint\n";
	 //	echo "serverusername========$serverusername\n";
	 //	echo "serverpassword==========$serverpassword\n\n";
	 //	echo "adduserdata=========$adduserdata\n";
	 //	echo 'httpresponse["code"]================'.$httpresponse["code"];
	//	echo 'httpresponse["body"]================'.$httpresponse["body"];

//	 die();	
		
		if($httpresponse["code"] != 200)
		{
			LogModule(FormateErrorMsg($httpresponse),__FUNCTION__,$params);
			return "Failed to add user.";
		}	
		
		$userdetailsJson = json_decode($httpresponse["body"]);
		$userId = $userdetailsJson->UserId;
		
		// add user profile. 
		$countrtid  = GetContryIdByName($serverusername, $serverpassword, $clientsdetails["country"],$apiurl);
		$addprofiledata = json_encode(array(
			'FirstName'=> $clientsdetails["firstname"],
			'LastName'=> $clientsdetails["lastname"],
			'Country'=> $countrtid,
			'State'=> $clientsdetails["state"],
			'City'=> $clientsdetails["city"],
			'StreetAddress'=> $clientsdetails["address1"],
			'StreetAddress2'=> $clientsdetails["address2"],
			'EmailAddress'=> $clientsdetails["email"],
			'PostalCode'=> $clientsdetails["postcode"],
			'PhoneNo'=> $clientsdetails["phonenumber"],
			'FaxNo'=> "",
			'Company'=> $clientsdetails["companyname"],
			'SocialSecurityNo'=> ""
		));
		// proceed even if profile addition fails. so no need to check response.
		$apiendpoint = $apiurl."/panel-users/".$userId."/general-profile";
		hc_Connect($apiendpoint, $serverusername, $serverpassword, "PUT", $addprofiledata);
	}
	else
	{			
		$mailDomainName = $customfields["MailDomain Name"];	
		$apiendpoint = $apiurl."/exchange/mail-domains?MailDomain=".$mailDomainName."&ExactMatch=true";
		$maildomainresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "GET",$maildomaindata);
		if($maildomainresponse["code"] != 200){
			LogModule(FormateErrorMsg($maildomainresponse),__FUNCTION__,$params);
			return "MailDomain details not found.";
		}
		$respjson = json_decode($maildomainresponse["body"]);
		foreach($respjson->ExchangeMailDomains as $value)
		{
			$mailDomainId = $value->MailDomainId;
			$mailDomainName = $value->MailDomain;
			$organizationId = $value->OrganizationId;
			$serverRoleId = $value->ServerRoleId;
			$userId = $value->OwnerId;											
		}
	}
        		
    // sell plan now.
    $planid = GetPlanIdByName($serverusername, $serverpassword, $params["configoption1"],$apiurl);
	$planDetails = GetPlanDetails($serverusername, $serverpassword,$planid,$apiurl);
	
	if($plandetails["ownerId"] != $userId)
	{
		$sellplandata = json_encode(array(
        'UserId'=> $userId,
        'PlanId'=> $planid,
        'Quantity'=> 1
		));	
		$apiendpoint = $apiurl."/sold-plans";
		$sellplanresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST", $sellplandata);
		if($sellplanresponse["code"] != 200)
		{
			LogModule(FormateErrorMsg($sellplanresponse),__FUNCTION__,$params);		
			return "User created successfully but failed to sell plan.";
		}
	}    
    
	if($createwebsite)
	{
		$websiteprovider = "";
		$dotnetenabled = false;
		$phpenabled = false;
		$coldfusionenabled = false;
		$perlenabled = false;
		$statsitesenabled = false;
		
		$plandetails = GetPlanDetails($serverusername, $serverpassword, $planid,$apiurl);
		if($cresourceid > 0)
		{
			$cresdetails = GetCompositeResourceDetails($serverusername, $serverpassword, $cresourceid,$apiurl);
			if(sizeof($cresdetails) <= 0)
			{
				LogModule("CResource details not found",__FUNCTION__,$params);
				return "User added successfully,CResource details not found.";
			}
			else
			{
				$websiteprovider = $cresdetails["provider"];
			}
		}
		else
		{
			if(isset($plandetails["WebProvider"]) && $plandetails["WebProvider"] != "")
				$websiteprovider = $plandetails["WebProvider"];
			else
			{
				LogModule("Web server provider not found",__FUNCTION__,$params);
				return "User added successfully,Web server provider not found.";
			}
			
			if(isset($plandetails["DotNetEnabled"]) && $plandetails["DotNetEnabled"] == "true")
				$dotnetenabled = true;
			if(isset($plandetails["ColdFusionEnabled"]) && $plandetails["ColdFusionEnabled"] == "true")
				$coldfusionenabled = true;
			if(isset($plandetails["PerlEnabled"]) && $plandetails["PerlEnabled"] == "true")
				$perlenabled = true;
			if(isset($plandetails["PHPEnabled"]) && $plandetails["PHPEnabled"] == "true")
				$phpenabled = true;
			if(isset($plandetails["StatsEnabled"]) && $plandetails["StatsEnabled"] == "true")
				$statsitesenabled = true;
		}
		$serverroleid = GetServerRoleIdByServerName($serverusername, $serverpassword,$servername,"webserver",$apiurl);
		
		//Get FTP user details
		$arr = explode(".",$params["domain"]);
		$site_name = $arr[0];
		$FtpUserName = $site_name."_ftp";
		$FtpUserPassword = generate_password();
				
		$websitedata = json_encode(array(
			'OwnerId'=> $userId,
			'WebsiteName'=> $params["domain"],
			'ProviderName' => $websiteprovider,
			'ServerRoleId' => $serverroleid,
			'IsNameBased' => true,
			'CResourceId' => $cresourceid,
			'DotNetEnabled' => $dotnetenabled,
			'PhpEnabled' => $phpenabled,
			'PerlEnabled' => $perlenabled,
			'ColdFusionEnabled' => $coldfusionenabled,
			'StatsEnabled' => $statsitesenabled,
			'DefaultDocuments' => "index.php,default.html,default.htm,default.asp,default.aspx,index.htm,index.html,index.cfm,index.asp,index.aspx,awstats.pl",
			'CreateFtpUser' => true,
			'FtpUserName' => $FtpUserName,
			'FtpUserPassword' => $FtpUserPassword,
			'AllowAnonymous' => true,
			'DefaultDocUpdate' => true,
			'HandlerReadPermission' => true,
			'IntegratedAuthentication' => true,
			'ReadPermission' => true,
			'ScriptPermission' => true
			
		));
		$apiendpoint = $apiurl."/websites";
		$websiteresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST",$websitedata);
		
//$apiendpoint, $serverusername, $serverpassword, "POST",$websitedata

 //	echo "apiendpoint==========$apiendpoint\n";
//	 	echo "serverusername========$serverusername\n";
//	 	echo "serverpassword==========$serverpassword\n\n";
//	 	echo "websitedata=========$websitedata\n";
//	 	echo 'httpresponse["code"]================'.$httpresponse["code"];
//		echo 'httpresponse["body"]================'.$httpresponse["body"];

//	 die();	


if($websiteresponse["code"] != 200)
		{		
			LogModule(FormateErrorMsg($websiteresponse),__FUNCTION__,$params);
			return "User added successfully,failed to create website.";
		}
		$webRespjson = json_decode($websiteresponse["body"]);		
		
		//Create Email data
		$siteCreationEmaildata = array(
				'NameBased'=> true,
				'WebsiteOwnerId'=> $userId,
				'ServerId' => $webRespjson->ServerId,
				'WebsiteName' => $params["domain"],
				'IpAddress' => $webRespjson->IpAddress,
				'VirtualDirectoryName' => "",
				'FtpSiteCreated' => true,
				'FtpUserName' => $FtpUserName,
				'FtpUserPassword' => $FtpUserPassword
				);
		
		//Create MailDomain
		if(isset($plandetails["MailProvider"]) && $plandetails["MailProvider"] != "")
		{
			$maildomaindata = json_encode(array(
				'MailDomainName'=> $params["domain"],
				'OwnerId'=> $userId,
				'ProviderName' => $plandetails["MailProvider"],
				'ServerRoleId' => $serverroleid
			));
			$apiendpoint = $apiurl."/mail-domains";
			$mdomainresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST",$maildomaindata);			
			if($mdomainresponse["code"] != 200)
			{		
				LogModule(FormateErrorMsg($mdomainresponse),__FUNCTION__,$params);
			}
			else
			{
				$mailRespjson = json_decode($mdomainresponse["body"]);
				$siteCreationEmaildata["MailDomainName"] = $params["domain"];
				$siteCreationEmaildata["MailServerIp"] = $mailRespjson->MailServerIp;
				$siteCreationEmaildata["MailServerId"] = $mailRespjson->MailServerId;
			}			
		}
		
		//Create DNS Zone
		if(isset($plandetails["DNSProvider"]) && $plandetails["DNSProvider"] != "")
		{
			$dnszonedata = json_encode(array(
				'DnsZoneName'=> $params["domain"],
				'OwnerId'=> $userId,
				'ProviderName' => $plandetails["DNSProvider"],
				'ServerRoleId' => $serverroleid,
				'MailConfiguredIp' => $mailRespjson->MailServerIp,
				'MailDomainName' => $params["domain"]
			));
			$apiendpoint = $apiurl."/dns-zones";
			$dnsresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST",$dnszonedata);			
			if($dnsresponse["code"] != 200)
			{		
				LogModule(FormateErrorMsg($dnsresponse),__FUNCTION__,$params);
			}
			else
			{
				$dnsRespjson = json_decode($mdomainresponse["body"]);
				$siteCreationEmaildata["DnsZoneName"] = $params["domain"];
				$siteCreationEmaildata["DnsServerIp"] = $dnsRespjson->DnsServerIp;
				$siteCreationEmaildata["NameServer1"] = $dnsRespjson->NameServer1;
				$siteCreationEmaildata["NameServer2"] = $dnsRespjson->NameServer2;
				$siteCreationEmaildata["NameServer3"] = $dnsRespjson->NameServer3;
				$siteCreationEmaildata["NameServer4"] = $dnsRespjson->NameServer4;
			}				
		}
		
		//Send Email
		$apiendpoint = $apiurl."/panel-email-conf/emails/website";
		$emailresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "PUT",json_encode($siteCreationEmaildata));
	}
	
	if($createvm)
	{
		$ramsize = 0;
		$vhd = 0;
		$cpucores = 0;
		$vmprovider = "";
		$vmproviderid = 0;
		$baseostype = "";
		$baseostypeid = "";
		if($cresourceid > 0)
		{
			$cresdetails = GetCompositeResourceDetails($serverusername, $serverpassword, $cresourceid,$apiurl);
			if(sizeof($cresdetails) <= 0)
			{
				LogModule("CResource details not found",__FUNCTION__,$params);
				return "User added successfully,CResource details not found.";
			}
			else
			{
				$vmprovider = $cresdetails["provider"];
				$vmproviderid = $cresdetails["providerid"];
				$baseostype = $cresdetails["baseostype"];
				$baseostypeid = $cresdetails["baseostypeid"];
			}
		}
		else
		{
			$plandetails = GetPlanDetails($serverusername, $serverpassword, $planid,$apiurl);			
			if(isset($plandetails["VMProvider"]) && $plandetails["VMProvider"] != "")
			{
				$plandetails = GetPlanDetails($serverusername, $serverpassword, $planid,$apiurl);			
				$vmprovider = $plandetails["VMProvider"];
				$vmproviderid = $plandetails["VMProviderId"];
				$baseostype = $plandetails["baseostype"];
				$baseostypeid = $plandetails["baseostypeid"];
			}
			else
			{
				LogModule("VM server provider not found",__FUNCTION__,$params);
				return "User added successfully,VM server provider not found.";
			}
			if(isset($customfields["Ram Size (MB)"]) && $customfields["Ram Size (MB)"] != "")
				$ramsize = $customfields["Ram Size (MB)"];
			if(isset($customfields["Virtual Hard Disk Size (GB)"]) && $customfields["Virtual Hard Disk Size (GB)"] != "")
				$vhd = $customfields["Virtual Hard Disk Size (GB)"];
			if(isset($customfields["CPU Cores"]) && $customfields["CPU Cores"] != "")
				$cpucores = $customfields["CPU Cores"];			
		}
		
		// create vm now.
		
		$vmdesc = isset($customfields["Virtual Machine Description"]) ? $customfields["Virtual Machine Description"] : $customfields["Virtual Machine Name"];
		$serverroleid = GetServerRoleIdByServerName($serverusername, $serverpassword,$servername,"virtualizationserver",$apiurl);
		$vmdata = json_encode(array(
			'OwnerId'=> $userId,
			'DisplayName'=> $customfields["Virtual Machine Name"],
			'Description' => $vmdesc,
			'OsAdminPassword' => $customfields["Admin Password"],
			'RamSize'=> $ramsize,
			'HardDriveSize'=> $vhd,
			'CpuCores'=> $cpucores,
			'CResourceId'=> $cresourceid,
			'ServerRoleId' => $serverroleid,
			'ProviderId' => $vmproviderid,
			'ResourceComponentPropId' => $baseostypeid
			
		));	
		$apiendpoint = $apiurl."/virtualization/virtual-machines";
		$vmresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST", $vmdata);
		if($vmresponse["code"] != 200){			
			LogModule(FormateErrorMsg($vmresponse),__FUNCTION__,$params);
			return "Failed to create virtual machine.";
		}
    
    }
	
	if($createorg)
	{		
		$exchangeprovider = "";
		
		$plandetails = GetPlanDetails($serverusername, $serverpassword, $planid,$apiurl);						
		if(isset($plandetails["ExchangeProvider"]) && $plandetails["ExchangeProvider"] != "")
			$exchangeprovider = $plandetails["ExchangeProvider"];
		else
		{
			LogModule("Exchange server provider not found",__FUNCTION__,$params);
			return "User added successfully,Exchange server provider not found.";
		}				
		
		$serverroleid = GetServerRoleIdByServerName($serverusername, $serverpassword,$servername,"exchangeserver",$apiurl);
		$orgdata = json_encode(array(
			'OwnerId'=> $userId,
			'Provider'=> $exchangeprovider,
			'SystemName' => $customfields["Organization Name"],
			'ServerRoleId' => $serverroleid,
		));		
		$apiendpoint = $apiurl."/organizations/exchange";
		$orgresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST",$orgdata);
		
		if($orgresponse["code"] != 200){		
			LogModule(FormateErrorMsg($orgresponse),__FUNCTION__,$params);			
			return "Failed to create exchange organization.";
		}
		else{
			$orgJson = json_decode($orgresponse["body"]);
			$organizationId = $orgJson->OrganizationId;
			$maildomaindata = json_encode(array(
				'OwnerId'=> $userId,
				'MailDomain'=> $customfields["MailDomain Name"],
				'OrganizationId' => $organizationId,
				'Provider' => $exchangeprovider
			));

			$apiendpoint = $apiurl."/exchange/mail-domains";
			$maildomainresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST",$maildomaindata);
			if($maildomainresponse["code"] != 200){				
				LogModule(FormateErrorMsg($maildomainresponse),__FUNCTION__,$params);
				return "Organization created successfully,failed to create exchange maildomain.";
			}
		}
    
	}
	
	if($createskype){
		$skypeprovider = "";
		
		$plandetails = GetPlanDetails($serverusername, $serverpassword, $planid,$apiurl);						
		if(isset($plandetails["SkypeProvider"]) && $plandetails["SkypeProvider"] != "")
			$skypeprovider = $plandetails["SkypeProvider"];
		else
		{
			LogModule("Skype server provider not found",__FUNCTION__,$params);
			return "User added successfully,Skype server provider not found.";
		}				
		
		$serverroleid = GetServerRoleIdByServerName($serverusername, $serverpassword,$servername,"skypeforbusiness",$apiurl);
		$orgdata = json_encode(array(
			'OwnerId'=> $userId,
			'Provider'=> $skypeprovider,
			'SystemName' => $customfields["Organization Name"],
			'ServerRoleId' => $serverroleid,
		));		
		$apiendpoint = $apiurl."/organizations/skype";
		$orgresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST",$orgdata);
		
		if($orgresponse["code"] != 200){		
			LogModule(FormateErrorMsg($orgresponse),__FUNCTION__,$params);			
			return "Failed to create skype organization.";
		}
		else{
			$orgJson = json_decode($orgresponse["body"]);
			$organizationId = $orgJson->OrganizationId;
			$skypedata = json_encode(array(
				'OrganizationId' => $organizationId,
				'SIPDomainName' => $customfields["SIP Domain Name"]
			));

			$apiendpoint = $apiurl."/skype/sip-domains";
			$skyperesponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST",$skypedata);
			if($skyperesponse["code"] != 200){				
				LogModule(FormateErrorMsg($skyperesponse),__FUNCTION__,$params);
				return "Organization created successfully,failed to create skype SIP domain.";
			}
		}
	}

	if($createsharepoint){
		$sharepointprovider = "";
		
		$plandetails = GetPlanDetails($serverusername, $serverpassword, $planid,$apiurl);						
		if(isset($plandetails["SharePointProvider"]) && $plandetails["SharePointProvider"] != "")
			$sharepointprovider = $plandetails["SharePointProvider"];
		else
		{
			LogModule("SharePoint server provider not found",__FUNCTION__,$params);
			return "User added successfully,SharePoint server provider not found.";
		}				
		
		$serverroleid = GetServerRoleIdByServerName($serverusername, $serverpassword,$servername,"sharepointserver",$apiurl);
		$orgdata = json_encode(array(
			'OwnerId'=> $userId,
			'Provider'=> $sharepointprovider,
			'SystemName' => $customfields["Organization Name"],
			'ServerRoleId' => $serverroleid,
		));		
		$apiendpoint = $apiurl."/organizations/sharepoint";
		$orgresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST",$orgdata);
		
		if($orgresponse["code"] != 200){		
			LogModule(FormateErrorMsg($orgresponse),__FUNCTION__,$params);			
			return "Failed to create sharepoint organization.";
		}
		else{
			$orgJson = json_decode($orgresponse["body"]);
			$organizationId = $orgJson->OrganizationId;
			$sharepointdata = json_encode(array(
				'OrganizationId' => $organizationId,
				'SPDomain' => $customfields["Domain Name"],
				'SPHostHeader' => $customfields["Site Host Header"],
				'SiteTitle' => $customfields["Site Title"],
				'SharePointUserName' => $customfields["SharePoint Username"],
				'SharePointUserPassword' => $customfields["SharePoint User Password"]
			));

			$apiendpoint = $apiurl."/sharepoint/sites";
			$sharepointresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST",$sharepointdata);
			if($sharepointresponse["code"] != 200){				
				LogModule(FormateErrorMsg($sharepointresponse),__FUNCTION__,$params);
				return "Organization created successfully,failed to create sharepoint site.";
			}
		}
	}
	
	if($createmailbox)
	{				
		$mailboxdata = json_encode(array(
			'OwnerId'=> $userId,
			'MailboxType'=> "usermailbox",
			'DisplayName' => $customfields["Mailbox Name"],
			'ServerRoleId' => $serverRoleId,
			'IsNewUser' => true,
			'Password' => $customfields["Mailbox Password"],
			'MaildomainName' => $customfields["MailDomain Name"],
			'CResourceId' => $cresourceid,
			'IMAP' => true,
			'POP' => true,
			'MAPI' => true,
			'OWA' => true,
			'MailboxSize' => "50",
			'OrganizationId' => $organizationId,
			'IsResourceMailbox' => false,
			'SystemName' => $customfields["Mailbox Name"],
			'GeneralProfile' => (array(  
				  'DisplayName' => $customfields["Mailbox Name"],
				  'CountryId' => 1,
				  'State' => 'alabama'
			   ))
		));	
		
		$apiendpoint = $apiurl."/exchange/mailboxes";
		$mbxresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST",$mailboxdata);
		
		if($mbxresponse["code"] != 200){			
			LogModule(FormateErrorMsg($mbxresponse),__FUNCTION__,$params);			
			return "Failed to create exchange mailbox.";
		}
		
	}
	
	if($createcspcustomer)
	{		
		$countryId = 0;
		$domainName = $customfields["Domain Name"];
		$arr = explode(".",$domainName);
		$domainName = $arr[0];		

		$apiendpoint = $apiurl."/system-entities/countries?CountryName=".urlencode($customfields["Country Name"]);
		$countryresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword);
		if($countryresponse["code"] != 200){			
			LogModule(FormateErrorMsg($countryresponse),__FUNCTION__,$params);			
			return "Failed to get Country details";
		}
		$respjson = json_decode($countryresponse["body"]);
		foreach($respjson->Countries as $value)
		{
			$countryId = $value->CountryId;										
		}

		//Create csp tenant now
		$tenantdata = json_encode(array(
			'OwnerId'=> $userId,
			'Provider'=> "office365",
			'SystemName' => $customfields["Customer Name"],
			'Region' => $countryId,
			'DefaultDomain' => $domainName,
			'AddressLine1' => $customfields["Address"],
			'City' => $customfields["City"],
			'FirstName' => $customfields["First Name"],
			'LastName' => $customfields["Last Name"],
			'EmailAddress' => $customfields["Email Address"],
			'ZipCode' => $customfields["Zip Code"],
			'State' => $customfields["State"],
			'PhoneNumber' => $customfields["Phone Number"]
		));	
		$apiendpoint = $apiurl."/office365/organizations";
		$tenamtresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "POST",$tenantdata);

		if($tenamtresponse["code"] != 200){			
			
			$errorDetail = GetErrorDescription($tenamtresponse);
			if($errorDetail == "")
				$errorDetail = "Failed to create CSP Customer.";

			$errorDesc = $userdetailsJson->ErrorDesc;
			if($errorDesc != "DUPLICATE_ENTRY")
				hc_TerminateAccount($params);
			else{
				$soldPlanId = json_decode($sellplanresponse["body"])->SoldPlanId;
				hc_DeleteSoldPlan($soldPlanId, $params);
			}
			LogModule($errorDetail,__FUNCTION__,$params);
			return  $errorDetail;
		}
		
	}
	return "success";
}

function hc_DeleteSoldPlan($soldPlanId, $params){
	$apiurl = GetPanelApiAccessUrl($params);
	$apiendpoint = $apiurl."/sold-plans/".$soldPlanId;
	$serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
	$httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "DELETE");
	if($httpresponse["code"] != 200){
        return "Failed to delete sold plan.".FormateErrorMsg($httpresponse);
    }
}

function hc_TerminateAccount($params) {

	//Get HC API access URL
	$apiurl = GetPanelApiAccessUrl($params);
	
    $customfields = $params["customfields"]; # Array of custom field values for the product
    $clientsdetails = $params["clientsdetails"]; # Array of clients details - firstname, lastname, email, country, etc...
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
    $username = $clientsdetails["customfields1"]!= Null ? $clientsdetails["customfields1"]: $customfields["Panel Login Name"];
	
	$apiendpoint = $apiurl."/panel-users?ExactNameMatch=True&UserName=".$username;
    $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword);
    if($httpresponse["code"] != 200){
        return "Failed to retrieve user details.".FormateErrorMsg($httpresponse);
    }
    
    $userdetailsJson = json_decode($httpresponse["body"]);
    $userId = $userdetailsJson->Users[0]->UserId;
   
    if($userId > 0)
    {
		$apiendpoint = $apiurl."/panel-users/".$userId."?advanceDelete=True";
        $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "DELETE");
        if($httpresponse["code"] == 200){
            return "success";
        }else{
             return "Failed to delete user.".FormateErrorMsg($httpresponse);
        }
    }else{
        return "User not found.";
    }
}

function hc_SuspendAccount($params) {
	
	//Get HC API access URL
	$apiurl = GetPanelApiAccessUrl($params);
	
    $customfields = $params["customfields"]; # Array of custom field values for the product
    $clientsdetails = $params["clientsdetails"]; # Array of clients details - firstname, lastname, email, country, etc...
    # Additional variables if the product/service is linked to a server
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
	
    $username = $clientsdetails["customfields1"]!= Null ? $clientsdetails["customfields1"]: $customfields["Panel Login Name"];			  
	
	$apiendpoint = $apiurl."/panel-users?ExactNameMatch=True&UserName=".$username;
    $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword);
    if($httpresponse["code"] != 200){
        return "Failed to retrieve user details.".FormateErrorMsg($httpresponse);
    }
    
    $userdetailsJson = json_decode($httpresponse["body"]);
    $userId = $userdetailsJson->Users[0]->UserId;
   
    if($userId > 0)
    {
        $data = json_encode(array(
            'DisableOption'=> 'restrictpanelaccessandsuspenduser'
        ));
		$apiendpoint = $apiurl."/panel-users/".$userId."/disable";
        $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "PUT", $data);
        
        if($httpresponse["code"] == 200){
            return "success";
        }else{
             return "Failed to suspend user.".FormateErrorMsg($httpresponse);
        }
    }else{
        return "User not found.";
    }
}

function hc_UnsuspendAccount($params) {
	
	//Get HC API access URL
	$apiurl = GetPanelApiAccessUrl($params);
	
    $customfields = $params["customfields"]; # Array of custom field values for the product
    $clientsdetails = $params["clientsdetails"]; # Array of clients details - firstname, lastname, email, country, etc...

    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
	
    $username = $clientsdetails["customfields1"]!= Null ? $clientsdetails["customfields1"]: $customfields["Panel Login Name"];			  
	
	$apiendpoint = $apiurl."/panel-users?ExactNameMatch=True&UserName=".$username;	
    $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword);
    if($httpresponse["code"] != 200){
         return "Failed to retrieve user details.".FormateErrorMsg($httpresponse);
    }
    
    $userdetailsJson = json_decode($httpresponse["body"]);
    $userId = $userdetailsJson->Users[0]->UserId;
   
    if($userId > 0)
    {
		$apiendpoint = $apiurl."/panel-users/".$userId."/enable";
        $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "PUT");
        if($httpresponse["code"] == 200){
            return "success";
        }else{
             return "Failed to unsuspend user.".FormateErrorMsg($httpresponse);
        }
    }else{
        return "User not found.";
    }
}

function hc_ChangePassword($params) {
	
	//Get HC API access URL
	$apiurl = GetPanelApiAccessUrl($params);
	
    $password = $params["password"];
    $customfields = $params["customfields"]; # Array of custom field values for the product
    $clientsdetails = $params["clientsdetails"]; # Array of clients details - firstname, lastname, email, country, etc...
   
    $serverusername = $params["serverusername"];
    $serverpassword = $params["serverpassword"];
	
    $username = $clientsdetails["customfields1"]!= Null ? $clientsdetails["customfields1"]: $customfields["Panel Login Name"];
	
	$apiendpoint = $apiurl."/panel-users?ExactNameMatch=True&UserName=".$username;
    $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword);
    if($httpresponse["code"] != 200){
        return "Failed to retrieve user details.".FormateErrorMsg($httpresponse);
    }
    
    $userdetailsJson = json_decode($httpresponse["body"]);
    $userId = $userdetailsJson->Users[0]->UserId;
   
    if($userId > 0)
    {
        $data = json_encode(array(
            'Password'=> $password
        ));
		$apiendpoint = $apiurl."/panel-users/".$userId."/change-password";        
        $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "PUT", $data);
        if($httpresponse["code"] == 200){
            return "success";
        }else{
             return "Failed to change user password.".FormateErrorMsg($httpresponse);
        }
    }else{
        return "User not found.";
    }
}

function hc_ClientArea($params) {
	
	//Get HC API access URL
	$apiurl = GetPanelApiAccessUrl($params);
	
    $panelAccessURL = hc_GetPanelAccessURL($params["serverusername"], $params["serverpassword"],$apiurl);
    $customfields = $params["customfields"]; 
		
	
	$mailDomainEndpoint = $apiurl."/mail-domains?PageSize=1&CurrentPage=1&MaildomainName=".$params["domain"];
	
    $httpresponse = hc_Connect($mailDomainEndpoint, $customfields["Panel Login Name"], $customfields["Panel Login Password"]);
	
	$mailAccessUrl = '';
    if($httpresponse["code"] == 200){
		
		$respjson = json_decode($httpresponse["body"]);
		if(!empty($respjson->MailDomains)){
			$mailAccessUrl = $respjson->MailDomains[0]->MailAccessUrl;
		}
	}
			
    $code = '<form action="'.$panelAccessURL.'" method="post" target="_blank">
    <input type="hidden" name="LoginName" id="LoginName" value="'.$customfields["Panel Login Name"].'" />
    <input type="hidden" name="Password" id="Password" value="'.$customfields["Panel Login Password"].'" />
    <input type="submit" value="Login to Control Panel" />';
	
	if(isset($mailAccessUrl) && !empty($mailAccessUrl)){
		$code = $code . '<input type="button" value="Login to Webmail" onClick="window.open(\''.$mailAccessUrl.'\')" /> ';
	}
	
    $code = $code . '</form>';

    return $code;
}

function hc_AdminLink($params) {
	
	//Get HC API access URL
	$apiurl = GetPanelApiAccessUrl($params);

    $panelAccessURL = hc_GetPanelAccessURL($params["serverusername"], $params["serverpassword"],$apiurl);

    $code = '<form action="'.$panelAccessURL.'" method="post" target="_blank">
    <input type="hidden" id="LoginName" name="LoginName" value="'.$params["serverusername"].'" />
    <input type="hidden" id="Password" name="Password" value="'.$params["serverpassword"].'" />
    <input type="hidden" name="IsRemoteLogin" value="1" />
    <input type="submit" value="Login to HC" />
    </form>';

    return $code;
}

function hc_LoginLink($params) {

	//Get HC API access URL
	$apiurl = GetPanelApiAccessUrl($params);
	
    $password = $params["password"];
    $customfields = $params["customfields"]; # Array of custom field values for the product
    $clientsdetails = $params["clientsdetails"]; # Array of clients details - firstname, lastname, email, country, etc...
    $panelAccessURL = hc_GetPanelAccessURL($params["serverusername"], $params["serverpassword"],$apiurl);
    $UserName=$clientsdetails["customfields1"]!= Null ? $clientsdetails["customfields1"]: $customfields["Panel Login Name"];

    $code = '
    <script language="javascript" type="text/javascript">
    function LoginToHC()
    {
        var fHCLogin = document.createElement(\'form\');
        fHCLogin.setAttribute("id", "fHCLogin");
        fHCLogin.setAttribute("name", "fHCLogin");
        fHCLogin.setAttribute("action", "'.$panelAccessURL.'");
        fHCLogin.setAttribute("method","post");
        fHCLogin.setAttribute("target", "_blank");
        fHCLogin.innerHTML =  "<input type=\'hidden\' name=\'LoginName\' value=\''.$UserName.'\' /><input type=\'hidden\' name=\'Password\' value=\''.$password.'\' /><input type=\'hidden\' name=\'IsRemoteLogin\' value=\'1\' />";
        document.body.appendChild(fHCLogin); 
        fHCLogin.submit();
    }
    </script>
    <a href="javascript:LoginToHC();" style="color:#cc0000">HostingController Login</a>	
    ';	


}

function hc_GetPanelAccessURL($serverusername, $serverpassword,$apiurl){

    # Code to perform action goes here...
    $HCAccessURL = "";

	$apiendpoint = $apiurl."/panel-conf/general-settings?metadata=false";
    $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword);
	
    if($httpresponse["code"] == 200){
        $bodyJson = json_decode($httpresponse["body"]);
        foreach($bodyJson->ConfigurationItems as $configItem){
             if($configItem->SystemName == "PanelUrl")
             {
                 $HCAccessURL = $configItem->Value;
             }
        }   
    }
	
    if($HCAccessURL == "")
    {
		$urldata = explode(":",$apiurl);
		$panelip = "";
		if(isset($urldata[1]))
		{
			$panelip = ltrim($urldata[1],"//");
		}
		
        $HCAccessURL = 'http://'.$panelip.':8797';
    }
    
    if(!EndsWithStr($HCAccessURL, "/")){
        $HCAccessURL .= "/";
    }
    $HCAccessURL .= "Auth/CheckLogin";
    return $HCAccessURL;
}

function hc_AdminCustomButtonArray() {
	# This function can define additional functions your module supports, the example here is a reboot button and then the reboot function is defined below
    $buttonarray = array(
	 
	);
	return $buttonarray;
}

function FormateErrorMsg($httpresponse){

    $respJson = json_decode($httpresponse["body"]);
    $errorDesc = $respJson->ErrorDesc;
    $errorCode = $respJson->ErrorCode;
    
    if (json_last_error() != JSON_ERROR_NONE || !isset($errorDesc) || $errorDesc == ""){
        return " Failed to connect to API.";
    }
   
    return " Error Code: $errorDesc ($errorCode).";
}

function GetErrorDescription($httpresponse){

    $respJson = json_decode($httpresponse["body"]);
    $errorDesc = $respJson->ErrorDesc;
    $errorCode = $respJson->ErrorCode;
    $errorDetails = $respJson->ErrorDetails;
    
    if ((json_last_error() != JSON_ERROR_NONE || !isset($errorDesc) || $errorDesc == "") && (!isset($errorDetails) || $errorDetails == "") ){
        return " Failed to connect to API.";
    }
   
    return " $errorDetails ";
}

function GetOsTemplateIdByName($serverusername, $serverpassword, $ostemplatename,$apiurl){
    
    $ostemplatename = urlencode($ostemplatename);	
	$apiendpoint = $apiurl."/virtualization/os-templates?DisplayName=".$ostemplatename."&amp;CompositeResourcesOnly=true&amp;PlanOnly=true";
    $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword);
    
    if($httpresponse["code"] != 200){
        return 0;
    }
    $respjson = json_decode($httpresponse["body"]);
    return $respjson->OsTemplates[0]->OsTemplateId;
}

function GetOsTemplateId($serverusername, $serverpassword, $baseostype,$provider,$apiurl){
    
	$apiendpoint1 = $apiurl."/virtualization/os-templates?BaseOsSystemName=".$baseostype."&ProviderName=".$provider; 
    $httpresponse1 = hc_Connect($apiendpoint1, $serverusername, $serverpassword);
	
    if($httpresponse1["code"] != 200){
        return 0;
    }
    $respjson1 = json_decode($httpresponse1["body"]);
    return $respjson1->OsTemplates[0]->OsTemplateId;
}

function GetCompositeResourceIdByName($serverusername, $serverpassword, $compositeresname,$apiurl){
    
    if((!isset($compositeresname) || $compositeresname == "")){
        return 0;
    }
    
	$apiendpoint = $apiurl."/composite-resources?IncludePurchased=true&ExactMatch=true&DisplayName=".$compositeresname;   
    $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "GET");
    if($httpresponse["code"] != 200){
        return 0;
    }  
    $respjson = json_decode($httpresponse["body"]);	
    return $respjson->CompositeResources[0]->CompositeResourceId;
}

function GetPlanIdByName($serverusername, $serverpassword, $planname,$apiurl){
   
    $planname = urlencode($planname);
    $apiendpoint = $apiurl."/plans?WithBasicDetail=true&ExactMatch=true&DisplayName=".$planname;
    $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "GET");
    if($httpresponse["code"] != 200){
        return 0;
    }
    $respjson = json_decode($httpresponse["body"]);
    return $respjson->Plans[0]->PlanId;
}

function GetCompositeResourceDetails($serverusername, $serverpassword, $cresourceid,$apiurl){
    
	$cresourcedetails = array();
	$apiendpoint = $apiurl."/composite-resources/".$cresourceid;   
    $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "GET");
    if($httpresponse["code"] != 200){
        return $cresourcedetails;
    }    
    $respjson = json_decode($httpresponse["body"]);
    $provider =  $respjson->ProviderName;
	$providerid =  $respjson->ProviderId;
	$cresourcedetails["provider"] = $provider;
	$cresourcedetails["providerid"] = $providerid;
	if (isset($respjson->ResourceComponents))
	{
		foreach($respjson->ResourceComponents as $value)
		{
			if($value->ComponentName == 'baseos')
			{
				$cresourcedetails["baseostype"] = $value->Value;
				$cresourcedetails["baseostypeid"] = $value->ComponentPropId;
			}
		}
	}
	return $cresourcedetails;
}

function GetPlanDetails($serverusername, $serverpassword, $planid,$apiurl){
    
	$plandetails = array();
	$apiendpoint = $apiurl."/plans/".$planid;   
    $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "GET");
    if($httpresponse["code"] != 200){
        return $plandetails;
    }    
    $respjson = json_decode($httpresponse["body"]);

	$plandetails["PlanId"] = $respjson->PlanId;
	$plandetails["OwnerId"] = $respjson->OwnerId;
	
	foreach($respjson->Resources as $value)
	{
		if($value->SystemName == 'websites' && ($value->IsComposite == false || $value->IsComposite == 'false'))//websites
		{
			if($value->Quantity == '-1' || $value->Quantity > '0')
			{
				$plandetails["WebProvider"] = $value->ProviderName;
			}
		}
		if($value->SystemName == 'dotnet'  && ($value->IsComposite == false || $value->IsComposite == 'false'))//websites
		{
			if($value->Quantity == '-1' || $value->Quantity > '0')
			{
				$plandetails["DotNetEnabled"] = "true";
			}
		}
		if($value->SystemName == 'php'  && ($value->IsComposite == false || $value->IsComposite == 'false'))//websites
		{
			if($value->Quantity == '-1' || $value->Quantity > '0')
			{
				$plandetails["PHPEnabled"] = "true";
			}
		}
		if($value->SystemName == 'perl'  && ($value->IsComposite == false || $value->IsComposite == 'false'))//websites
		{
			if($value->Quantity == '-1' || $value->Quantity > '0')
			{
				$plandetails["PerlEnabled"] = "true";
			}
		}
		if($value->SystemName == 'coldfusion'  && ($value->IsComposite == false || $value->IsComposite == 'false'))//websites
		{
			if($value->Quantity == '-1' || $value->Quantity > '0')
			{
				$plandetails["ColdFusionEnabled"] = "true";
			}
		}
		if($value->SystemName == 'statsdomains'  && ($value->IsComposite == false || $value->IsComposite == 'false'))//websites
		{
			if($value->Quantity == '-1' || $value->Quantity > '0')
			{
				$plandetails["StatsEnabled"] = "true";
			}
		}
		if($value->SystemName == 'dnszones'  && ($value->IsComposite == false || $value->IsComposite == 'false'))//DNS
		{
			if($value->Quantity == '-1' || $value->Quantity > '0')
			{
				$plandetails["DNSProvider"] = $value->ProviderName;
			}
		}
		if($value->SystemName == 'maildomains'  && ($value->IsComposite == false || $value->IsComposite == 'false'))//Mail
		{
			if($value->Quantity == '-1' || $value->Quantity > '0')
			{
				$plandetails["MailProvider"] = $value->ProviderName;
			}
		}
		if($value->SystemName == 'virtualmachines'  && ($value->IsComposite == false || $value->IsComposite == 'false'))//VirtualMachine
		{
			if($value->Quantity == '-1' || $value->Quantity > '0')
			{
				$plandetails["VMProvider"] = $value->ProviderName;
				$plandetails["VMProviderId"] = $value->ProviderId;
			}
		}
		if($value->SystemName == 'exchangemaildomains'  && ($value->IsComposite == false || $value->IsComposite == 'false'))//ExgMailDomains
		{
			if($value->Quantity == '-1' || $value->Quantity > '0')
			{
				$plandetails["ExchangeProvider"] = $value->ProviderName;
			}
		}
		if($value->SystemName == 'sipdomains'  && ($value->IsComposite == false || $value->IsComposite == 'false'))//SIPDomains(Skype)
		{
			if($value->Quantity == '-1' || $value->Quantity > '0')
			{
				$plandetails["SkypeProvider"] = $value->ProviderName;
			}
		}
		if($value->SystemName == 'sharepointsites'  && ($value->IsComposite == false || $value->IsComposite == 'false'))//SharePointSites
		{
			if($value->Quantity == '-1' || $value->Quantity > '0')
			{
				$plandetails["SharePointProvider"] = $value->ProviderName;
			}
		}
	}		
	
	if (isset($respjson->ResourceComponents))
	{
		foreach($respjson->ResourceComponents as $value)
		{
			if($value->ComponentName == 'baseos')
			{
				$plandetails["baseostype"] = $value->Value;
				$plandetails["baseostypeid"] = $value->ComponentPropId;
			}
		}
	}
	return $plandetails;
}

function GetServerRoleIdByServerName($serverusername, $serverpassword,$servername,$role,$apiurl){
    
	$serverroleid = 0;
	if($servername == "")
		return $serverroleid;
	$serverapiendpoint = $apiurl."/servers";   
    $httpresponse = hc_Connect($serverapiendpoint, $serverusername, $serverpassword, "GET");
    if($httpresponse["code"] != 200){
        return $serverroleid;
    }    
    $respjson = json_decode($httpresponse["body"]);
	
	if (isset($respjson->Servers))
	{
		foreach($respjson->Servers as $value)
		{
			if($value->DisplayName == $servername)
			{
				$serverid = $value->ServerId;
				if($serverid > 0)
				{
					$roleapiendpoint = $apiurl."/Server-Roles?roleName=".$role;   
					$httpresponse = hc_Connect($roleapiendpoint, $serverusername, $serverpassword, "GET");
					if($httpresponse["code"] != 200){
						return $serverroleid;
					}    
					$respjson = json_decode($httpresponse["body"]);
					$roleid = $respjson->Roles[0]->RoleId;
					 
					$serverroleapiendpoint = $apiurl."/servers/".$serverid."/roles";				
					$httpresponse = hc_Connect($serverroleapiendpoint, $serverusername, $serverpassword, "GET");					
					if($httpresponse["code"] != 200){
						return $serverroleid;
					}    
					$respjson = json_decode($httpresponse["body"]);
					foreach($respjson->ServerRoles as $value)
					{
						if($value->RoleId == $roleid)
						{
							$serverroleid = $value->ServerRoleId;
							Break;
						}
					}					
					Break;
				}				
			}
		}
	}
	
	return $serverroleid;
}

function GetContryIdByName($serverusername, $serverpassword, $contryname,$apiurl){
    
	$apiendpoint = $apiurl."/system-entities/countries?CountryName=".$contryname;
    $httpresponse = hc_Connect($apiendpoint, $serverusername, $serverpassword, "GET");
    if($httpresponse["code"] != 200){
        return 1;
    }
    $respjson = json_decode($httpresponse["body"]);
    return $respjson->Countries[0]->CountryId;
}

function StartsWithStr($haystack, $needle) {
    return $needle === "" || strrpos($haystack, $needle, -strlen($haystack)) !== false;
}

function EndsWithStr($haystack, $needle) {
    return $needle === "" || (($temp = strlen($haystack) - strlen($needle)) >= 0 && strpos($haystack, $needle, $temp) !== false);
}

function LogModule($error,$calledby,$params)
{
	logModuleCall('HC',$calledby,$params,$error,"");
}

function generate_password( $length = 8 )
{
	$chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_-=+;:,.?";
	$password = substr( str_shuffle( $chars ), 0, $length );
	return $password;
}

?>
