<?php

// CREATE DATABASE!!!


if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

use Illuminate\Database\Capsule\Manager as Capsule;

function ccpaas_MetaData() {
    Capsule::statement("CREATE TABLE IF NOT EXISTS `mod_ccpaasmarketplace` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `userid` int(11) NOT NULL,
    `username` text NOT NULL,
    `accountid` int(11) NOT NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB  DEFAULT CHARSET=latin1");

    return array(
        'DisplayName' => 'ccpaas Marketplace API',
        'APIVersion' => '1.0',
        'RequiresServer' => true,
        'DefaultNonSSLPort' => '80',
        'DefaultSSLPort' => '443',
    );
}


function ccpaas_ConfigOptions() {
    return array(
        'Productname' => array(
            'Type' => 'text',
            'Size' => '25',
            'Default' => '141309_Office365Business_84022',
            'Description' => 'Productname',
        ),
        'Marketplace ID' => array(
            'Type' => 'text',
            'Size' => '25',
            'Default' => '14086',
            'Description' => 'Marketplace ID',
        ),
        'Parent Account ID' => array(
            'Type' => 'text',
            'Size' => '25',
            'Default' => '751902',
            'Description' => 'Parent Account ID',
        ),
    );
}



function ccpaas_MakeAPICall ($params, $endpoint, $call) {
    $APILogin = array("User" => $params['serverusername'], "Password" => $params['serverpassword'], "URL" => $params['serverhostname']);
    
    $apiurl = "https://".$params['serverhostname']."/SimpleAPI/SimpleAPIService.svc/rest";

    // get token
    $curl = curl_init($apiurl . "/GetSessionToken");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    $data = array(
        'username' => $APILogin['User'],
        'password' => $APILogin['Password'],
    );

    $curl_data = json_encode($data);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $curl_data);
    curl_setopt($curl, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=UTF-8',
        'Content-Length: ' . strlen($curl_data))
    );

    curl_setopt($curl, CURLOPT_USERPWD, $APILogin['User'] . ":" . $APILogin['Password']);
    $curl_response = curl_exec($curl);

    $Token = str_replace('"', '', $curl_response);
    logModuleCall(
        'ccpaas',
        'Auth',
        $Token,
        $curl_response,
        $curl_response
    );

       // make api call
         $curl_data = array();
    /* $curl = curl_init($apiurl . "/PingPong");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $curl_data);
    curl_setopt($curl, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Content-Type: application/json; charset=UTF-8',
        'Authenticate: CCPSessionId '.$Token."'"
        ));
    $curl_response = curl_exec($curl);
    
 
    logModuleCall(
        'ccpaas',
        'PingPong',
        $Token,
        $curl_response,
        $curl_response
    ); */

    // make api call
    $curl_data = json_encode($call);
    $curl = curl_init($apiurl . $endpoint);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $curl_data);
    curl_setopt($curl, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Content-Type: application/json; charset=UTF-8',
       'Authenticate: CCPSessionId '.$Token
        ));
    $curl_response = curl_exec($curl);

    /*
    echo "<pre>";
    var_dump($curl_response);
    var_dump(json_decode($curl_response));
    echo "</pre>";
    */

    logModuleCall(
        'ccpaas',
        __FUNCTION__."/".$endpoint,
        $params,
        $curl_response,
        $curl_response
    );

    return $curl_response;
}



function ccpaas_findVATNumber ($userid) {
    $VATFieldIdDb = Capsule::table('tblcustomfields')->where('fieldname', 'VAT/Tax ID')->where('type', 'client')->first();
    $VatFieldId = $VATFieldIdDb->id;

    $VatNumber = Capsule::table('tblcustomfieldsvalues')->where('fieldid', $VatFieldId)->where('relid', $userid)->first();
    return $VatNumber->value;
}


function ccpaas_AdminServicesTabFields(array $params) {
    try {
        $ServiceIDs = explode(' ', $params['customfields']['ServiceID']);

        foreach ($ServiceIDs as $ServiceID) {
            $ProductDetails = json_decode(ccpaas_MakeAPICall ($params, '/GetSubscription', array('accountId' => $ServiceID)));

            // skip if product is "tenant" because we want informations about the product, not about tenant.
            if ($ProductDetails->ServiceName === "141309_MicrosoftOrganizationtenant_54197") {
                continue;
            } else {
                $ProductId = $ServiceID;
                break;
            }
        }




        $ServiceDetails = ccpaas_MakeAPICall ($params, '/GetSubscription', array('accountId' => $ProductId));
        $ServiceDetails = json_decode($ServiceDetails);

        foreach ($ServiceDetails->Fields as $FindSeats) {
            if ($FindSeats->Name === "NumberofSeats") {
                $CurrentSeats = $FindSeats->Value;
            }
        }

        $ProductDetails = array (   "ParentAccountId" => $ServiceDetails->ParentAccountId,
                                    "AccountId" => $ServiceDetails->AccountId,
                                    "AccountState" => $ServiceDetails->AccountState,
                                    "ServiceName" => $ServiceDetails->ServiceName,
                                    "ContractId" => $ServiceDetails->ContractId,
                                    "ProvisioningStatus" => $ServiceDetails->ProvisioningStatus,
                                    "NumberOfSeats" => $CurrentSeats,
                                );



        return array (  'ParentAccountId' => $ProductDetails['ParentAccountId'],
                        'AccountId' => $ProductDetails['AccountId'],
                        'AccountState' => $ProductDetails['AccountState'],
                        'ServiceName' => $ProductDetails['ServiceName'],
                        'ContractId' => $ProductDetails['ContractId'],
                        'ProvisioningStatus' => $ProductDetails['ProvisioningStatus'],
                        'NumberofSeats' => $ProductDetails['NumberOfSeats'],
						'Open at Marketplace' => "<a href='https://marketplace.also.lt/#/Account/View/$ProductDetails[AccountId]' target='_blank'>Open</a>"
                     );
    } catch (Exception $e) {
        logModuleCall(
            'ccpaas',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );
    }

    return array();
}



function ccpaas_GenRandomString ($start, $end) {

        $random = substr(str_shuffle('ABCDEFGHIJ'), -3);

    $random = $random . rand($start, $end);

    return $random;
}



function ccpaas_CreateAccount(array $params) {
    try {
        $APILogin = array("User" => $params['serverusername'], "Password" => $params['serverpassword'], "URL" => $params['serverhostname']);

        // get values to create service
        $ServiceToCreate = $params['configoption1'];
        $MarketplaceId = array(0 => $params['configoption2']);
        $ParentAccountId = $params['configoption3'];
        $ExistingOffice365customer = $params['customfields']['Existing Office365 Customer']; // on or empty

        $VATID = ccpaas_findVATNumber ($params['userid']);
        $CrefoNumber = $params['customfields']['CrefoNumber'];
        $NumberOfSeats = $params['configoptions']['Seats'];
  
        $CustomerPhoneNumber = str_replace('.', ' ', $params['clientsdetails']['phonenumberformatted']);

        // check checkbox status of 'Existing Office365 Customer' field
        if ($ExistingOffice365customer === "on") {
            $ExistingOffice365customer = true;
        } else {
            $ExistingOffice365customer = false;
        }
       

        // remove domain extension because for provisoring there is no domain extension needed.
        //^[a-zA-Z0-9]{2,27}$
        if (strpos($params['customfields']['Domain'], '.') !== false) {
            list($Domainname, $ext) = explode('.', $params['customfields']['Domain'], 2);
            $RealDomain = $params['customfields']['Domain'];
        } else {
            $Domainname = $params['customfields']['Domain'];
            $RealDomain = $Domainname . ".com";
        }

        // generate contract id.
        $ContractId = ccpaas_GenRandomString('100000', '999999');

        /*
         echo "<pre>";
         var_dump($params);
         echo "</pre>";
        */

        // check if exist....
        // if username already exist and not match with uid, generate new user
        $ExistingUser = Capsule::table('mod_ccpaasmarketplace')->where('userid', $params['userid'])->first();

        if (!empty($ExistingUser->username)) {
            $Username = $ExistingUser->username;
            $CustomerAccountId = $ExistingUser->accountid;
        }

        // create new company if user has no account yet
        if (empty($ExistingUser->username)) {
            // generate unique username
            $Username = $params['clientsdetails']['firstname'] . " " . $params['clientsdetails']['lastname'];
            while (!empty(Capsule::table('mod_ccpaasmarketplace')->where('username', $Username)->first())) {
                $Username = $params['clientsdetails']['firstname'] . " " . $params['clientsdetails']['lastname'] . ccpaas_GenRandomString('1', '999', 'noalpha');
            }

            if (empty($params['clientsdetails']['companyname'])) {
                $CompanyName = $params['clientsdetails']['firstname'] . " " . $params['clientsdetails']['lastname'];
            } else {
                $CompanyName = $params['clientsdetails']['companyname'];
            }

            $CreateCompany = array(
                'companyAccount' => array(   'Address' => $params['clientsdetails']['address1'],
    'City' => $params['clientsdetails']['city'],
    'CompanyName' => $CompanyName,
    'ContractId' => ccpaas_GenRandomString('100000', '999999'),
    'Country' => $params['clientsdetails']['countryname'],
    'CrefoNumber' => $CrefoNumber,
    'CustomerId' => '',
    'Domain' => 
    array (
      0 => $Domainname. ".dummy",
    ),
    'Email' => $params['clientsdetails']['email'],
    'Marketplaces' => $MarketplaceId,
    'ParentAccountId' => $ParentAccountId,
    'VATID' => $VATID,
    'Zip' => $params['clientsdetails']['postcode'],
    'ContactPhone' => $params['clientsdetails']['phonenumber'],
    'State' => $params['clientsdetails']['state'],
                                        ),
            );

            $CallCreateCompany = ccpaas_MakeAPICall ($params, '/CreateCompany', $CreateCompany);
            $CreateCompany = json_decode($CallCreateCompany);
            $CustomerAccountId = $CreateCompany->AccountId;

            if (!empty($CustomerAccountId)) {
                Capsule::table('mod_ccpaasmarketplace')->where('userid', $params['clientsdetails']['userid'])->delete();
                Capsule::table('mod_ccpaasmarketplace')->insert(
                        [
                            'userid' => $params['clientsdetails']['userid'],
                            'username' => $Username,
                            'accountid' => $CustomerAccountId,
                        ]
                );
               /* return "Company Creation success: ".$Username." ".$CustomerAccountId;*/
               
            } else {
                return "Company Creation Failed: $CallCreateCompany";
            }
        }

        // search for dependencies
        $GetDependencyProduct = ccpaas_MakeAPICall ($params, '/GetPossibleServicesForParent', array('parentAccountId' => $CustomerAccountId));
        $GetDependencyProduct = json_decode($GetDependencyProduct);

        foreach ($GetDependencyProduct as $key => $value) {
            if ($value->ProductName === $ServiceToCreate) {
                foreach ($value->DependencyInfo as $Dependencys) {
                    $Dependency = $Dependencys->ProductName;
                    break;
                }
                break;
            }
        }
   #luna
  

        // create dependend products
        #19-11-2020:
        # JUnell: If depenedend product exist (in this case, microsoft tenant)
        # then we dont need to createsubscribtion (dependend product of the ordered)
        #If there is other product that require other dependency that already exist, copy code bellow and change accordingly
        if($Dependency == '141309_MicrosoftOrganizationtenant_54197'){
        $checkTENANT = array('parentAccountId' => "3816368");
        $APIcheckCallTenant = ccpaas_MakeAPICall($params, '/GetSubscriptions', $checkTENANT);
            $APICall = json_decode($APIcheckCallTenant);
            foreach ($APICall as $subArray) {
                if($subArray->ServiceName == '141309_MicrosoftOrganizationtenant_54197'){
                    $bypassCraeteTenantDependancy = true;
 
                }
  
            }
        }  
        if (!empty($Dependency) && !$bypassCraeteTenantDependancy) {
            $InitialPassword = str_shuffle(ccpaas_GenRandomString('1000000', '9999999'));
            $CreateProductTenant = array(
                'subscriptionAccount' => array( 'parentAccountId' => $CustomerAccountId,
                                                'ServiceName' => $Dependency,
                                                'ContractId' => ccpaas_GenRandomString('100000', '999999'),
                                                'fields' => array(  'Primarycontactfirstname' => $params['clientsdetails']['firstname'],
                                                                    'Primarycontactlastname' => $params['clientsdetails']['lastname'],
                                                                    'Primarydomainname' => $Domainname,
                                                                    'PostalCode' => $params['clientsdetails']['postcode'],
                                                                    'Phone' => $CustomerPhoneNumber,
                                                                    'PrimaryContactEmailAddress' => $params['clientsdetails']['email'],
                                                                    "SpecialQualification" => false,
                                                                    'ExistingOffice365customer' => $ExistingOffice365customer,
                                                                    'InitialPassword' => $InitialPassword,
                                                                ),
                                              )
            );
      
            $APICallTenant = ccpaas_MakeAPICall ($params, '/CreateSubscription', $CreateProductTenant);
            $APICall = json_decode($APICallTenant);
            $ServiceAccountId = $APICall->AccountId;
            
            if (empty($APICall->AccountId)) {
                return "Failure at depended product: $APICallTenant";
            }
                 /**Start OF Sign MCA: Added by junell **/
            #Junell: Get cstom actions (for teneant to Sign microsoft agreement)
               $getAccountCustomActionsData = array('accountId' =>  $ServiceAccountId);
               #Note, accountID here is not mainAccountID but the service accountID newly created
               
               $CallgetCustomActions = ccpaas_MakeAPICall ($params, '/GetAccountCustomActionsWithFields', $getAccountCustomActionsData);
               $CustomActions = json_decode($CallgetCustomActions);
               
               $MCADate = date('d.m.Y',strtotime('-4hours')); #Fix midnight time bug as server maybe a day behind in relation to this WHMCS server
               
               #Junell: Sign MCA agreement  (Note: The Fields are per /GetAccountCustomActionsWithFields )
               $signMCAData = array('action' => "ACCEPTMCA","subscriptionAccount" => array(
                   "AccountId" => $ServiceAccountId, 
         "ServiceName" => $APICall->ServiceName, "Fields" => array(
             "_CA_ACCEPTMCA_Information" => $CustomActions['Fields'][0]['DefaultValue'], 
             "_CA_ACCEPTMCA_AgreementURL" => $CustomActions['Fields'][1]['DefaultValue'], 
             "_CA_ACCEPTMCA_Confirmation" => true, 
             "_CA_ACCEPTMCA_FirstName" => $params['clientsdetails']['firstname'], 
             "_CA_ACCEPTMCA_LastName" => $params['clientsdetails']['lastname'], 
             "_CA_ACCEPTMCA_EmailAddress" => $params['clientsdetails']['email'], 
             "_CA_ACCEPTMCA_PhoneNumber" => "+".$params['clientsdetails']['phonenumber'], #phone starts with+
             "_CA_ACCEPTMCA_DateofAcceptance" => $MCADate, #dd.mm.yyyy
             ) ));
       
               $ExecSignMCA = ccpaas_MakeAPICall ($params,'/ExecuteAccountCustomAction', $signMCAData);
               
                $test = json_decode($ExecSignMCA);
                if (!empty($test)) {
                return "Failed signing tenant MCA: $test";
                }
  
        }
         

        // create main product
        $CreateProduct = array(
            'subscriptionAccount' => array ( 'ParentAccountId' => $CustomerAccountId,
                                            'ServiceName' => $ServiceToCreate,
                                            'ContractId' => ccpaas_GenRandomString('100000', '999999'),
                                            'Fields' => array(
                                                'NumberofCSPlicenses' => (int)$NumberOfSeats,
                                                'SpecialQualifications' => false,
                                                'ExistingOffice365customer' => $ExistingOffice365customer,
                                                'PrimaryContactEmailAddress' => $params['clientsdetails']['email'],
                                            ),
                                          )
        );

        $APICallProduct = ccpaas_MakeAPICall ($params, '/CreateSubscription', $CreateProduct);
        $APICall = json_decode($APICallProduct);
        $ServiceAccountId .= " " . $APICall->AccountId;

        if (empty($APICall->AccountId)) {
            return "Failure product creation: $APICallProduct";
        }
        


        $ServiceIDs = explode(' ', $ServiceAccountId);
        $LoginInfo = array();

        foreach ($ServiceIDs as $ServiceID) {
            $ProductDetails = json_decode(ccpaas_MakeAPICall ($params, '/GetSubscription', array('accountId' => $ServiceID)));

            // login details are keept at the tenant product.
            if ($ProductDetails->ServiceName === "141309_MicrosoftOrganizationtenant_54197") {
                foreach ($ProductDetails->Fields as $TenantKey => $TenantInformations) {
                    if ($TenantInformations->Name === "InitialPassword") {
                        if (empty($TenantInformations->Value)) {
                                $count = 0;
                                // loop until the API returns the password
                                while (true) {
                                        // force exit after 160 seconds
                                        if ($count > "160") {
                                                break;
                                        }

                                        // make new api call to check if password is returned.
                                        $ProductDetails = json_decode(ccpaas_MakeAPICall ($params, '/GetSubscription', array('accountId' => $ServiceID)));

                                        if ($ProductDetails->ServiceName === "141309_MicrosoftOrganizationtenant_54197") {
                                                foreach ($ProductDetails->Fields as $TenantKey => $TenantInformations) {
                                                        if ($TenantInformations->Name === "InitialPassword") {
                                                                if (!empty($TenantInformations->Value)) {
                                                                        // copy current returned datas to get the username.
                                                                        $TenantInformationsWithData = $ProductDetails->Fields;
                                                                        // if stop = 1, then exit while loop.
                                                                        $stop = 1;
                                                                        break;
                                                                }
                                                        }
                                                }
                                        }

                                        if ("$stop" === "1") {
                                                break;
                                        }

                                        // 1 count = 1 second
                                        sleep (1);
                                        $count++;
                                }
                        }

                        $LoginInfo['Password'] = $TenantInformations->Value;
                    }
                }
                // get username from the recently copied api response.
                foreach ($TenantInformationsWithData as $TenantInformations) {
                        if ($TenantInformations->Name === "AdministratorUserName") {
                                $LoginInfo['Username'] = $TenantInformations->Value;
                        }
                }
            }
        }
        
                   
               
               

        if (empty($LoginInfo['Username'])) {
            $LoginInfo['Username'] = $params['clientsdetails']['email'];
        }
        if (empty($LoginInfo['Password']) OR $LoginInfo['Password'] === 'None') {
            $LoginInfo['Password'] = $InitialPassword;
        }


        // update login details
        $updateLoginDetails = Capsule::table('tblhosting')
                ->where('id', $params['serviceid'])
                ->update(
                [
                    'username' => $LoginInfo['Username'],
                    'password' => encrypt($LoginInfo['Password']),
                    'domain' => $RealDomain,
                ]
        );

        // update custom field to identificate product.
        foreach (Capsule::table('tblcustomfields')->where('fieldname', 'ServiceID')->where('relid', $params['pid'])->get() as $CustomFieldsID) {
            // check if the service id field already exist
            foreach (Capsule::table('tblcustomfieldsvalues')->where('fieldid', $CustomFieldsID->id)->where('relid', $params['serviceid'])->get() as $FieldCheck) {
                $insertServiceIDs_customField = Capsule::table('tblcustomfieldsvalues')
                        ->where('fieldid', $CustomFieldsID->id)
                        ->where('relid', $params['serviceid'])
                        ->update(
                        [
                            'value' => $ServiceAccountId,
                        ]
                );
                $Inserted = 1;
            }

            // if service id field not exist, then create it.
            if (empty($Inserted)) {
                Capsule::table('tblcustomfieldsvalues')->insert(
                        [
                            'fieldid' => $CustomFieldsID->id,
                            'relid' => $params['serviceid'],
                            'value' => $ServiceAccountId,
                        ]
                );
            }
        }
    } catch (Exception $e) {
        logModuleCall(
            'ccpaas',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}


// get possible fields to set password? check if there is a pw field.


function ccpaas_AdminServicesTabFieldsSave(array $params) {
    $NewSeats = $_POST['configoption']['1'];
    ccpaas_ChangeNumberOfSeats ($params, $NewSeats);
}



function ccpaas_ChangePackage (array $params) {
    $NewSeats = $params['configoptions']['Seats'];
    ccpaas_ChangeNumberOfSeats ($params, $NewSeats);
    return 'success';
}



function ccpaas_ChangeNumberOfSeats ($params, $NewSeats) {
    $ServiceIDs = explode(' ', $params['customfields']['ServiceID']);
    $CreatedService = $params['configoption1'];

    foreach ($ServiceIDs as $ServiceID) {
        $ProductDetails = json_decode(ccpaas_MakeAPICall ($params, '/GetSubscription', array('accountId' => $ServiceID)));
        // login details are keept at the tenant product.
        if ($ProductDetails->ServiceName === "$CreatedService") {
            foreach ($ProductDetails->Fields as $TenantKey => $TenantInformations) {
                if ($TenantInformations->Name === "NumberofSeats") {
                    $CurrentNumberOfSeats = $TenantInformations->Value;
                    break;
                }
            }

            if ("$CurrentNumberOfSeats" !== "$NewSeats") {
                $ServiceDetails = ccpaas_MakeAPICall ($params, '/GetSubscription', array('accountId' => $ServiceID));
                $ServiceDetails = json_decode($ServiceDetails);
/** Junell: not in use
                $ProductDetails = array (   'ParentAccountId' => $ServiceDetails->ParentAccountId,
                                            'AccountId' => $ServiceDetails->AccountId,
                                            'AccountState' => $ServiceDetails->AccountState,
                                            'ServiceName' => $ServiceDetails->ServiceName,
                                            'ContractId' => $ServiceDetails->ContractId,
                                            'ProvisioningStatus' => $ServiceDetails->ProvisioningStatus,
                                            'NumberOfSeats' => $ServiceDetails->Fields['2']->Value,
                                        ); */
                                        
                                        
             /** Junell fix 01/04/2021 : 1. Numberofseats => NumberofCSPlicenses  (we created NumberofCSPlicenses, doesnt make sense to update Numberofseats (which was used to read whmcs local value) DEV must have made a mistake and never checked )
              *              2. changed $ProductDetails to $ServiceDetails
              *              3. uncomment $ProductDetails array (not sure why it was created) **/
              
              $SendParams = array(  'subscription' => array (
                                                                'AccountId' => $ServiceID,
                                                                'ParentAccountID' => $ServiceDetails->ParentAccountId,
                                                                'Fields' => array([
                                                                    'name' => 'NumberofCSPlicenses',
                                                                    'value' => $NewSeats,
                                                                ]),
                                                                'ServiceName' => $ServiceDetails->ServiceName,
                                                            ));
                $UpdateNumberOfSeats = ccpaas_MakeAPICall ($params, '/UpdateSubscription',
                            $SendParams);
            }
            logModuleCall(
            'ccpaas',
            __FUNCTION__,
            $SendParams,
            $SendParams,
            $UpdateNumberOfSeats
        );
        }
    }
}



function ccpaas_SuspendAccount(array $params) {
    try {
        return ccpaas_TerminateAccount($params);
    } catch (Exception $e) {
        logModuleCall(
            'ccpaas',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}



function ccpaas_UnsuspendAccount(array $params) {
    try {
        return ccpaas_CreateAccount($params);
    } catch (Exception $e) {
        logModuleCall(
            'ccpaas',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}



function ccpaas_TerminateAccount(array $params) {
    try {
        ccpaas_MakeAPICall ($params, '/TerminateAccount', array('accountId' => $params['customfields']['ServiceID']));

        $ServiceIds = explode(" ", $params['customfields']['ServiceID']);
        if (!empty($ServiceIds)) {
            foreach ($ServiceIds as $ServiceId) {
                ccpaas_MakeAPICall ($params, '/TerminateAccount', array('accountId' => $ServiceId));
            }
        }

        Capsule::table('mod_ccpaasmarketplace')->where('userid', $params['userid'])->delete();

    } catch (Exception $e) {
        logModuleCall(
            'ccpaas',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}
