<?php

namespace Paysera\Validator;

use Paysera\Exception\CheckoutDataValidatorException;

class CheckoutDataValidator
{
    /**
     * @param array $checkoutDataMap
     * @throws CheckoutDataValidatorException
     */
    public function validateCheckoutData(array $checkoutDataMap)
    {
        foreach ($this->necessaryData() as $key) {
            if (!array_key_exists($key, $checkoutDataMap)) {
                throw new CheckoutDataValidatorException('Checkout data doesnt contain all necessary values');
            }
        }
    }

    /**
     * @return array
     */
    private function necessaryData()
    {
        return [
            'invoiceid',
            'amount',
            'currency',
            'systemurl',
            'returnurl',
        ];
    }
}
