<?php

namespace Paysera\Service;

use Paysera\Entity\PluginSettings;

class AdminForm
{
    const SETTINGS_PROJECT_ID_KEY = 'project_id';
    const SETTINGS_PROJECT_PASSWORD_KEY = 'project_password';
    const SETTINGS_TEST_MODE_KEY = 'test_mode';
    const SETTINGS_DESCRIPTION_KEY = 'description';
    const SETTINGS_PAYMENT_LIST_KEY = 'payment_list';
    const SETTINGS_ENABLED_COUNTRIES_KEY = 'enabled_countries';
    const SETTINGS_GRID_VIEW_KEY = 'grid_view';
    const SETTINGS_BUYER_CONSENT_KEY = 'buyer_consent';
    const SETTINGS_QUALITY_SIGN_KEY = 'quality_sign';
    const SETTINGS_OWNERSHIP_CODE_KEY = 'ownership_code';

    /**
     * @param array $availableCountries
     * @return array
     */
    public function buildForm(array $availableCountries)
    {
        return array_merge(
            $this->getMainSettingsPart(),
            $this->getExtraSettingsPart($availableCountries),
            $this->getAdditionalSettingsPart()
        );
    }

    /**
     * @return array
     */
    private function getMainSettingsPart()
    {
        return [
            'FriendlyName' => [
                'Type' => 'Payment gateway',
                'Value' => PluginSettings::DISPLAY_PLUGIN_NAME,
            ],
            self::SETTINGS_PROJECT_ID_KEY => [
                'FriendlyName' => 'Project ID',
                'Type' => 'text',
                'Size' => '11',
                'Default' => '0',
            ],
            self::SETTINGS_PROJECT_PASSWORD_KEY => [
                'FriendlyName' => 'Project password',
                'Type' => 'text',
                'Size' => '32',
            ],
            self::SETTINGS_TEST_MODE_KEY => [
                'FriendlyName' => 'Test Mode',
                'Type' => 'yesno',
                'Description' => 'Tick this to enable test mode',
            ],
        ];
    }

    /**
     * @param array $availableCountries
     * @return array
     */
    private function getExtraSettingsPart(array $availableCountries)
    {
        return [
            self::SETTINGS_DESCRIPTION_KEY => [
                'FriendlyName' => 'Description',
                'Type' => 'textarea',
                'Value' => 'Choose a payment method on the Paysera page',
                'Description' => 'Enter description which will be shown at checkout',
            ],
            self::SETTINGS_PAYMENT_LIST_KEY => [
                'FriendlyName' => 'Payment list',
                'Type' => 'yesno',
                'Description' => 'Enables payment list during checkout',
                'Default' => 'on',
            ],
            // todo: currently whmcs doesnt support multiple choices..
            /*self::SETTINGS_ENABLED_COUNTRIES_KEY => [
                'FriendlyName' => 'Enabled countries',
                'Type' => 'dropdown',
                'Options' => $availableCountries,
                'Description' => 'By default all countries are enabled',
                'Size' => 5,
                'Multiple' => 'multiple'
            ],*/
            self::SETTINGS_GRID_VIEW_KEY => [
                'FriendlyName' => 'Grid view',
                'Type' => 'yesno',
                'Description' => 'Tick this to enable grid view at checkout'
            ],
            self::SETTINGS_BUYER_CONSENT_KEY => [
                'FriendlyName' => 'Buyer consent',
                'Type' => 'yesno',
                'Description' => 'Tick this to enable buyer consent at checkout'
            ],
        ];
    }

    /**
     * @return array
     */
    private function getAdditionalSettingsPart()
    {
        return [
            self::SETTINGS_QUALITY_SIGN_KEY => [
                'FriendlyName' => 'Quality sign',
                'Type' => 'yesno',
                'Description' => 'Tick this to enable quality sign',
            ],
            self::SETTINGS_OWNERSHIP_CODE_KEY => [
                'FriendlyName' => 'Ownership code',
                'Type' => 'text',
                'Size' => '32',
                'Description' => '',
            ],
        ];
    }
}
