<?php

namespace Paysera\Hook;

use Paysera\Helper\LanguageHelper;
use Paysera\Provider\PluginSettingsProvider;
use Paysera\Service\PayseraSmarty;
use SmartyException;

class QualitySignHook
{
    const OWNERSHIP_CODE_TEMPLATE = 'qualitySign.tpl';

    private $pluginSettings;
    private $smarty;
    private $languageHelper;

    public function __construct()
    {
        $this->pluginSettings = (new PluginSettingsProvider())->getPluginSettings();
        $this->smarty = (new PayseraSmarty())->buildSmarty();
        $this->languageHelper = new LanguageHelper();
    }

    /**
     * @param array|null $whmcsLanguage
     * @return string
     * @throws SmartyException
     */
    public function buildQualitySignResponse($whmcsLanguage)
    {
        $this->smarty->assign('qualitySignEnabled', $this->pluginSettings->isQualitySignEnabled());
        $this->smarty->assign('projectId', $this->pluginSettings->getProjectId());
        $this->smarty->assign('language', $this->languageHelper->getClientLanguage($whmcsLanguage));

        return $this->smarty->fetch(self::OWNERSHIP_CODE_TEMPLATE);
    }
}
