<?php

namespace Paysera\Entity;

class PluginSettings
{
    const PLUGIN_NAME = 'paysera';
    const DISPLAY_PLUGIN_NAME = 'All popular payment methods';

    const FIELD_YESNO_VALUE_ENABLED = 'on';
    const FIELD_YESNO_VALUE_DISABLED = 'off';

    /**
     * @var int
     */
    private $projectId;

    /**
     * @var string|null
     */
    private $projectPassword;

    /**
     * @var string
     */
    private $testMode;

    /**
     * @var string|null
     */
    private $description;

    /**
     * @var string
     */
    private $paymentList;

    /**
     * @var array
     */
    private $enabledCountries;

    /**
     * @var string
     */
    private $gridView;

    /**
     * @var string
     */
    private $buyerConsent;

    /**
     * @var string
     */
    private $qualitySign;

    /**
     * @var string|null
     */
    private $ownershipCode;

    public function __construct()
    {
        $this->projectId = 0;
        $this->testMode = self::FIELD_YESNO_VALUE_DISABLED;
        $this->paymentList = self::FIELD_YESNO_VALUE_DISABLED;
        $this->enabledCountries = [];
        $this->gridView = self::FIELD_YESNO_VALUE_DISABLED;
        $this->buyerConsent = self::FIELD_YESNO_VALUE_DISABLED;
        $this->qualitySign = self::FIELD_YESNO_VALUE_DISABLED;
    }

    /**
     * @return int
     */
    public function getProjectId()
    {
        return $this->projectId;
    }

    /**
     * @param int $projectId
     * @return self
     */
    public function setProjectId($projectId)
    {
        $this->projectId = (int) $projectId;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getProjectPassword()
    {
        return $this->projectPassword;
    }

    /**
     * @param string $projectPassword
     * @return self
     */
    public function setProjectPassword($projectPassword)
    {
        if ($projectPassword !== null) {
            $this->projectPassword = (string)$projectPassword;
        }

        return $this;
    }

    /**
     * @return bool
     */
    public function isTestModeEnabled()
    {
        return $this->isEnabled($this->testMode);
    }

    /**
     * @param string $testMode
     * @return self
     */
    public function setTestMode($testMode)
    {
        $this->testMode = (string) $testMode;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     * @return self
     */
    public function setDescription($description)
    {
        if ($description !== null) {
            $this->description = (string) $description;
        }

        return $this;
    }

    /**
     * @return bool
     */
    public function isPaymentListEnabled()
    {
        return $this->isEnabled($this->paymentList);
    }

    /**
     * @param string $paymentList
     * @return self
     */
    public function setPaymentList($paymentList)
    {
        $this->paymentList = (string) $paymentList;

        return $this;
    }

    /**
     * @return array
     */
    public function getEnabledCountries()
    {
        return $this->enabledCountries;
    }

    /**
     * @param array $enabledCountries
     * @return self
     */
    public function setEnabledCountries($enabledCountries)
    {
        if (is_array($enabledCountries)) {
            $this->enabledCountries = $enabledCountries;
        }

        return $this;
    }

    /**
     * @return bool
     */
    public function isGridViewEnabled()
    {
        return $this->isEnabled($this->gridView);
    }

    /**
     * @param string $gridView
     * @return self
     */
    public function setGridView($gridView)
    {
        $this->gridView = (string) $gridView;

        return $this;
    }

    /**
     * @return bool
     */
    public function isBuyerConsentEnabled()
    {
        return $this->isEnabled($this->buyerConsent);
    }

    /**
     * @param string $buyerConsent
     * @return self
     */
    public function setBuyerConsent($buyerConsent)
    {
        $this->buyerConsent = (string) $buyerConsent;

        return $this;
    }

    /**
     * @return bool
     */
    public function isQualitySignEnabled()
    {
        return $this->isEnabled($this->qualitySign);
    }

    /**
     * @param string $qualitySign
     * @return self
     */
    public function setQualitySign($qualitySign)
    {
        $this->qualitySign = (string) $qualitySign;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getOwnershipCode()
    {
        return $this->ownershipCode;
    }

    /**
     * @param string $ownershipCode
     * @return self
     */
    public function setOwnershipCode($ownershipCode)
    {
        if ($ownershipCode !== null) {
            $this->ownershipCode = (string) $ownershipCode;
        }
        return $this;
    }

    /**
     * @param string $value
     * @return bool
     */
    private function isEnabled($value)
    {
        return $value === self::FIELD_YESNO_VALUE_ENABLED;
    }
}
