<?php

namespace Paysera\Entity;

use WHMCS\View\Formatter\Price;

class CheckoutData
{
    /**
     * @var float|null
     */
    private $rawTotal;

    /**
     * @var Price|null
     */
    private $priceTotal;

    /**
     * @var float|null
     */
    private $amount;

    /**
     * @var string|null
     */
    private $currency;

    /**
     * @var string|null
     */
    private $billingCountry;

    /**
     * @var int|null
     */
    private $invoiceId;

    /**
     * @var string|null
     */
    private $systemUrl;

    /**
     * @var string|null
     */
    private $returnUrl;

    /**
     * @var string|null
     */
    private $payerCountryCode;

    /**
     * @var string|null
     */
    private $payerFirstName;

    /**
     * @var string|null
     */
    private $payerLastName;

    /**
     * @var string|null
     */
    private $payerEmail;

    /**
     * @var string|null
     */
    private $payerStreet;

    /**
     * @var string|null
     */
    private $payerCity;

    /**
     * @var string|null
     */
    private $payerState;

    /**
     * @var string|null
     */
    private $payerPostCode;

    /**
     * @return float|null
     */
    public function getRawTotal()
    {
        return $this->rawTotal;
    }

    /**
     * @param float $rawTotal
     * @return self
     */
    public function setRawTotal($rawTotal)
    {
        $this->rawTotal = $rawTotal;

        return $this;
    }

    /**
     * @return Price
     */
    public function getPriceTotal()
    {
        return $this->priceTotal;
    }

    /**
     * @param Price $priceTotal
     * @return self
     */
    public function setPriceTotal($priceTotal)
    {
        $this->priceTotal = $priceTotal;

        return $this;
    }

    /**
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param float $amount
     * @return self
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     * @return self
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getBillingCountry()
    {
        return $this->billingCountry;
    }

    /**
     * @param string $billingCountry
     * @return self
     */
    public function setBillingCountry($billingCountry)
    {
        $this->billingCountry = $billingCountry;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getInvoiceId()
    {
        return $this->invoiceId;
    }

    /**
     * @param int $invoiceId
     * @return self
     */
    public function setInvoiceId($invoiceId)
    {
        $this->invoiceId = $invoiceId;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getSystemUrl()
    {
        return $this->systemUrl;
    }

    /**
     * @param string $systemUrl
     * @return self
     */
    public function setSystemUrl($systemUrl)
    {
        $this->systemUrl = $systemUrl;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getReturnUrl()
    {
        return $this->returnUrl;
    }

    /**
     * @param string $returnUrl
     * @return self
     */
    public function setReturnUrl($returnUrl)
    {
        $this->returnUrl = $returnUrl;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getPayerCountryCode()
    {
        return $this->payerCountryCode;
    }

    /**
     * @param string $payerCountryCode
     * @return self
     */
    public function setPayerCountryCode($payerCountryCode)
    {
        $this->payerCountryCode = $payerCountryCode;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getPayerFirstName()
    {
        return $this->payerFirstName;
    }

    /**
     * @param string $payerFirstName
     * @return self
     */
    public function setPayerFirstName($payerFirstName)
    {
        $this->payerFirstName = $payerFirstName;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getPayerLastName()
    {
        return $this->payerLastName;
    }

    /**
     * @param string $payerLastName
     * @return self
     */
    public function setPayerLastName($payerLastName)
    {
        $this->payerLastName = $payerLastName;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getPayerEmail()
    {
        return $this->payerEmail;
    }

    /**
     * @param string $payerEmail
     * @return self
     */
    public function setPayerEmail($payerEmail)
    {
        $this->payerEmail = $payerEmail;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getPayerStreet()
    {
        return $this->payerStreet;
    }

    /**
     * @param string $payerStreet
     * @return self
     */
    public function setPayerStreet($payerStreet)
    {
        $this->payerStreet = $payerStreet;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getPayerCity()
    {
        return $this->payerCity;
    }

    /**
     * @param string $payerCity
     * @return self
     */
    public function setPayerCity($payerCity)
    {
        $this->payerCity = $payerCity;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getPayerState()
    {
        return $this->payerState;
    }

    /**
     * @param string $payerState
     * @return self
     */
    public function setPayerState($payerState)
    {
        $this->payerState = $payerState;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getPayerPostCode()
    {
        return $this->payerPostCode;
    }

    /**
     * @param string $payerPostCode
     * @return self
     */
    public function setPayerPostCode($payerPostCode)
    {
        $this->payerPostCode = $payerPostCode;

        return $this;
    }
}
