<?php
/**
 * WHMCS montonio Gateway Module
 *
 * Within the module itself, all functions must be prefixed with the module
 * filename, followed by an underscore, and then the function name. For this
 * example file, the filename is "remotebank" and therefore all functions
 * begin "remotebank_".
 *
 * For more information, please refer to the online documentation.
 *
 * @see https://developers.whmcs.com/payment-gateways/
 *
 * @copyright Copyright (c) WHMCS Limited 2021
 * @license https://www.whmcs.com/license/ WHMCS Eula
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

/**
 * Define module related meta data.
 *
 * Values returned here are used to determine module related capabilities and
 * settings.
 *
 * @see https://developers.whmcs.com/payment-gateways/meta-data-params/
 *
 * @return array
 */
function montonio_MetaData()
{
    return [
        'DisplayName' => 'Montonio Gateway',
        'APIVersion' => '1.0', // Use API Version 1.1
        'DisableLocalCredtCardInput' => true,
    ];
}

/**
 * Define gateway configuration options.
 *
 * The fields you define here determine the configuration options that are
 * presented to administrator users when activating and configuring your
 * payment gateway module for use.
 *
 * Supported field types include:
 * * text
 * * password
 * * yesno
 * * dropdown
 * * radio
 * * textarea
 *
 * Examples of each field type and their possible configuration parameters are
 * provided in the sample function below.
 *
 * @see https://developers.whmcs.com/payment-gateways/configuration/
 *
 * @return array
 */

function montonio_config()
{
    return array(
        // the friendly display name for a payment gateway should be
        // defined here for backwards compatibility
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'Montonio Gateway',
        ),        
        'publicKey' => array(
            'FriendlyName' => 'Access Key',
            'Type' => 'text',
            'Size' => '100',
            'Default' => 'b1798201-e84b-4804-8a3f-9ae1ca449bae',
            'Description' => 'Enter Access Key here',
        ),        
        'privateKey' => array(
            'FriendlyName' => 'Secret Key',
            'Type' => 'text',
            'Size' => '25',
            'Default' => 'pOmpdQnvHq1vjBm6cJuXQ8HiWgz78er0l7dTMztFoQ4N',
            'Description' => 'Enter Secret Key here',
        ),      
        'paymentmode' => array(
            'FriendlyName' => 'Payment Mode',
            'Type' => 'dropdown',
            'Size' => '25',
            'Default' => 'sandbox',
            'Options' => array(
                'sandbox' => 'Sandbox',
                'production' => 'Production',                
            ),
            'Description' => 'Select Payment Mode here',
        ),
    );
}



/**
 * Capture payment.
 *
 * Called when a payment is requested to be processed and captured.
 *
 * This function must have a token stored when a payment is attempted which is
 * created and stored upon the _remoteinput function
 *
 * @param array $params Payment Gateway Module Parameters
 *
 * @return array
 * @see https://developers.whmcs.com/payment-gateways/merchant-gateway/
 *
 */
function montonio_link($params)
{   
    $bank_name = $_COOKIE["bankname"];
    
    //echo "<pre>"; print_r($_SERVER['PHP_SELF']);die;

    try {       
        
        require_once 'montoniogateway/lib/MontonioPayments/MontonioPaymentsSDK.php';
        
        // echo "out gateway";

        $accessKey = $params['publicKey'];
        $secretKey = $params['privateKey'];
        $env       = $params['paymentmode'];
        
        $sdk = new MontonioPaymentsSDK(
            $accessKey,
            $secretKey,
            $env
        );
        $paymentData = array(
            'amount'                    => $params['amount'], // Make sure this is a float
            'currency'                  => "EUR", // Currently only EUR is supported
            'merchant_reference'        => $params['invoiceid'], // The invoice id 
            'merchant_name'             => $params['clientdetails']['company'],
            'checkout_email'            => $params['clientdetails']['email'],
            'checkout_first_name'       => $params['clientdetails']['firstname'],
            'checkout_last_name'        => $params['clientdetails']['lastname'],
            'checkout_phone_number'     => $params['clientdetails']['phonenumber'],
            'merchant_notification_url' => $params['systemurl'].'modules/gateways/callback/montonio_callback.php', // We will send a webhook after the payment is complete
            'merchant_return_url'       => $params['systemurl'].'viewinvoice.php?id=' . $params['invoiceid'], // Where to redirect the customer to after the payment
            'preselected_country'       => $params['clientdetails']['countrycode'],
            'preselected_aspsp'         => $bank_name, // The preselected ASPSP identifier
            // For card payments:
            // 'preselected_aspsp'         => 'CARD'
            'preselected_locale'        => 'en' // See available locale options in the docs
        );

        $sdk->setPaymentData($paymentData);

        //echo "<pre>"; print_r($paymentData);

        $paymentUrl = $sdk->getPaymentUrl();

        //echo "<pre>"; print_r($paymentUrl); die();  

        logActivity('Payment success by montoniogateway from page name: '.$_SERVER['PHP_SELF']); 

        if(strpos($_SERVER['PHP_SELF'],'montonio_callback.php')) {
            return true;
        }      
         
        if(basename($_SERVER['PHP_SELF']) == 'viewinvoice.php')
        {    
            $langPayNow = $params['langpaynow'];
            $htmlOutput = '<form method="post" action="' . $paymentUrl . '">';            
            $htmlOutput .= '<input type="submit" value="' . $langPayNow . '" />';
            $htmlOutput .= '</form>';
            return $htmlOutput;
        }else{
            if(strpos($_SERVER['PHP_SELF'],'invoices.php') || strpos($_SERVER['PHP_SELF'],'montonio_callback.php')) {
                return true;
            }else{
                if ($_SERVER['PHP_SELF'] != "/members/dl.php") {
                    header("location:".$paymentUrl); die(); 
                }
            } 
        }    

    }
    catch(Exception $e) {
        return [
            // 'success' if successful, otherwise 'declined', 'error' for failure
            'status' => 'declined',
            // For declines, a decline reason can optionally be returned
            'declinereason' => $e->getMessage(),
            // Data to be recorded in the gateway log - can be a string or array
            'rawdata' => $e,
        ];        
    }        
}





/*function montonio_refund($params)
{           
    $pblKey = $params['publicKey'];
    $pvtKey = $params['privateKey'];
    $gatewayid = $params['gatewayid'];
    try {
        
     }
    //catch exception
    catch(Exception $e) {        
        return array(
            // 'success' if successful, otherwise 'declined', 'error' for failure
            'status' => 'declined',
            // Data to be recorded in the gateway log - can be a string or array
            'rawdata' => $e->getMessage(),
            // Optional fee amount for the fee value refunded
            'fee' => '0.00',
        );
    }    
}*/


