<?php
/*
Gateway Module Name: InterKassa 
Description: Developed for mydatapage.com
Version: 1.0
date: 06/11/2018
Author: Mathew,L (https://www.freelancer.com/u/mathewlojel)
About InterKassa "Shop Cart Interface": https://www.interkassa.com/en/documentation-sci/
*/
if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function interkassa_MetaData()
{
    return array(
        'DisplayName' => 'InterKassa Payment Gateway Module',
        'APIVersion' => '1.0',
        'DisableLocalCredtCardInput' => true,
        'TokenisedStorage' => false,
    );
}

function interkassa_config()
{
    return array(
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'InterKassa',
        ),
        'gatewayId' => array(
            'FriendlyName' => 'Checkout ID',
            'Type' => 'text',
            'Size' => '30',
            'Default' => '',
            'Description' => 'Enter IK Shop ID here',
        ),
        'secretHashKey' => array(
            'FriendlyName' => 'Secret Key',
            'Type' => 'text',
            'Size' => '30',
            'Default' => '',
            'Description' => 'Enter secret key here',
        ),
        'AllowCurrency' => array(
            'FriendlyName' => 'Allow currencies',
            'Type' => 'text',
            'Size' => '30',
            'Default' => '',
            'Description' => 'Must be same as on IK! Ex: EUR UAH RUB',
        )  

    );
}

function interkassa_link($params)
{
    // Gateway Configuration Parameters
    $gatewayId = $params['gatewayId'];
    $secretKey = $params['secretHashKey'];
    $AllowCurrency = $params['AllowCurrency'];
    // Invoice Parameters
    $invoiceId = $params['invoiceid'];
    $description = $params["description"];
    $amount = $params['amount'];
    $currencyCode = $params['currency'];
    // Client Parameters
    $firstname = $params['clientdetails']['firstname'];
    $lastname = $params['clientdetails']['lastname'];
    $fullname = $params['clientdetail']['fullname'];
    $email = $params['clientdetails']['email'];
    $address1 = $params['clientdetails']['address1'];
    $address2 = $params['clientdetails']['address2'];
    $city = $params['clientdetails']['city'];
    $state = $params['clientdetails']['state'];
    $postcode = $params['clientdetails']['postcode'];
    $country = $params['clientdetails']['country'];
    $phone = $params['clientdetails']['phonenumber'];
    // System Parameters
    $companyName = $params['companyname'];
    $systemUrl = $params['systemurl'];
    $returnUrl = $params['returnurl'];
    $langPayNow = $params['langpaynow'];
    $moduleDisplayName = $params['name'];
    $moduleName = $params['paymentmethod'];
    $whmcsVersion = $params['whmcsVersion'];
    $url = 'https://sci.interkassa.com/';
    // InterKassa SCI Parameters
    $postfields = array();
    $postfields['ik_co_id'] = $gatewayId;
    #$postfields['secretKey'] = $secretKey;
    $postfields['ik_pm_no'] = $invoiceId;
    $postfields['ik_inv_id'] = $invoiceId;

    $postfields['ik_desc'] = $description;
    $postfields['ik_am'] = $amount;
    $postfields['ik_cur'] = $currencyCode;
    #$postfields['name'] = $fullname;
    #$postfields['email'] = $email;
    #$postfields['address'] = $address1;
    #$postfields['city'] = $city;
    #$postfields['state'] = $state;
    #$postfields['country'] = $country;
    #$postfields['phone'] = $phone;
    #$postfields['action'] = 'capture';
    $postfields['ik_ia_u'] = $systemUrl . 'modules/gateways/callback/' . $moduleName . '.php'; #Callback / Interaction page
    $postfields['ik_ia_m'] = 'POST';
    $postfields['ik_suc_u'] = $returnUrl."&paymentsuccess=true"; # Return page on Success
    $postfields['ik_pnd_u'] = $returnUrl."&paymentsuccess=true"; # Return page on Pending
    $postfields['ik_fal_u'] = $returnUrl."&paymentfailed=true"; # Return on Failure

   # Check if user's currency is supported per interkassa configurations (1. Configure currency in interkassa by loging to your interkassa account > select checkout > checkout settinfs > payment settings  2. In WHMCS Gateway configuration, add the currency in the "supported currencies" field)
   

  // if($AllowCurrency == 'UAH' | $currencyCode == 'RUB' | $currencyCode == 'EUR'){
  if (strpos($AllowCurrency, $currencyCode) !== false) {
          # Generate HTML for InterKassa
   $htmlOutput = '<form method="post" id="payment" action="' . $url . '" accept-charset="UTF-8">';
    
    foreach ($postfields as $k => $v) {
        $htmlOutput .= '<input type="hidden" name="' . $k . '" value="' . $v . '" />';
    }
    
    $htmlOutput .= '<input type="submit" value="' . $langPayNow . '" />';
    $htmlOutput .= '</form>';

   }else{
   # If currency is NOT supported, show user the error
   $htmlOutput='<div class="alert alert-danger">
                <div class="alert-body">
                                            Sorry, InterKassa is not available in your currency: '.$currencyCode.' Please contact support for more info.
                    </div>
    </div>'; 
}
 
    return $htmlOutput;
    
}