<?php
/*
Gateway Module Name: InterKassa 
Description: Developed for mydatapage.com
Version: 1.0
date: 06/11/2018
Author: Mathew,L (https://www.freelancer.com/u/mathewlojel)
About InterKassa "Shop Cart Interface":
https://www.interkassa.com/en/documentation-sci/
*/

// Require libraries needed for gateway module functions.
require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';

// Detect module name from filename.
$gatewayModuleName = basename(__FILE__, '.php');

// Fetch gateway configuration parameters.
$gatewayParams = getGatewayVariables($gatewayModuleName);
// Die if module is not active.
if (!$gatewayParams['type']) {
    die('Module Not Activated');
}


// InterKassa Call Example: 

/* $_POST
ik_co_id => 58b7d7873c1eaf153b8b456b
ik_co_prs_id => 302618476548
ik_inv_id => 117476728
ik_inv_st => success
ik_inv_crt => 2018-11-05 05:09:33
ik_inv_prc => 2018-11-05 05:09:33
ik_trn_id => 
ik_pm_no => 445
ik_pw_via => test_interkassa_test_xts
ik_am => 41.54
ik_co_rfn => 40.9169
ik_ps_price => 42.17
ik_cur => UAH
ik_desc => Roxlogic IT Solutions, UAB - Invoice #2018 03 20 201602090491 
ik_sign => FMfh9Eb6nsgV18eeoBz41Q==
*/

// 1. Get Callback data returned from IK Interaction

$replyGatewayID = $_POST["ik_co_id"];
$replyHash = $_POST["ik_sign"];
$success = $_POST["ik_inv_st"];
$invoiceId = $_POST["ik_pm_no"];
$transactionId = $_POST["ik_trn_id"];
$paymentAmount = $_POST["ik_ps_price"];
#$paymentFee = $_POST["x_fee"];
$status = $_POST["ik_inv_st"];
#$transactionStatus = ucwords($status);
# $transactionStatus = $success ? 'Success' : 'Failure';

$gatewayId = $gatewayParams['gatewayId'];
$secretKey = $gatewayParams['secretHashKey'];
$pst = $_POST;
logTransaction($gatewayParams['name'], $pst , 'Inv '.$invoiceId.'');

if($gatewayId !== $replyGatewayID){
  $transactionStatus = 'Returned Wrong Checkout ID';
  logTransaction($gatewayParams['name'],'Invoice: '.$invoiceId.' Secret Hash: '.$secretKey.'',$transactionStatus);
	die('something wrong');
}


/**
 * 2. Validate callback authenticity 
 * Note: In test mode use the test secret givin on InterKassa UI
 */

unset($_POST['ik_sign']);
$dataSet = array();
foreach ($_POST as $key => $value) {
			if (!preg_match('/ik_/', $key)) continue;
			$dataSet[$key] = $value;
		}

ksort($dataSet, SORT_STRING); 
array_push($dataSet, $secretKey); 
$signString = implode(':', $dataSet); 
$sign = base64_encode(md5($signString, true));

if ($sign !== $replyHash ){
     $transactionStatus = 'Hash Verification Failure';
     logTransaction($GATEWAY["name"],'Failed: Invoice: '.$invoiceId.' Calc Hash: '.$sign.' Reply Hash: '.$replyHash.' Secret Hash: '.$secretKey.'','Callback Authenticity failed!');
     $success = false;
     die('Something is very wrong');
}


/**
 * 3. Validate Callback Invoice ID.
 */
 
$invoiceId = checkCbInvoiceID($invoiceId, $gatewayParams['name']);

/**
 * 4. Check Callback Transaction ID.
 */
 
checkCbTransID($transactionId);



if ($status == 'success') {
    /**
     * 5. Add Invoice Payment.
     */
    addInvoicePayment(
        $invoiceId,
        $transactionId,
        $paymentAmount,
        $paymentFee,
        $gatewayModuleName
    );
    $transactionStatus = 'Payment added Invoice: '.$invoiceId.'';
    logTransaction($gatewayParams['name'], $_POST, $transactionStatus);
    echo 'success';
}
