{******************************************* 

RSThemes - Graphics - Products
1. Widget Top
    1.1. Top Title
    1.2. Top Actions
2. Widget Content
    2.1. Product Group Graphic
        2.1.1. Main Graphic
        2.1.2. Condensed Graphic
    2.2. Products Graphic    
        2.2.1. Main Graphic
********************************************}

{assign var="iconsPath" value="./../../../../../../../templates/{$themeName}/assets/svg-icon"}
{assign var="ilustrationPath" value="./../../../../../../../templates/{$themeName}/assets/svg-illustrations"}
{assign var="imagesPath" value="{$whmcsURL}/templates/{$themeName}/assets/img"}
<section>
    {foreach $productGroups as $group}
        
        <div class="widget panel of-visible m-b-0x" data-graphics-manager-search-target>
            {* 1. Widget Top *}
            <div class="widget__top top top--collapsible">
                {$graphicMain = false}
                {$graphicMainType = false}
                {$graphicCondensed = false}
                {$graphicCondensedType = false}
                {$iconShow = false}
                {$iconShowType = false}

                {if isset($graphics['group'][$group->id]) && $graphics['group'][$group->id]->getJson() && $graphics['group'][$group->id]->getJson()->condensed->graphic}
                    {$graphicCondensed = $graphics['group'][$group->id]->getJson()->condensed->graphic}
                    {$iconShow = $graphicCondensed}
                {/if}
                {if isset($graphics['group'][$group->id]) && $graphics['group'][$group->id]->getJson() && $graphics['group'][$group->id]->getJson()->condensed->type}
                    {$graphicCondensedType = $graphics['group'][$group->id]->getJson()->condensed->type}
                    {$iconShowType = $graphicCondensedType}
                {/if}

                {if isset($graphics['group'][$group->id]) && $graphics['group'][$group->id]->getJson() && $graphics['group'][$group->id]->getJson()->main->graphic}
                    {$graphicMain = $graphics['group'][$group->id]->getJson()->main->graphic}
                    {$iconShow = $graphicMain}
                {/if}
                {if isset($graphics['group'][$group->id]) && $graphics['group'][$group->id]->getJson() && $graphics['group'][$group->id]->getJson()->main->type}
                    {$graphicMainType = $graphics['group'][$group->id]->getJson()->main->type}
                    {$iconShowType = $graphicMainType}
                {/if}

                {* 1.1. Top Title *}
                <div class="top__title collapsed" data-toggle="lu-collapse" data-target="#product-group-content-{$group->id}" data-graphics-manager-search-value="{$group->name}">
                    <span class="m-r-2x i-c-4x {if !$iconShow}is-hidden{/if}" data-top-icon="group-{$group->id}">
                        {if $iconShowType == "icon"}
                            {if file_exists("{$whmcsDir|regex_replace:"/:\d+/" : ""}/templates/{$themeName}/assets/svg-icon/{$iconShow}")}
                                {include file="{$iconsPath}/{$iconShow}"}
                            {/if}
                        {elseif $iconShowType == "illustration"}
                            {if file_exists("{$whmcsDir|regex_replace:"/:\d+/" : ""}/templates/{$themeName}/assets/svg-illustrations/{$iconShow}")}
                                {include file="{$ilustrationPath}/{$iconShow}"}
                            {/if} 
                        {elseif $iconShowType == "media"}
                            <img src="{$imagesPath}/page-manager/{$iconShow}" alt="{$iconShow}">
                        {elseif $iconShowType == "font-icon"}
                            <i class="{$iconShow}"></i>
                        {/if}
                    </span>
                    {$group->name} {if $group->hidden}<span class="label label--default label--outline m-l-2x">{$lang.graphics.general.hidden}</span>{/if}        
                </div>

                {* 1.2. Top Actions *}
                <div class="top__toolbar">
                    <input type="hidden" name="graphics[group][{$group->id}][status]" value="1">
                    <div class="d-flex m-l-1x">
                        <span class="btn btn--icon btn--circle btn--xs i-c-3x collapsed" data-toggle="lu-collapse" data-target="#product-group-content-{$group->id}">
                            <i class="btn__icon ls ls-down"></i>
                        </span>
                    </div>
                </div>
            </div>
        
            {* 2. Widget Content *}
            <div class="widget__body collapse" id="product-group-content-{$group->id}">
                <div class="widget__content">
                    {* 2.1. Product Group Graphic *}
                    <div class="widget__section section flex-1 m-t-0x">
                        <div class="section__header top ">
                            <h6 class="top__title">{$lang.graphics.products.widget.group_graphic}</h6>
                        </div>
                        <div class="section__content ">
                            <div class="well">
                                {* 2.1.1. Main Graphic *}
                                {$sectionField = [
                                    "label" => $lang.graphics.products.widget.product_group_illustration, 
                                    "tooltip" => $tooltips.graphics.products.product_group_illustration.content,
                                    "tooltip_url" => $tooltips.graphics.products.product_group_illustration.url,
                                    "name" => "group-`$group->id`-main",
                                    "graphic" => $graphicMain,
                                    "graphicType" => $graphicMainType,
                                    "type" => "main",
                                    "fieldName" => "graphics[group][`$group->id`]",
                                    "categoryType" => 'product_group',
                                    "categoryName" => $group->name
                                ]}
                                {include "./fields/graphic.tpl" sectionField=$sectionField}
                                {* 2.1.2. Condensed Graphic *}
                                {$sectionField = [
                                    "label" => $lang.graphics.products.widget.product_group_graphic, 
                                    "tooltip" => $tooltips.graphics.products.product_group_graphic.content,
                                    "tooltip_url" => $tooltips.graphics.products.product_group_graphic.url,
                                    "name" => "group-`$group->id`-condensed",
                                    "graphic" => $graphicCondensed,
                                    "graphicType" => $graphicCondensedType,
                                    "type" => "condensed",
                                    "fieldName" => "graphics[group][`$group->id`]",
                                    "categoryType" => 'product_group',
                                    "categoryName" => $group->name
                                ]}
                                {include "./fields/graphic.tpl" sectionField=$sectionField}
                            </div>
                        </div>
                    </div> 
                    
                    {* 2.2. Products Graphic *}
                    <div class="widget__section section flex-1">
                        <div class="section__header top collapsed" data-toggle="lu-collapse" data-target="#product-graphic-content-{$group->id}">
                            <h6 class="top__title">
                                {$lang.graphics.products.widget.products_graphic}
                            </h6>
                            <button type="button" class="top__toolbar btn btn--link">
                                <span class="btn__text">Expand</span>
                                <span class="btn__text">Hide</span>
                                <i class="btn__icon ls ls-down"></i>
                            </button>
                        </div>
                        <div class="section__content collapse" id="product-graphic-content-{$group->id}">
                            <ul class="list list--collapsible m-t-3x">
                                {foreach $products as $product}
                                    {if $product->gid == $group->id}
                                        {$graphicMain = false}
                                        {$graphicMainType = false}
                                        {$graphicCondensed = false}
                                        {$graphicCondensedType = false}
                                        {$iconShow = false}
                                        {$iconShowType = false}

                                        {if isset($graphics['product'][$product->id]) && $graphics['product'][$product->id]->getJson() && $graphics['product'][$product->id]->getJson()->condensed->graphic}
                                            {$graphicCondensed = $graphics['product'][$product->id]->getJson()->condensed->graphic}
                                            {$iconShow = $graphicCondensed}
                                        {/if}
                                        {if isset($graphics['product'][$product->id]) && $graphics['product'][$product->id]->getJson() && $graphics['product'][$product->id]->getJson()->condensed->type}
                                            {$graphicCondensedType = $graphics['product'][$product->id]->getJson()->condensed->type}
                                            {$iconShowType = $graphicCondensedType}
                                        {/if}

                                        {if isset($graphics['product'][$product->id]) && $graphics['product'][$product->id]->getJson() && $graphics['product'][$product->id]->getJson()->main->graphic}
                                            {$graphicMain = $graphics['product'][$product->id]->getJson()->main->graphic}
                                            {$iconShow = $graphicMain}
                                        {/if}
                                        {if isset($graphics['product'][$product->id]) && $graphics['product'][$product->id]->getJson() && $graphics['product'][$product->id]->getJson()->main->type}
                                            {$graphicMainType = $graphics['product'][$product->id]->getJson()->main->type}
                                            {$iconShowType = $graphicMainType}
                                        {/if}
                                        
                                        <li class="list__item" data-graphics-manager-search-value="{$product->name}">
                                            <div class="list__item-top collapsed" data-toggle="lu-collapse" data-target="#product-content-{$product->id}">
                                                <input type="hidden" name="graphics[product][{$product->id}][status]" value="1">
                                                <input type="hidden" name="graphics[product][{$product->id}][group]" value="{$group->id}">
                                                <span class="list__item-icon i-c-4x m-r-2x {if !$iconShow}is-hidden{/if}" data-top-icon="product-{$product->id}">
                                                    {if $iconShowType == "icon"}
                                                        {if file_exists("{$whmcsDir|regex_replace:"/:\d+/" : ""}/templates/{$themeName}/assets/svg-icon/{$iconShow}")}
                                                            {include file="{$iconsPath}/{$iconShow}"}
                                                        {/if}
                                                    {elseif $iconShowType == "illustration"}
                                                        {if file_exists("{$whmcsDir|regex_replace:"/:\d+/" : ""}/templates/{$themeName}/assets/svg-illustrations/{$iconShow}")}
                                                            {include file="{$ilustrationPath}/{$iconShow}"}
                                                        {/if} 
                                                    {elseif $iconShowType == "media"}
                                                        <img src="{$imagesPath}/page-manager/{$iconShow}" alt="{$iconShow}">
                                                    {elseif $iconShowType == "font-icon"}
                                                        <i class="{$iconShow}"></i>
                                                    {/if}
                                                </span>
                                                <span class="list__item-name">
                                                    {$product->name} {if $product->hidden}<span class="label label--default label--outline m-l-2x">{$lang.graphics.general.hidden}</span>{/if}
                                                </span>
                                                <span class="list__item-actions">
                                                    <span class="btn btn--icon btn--circle btn--xs i-c-3x">
                                                        <i class="btn__icon ls ls-down"></i>
                                                    </span>
                                                </span>
                                            </div>
                                            <div class="list__item-content collapse" id="product-content-{$product->id}">
                                                <div class="well">
                                                    {* 2.2.1. Main Graphic *} 
                                                    {* {$sectionField = [
                                                        "label" => $lang.graphics.general.main_graphic, 
                                                        "tooltip" => $tooltips.graphics.general.main_graphic.content,
                                                        "tooltip_url" => $tooltips.graphics.general.main_graphic.url,
                                                        "name" => "product-`$product->id`-main",
                                                        "graphic" => $graphicMain,
                                                        "graphicType" => $graphicMainType,
                                                        "type" => "main",
                                                        "fieldName" => "graphics[product][`$product->id`]",
                                                        "categoryType" => 'product',
                                                        "categoryName" => $product->name
                                                    ]} *}
                                                    {* {include "./fields/graphic.tpl" sectionField=$sectionField} *}
                                                    {* 2.2.2. Condensed Graphic *} 
                                                    {$sectionField = [
                                                        "label" => $lang.graphics.products.widget.product_graphic, 
                                                        "tooltip" => $tooltips.graphics.products.product_graphic.content,
                                                        "tooltip_url" => $tooltips.graphics.products.product_graphic.url,
                                                        "name" => "product-`$product->id`-condensed",
                                                        "graphic" => $graphicCondensed,
                                                        "graphicType" => $graphicCondensedType,
                                                        "type" => "condensed",
                                                        "fieldName" => "graphics[product][`$product->id`]",
                                                        "categoryType" => 'product',
                                                        "categoryName" => $product->name
                                                    ]}
                                                    {include "./fields/graphic.tpl" sectionField=$sectionField}
                                                </div>    
                                            </div>  
                                        </li>
                                    {/if}
                                {/foreach}
                            </ul>
                        </div>
                    </div>        
                </div>
            </div>    
        </div>    
    {/foreach}
</section>
