{******************************************* 

RSThemes - Graphics - Domains
1. Widget Top
    1.1. Top Title
    1.2. Top Actions
2. Widget Content
    2.1. Domain Graphic
        2.1.1. Condensed Graphic

********************************************}
{assign var="iconsPath" value="./../../../../../../../templates/{$themeName}/assets/svg-icon"}
{assign var="ilustrationPath" value="./../../../../../../../templates/{$themeName}/assets/svg-illustrations"}
{assign var="imagesPath" value="{$whmcsURL}/templates/{$themeName}/assets/img"}

<section>
    {foreach from=$domains item=domain}
        <div class="widget panel of-visible m-b-0x" data-graphics-manager-search-target>
            {* 1. Widget Top *}
            <div class="widget__top top top--collapsible">
                {$graphicCondensed = false}
                {$graphicCondensedType = false}
                {$iconShow = false}
                {$iconShowType = false}

                {if isset($graphics['domain'][$domain.id]) && $graphics['domain'][$domain.id]->getJson() && $graphics['domain'][$domain.id]->getJson()->condensed->graphic}
                    {$graphicCondensed = $graphics['domain'][$domain.id]->getJson()->condensed->graphic}
                    {$iconShow = $graphicCondensed}
                {/if}
                {if isset($graphics['domain'][$domain.id]) && $graphics['domain'][$domain.id]->getJson() && $graphics['domain'][$domain.id]->getJson()->condensed->type}
                    {$graphicCondensedType = $graphics['domain'][$domain.id]->getJson()->condensed->type}
                    {$iconShowType = $graphicCondensedType}
                {/if}

                {* 1.1. Top Title *}
                <div class="top__title collapsed" data-toggle="lu-collapse" data-target="#domain-content-{$domain.id}" data-graphics-manager-search-value="{$domain.name}">
                    <span class="m-r-2x i-c-4x {if !$iconShow}is-hidden{/if}" data-top-icon="domain-{$domain.id}">
                        {if $iconShowType == "icon"}
                            {if file_exists("{$whmcsDir|regex_replace:"/:\\d+/" : ""}/templates/{$themeName}/assets/svg-icon/{$iconShow}")}
                                {include file="{$iconsPath}/{$iconShow}"}
                            {/if}
                        {elseif $iconShowType == "illustration"}
                            {if file_exists("{$whmcsDir|regex_replace:"/:\\d+/" : ""}/templates/{$themeName}/assets/svg-illustrations/{$iconShow}")}
                                {include file="{$ilustrationPath}/{$iconShow}"}
                            {/if}
                        {elseif $iconShowType == "media"}
                            <img src="{$imagesPath}/page-manager/{$iconShow}" alt="{$iconShow}">
                        {elseif $iconShowType == "font-icon"}
                            <i class="{$iconShow}"></i>
                        {/if}
                    </span>
                    {$domain.name}
                </div>

                {* 1.2. Top Actions *}
                <div class="top__toolbar">
                    <input type="hidden" name="graphics[domain][{$domain.id}][status]" value="1">
                    <div class="d-flex m-l-1x">
                        <span class="btn btn--icon btn--circle btn--xs i-c-3x collapsed" data-toggle="lu-collapse" data-target="#domain-content-{$domain.id}">
                            <i class="btn__icon ls ls-down"></i>
                        </span>
                    </div>
                    <input type="hidden" name="graphics[domain][{$domain.id}][type]" value="{$domain.type}">
                </div>
            </div>

            {* 2. Widget Content *}
            <div class="widget__body collapse" id="domain-content-{$domain.id}">
                <div class="widget__content">
                    {* 2.1. Domain Graphic *}
                    <div class="widget__section section flex-1 m-t-0x">
                        <div class="section__content ">
                            <div class="well m-t-0x">
                                {* 2.1.1. Condensed Graphic *}
                                {$sectionField = [
                                    "label" => $lang.graphics.domains.widget.domain_graphic,
                                    "tooltip" => $tooltips.graphics.domains.domain_graphic.content,
                                    "tooltip_url" => $tooltips.graphics.domains.domain_graphic.url,
                                    "name" => "domain-`$domain.id`-condensed",
                                    "graphic" => $graphicCondensed,
                                    "graphicType" => $graphicCondensedType,
                                    "type" => "condensed",
                                    "fieldName" => "graphics[domain][`$domain.id`]",
                                    "categoryType" => 'domain',
                                    "categoryName" => $domain.name
                                ]}
                                {include "./fields/graphic.tpl" sectionField=$sectionField}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    {/foreach}
</section>