{******************************************* 

RSThemes - Graphics - Departments
1. Widget Top
    1.1. Top Title
    1.2. Top Actions
2. Widget Content
    2.1. Support Department Graphic
        2.1.1. Condensed Graphic

********************************************}
{assign var="iconsPath" value="./../../../../../../../templates/{$themeName}/assets/svg-icon"}
{assign var="ilustrationPath" value="./../../../../../../../templates/{$themeName}/assets/svg-illustrations"}
{assign var="imagesPath" value="{$whmcsURL}/templates/{$themeName}/assets/img"}
<section>
    {foreach $supportDepartments as $department}
        <div class="widget panel of-visible m-b-0x" data-graphics-manager-search-target>
            {* 1. Widget Top *}
            <div class="widget__top top top--collapsible">
                {$graphicCondensed = false}
                {$graphicCondensedType = false}
                {$iconShow = false}
                {$iconShowType = false}
            
                {if isset($graphics['department'][$department->id]) && $graphics['department'][$department->id]->getJson() && $graphics['department'][$department->id]->getJson()->condensed->graphic}
                    {$graphicCondensed = $graphics['department'][$department->id]->getJson()->condensed->graphic}
                    {$iconShow = $graphicCondensed}
                {/if}
                {if isset($graphics['department'][$department->id]) && $graphics['department'][$department->id]->getJson() && $graphics['department'][$department->id]->getJson()->condensed->type}
                    {$graphicCondensedType = $graphics['department'][$department->id]->getJson()->condensed->type}
                    {$iconShowType = $graphicCondensedType}
                {/if}    

                {* 1.1. Top Title *}
                <div class="top__title collapsed" data-toggle="lu-collapse" data-target="#support-department-content-{$department->id}" data-graphics-manager-search-value="{$department->name}">
                    <span class="m-r-2x i-c-4x {if !$iconShow}is-hidden{/if}" data-top-icon="department-{$department->id}">
                        {if $iconShowType == "icon"}
                            {if file_exists("{$whmcsDir|regex_replace:"/:\d+/" : ""}/templates/{$themeName}/assets/svg-icon/{$iconShow}")}
                                {include file="{$iconsPath}/{$iconShow}"}
                            {/if}
                        {elseif $iconShowType == "illustration"}
                            {if file_exists("{$whmcsDir|regex_replace:"/:\d+/" : ""}/templates/{$themeName}/assets/svg-illustrations/{$iconShow}")}
                                {include file="{$ilustrationPath}/{$iconShow}"}
                            {/if} 
                        {elseif $iconShowType == "media"}
                            <img src="{$imagesPath}/page-manager/{$iconShow}" alt="{$iconShow}">
                        {elseif $iconShowType == "font-icon"}
                            <i class="{$iconShow}"></i>
                        {/if}
                    </span>
                    {$department->name}        
                </div>

                {* 1.2. Top Actions *}
                <div class="top__toolbar">
                    <input type="hidden" name="graphics[department][{$department->id}][status]" value="1">
                    <div class="d-flex m-l-1x">
                        <span class="btn btn--icon btn--circle btn--xs i-c-3x collapsed" data-toggle="lu-collapse" data-target="#support-department-content-{$department->id}">
                            <i class="btn__icon ls ls-down"></i>
                        </span>
                    </div>
                </div>
            </div>

             {* 2. Widget Content *}
            <div class="widget__body collapse" id="support-department-content-{$department->id}">
                <div class="widget__content">
                    {* 2.1. Support Department Graphic *}
                    <div class="widget__section section flex-1 m-t-0x">
                        <div class="section__content ">
                            <div class="well m-t-0x">
                                {* 2.1.1. Condensed Graphic *}
                                {$sectionField = [
                                    "label" => $lang.graphics.departments.widget.department_graphic, 
                                    "tooltip" => $tooltips.graphics.support_departments.department_graphic.content,
                                    "tooltip_url" => $tooltips.graphics.support_departments.department_graphic.url,
                                    "name" => "department-`$department->id`-condensed",
                                    "graphic" => $graphicCondensed,
                                    "graphicType" => $graphicCondensedType,
                                    "type" => "condensed",
                                    "fieldName" => "graphics[department][`$department->id`]",
                                    "categoryType" => 'support_department',
                                    "categoryName" => $department->name
                                ]}
                                {include "./fields/graphic.tpl" sectionField=$sectionField}
                            </div>
                        </div>
                    </div>
                </div>            
            </div>
        </div>
    {/foreach}        
</section>    