{**************************** 

RSThemes - Graphics
1. Categories Sidebar
    1.1. Products
    1.2. Domains
    1.3. Support Departments
2. Content Tabs
    2.1. Products
    2.2. Domains
    2.3. Support Departments
3. Actions
4. Modals
5. Scripts

*****************************}


{extends file="adminarea/includes/layout.tpl"}
{block name="template-heading"}
    {include file="adminarea/includes/breadcrumb.tpl"}
{/block}
{block name="template-tabs"}
    {include file="adminarea/includes/tabs.tpl"}
{/block}
{block name="template-content"}
    <div class="section">
        <div class="d-flex">
            {* 1. Categories Sidebar *}
            <div class="app-main__sidebar">
                <div class="tabs tabs--block m-w-200 is-sticky">
                    <div class="tabs__nav"
                         data-options="navStorage:localStorage; localStorageId:custom-slider-23; slideToClickedSlide: true;">
                        <ul class="nav nav--tabs custom-nav-styles">
                            <div class="nav__header p-0x text-faded p-4">
                                Categories
                            </div>
                            {* 1.1. Products *}
                            <li class="nav__item {if !isset($smarty.get.graphicTab) || $smarty.get.graphicTab == 'products'} is-active {/if}">
                                <a class="nav__link" data-toggle="lu-tab" data-change-hash="true" href="#tab-graphics-products">
                                    <span class="nav__link-text">{$lang.graphics.products.title}</span>
                                </a>
                            </li>
                            {* 1.2. Domains *}
                            <li class="nav__item {if $smarty.get.graphicTab == 'domains'} is-active {/if}">
                                <a class="nav__link" data-toggle="lu-tab" data-change-hash="true" href="#tab-graphics-domains">
                                    <span class="nav__link-text">{$lang.graphics.domains.title}</span>
                                </a>
                            </li>
                            {* 1.3. Support Departments *}
                            <li class="nav__item {if $smarty.get.graphicTab == 'departments'} is-active {/if}">
                                <a class="nav__link" data-toggle="lu-tab" data-change-hash="true" href="#tab-graphics-departments">
                                    <span class="nav__link-text">{$lang.graphics.departments.title}</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            {* 2. Content Tabs *}
            <form
                action="{$helper->url('Template@saveGraphics',['templateName'=>$template->getMainName()])}"
                method="POST"
                class="app-main__content" 
                id="graphicsForm"
                data-graphics-manager
                data-assets-url="{$whmcsURL}/templates/{$themeName}/assets"
            >
                <div class="tabs__body">
                    <div class="tab-content">
                        {* 2.1. Products *}        
                        <div class="tab-pane{if !isset($smarty.get.graphicTab) || $smarty.get.graphicTab == 'products'} is-active {/if}" id="tab-graphics-products" data-graphics-manager-tab>
                            <div class="top m-b-4x">
                                <div class="top__toolbar">
                                    <h3 class="section__title">{$lang.graphics.products.title}</h3>
                                    {include file="adminarea/includes/helpers/docs.tpl" link=$docs.graphics.products}
                                </div>
                                <div class="top__toolbar is-right">
                                    <div class="top__search input-group">
                                        <span class="input-group__icon lm lm-search"></span>
                                        <input class="form-control input-group__form-control" value="" placeholder="Search..." data-graphics-manager-search>
                                    </div>
                                    {* <button type="button" data-graphics-manager-disable-all class="btn btn--default btn--outline">
                                        <span class="btn__text">{$lang.graphics.general.disable_all}</span>
                                        <span class="btn__preloader preloader"></span>
                                    </button> *}
                                </div>
                            </div>
                            {if isset($productGroups) && $productGroups}
                                {include file="./includes/products.tpl"}
                                {include 
                                    file="./includes/nodata/nodata.tpl"
                                    title="We couldn’t find anything matching your search."
                                    desc="Check your spelling or try different keywords."
                                    icon="category-search.tpl"
                                    type="search"
                                }
                            {else}
                                {include 
                                    file="./includes/nodata/nodata.tpl"
                                    title="You don’t have any items for which you could configure graphics."
                                    desc="Set up your first item in WHMCS settings to get started."
                                    icon="category-none.tpl"
                                }
                            {/if}
                        </div>
                        {* 2.2. Domains *}    
                        <div class="tab-pane{if $smarty.get.graphicTab == 'domains'} is-active {/if}" id="tab-graphics-domains" data-graphics-manager-tab>
                            <div class="top m-b-4x">
                                <div class="top__toolbar">
                                    <h3 class="section__title">{$lang.graphics.domains.title}</h3>
                                    {include file="adminarea/includes/helpers/docs.tpl" link=$docs.graphics.products}
                                </div>
                                <div class="top__toolbar is-right">
                                    <div class="top__search input-group">
                                        <span class="input-group__icon lm lm-search"></span>
                                        <input class="form-control input-group__form-control" value="" placeholder="Search..." data-graphics-manager-search>
                                    </div>
                                    {* <button type="button" data-graphics-manager-disable-all class="btn btn--default btn--outline">
                                        <span class="btn__text">{$lang.graphics.general.disable_all}</span>
                                        <span class="btn__preloader preloader"></span>
                                    </button> *}
                                </div>
                            </div>
                            {include file="./includes/domains.tpl"}
                            {include 
                                file="./includes/nodata/nodata.tpl"
                                title="We couldn’t find anything matching your search."
                                desc="Check your spelling or try different keywords."
                                icon="category-search.tpl"
                                type="search"
                            }
                        </div>
                        {* 2.3. Support Departments *}      
                        <div class="tab-pane{if $smarty.get.graphicTab == 'departments'} is-active {/if}" id="tab-graphics-departments" data-graphics-manager-tab>
                            <div class="top m-b-4x" data-top-search>
                                <div class="top__toolbar">
                                    <h3 class="section__title">{$lang.graphics.departments.title}</h3>
                                    {include file="adminarea/includes/helpers/docs.tpl" link=$docs.graphics.departments}
                                </div>
                                <div class="top__toolbar is-right">
                                    <div class="top__search input-group">
                                        <span class="input-group__icon lm lm-search"></span>
                                        <input class="form-control input-group__form-control" value="" placeholder="Search..." data-graphics-manager-search>
                                    </div>
                                    {* <button type="button" data-graphics-manager-disable-all class="btn btn--default btn--outline">
                                        <span class="btn__text">{$lang.graphics.general.disable_all}</span>
                                        <span class="btn__preloader preloader"></span>
                                    </button> *}
                                </div>
                            </div>
                            {if isset($supportDepartments) && $supportDepartments}
                                {include file="./includes/departments.tpl"}
                                {include 
                                    file="./includes/nodata/nodata.tpl"
                                    title="We couldn’t find anything matching your search."
                                    desc="Check your spelling or try different keywords."
                                    icon="category-search.tpl"
                                    type="search"
                                }
                            {else}
                                {include 
                                    file="./includes/nodata/nodata.tpl"
                                    title="You don’t have any items for which you could configure graphics."
                                    desc="Set up your first item in WHMCS settings to get started."
                                    icon="category-none.tpl"
                                }
                            {/if}
                        </div>
                    </div>    
                </div>    
            </form>
        </div>
    </div>
{/block}

{* 3. Actions *}
{block name="template-actions"}
    <div class="app-main__actions">
        <div class="container">
            <button
                class="btn btn--primary" 
                data-changes-save="#graphicsForm" data-form-validate="#graphicsForm"
                type="button"
                data-check-unsaved-changes
            >
                <span class="btn__text">Save Changes</span>
                <span class="btn__preloader preloader"></span>
            </button>
            <a 
                class="btn btn--default btn--outline" 
                href="{$helper->url('Template@graphics',['templateName'=>$template->getMainName()])}"
            >
                <span class="btn__text">Cancel</span>
                <span class="btn__preloader preloader"></span>
            </a>
        </div>
    </div>
{/block}

{* 4. Modals *}
{block name="template-modals"}
    {* 4.1. Unsaved Changes *}
    {include file="adminarea/includes/modals/unsaved-changes.tpl"}

    {* 4.2. Save Confirmation *}
    {include file="adminarea/includes/modals/save-confirmation.tpl"}

    {* 4.3. Main Graphic *}
    {include file="./includes/modals/graphic-main.tpl"}

    {* 4.4. Condensed Graphic *}
    {include file="./includes/modals/graphic-condensed.tpl"}

    {* 4.5. Remove Graphic *}
    {include file="./includes/modals/graphic-remove.tpl"}
{/block}

{* 4. Scripts *}
{block name="template-scripts"}
    <script type="text/javascript" src="{$helper->script('graphics-manager.js')}?v={$template->getRSThemesVersion()}"></script>
{/block}