<?php
/**
 * WHMCS-OPC Hook Function
 *
 * Please refer to the documentation @ https://docs.whmcs.com/Hooks for more information
 * The code in this hook is commented out by default. Uncomment to use.
 *
 * @package    WHMCS
 * @author     WHMCS Limited <development@whmcs.com>
 * @copyright  Copyright (c) WHMCS Limited 2005-2018
 * @license    https://www.whmcs.com/license/ WHMCS Eula
 * @version    $Id$
 * @link       https://www.whmcs.com/
 */


if (!defined("WHMCS"))
    die("This file cannot be accessed directly");

use WHMCS\Database\Capsule;

add_hook('ClientAreaPage', 1, function($vars) {
    
    global $smarty;
    global $CONFIG;
    require_once __DIR__ . '/../gatewayfunctions.php';
    $gatewayModuleName = 'montonio';
    $gatewayParams = getGatewayVariables($gatewayModuleName);

    $templatefile = $smarty->tpl_vars['templatefile']->value;
    $modulepath =  dirname( dirname( __DIR__ ) ) . DIRECTORY_SEPARATOR . 'modules';
    $accessKey = $gatewayParams['publicKey'];
    $secretKey = $gatewayParams['privateKey'];
    $env = $gatewayParams['paymentmode']; // or 'production'

    if($templatefile=='invoice-payment' || $templatefile=='viewcart'){

    $countary_select = $_SESSION['cart']['user']['country'];

    if (!empty($_SESSION['uid'])) {
        $getpid = Capsule::table('tblclients')->where('id',$_SESSION['uid'])->first();
        $countary_select = $getpid->country;
    }
    
    if (empty($countary_select)) {
        $countary_select = 'EE';
    }
    
    //echo $countary_select;

    require_once $modulepath.'/gateways/montoniogateway/lib/MontonioPayments/MontonioPaymentsSDK.php';

    

    $sdk = new MontonioPaymentsSDK(
        $accessKey,
        $secretKey,
        $env
    );

    $banklistResponse = $sdk->fetchBankList();

    // Save banklist in DB ... 
    $banklist = json_encode($banklistResponse['data']);
    //print_r($banklist);
 

        echo '<link type="text/css" rel="stylesheet" href="montoniogateway/grid_logos.css?v=1.2.9">
        <script src="montoniogateway/montonio-payment-handle.js?v=1.1.8"></script>';
        require_once $modulepath . '/gateways/montoniogateway/lib/MontonioPayments/MontonioPaymentsCheckout.php';
        $checkout = new MontonioPaymentsCheckout();
        $checkout->set_description('Pay with your bank');
        $checkout->set_preferred_country($countary_select);
        $checkout->set_payment_handle_style('grid_logos');
        $checkout->set_banklist($banklist);

        $html = $checkout->get_description_html();
        //echo "<script>var html =  '".$html."';setTimeout(function(){document.getElementById('frmPayment').append(html);},20000);</script>";
        echo '<div id="select_bank" style="display:none;"><label class="bank_label">Select Location: </label>'.$html.'</div>';
        //print_r($checkout);
        /// your code here
    }
     
   
});
