<?php

use Illuminate\Database\Capsule\Manager as Capsule;

function cf_user_auth($vars) {

    $index = $vars[i];

    global $smarty;

    $productID = $_SESSION['cart']['products'][$index]['pid'];

    $configValuesQuery = Capsule::table("tblproducts")->where("id", $productID)->get();
    $configValues = (array) $configValuesQuery[0];

    if ($configValues['servertype'] !== "wgs_cf_partnerapi")
        return;

    # Email Address
    $email = substr($configValues['configoption3'], strpos($configValues['configoption3'], ':') + 1);
    $email = utf8_encode($email);
    $emailid = fetchCusomfieldID($productID, $email);
    # Password
    $password = substr($configValues['configoption4'], strpos($configValues['configoption4'], ':') + 1);
    $password = utf8_encode($password);
    $passwordid = fetchCusomfieldID($productID, $password);
    # Username
    $username = substr($configValues['configoption5'], strpos($configValues['configoption5'], ':') + 1);
    $username = utf8_encode($username);
    $usernameid = fetchCusomfieldID($productID, $username);

    $emailvalue = $vars['customfield'][$emailid];
    $passwordvalue = $vars['customfield'][$passwordid];
    $usernamevalue = $vars['customfield'][$usernameid];

    $hostAPIKey = $configValues['configoption2'];

    $cf = new CF_HOST_API_WHMCS_HOOK($hostAPIKey);

    $result = $cf->user_auth($emailvalue, $passwordvalue);
    if ($emailvalue) {
        if ($result->result == "error" && $result->err_code != 123) { # 123 error code: When cloudflare account doesn't exist
            $errors = array();
            if ($emailvalue) {
                $errors[] = "This Email Address (" . $emailvalue . ") is already registered. Please try another!";
            }

            $errors[] = "If you want to proceed with your existing account, then you must enter correct Email Address and Password.";
            $errors[] = $result->msg;
            return $errors;
        }
    }
}

//add_hook("ShoppingCartValidateProductUpdate", 1, "cf_user_auth");
######## Cloudflare Host API ########

function fetchCusomfieldID($relid, $name) {
    $result = Capsule::table('tblcustomfields')->select('id')->where("type", "product")->where("relid", $relid)->where("fieldname", $name)->get();
    $data = (array) $result[0];
    return $data['id'];
}

class CF_HOST_API_WHMCS_HOOK {

    //The URL of the API
    private static $URL = array(
        'HOST' => 'https://api.cloudflare.com/host-gw.html'
    );

    //Timeout for the API requests in seconds
    const TIMEOUT = 10;

    //Stores the api key
    private $token_key;
    private $host_key;
    //Stores the email login
    private $email;

    /**
     * Make a new instance of the API client
     */
    public function __construct() {
        $parameters = func_get_args();

        switch (func_num_args()) {
            case 1:
                //a host API
                $this->host_key = $parameters[0];
                break;
            case 2:
                //a user request
                $this->email = $parameters[0];
                $this->token_key = $parameters[1];
                break;
        }
    }

    public function user_lookup($email, $isID = false) {
        $data = array(
            'act' => 'user_lookup'
        );
        if ($isID) {
            $data['unique_id'] = $email;
        } else {
            $data['cloudflare_email'] = $email;
        }
        return $this->http_post($data, 'HOST');
    }

    public function user_auth($email, $password, $id = '') {
        $data = array(
            'act' => 'user_auth',
            'cloudflare_email' => $email,
            'cloudflare_pass' => $password,
            'unique_id' => $id
        );
        return $this->http_post($data, 'HOST');
    }

    private function http_post($data, $type = 'HOST') {
        switch ($type) {
            case 'HOST':
                $data['host_key'] = $this->host_key;
                break;
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
        curl_setopt($ch, CURLOPT_VERBOSE, 0);
        curl_setopt($ch, CURLOPT_FORBID_REUSE, true);
        curl_setopt($ch, CURLOPT_URL, self::$URL[$type]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_TIMEOUT, self::TIMEOUT);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $http_result = curl_exec($ch);
        $error = curl_error($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($http_code != 200) {
            return array(
                'error' => $error
            );
        } else {
            return json_decode($http_result);
        }
    }

}

?>
